﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Bll;
using BookShopOnline.Model;

public partial class UserCenter_OrderList : Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        UserState.CheckUserLogin();

        if (!IsPostBack)
        {
            BindOrderList();
        }
    }

    private void BindOrderList()
    {
        User userLogined = UserState.GetUserLogined();

        DataSet ds = new OrdersBll().SelectOrdersByUserID(userLogined.UserID);
        gvOrderList.DataSource = ds;
        gvOrderList.DataBind();

        if (ds == null || ds.Tables[0].Rows.Count == 0)
            lblMsg.Text = "暂无订单！";
        else
            lblMsg.Text = "共有订单记录："+ds.Tables[0].Rows.Count+"条";
    }

    protected void gvOrderList_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        gvOrderList.PageIndex = e.NewPageIndex;
        BindOrderList();
    }
}
