﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Model;
using BookShopOnline.Bll;

public partial class UserCenter_ShowOrder:Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        UserState.CheckUserLogin();

        if (!IsPostBack)
        {
            string orderID = PageHelper.GetUrlParmValue(UrlParmName.OrderID);
            string toEmail = PageHelper.GetUrlParmValue(UrlParmName.ToEmail);

            if (!string.IsNullOrEmpty(orderID))
            {
                lblToEmailMsg.Text += toEmail;
                lblToEmailMsg.Visible = true;

                OrderDetail1.BindOrderDetail(orderID);

                OrderInfo1.BindOrderInfo(orderID);

                PageHelper.SetSession(SessionName.HasNotPayedPrice,OrderInfo1.HasNotPayedPrice);
            }
        }
    }

    //付款
    protected void btnPay_Click(object sender, EventArgs e)
    {
        Response.Redirect("~/168regpay/payment.aspx?OrderID=" + PageHelper.GetUrlParmValue(UrlParmName.OrderID));
    }

    //修改订单
    protected void btnModifyOrder_Click(object sender, EventArgs e)
    {
        Response.Redirect("ModifyOrder.aspx?OrderID=" + PageHelper.GetUrlParmValue(UrlParmName.OrderID));
    }

    
}
