﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Model;
using BookShopOnline.Bll;

public partial class UserCenter_UpdateUser:Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        UserState.CheckUserLogin();

        if (!IsPostBack)
        {
            InitControl();
            BindUserInfo();
        }
    }

    #region 初始化控件
    private void InitControl()
    {
        RegisterUser1.BtnRegister.Enabled = false;
        RegisterUser1.BtnRegister.Visible = false;
        RegisterUser1.BtnCheckUserName.Enabled = false;
        RegisterUser1.TxtUserName.Enabled = false;
        RegisterUser1.PanelUserPwd.Visible = false;
    }
    #endregion

    #region 绑定用户信息
    private void BindUserInfo()
    {
        User userLogined = UserState.GetUserLogined();

        //用户名、Email、收货人姓名、邮编、电话、地址
        RegisterUser1.TxtUserName.Text = userLogined.UserName;
        RegisterUser1.TxtEmail.Text = userLogined.Email;
        RegisterUser1.TxtRealName.Text = userLogined.RealName;
        RegisterUser1.TxtPostalCode.Text = userLogined.PostalCode;
        RegisterUser1.TxtPhone.Text = userLogined.Phone;
        RegisterUser1.TxtAddress.Text = userLogined.Address;
    }
    #endregion

    #region 保存修改
    protected void SaveModifyClick(object sender, EventArgs e)
    {
        User userLogined = UserState.GetUserLogined();

        User user = new User();
        //用户ID、Email、收货人姓名、邮编、电话、地址
        user.UserID = userLogined.UserID;
        user.Email = RegisterUser1.TxtEmail.Text;
        user.RealName = RegisterUser1.TxtRealName.Text;
        user.PostalCode = RegisterUser1.TxtPostalCode.Text;
        user.Phone = RegisterUser1.TxtPhone.Text;
        user.Address = RegisterUser1.TxtAddress.Text;

        int returnValue=new UserBll().UpdateUser(user,userLogined.Email);

        RegisterUser1.LblMsg.Text = "";
        if (returnValue == -1)
            RegisterUser1.LblMsg.Text = "修改失败！修改的Email已存在。";

        if (returnValue == 0)
            RegisterUser1.LblMsg.Text = "修改失败！请检查输入并重试。";

        if (returnValue > 0)
        {
            RegisterUser1.LblMsg.Text = "修改成功！";
            //更新内存中的用户信息
            //Email、收货人姓名、邮编、电话、地址
            userLogined.Email = user.Email;
            userLogined.RealName = user.RealName;
            userLogined.PostalCode = user.PostalCode;
            userLogined.Phone = user.Phone;
            userLogined.Address = user.Address;

            UserState.SetUserLogined(userLogined);
        }
    }
    #endregion
}
