var sCurrMode = null;
var bEditMode = null;

sCurrMode = "EDIT";

var borderShown = "yes";

var bInitialized = false;

function onreadystatechange(){
	if (document.readyState!="complete") return;
	if (bInitialized) return;
	bInitialized = true;
	
	var mBody;
	Content.value = parent.document.getElementById(sLinkFieldName).value;
	mBody = Content.value;
	setHTML(mBody);
}
document.onreadystatechange=onreadystatechange;
function setHTML(html) {
	switch (sCurrMode){
	case "CODE":
		html = formatHtml(html);
		LinziWebEditor.document.designMode="On";
		LinziWebEditor.document.open();
		LinziWebEditor.document.write("<head><link href=\"EditorArea.css\" type=\"text/css\" rel=\"stylesheet\"></head><body>");
		LinziWebEditor.document.body.innerText=html;
		LinziWebEditor.document.body.contentEditable="true";
		LinziWebEditor.document.close();
		bEditMode=false;
		break;
	case "EDIT":
		html = formatHtml(html);
		LinziWebEditor.document.designMode="On";
		LinziWebEditor.document.open();
		LinziWebEditor.document.write("<head><link href=\"EditorArea.css\" type=\"text/css\" rel=\"stylesheet\"></head><body>"+html);
		LinziWebEditor.document.body.contentEditable="true";
		LinziWebEditor.document.execCommand("2D-Position",true,true);
		LinziWebEditor.document.execCommand("MultipleSelection", true, true);
		LinziWebEditor.document.execCommand("LiveResize", true, true);
		LinziWebEditor.document.close();
		bEditMode=true;
		LinziWebEditor.document.onselectionchange = function () { }
		break;
	case "VIEW":
		LinziWebEditor.document.designMode="off";
		LinziWebEditor.document.open();
		LinziWebEditor.document.write("<head><link href=\"EditorArea.css\" type=\"text/css\" rel=\"stylesheet\"></head><body>"+html);
		LinziWebEditor.document.body.contentEditable="false";
		LinziWebEditor.document.close();
		bEditMode=false;
		break;
	}
	
	LinziWebEditor.document.body.onpaste = onPaste;
	LinziWebEditor.document.onkeydown = new Function("return onKeyDown(LinziWebEditor.event);");
	LinziWebEditor.document.oncontextmenu=new Function("return showContextMenu(LinziWebEditor.event);");
	LinziWebEditor.document.body.onblur = bodyonBlur;
}

function bodyonBlur()
{
	var htmlstr;
	htmlstr = getHTML();
	parent.document.getElementById(sLinkFieldName).value = htmlstr;
	Content.value = htmlstr;
}

function SetMode(newMode){
	var sBody = "";
	if(newMode==sCurrMode){
		return false;
	}
	if(sCurrMode == "EDIT"){
		sBody = LinziWebEditor.document.body.innerHTML;
		EDIT_button.className="login_0";
		CODE_button.className="login_1";
	}else{
		sBody = LinziWebEditor.document.body.innerText;
		CODE_button.className="login_0";
		EDIT_button.className="login_1";
	}
	LinziWebEditor.focus();
	sCurrMode = newMode;
	setHTML(sBody);
}

function showContextMenu(event){
	showContextMenu(event);
	return false;
}

function onPaste(){
	if (sCurrMode=="VIEW") return false;
	if(sCurrMode == "CODE")
	{
		LinziWebEditor.document.selection.createRange().pasteHTML(HTMLEncode(clipboardData.getData("Text")));
		return false;
	}
}

function onKeyDown(event){
	var key = String.fromCharCode(event.keyCode).toUpperCase();
	
	switch(sCurrMode){
	case "VIEW":
		return false;
		break;
	case "EDIT":
		return true;
		break;
	default:
		if (event.keyCode==13){
			var sel = LinziWebEditor.document.selection.createRange();
			sel.pasteHTML("<BR>");
			event.cancelBubble = true;
			event.returnValue = false;
			sel.select();
			sel.moveEnd("character", 1);
			sel.moveStart("character", 1);
			sel.collapse(false);
			return false;
		}
		// ¼
		if (event.ctrlKey){
			// Ctrl+B,I,U
			if ((key == "B")||(key == "I")||(key == "U")){
				return false;
			}
		}
	}
}

// ȡ༭
function getHTML() {
	var html;
	if((sCurrMode=="EDIT")||(sCurrMode=="VIEW")){
		html = LinziWebEditor.document.body.innerHTML;
	}else{
		html = LinziWebEditor.document.body.innerText;
	}
	if (sCurrMode!="TEXT"){
		if ((html.toLowerCase()=="<p>&nbsp;</p>")||(html.toLowerCase()=="<p></p>")){
			html = "";
		}
	}
	return html;
}

// 滻ַ
function HTMLEncode(text){
	text = text.replace(/&/g, "&amp;") ;
	text = text.replace(/"/g, "&quot;") ;
	text = text.replace(/</g, "&lt;") ;
	text = text.replace(/>/g, "&gt;") ;
	text = text.replace(/'/g, "&#146;") ;
	text = text.replace(/\ /g,"&nbsp;");
	text = text.replace(/\n/g,"<br>");
	text = text.replace(/\t/g,"&nbsp;&nbsp;&nbsp;&nbsp;");
	return text;
}

// Ƿѡָ͵Ŀؼ
function isControlSelected(tag){
	if (LinziWebEditor.document.selection.type == "Control") {
		var oControlRange = LinziWebEditor.document.selection.createRange();
		if (oControlRange(0).tagName.toUpperCase() == tag && oControlRange(0).getAttribute("width") != "SITEBOX") {
			return true;
		}
	}
	return false;
}



// ʽ༭е
function format(what,opt) {
	if (sCurrMode!="EDIT") return;
	LinziWebEditor.focus();
	if (opt=="RemoveFormat"){
		what=opt;
		opt=null;
	}
	if (opt==null) LinziWebEditor.document.execCommand(what);
	else LinziWebEditor.document.execCommand(what,"",opt);
	LinziWebEditor.focus();
}

// ʾģʽԻ
function ShowDialog(url, width, height, optValidate) {
	if (optValidate) {
		if (sCurrMode!="EDIT") return;
	}
	LinziWebEditor.focus();
	var arr = showModalDialog(url, window, "dialogWidth:" + width + "px;dialogHeight:" + height + "px;help:no;scroll:no;status:no");
	LinziWebEditor.focus();
}


// (forward)(backward)һ
function zIndex(action){
	var objReference	= null;
	var RangeType		= LinziWebEditor.document.selection.type;
	if (RangeType != "Control") return;
	var selectedRange	= LinziWebEditor.document.selection.createRange();
	for (var i=0; i<selectedRange.length; i++){
		objReference = selectedRange.item(i);
		if (action=='forward'){
			objReference.style.zIndex  +=1;
		}else{
			objReference.style.zIndex  -=1;
		}
		objReference.style.position='absolute';
	}
	//LinziWebEditor.content = false;
	//LinziWebEditor.setActive();
}


// ı༭߶
function sizeChange(size){
	for (var i=0; i<parent.frames.length; i++){
		if (parent.frames[i].document==self.document){
			var obj=parent.frames[i].frameElement;
			var height = parseInt(obj.offsetHeight);
			if (height+size>=300){
				obj.height=height+size;
			}
			break;
		}
	}
}

///վռλ
function SiteBoxInsert()
{
	LinziWebEditor.document.selection.createRange().pasteHTML("<table style=\"BORDER: #c9ddf0 1px dashed; float:left;\" width=SITEBOX><tr><TD vAlign=top>{$SiteName}</TD></tr></table>");
}

///վ
function SiteNameInsert()
{
	LinziWebEditor.document.selection.createRange().pasteHTML("{HL.Config.SiteName}");
}
///ѭ
function IndexIDInsert()
{
	LinziWebEditor.document.selection.createRange().pasteHTML("{$IndexID}");
}

///վ
function SiteUrlInsert()
{
	if (sCurrMode!="EDIT")
	{
		LinziWebEditor.document.selection.createRange().pasteHTML("{$SiteUrl}");
		return;
	}
	
	if (LinziWebEditor.document.selection.type == "Control") {
		var oControlRange = LinziWebEditor.document.selection.createRange();
		if (oControlRange(0).tagName.toUpperCase() != "IMG") {
			alert("ֻͼƬı");
			return;
		}
		oControlRange.execCommand("CreateLink",false,"{HL.Config.SiteUrl}");
		return;
	}else{
		var oControlRange = LinziWebEditor.document.selection.createRange();
		if(oControlRange.text.length>0)
		{
			oControlRange.execCommand("CreateLink",false,"{HL.Config.SiteUrl}");
			return;
		}
	}
	LinziWebEditor.document.selection.createRange().pasteHTML("{HL.Config.SiteUrl}");
}

///վ
function SiteInforInsert()
{
	LinziWebEditor.document.selection.createRange().pasteHTML("{HL.Config.Logo}");
}

///ʽת
function formatHtml(html)
{
	var m_RegExp;
	var Matches;
	var newhtml;
	newhtml = html;
	if(sCurrMode == "EDIT")
	{
		newhtml = html.replace(/<SITEBOX>([\s\S]*?)<\/SITEBOX>/g,"<TABLE style=\"BORDER-RIGHT: #c9ddf0 1px dashed; BORDER-TOP: #c9ddf0 1px dashed; FLOAT: left; BORDER-LEFT: #c9ddf0 1px dashed; BORDER-BOTTOM: #c9ddf0 1px dashed;\" width=SITEBOX><TBODY><TR><TD vAlign=top>$1<\/TD><\/TR><\/TBODY><\/TABLE>");
	}
	else if(sCurrMode == "CODE")
	{
		newhtml = html.replace(/<TABLE(.*?)width=SITEBOX>([\s\S]*?)vAlign=top>([\s\S]*?)<\/TD><\/TR><\/TBODY><\/TABLE>/g,"<SITEBOX>$3<\/SITEBOX>");
	}
	return newhtml;
}