﻿<%@ page language="C#" masterpagefile="MyShopMasterPage.master" autoeventwireup="true" inherits="Shop_Member_Shop_PaymentType, WebApp_deploy" title="付款方式管理" enableEventValidation="false" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="Server">
    <div class="pageTitle">
        付款方式管理</div>
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <br />
    <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" CssClass="tableHead"
        DataKeyNames="TypeID" OnDataBound="GridView1_DataBound" OnRowDeleting="GridView1_RowDeleting"
        OnRowEditing="GridView1_RowEditing">
        <Columns>
            <asp:BoundField DataField="Typeid" HeaderText="编号" ReadOnly="True" />
            <asp:BoundField DataField="TypeName" HeaderText="名称" />
            <asp:BoundField DataField="DisCount" HeaderText="折扣" DataFormatString="{0}%" />
            <asp:CheckBoxField DataField="isdisabled" HeaderText="禁用" Text="是" />
            <asp:CheckBoxField DataField="isdefault" HeaderText="默认" Text="是" ReadOnly="True" />
            <asp:TemplateField HeaderText="描述">
                <ItemTemplate>
                    <div style="padding-left: 3px;">
                        <asp:Literal ID="txtIntro" runat="server" Text='<%# (Eval("Intro").ToString()).Replace("\n","<br/>") %>' /></div>
                </ItemTemplate>
                <ItemStyle Width="40%" HorizontalAlign="Left" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="设为默认">
                <ItemTemplate>
                    <asp:LinkButton ID="butSetDefault" runat="server" OnCommand="SetDefault_OnCommand"
                        CausesValidation="false" CommandArgument='<%#Eval("Typeid") %>' Text="设为默认" />
                    <asp:HiddenField ID="typeID" runat="server" Value='<%# Eval("TypeID") %>' />
                </ItemTemplate>
            </asp:TemplateField>
            <asp:CommandField EditText="修改" ShowEditButton="True" />
            <asp:CommandField ShowDeleteButton="True" />
        </Columns>
        <EmptyDataTemplate>
            <div style="padding: 10px;">
                没有符合查询条件的记录！</div>
        </EmptyDataTemplate>
    </asp:GridView>
    <input type="hidden" id="action" value="" name="action" />
    <input type="hidden" id="pid" value="" name="pid" />
    <input type="hidden" id="uid" value="" name="uid" />
    <br />
    <table class="ShopOrderStyle">
        <caption id="paytype_title">
            新增付款方式信息</caption>
        <tr>
            <td class="OrderTitle" style="height: 26px">名称：</td>
            <td style="height: 26px"><asp:TextBox ID="TxtPayName" runat="server" onblur="CheckInputCharNums(this,25);" />
                <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="TxtPayName"
                    ErrorMessage="名称不能空"/>(限定最多为25个中文字)</td>
        </tr>
        <tr>
            <td class="OrderTitle">
                支付属性：</td>
            <td>
                <asp:UpdatePanel ID="UpdatePanel1" runat="server">
                    <ContentTemplate>
                        <asp:DropDownList ID="DropPayAttribute" runat="server" AutoPostBack="True" OnSelectedIndexChanged="DropPayAttribute_SelectedIndexChanged">
                            <asp:ListItem Value="0">在线支付</asp:ListItem>
                            <asp:ListItem Enabled="False" Value="1">商城用户</asp:ListItem>
                            <asp:ListItem Value="2">线下支付</asp:ListItem>
                        </asp:DropDownList>
                        <div id="online_payTypeSelect" class="Content" runat="server">
                            <div class="div_row">
                                <div class="div_left">
                                    选择支付方式：</div>
                                <div class="div_right">
                                    <asp:DropDownList ID="ShopOnlinePaytype" runat="server" AppendDataBoundItems="True">
                                        <asp:ListItem Value="AliPay">支付宝</asp:ListItem>
                                        <asp:ListItem Value="ChinaBank">网 银</asp:ListItem>
                                        <asp:ListItem Value="QuickBill">快 钱</asp:ListItem>
                                        <asp:ListItem Value="TrafutonQ">财付通</asp:ListItem>
                                    </asp:DropDownList></div>
                            </div>
                            <div id="alipay_seller_email" class="div_row">
                                <div class="div_left">
                                    支付帐号：</div>
                                <div class="div_right">
                                    <asp:TextBox ID="OnlinePayEmail" runat="server" Width="150px"></asp:TextBox>
                                    (选择支付宝时填写) <a href="https://www.alipay.com/" target="_blank">申请支付宝</a> <a onmouseover="showHelp('help4');"
                                        onmouseout="hidenHelp('help4');" href="#">&nbsp;<img src="/Images/Member/tooltip.png"
                                            border="0" /></a><br />
                                </div>
                            </div>
                            <div id="other_onlinepya_account" class="div_row">
                                <div class="div_left">
                                    商户号：</div>
                                <div class="div_right">
                                    <asp:TextBox ID="Account" runat="server" Width="200px"></asp:TextBox>
                                </div>
                            </div>
                            <div id="other_onlinepya_key" class="div_row">
                                <div class="div_left">
                                    商户密钥：</div>
                                <div class="div_right">
                                    <asp:TextBox ID="Md5Code" runat="server" Width="200px" TextMode="Password"></asp:TextBox>&nbsp;不修改请匆改动
                                </div>
                            </div>
                            <div class="div_row">
                                <div class="div_left">
                                    在线支付订单前缀：</div>
                                <div class="div_right">
                                    <asp:TextBox ID="OnlinePayFlag" runat="server" Text="HL_" MaxLength="4" /></div>
                            </div>
                        </div>
                        <div id="Div1" class="Content" runat="server">
                            <div style="display: none" class="div_row">
                                <div class="div_left">
                                    线下支付类型：</div>
                                <div class="div_right">
                                    <asp:DropDownList ID="outLinePayType" runat="server">
                                        <asp:ListItem Text="银行转帐/汇款" Value="1" />
                                        <asp:ListItem Text="现金" Value="0" />
                                        <asp:ListItem Text="邮寄汇款" Value="4" />
                                        <asp:ListItem Text="上门收款" Value="5" />
                                        <asp:ListItem Text="支票" Value="6" />
                                        <asp:ListItem Text="其它" Value="7" />
                                    </asp:DropDownList><span>（注：“银行转帐”方式请注意描述银行帐号信息）</span>
                                </div>
                            </div>
                        </div>
                    </ContentTemplate>
                </asp:UpdatePanel>
                <asp:HiddenField ID="payTypeID" runat="server" />
                &nbsp;&nbsp;<br />
            </td>
        </tr>
        <tr>
            <td class="OrderTitle">
                设定付款折扣：</td>
            <td>
                <asp:TextBox ID="TxtDisCount" runat="server" Text="0" Width="30px" />%(请填写0-100范围内数字)
                <a href="#" onmouseover="showHelp('help2');" onmouseout="hidenHelp('help2');">&nbsp;<img
                    src="/Images/Member/tooltip.png" border="0" /></a><br />
                <asp:RequiredFieldValidator ID="Rq2" runat="server" ErrorMessage="折扣不能空" ControlToValidate="TxtDisCount"
                    Display="Dynamic" />
                <asp:RangeValidator ID="Ra1" runat="server" ControlToValidate="TxtDisCount" ErrorMessage="请填写0-100范围内数字"
                    MaximumValue="100" MinimumValue="0" Type="Integer" Display="Dynamic" Width="141px" /></td>
        </tr>
        <tr>
            <td class="OrderTitle">
                是否禁用：</td>
            <td>
                <asp:CheckBox ID="ChDisable" runat="server" Text="禁用" /></td>
        </tr>
        <tr>
            <td class="OrderTitle">
                描述：</td>
            <td>
                <asp:TextBox ID="TxtIntro" runat="server" TextMode="MultiLine" Height="60px" Width="433px"
                    onblur="CheckInputCharNums(this,200);" />(注:字数限制在200字以内)</td>
        </tr>
        <tr>
            <td class="OrderTitle">
                请输入安全密码：</td>
            <td>
                <asp:TextBox ID="UserSavePass" runat="server" TextMode="Password" /><a href="#" onmouseover="showHelp('help3');"
                    onmouseout="hidenHelp('help3');">&nbsp;<img src="/Images/Member/tooltip.png" border="0" /></a><br />
                <asp:RequiredFieldValidator ID="Rq4" runat="server" ErrorMessage="请输入安全密码" ControlToValidate="UserSavePass"
                    Display="Dynamic" /></td>
        </tr>
        <tr>
            <td colspan="2">
                <asp:Label ID="err_tips" runat="server" /></td>
        </tr>
        <tr>
            <td colspan="2" style="text-align: center;">
                <asp:Button ID="OnLinePaySubmit" runat="server" OnClick="OnLinePaySubmit_Click" Text=" 新 增 " />&nbsp;&nbsp;<a
                    href="Shop_PaymentType.aspx" style="display: none;" id="AddNewPayType">新增付款方式</a><asp:Button
                        ID="btnEdit" runat="server" Text="修改" Visible="False" OnClick="btnEdit_Click" /></td>
        </tr>
    </table>
    <div id="help2" style="position: absolute; z-index: 1000; border: solid 1px black;
        padding: 10px; background: white; display: none;" onmouseover="this.style.display='block';"
        onmouseout="this.style.display='none'">
        你可以设置多个付款方式，设置优惠的付款折扣可以吸引买家在购买商品时采用该付款方式。
    </div>
    <div id="help3" style="position: absolute; z-index: 1000; border: solid 1px black;
        padding: 10px; background: white; display: none;" onmouseover="this.style.display='block';"
        onmouseout="this.style.display='none'">
        此密码为用户登陆密码！
    </div>
    <div id="help4" style="position: absolute; z-index: 1000; border: solid 1px black;
        padding: 10px; background: white; display: none;" onmouseover="this.style.display='block';"
        onmouseout="this.style.display='none'">
        商城已集成支付宝商家工具。只需填写支付宝帐号即可无须另外开通商家工具。
    </div>
</asp:Content>
