﻿<%@ page language="C#" masterpagefile="MyShopMasterPage.master" autoeventwireup="true" inherits="Member_Shop_ProductInStock, WebApp_deploy" title="仓库商品" enableEventValidation="false" %>
<%@ Import   Namespace="HoWave.Web.Shop"   %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
 <div class="pageTitle">仓库里的商品</div>
 <br />
<table class="SearchTableStyle">
    <tr class="tdbg">
        <td class="tdbg5">商品名称：<asp:TextBox ID="TxtProductName" runat="server" /> </td>
        <td class="tdbg5">商品类型：<asp:DropDownList ID="ProductType" runat="server">
         <asp:ListItem Text="全部" Value="0" />
         <asp:ListItem Text="一口价" Value="1" />
         <asp:ListItem Text="拍卖" Value="2" />
         <asp:ListItem Text="团购" Value="3" />
      </asp:DropDownList></td>
        <td class="tdbg5"><asp:Button ID="Button1" runat="server" Text=" 查 询 " OnClick="Search_OnClick" /></td>
    </tr>
</table>
<br />
<div style="clear:both;"></div>  
    <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False"  AllowPaging="True" PageSize="20" CssClass="tableHead" DataKeyNames="ProductID" 
       OnRowDataBound="GridView1_RowDataBound" Width="98%" EnableViewState="False">
        <Columns>
            <asp:TemplateField HeaderText="选择" ItemStyle-Width="4%" ItemStyle-HorizontalAlign="Center">
               <ItemTemplate>
                   <input id="productids" name="productids" value="<%#Eval("ProductID") %>" type="checkbox" />
               </ItemTemplate>
               <HeaderTemplate>
                   <input id="chkAll" onclick="SelectAllCheckboxes(this,'');" type="checkbox" />  
               </HeaderTemplate>
            </asp:TemplateField>
            

            
            
            
            <asp:TemplateField HeaderText="图片">
            <HeaderStyle Width="110px" /> 
               <ItemTemplate>
                  <asp:HyperLink ID="ProductImgLink" runat="server" NavigateUrl='<%#"../ShowProduct.aspx?ProductID="+Eval("ProductID") %>'  Target="_blank"><asp:Image ID="Product_Image" runat="server" ImageUrl='<%# Eval("ProductSmallImageUrl") %>' onerror="this.src='/Images/show_nopic.gif'" Height="100px"   Width="100px"/>
                  </asp:HyperLink>
               </ItemTemplate>
               <HeaderStyle Width="14%" />
             </asp:TemplateField>
             
             
             
              <asp:TemplateField HeaderText="商品名称">
               <ItemTemplate>
                  <asp:HyperLink ID="ProductName" runat="server"  Text='<%# Eval("ProductName") %>'  NavigateUrl='<%#"../ShowProduct.aspx?ProductID="+Eval("ProductID") %>'  Target="_blank"/><br />
                  <asp:Label ID="ProductType" runat="server" Text='<%#TextFormat.GetProductType(Eval("ProductType").ToString())    %>'  ForeColor="orangered"/>
               </ItemTemplate>
             </asp:TemplateField>
            <asp:TemplateField HeaderText="销售时间">
                <ItemTemplate>
                    <asp:Literal ID="LitBeginDate" runat="server" Text='<%#Eval("BeginDate") %>' /><br />
                    <asp:Literal ID="LitEndDate" runat="server" Text='<%#Eval("EndDate") %>' />
                </ItemTemplate>
                <ItemStyle Width="14%" />
            </asp:TemplateField>
            <asp:BoundField DataField="CurrentPrice" HeaderText="价格">
                <ItemStyle Width="8%" />
            </asp:BoundField>
            <asp:BoundField DataField="Stocks" HeaderText="库存量">
                <ItemStyle Width="8%" />
            </asp:BoundField>
            <asp:HyperLinkField HeaderText="编辑" DataNavigateUrlFields="ProductID"  DataTextFormatString="编辑" DataNavigateUrlFormatString="../EditProduct.aspx?ProductID={0}" Target="_blank" ItemStyle-Width="6%" DataTextField="ProductID"/>
        </Columns>
        <EmptyDataTemplate>
        <table class="TableHeader" style="width:98%">
        <tr>
        <th>
            <input id="Checkbox1" type="checkbox" />选择</th>
            <th>图片</th>
            <th>商品名称</th>
            <th>销售时间</th>
            <th>价格</th>
            <th>库存量</th>
            <th>编辑</th>
        </tr>
        <tr><td colspan="7">暂无任何商品</td></tr>
        </table>
        </EmptyDataTemplate>
        <PagerStyle CssClass="productPageStyle" />            
    </asp:GridView>

<div style="text-align:center;width:98%; margin-top:10px;">
     <asp:Button ID="OnSale_Button" runat="server" Text="商品上架"  CommandName="OnSale" OnCommand="StockPorityButton_Command" />&nbsp;
     <asp:Button ID="btn_editProducts" runat="server" OnClick="btn_editProducts_Click" Text="批量修改" />
     <asp:Button ID="Delete_Button" runat="server" Text="批量删除" CommandName="Delete" OnCommand="StockPorityButton_Command"  OnClientClick="return confirm('确定将删除所选定的商品，确认吗？')"/></div>

<div style="margin:auto; width:95%; margin-top:10px;">
注：系统默认不删除有订单的商品！
</div>

  <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" SelectMethod="GetInStockProductsBySalerID" TypeName="HoWave.Web.Shop_Product" OldValuesParameterFormatString="original_{0}">
      <SelectParameters>
      <asp:Parameter  Name="SalerID"  Type="Int32"/>
      <asp:Parameter DefaultValue="NotSoldAll" Name="Type" Type="String" />
      </SelectParameters>
  </asp:ObjectDataSource>
  
</asp:Content>

