﻿<%@ page language="C#" masterpagefile="MyShopMasterPage.master" autoeventwireup="true" inherits="Member_ShopProductSale, WebApp_deploy" title="出售中的商品" enableEventValidation="false" %>
<%@ Register tagPrefix="hl" TagName="TextFormat" Src="../UserControls/ProductTextFormat.ascx" %>
<%@ Import   Namespace="HoWave.Web.Shop"%>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
<script language="javascript" type="text/javascript" src="../Js/howave_time.js"></script> 
 <div class="pageTitle">出售中的商品</div>
 <br />
 <table class="SearchTableStyle">
    <tr>
       <td>查询商品：
           <asp:DropDownList ID="searchProductType" runat="server" AppendDataBoundItems="True">
             <asp:ListItem Selected="True" Value="-1" Text="所有"/>
             <asp:ListItem Value="1" Text="推荐"/>
             <asp:ListItem Value="0" Text="没有推荐"/>
           </asp:DropDownList></td>
       <td>商品名称：<asp:TextBox ID="ProductName" runat="server"  Width="100px" Height="16px"/></td>
       <td>商品类型：<asp:DropDownList ID="ProductType" runat="server">
         <asp:ListItem Text="全部" Value="-1" />
         <asp:ListItem Text="一口价" Value="1" />
         <asp:ListItem Text="拍卖" Value="2" />
         <asp:ListItem Text="团购" Value="3" />
      </asp:DropDownList></td>
       <td><asp:CheckBox ID="bid" runat="server" Text="已出价" />
      <asp:CheckBox ID="discount_join" runat="server" Text="折扣" />&nbsp;</td>
       <td><asp:DropDownList ID="show_type" runat="server">
         <asp:ListItem Text="选择排序方式" Value="-1" Selected="True" />
         <asp:ListItem Text="上架时间从近到远" Value="1" />
         <asp:ListItem Text="上架时间从远到近" Value="2" />
         <asp:ListItem Text="价格从高到低" Value="3" />
         <asp:ListItem Text="价格从低到高" Value="4" />
         <asp:ListItem Text="浏览量从高到低" Value="5" />
         <asp:ListItem Text="浏览量从低到高" Value="6" />
         <asp:ListItem Text="剩余数量从高到低" Value="7" />
         <asp:ListItem Text="剩余数量从低到高" Value="8" />
      </asp:DropDownList></td>
       <td> <asp:Button ID="search" Text="查询" runat="server" OnClick="QucikSearch_Click"/></td>       
    </tr>
 </table>
 <br />
 <div id="product_history">
     <asp:GridView ID="GridView1" runat="server" CssClass="tableHead" AutoGenerateColumns="False" DataSourceID="ObjectDataSource1" 
     RowStyle-HorizontalAlign="Center" width="98%" AllowPaging="True" DataKeyNames="ProductID" AllowSorting="True" GridLines="Horizontal" OnPageIndexChanging="GridView1_PageIndexChanging" >
         <Columns>
             <asp:TemplateField HeaderText="选择">                
                 <HeaderStyle Width="20px" />
                 <ItemTemplate>
                     <asp:CheckBox ID="Product_Select" runat="server" />
                     <asp:HiddenField ID="ProductClassID" runat="server"  Value='<%# Eval("ClassID") %>'/>
                 </ItemTemplate>
                  <HeaderTemplate>
                     <input id="chkAll" onclick="SelectAllCheckboxes(this);" runat="server" type="checkbox" />                    
                  </HeaderTemplate>
                  <HeaderStyle Width="30px" />
             </asp:TemplateField>
             <asp:TemplateField HeaderText="图片">                
                 <HeaderStyle Width="110px" />              
                 <ItemTemplate>
                      <asp:HyperLink ID="ProductNameUrl2" runat="server" NavigateUrl='<%#"../ShowProduct.aspx?ProductID="+Eval("ProductID") %>' Target="_blank"><asp:Image ID="Image1" runat="server" ImageUrl='<%# (Convert.ToString(Eval("ProductSmallImageUrl"))==""?"../Images/show_nopic.gif":Eval("ProductSmallImageUrl")) %>' 
                        Height="100px"   Width="100px"/></asp:HyperLink>
                 </ItemTemplate>
             </asp:TemplateField>
             <asp:TemplateField HeaderText="商品名称">                 
                 <ItemTemplate>
                    <asp:HyperLink ID="ProductNameUrl" runat="server" Text='<%# Bind("ProductName") %>' NavigateUrl='<%#"../ShowProduct.aspx?ProductID="+Eval("ProductID") %>' Target="_blank"/><br />
                    <asp:Label ID="ProductType" runat="server" Text='<%#TextFormat.GetProductType(Eval("ProductType").ToString())    %>'  ForeColor="orangered"/>
                 </ItemTemplate>
                
             </asp:TemplateField>
             <asp:BoundField HeaderText="当前价格" DataField="CurrentPrice"  HeaderStyle-Width="120px"/>
             <asp:TemplateField HeaderText="剩余时间">                
                 <ItemTemplate>
                     <hl:TextFormat runat="server" ID="TextFormat0" Text="LeftTime" Value='<%# Eval("LeftTime")%>' />
                 </ItemTemplate>
                 <HeaderStyle Width="90px" />
             </asp:TemplateField>
             <asp:TemplateField HeaderText="出价次数/浏览量">                
                 <ItemTemplate>
                     <asp:Label ID="Bid_Times_Or_Hits" runat="server" Text='<%#Eval("BidTimes")+"/"+Eval("Hits") %>'/>
                 </ItemTemplate>
                  <HeaderStyle Width="120px" />
             </asp:TemplateField>
             <asp:BoundField DataField="Stocks" HeaderText="库存" />
             <asp:TemplateField HeaderText="操作">                
                 <HeaderStyle Width="100px" />
                 <ItemTemplate>
                     <asp:HyperLink ID="editProduct" runat="server" Text="编辑" NavigateUrl='<%#"../EditProduct.aspx?ProductID="+Eval("ProductID") %>' Target="_blank" />
                 </ItemTemplate>
             </asp:TemplateField>
         </Columns>
         <EmptyDataTemplate>
         <Table style="width:98%">
         <tr>
         <th><input id="Checkbox1" type="checkbox" />选择</th>
         <th>图片</th>
         <th>商品名称</th>
         <th>当前价格</th>
         <th>剩余时间</th>
         <th>出价次数/浏览量</th>
         <th>库存</th>
         <th>操作</th>
         </tr>
         <tr><td colspan="8">没有出售中的商品！</td></tr>
         </Table>
         </EmptyDataTemplate>
         <PagerStyle CssClass="productPageStyle" />              
     </asp:GridView>
 </div>
 <div align="center" style="text-align:center;">
     <asp:Button ID="Stop_Button" runat="server" Text="放入仓库"  CommandName="StopSale" OnCommand="Button_Command" />
     <asp:Button ID="Elite_Button" runat="server" Text="店铺推荐" CommandName="ShopElite" OnCommand="Button_Command" />
     <asp:Button ID="Button1" runat="server" Text="取消推荐" CommandName="CancleShopElite" OnCommand="Button_Command" />
 </div>
    <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" SelectMethod="GetOnSaleProductBySalerID" TypeName="HoWave.Web.Shop_Product" OldValuesParameterFormatString="original_{0}">
        <SelectParameters>
        <asp:Parameter
      Name="SalerID"   Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>