﻿<%@ page language="C#" autoeventwireup="true" inherits="Admin_GoodsManagement_UpdateGoods, ShopWe" validaterequest="false" %>

<%@ Register Assembly="System.Web.Extensions, Version=1.0.61025.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35"
    Namespace="System.Web.UI" TagPrefix="asp" %>
<%@ Register Src="~/Admin/UserControl/UploadImages.ascx" TagName="UploadImages" TagPrefix="uc5" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>修改商品基本信息</title>
    <link href="../css/my.css" rel="stylesheet" type="text/css" />
    <link href="../JS/TableSort/tablesort.css" rel="stylesheet" type="text/css" />
    <link href="../css/volti.css" rel="stylesheet" type="text/css" />

    <script src="../css/admin.js" type="text/javascript"></script>

    <!-- TinyMCE -->

    <script type="text/javascript" src="../JS/tinymce/tiny_mce.js"></script>

    <script type="text/javascript" src="../JS/TinyMceInit.js"></script>

    <!-- /TinyMCE -->
</head>
<body>
    <form id="form1" runat="server">
        <div class="validate">
            <asp:ValidationSummary ID="ValidationSummaryPage" CssClass="val_ys" runat="server"
                DisplayMode="List" ForeColor="#FF6600" />
            <asp:CompareValidator ID="CompareValidatorGoodsClass" runat="server" ForeColor="OrangeRed"
                ValueToCompare="请选择商品分类" Operator="NotEqual" ErrorMessage="请选择一个商品分类" ControlToValidate="GoodsClass"
                Display="None">请选择一个商品分类</asp:CompareValidator>
            <asp:CompareValidator ID="CompareValidatorGoodsBrand" runat="server" ForeColor="OrangeRed"
                ValueToCompare="请选择商品品牌" Operator="NotEqual" ErrorMessage="请选择一个商品品牌" ControlToValidate="GoodsBrand"
                Display="None"></asp:CompareValidator>
            <asp:RequiredFieldValidator ID="RequiredFieldValidatorGoodsName" runat="server" ForeColor="OrangeRed"
                ErrorMessage="商品名称不能为空" ControlToValidate="GoodsName" Display="None"></asp:RequiredFieldValidator>
            <asp:RequiredFieldValidator ID="RequiredFieldValidatorGoodsNumber" runat="server"
                ForeColor="OrangeRed" ErrorMessage="商品货号不能为空" ControlToValidate="GoodsNumber"
                Display="None"></asp:RequiredFieldValidator>
            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ForeColor="OrangeRed"
                ErrorMessage="商品售价不能为空" ControlToValidate="GoodsPrice" Display="None"></asp:RequiredFieldValidator>
            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ForeColor="OrangeRed"
                ErrorMessage="商品市场价不能为空" ControlToValidate="GoodsMarketPrice" Display="None"></asp:RequiredFieldValidator>
            <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ForeColor="OrangeRed"
                ErrorMessage="满足折扣购买数量不能为空" ControlToValidate="DiscountNumber" Display="None"></asp:RequiredFieldValidator>
            <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="GoodsMarketPrice"
                Display="None" ErrorMessage="市场价格式不对" ValidationExpression="^[0-9]+(.[0-9]{1,4})?$"></asp:RegularExpressionValidator>
            <asp:RegularExpressionValidator ID="RegularExpressionValidator2" runat="server" ControlToValidate="GoodsPrice"
                Display="None" ErrorMessage="商品售价格式不对" ValidationExpression="^[0-9]+(.[0-9]{1,4})?$"></asp:RegularExpressionValidator>
            <asp:RegularExpressionValidator ID="RegularExpressionValidator6" runat="server" ControlToValidate="GoodsCostPrice"
                Display="None" ErrorMessage="商品成本价格式不对" ValidationExpression="^[0-9]+(.[0-9]{1,4})?$"></asp:RegularExpressionValidator>
            <asp:RegularExpressionValidator ID="RegularExpressionValidator3" runat="server" ControlToValidate="GoodsHeft"
                Display="None" ErrorMessage="商品重量格式不对,不能输入小数" ValidationExpression="^\d+$"></asp:RegularExpressionValidator>
            <asp:RegularExpressionValidator ID="RegularExpressionValidator4" runat="server" ControlToValidate="GoodsStock"
                Display="None" ErrorMessage="库存数量格式不对,不能输入小数" ValidationExpression="^\d+$"></asp:RegularExpressionValidator>
            <asp:RegularExpressionValidator ID="RegularExpressionValidator5" runat="server" ControlToValidate="PointText"
                Display="None" ErrorMessage="赠送积分格式不对,不能输入小数" ValidationExpression="^\d+$"></asp:RegularExpressionValidator>
            <asp:RegularExpressionValidator ID="RegularExpressionValidator7" runat="server" ControlToValidate="DiscountNumber"
                Display="None" ErrorMessage="商品参与折扣满足数量不对,不能输入小数" ValidationExpression="^\d+$"></asp:RegularExpressionValidator>
        </div>
        <div id="all">
            <asp:Panel ID="PanelBody" runat="server" Height="100%" ScrollBars="Auto" Width="100%">
                <div class="come_title">
                    <div class="title_ico">
                        <img src="../css/images/title_ico.jpg" width="16" height="16" /></div>
                    <h2>
                        商品的基本信息</h2>
                    <div class="title_help">
                        <a href="#">
                            <img src="../css/images/help.jpg" alt="shopwe帮助中心" /></a></div>
                </div>
                <div class="k_all">
                    <div class="k1">
                        <div class="img_250">
                            <asp:Panel ID="newPreview" runat="server" Width="200px" Height="200px">
                            </asp:Panel>
                        </div>
                        <br />
                        <asp:FileUpload ID="FileUploadSmallImage" runat="server" Width="203" CssClass="input" />
                    </div>
                    <div class="k2">
                        <table width="100%" cellpadding="0" cellspacing="0">
                            <tr>
                                <td width="90" class="bg_1" style="text-align: right; width: 90px;">
                                    商品分类：
                                </td>
                                <td>
                                    <asp:DropDownList ID="GoodsClass" runat="server" Width="226" AutoPostBack="True"
                                        OnSelectedIndexChanged="GoodsClass_SelectedIndexChanged">
                                    </asp:DropDownList>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                </td>
                                <td>
                                    <asp:Literal ID="LiteralFilter" runat="server"></asp:Literal></td>
                            </tr>
                            <tr>
                                <td width="90" class="bg_1" style="text-align: right;">
                                    商品品牌：
                                </td>
                                <td>
                                    <asp:DropDownList ID="GoodsBrand" runat="server" Width="226">
                                    </asp:DropDownList>
                                </td>
                            </tr>
                            <tr>
                                <td width="90" class="bg_1" style="text-align: right;">
                                    商品名称：
                                </td>
                                <td class="bg_1">
                                    <asp:TextBox ID="GoodsName" runat="server" CssClass="input" Width="220"></asp:TextBox>&nbsp;&nbsp;&nbsp;<img
                                        src="../css/images/help.png" />
                                    <span class="lu">商品名称可以是英文、数字、汉字</span>
                                </td>
                            </tr>
                            <tr>
                                <td width="90" class="bg_1" style="text-align: right;">
                                    商品货号：
                                </td>
                                <td class="bg_1">
                                    <asp:TextBox ID="GoodsNumber" runat="server" CssClass="input4" Width="220"></asp:TextBox>&nbsp;&nbsp;&nbsp;<img
                                        src="../css/images/help.png" />
                                    <span style="color: #999999">可以自行录入或系统生成，</span><asp:Button ID="ValieateGoodsNumber"
                                        runat="server" Text="检查重复" OnClick="ValieateGoodsNumber_Click" CssClass="kon_button" />&nbsp;<span
                                            class="lu">商品货号不能重复</span>
                                </td>
                            </tr>
                            <tr>
                                <td width="90" class="bg_1" style="text-align: right;">
                                    关键词：
                                </td>
                                <td class="bg_1">
                                    <asp:CheckBoxList ID="GoodsTag" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                                        <asp:ListItem>最新</asp:ListItem>
                                        <asp:ListItem>热卖</asp:ListItem>
                                        <asp:ListItem>促销</asp:ListItem>
                                        <asp:ListItem>推荐</asp:ListItem>
                                        <asp:ListItem>配件</asp:ListItem>
                                    </asp:CheckBoxList>
                                </td>
                            </tr>
                            <tr>
                                <td width="90" class="bg_1" style="text-align: right;">
                                    自定义标签：
                                </td>
                                <td class="bg_1">
                                    <input id="ControlTag" runat="server" type="text" class="input4" style="width: 220px" />&nbsp;&nbsp;&nbsp;<span
                                        class="lu"><img src="../css/images/help.png" />
                                        多个关键词之间可以用逗号（,）分开。</span><span style="color: #999999">例如：保湿,美白</span></td>
                            </tr>
                            <tr>
                                <td width="90" class="bg_1" style="text-align: right;">
                                    计量单位：
                                </td>
                                <td class="bg_1">
                                    <asp:TextBox ID="GoodsMeasure" runat="server" Width="71" CssClass="input2">台</asp:TextBox>
                                    商品重量：<asp:TextBox ID="GoodsHeft" runat="server" Width="71px" CssClass="input2">0</asp:TextBox>&nbsp;&nbsp;&nbsp;<img
                                        src="../css/images/help.png" />
                                    <span style="color: #999999">默认单位为 <span class="lu">克</span>，商品重量关系着商品的 <span class="lu">
                                        配送价格</span> ，请仔细填写</span>
                                </td>
                            </tr>
                            <tr>
                                <td width="90" class="bg_1" style="text-align: right;">
                                    赠送积分：
                                </td>
                                <td>
                                    <input type="text" runat="server" value="0" id="PointText" name="textfield" class="input"
                                        style="width: 220px" />
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="come_title">
                    <div class="title_ico">
                        <img src="../css/images/title_ico.jpg" width="16" height="16" /></div>
                    <h2>
                        商品价格与库存</h2>
                    <h3>
                        （注意：如果您输入商品有"商品属性"，则商品的价格和库存取决于属性的库存和价格，你可以直接到商品属性中去填写）</h3>
                </div>
                <div class="k_all2">
                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                            <td class="bg_1" style="text-align: right; width: 100px; height: 36px;">
                                商品售价：
                            </td>
                            <td style="width: 120px">
                                <asp:TextBox ID="GoodsPrice" runat="server" Width="100" CssClass="input">0</asp:TextBox>
                            </td>
                            <td class="bg_1" style="text-align: right; width: 100px">
                                市场售价：
                            </td>
                            <td style="width: 120px">
                                <asp:TextBox ID="GoodsMarketPrice" runat="server" Width="100" CssClass="input">0</asp:TextBox>
                            </td>
                            <td class="bg_1" style="text-align: right; width: 100px">
                                成本价：
                            </td>
                            <td style="width: 120px">
                                <asp:TextBox ID="GoodsCostPrice" runat="server" Width="100" CssClass="input">0</asp:TextBox>
                            </td>
                            <td class="bg_1" style="text-align: right; width: 100px">
                                库存数量：
                            </td>
                            <td>
                                <asp:TextBox ID="GoodsStock" runat="server" Width="100" CssClass="input">0</asp:TextBox>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="come_title">
                    <div class="title_ico">
                        <img src="../css/images/title_ico.jpg" width="16" height="16" /></div>
                    <h2>
                        是否参与会员打折</h2>
                    <h3>
                        （注意：置此商品是否参与会员可享受折扣率的打折，同时设置购买商品需要满足多少数量才能享受折扣）</h3>
                </div>
                <div class="k_all2">
                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                            <td class="bg_1" style="text-align: right; width: 100px; height: 36px;">
                                会员打折：
                            </td>
                            <td style="width: 120px">
                                <asp:RadioButton ID="IsDiscountYes" Text="是" runat="server" GroupName="IsDiscount"
                                    Checked="True" /><asp:RadioButton ID="IsDiscountNo" Text="否" runat="server" GroupName="IsDiscount" />
                            </td>
                            <td class="bg_1" style="text-align: right; width: 100px">
                                满足数量：
                            </td>
                            <td>
                                <asp:TextBox ID="DiscountNumber" runat="server" Width="100" CssClass="input">1</asp:TextBox>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="come_title">
                    <div class="title_ico">
                        <img src="../css/images/title_ico.jpg" width="16" height="16" /></div>
                    <h2>
                        商品简介</h2>
                    <h3>
                        （不能超过1000字节）</h3>
                </div>
                <div class="k_all2">
                    <textarea id="GoodsSummarize" cols="20" rows="2" style="width: 100%; height: 200px"
                        runat="server"></textarea>
                </div>
            </asp:Panel>
        </div>
        <div id="sub">
            <asp:ImageButton ID="Submit" runat="server" ImageUrl="~/Admin/css/images/sub_button.jpg"
                OnClick="Submit_Click" />
        </div>
    </form>
</body>
</html>
