﻿using System;
using System.Data;
using System.Globalization;
using System.Text;
using Microsoft.Practices.EnterpriseLibrary.Data;
using Microsoft.Practices.EnterpriseLibrary.Data.Sql;
using System.Data.Common;
using System.Data.SqlClient;
using System.Web.UI.WebControls;
using Maticsoft.DBUtility;//请先添加引用

namespace DataClass
{
    public class BaseData
    {
        public BaseData()
        {
        }

        public static bool is_MeiShi(string dept_id)
        {
            return DbHelperSQL.Exists("select 1 from dept_list where can_sell=1 and dept_id='" + dept_id + "'");            
        }

        public static int info(string op_str, Int16 isreg)
        {
            DataClass.BaseData ws = new DataClass.BaseData();
            Model.BaseData.Company_data model = new Model.BaseData.Company_data();

            model = ws.GetCompany_dataModel();

            return FengFan.Functions.i("computer", model.sname, op_str, model.sman, model.tel, model.address, model.email, model.mobil, isreg);
        }
        public static bool is_reg_company_info()
        {
            DataClass.BaseData ws = new DataClass.BaseData();
            Model.BaseData.Company_data model = new Model.BaseData.Company_data();

            model = ws.GetCompany_dataModel();

            return model.sname.Length > 0 && model.sman.Length > 0 && model.tel.Length > 0 && model.address.Length > 0 && model.email.Length > 0 && model.mobil.Length > 0;
        }
        public static bool repeat_codeID(string codeID, string save_state, string material_id)
        {
            int _count = 0;
            bool _return = false;
            if (codeID.Trim().Length > 0)
            {

                if (save_state == "N")
                {
                    _count = Int16.Parse(DbHelperSQL.GetSingle("select count(1) from material_list where codeID='" + codeID.Trim() + "'").ToString());
                }
                if (save_state == "M")
                {
                    _count = Int16.Parse(DbHelperSQL.GetSingle("select count(1) from material_list where material_id!='" + material_id + "' and  codeID='" + codeID.Trim() + "'").ToString());

                } if (_count > 0) _return = true; else _return = false;

            }
            return _return;
        }




        public DataSet GetDept()
        {

            SqlDatabase db = common.db;

            string sqlCommand = "SELECT  [dept_id], [sname], [sman], [tel], [remark],can_sell   FROM [dept_list] ORDER BY [dept_id]";
            DbCommand dbCommand = db.GetSqlStringCommand(sqlCommand);

            DataSet _DataSet = null;

            _DataSet = db.ExecuteDataSet(dbCommand);


            return _DataSet;
        }

        public ListItemCollection get_DropData(string sql_str)
        {
            SqlDatabase db = common.db;

            string sqlCommand = sql_str;
            DbCommand dbCommand = db.GetSqlStringCommand(sqlCommand);


            ListItemCollection _ws = new ListItemCollection();

            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(dbCommand);
            ListItem _List = new ListItem();
            try
            {
                _List.Text = "请选择";
                _List.Value = "-1";
                _ws.Add(_List);
                while (MyReader.Read())
                {
                    _ws.Add(new ListItem(MyReader[1].ToString(), MyReader[0].ToString()));
                }
            }
            finally
            {
                MyReader.Close();
            }

            return _ws;
        }

        public ListItemCollection get_deptData(string sql_str)
        {
            SqlDatabase db = common.db;

            string sqlCommand = sql_str;
            DbCommand dbCommand = db.GetSqlStringCommand(sqlCommand);


            ListItemCollection _ws = new ListItemCollection();

            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(dbCommand);
            ListItem _List = new ListItem();
            try
            {
                _List.Text = "总店";
                _List.Value = "0";
                _ws.Add(_List);
                while (MyReader.Read())
                {
                    _ws.Add(new ListItem(MyReader[1].ToString(), MyReader[0].ToString()));
                }
            }
            finally
            {
                MyReader.Close();
            }

            return _ws;
        }

        public int DeleteDept(string dept_id)
        {
            SqlDatabase db = common.db;

            DbCommand deleteCommand = db.GetStoredProcCommand("delete_dept_list");
            db.AddInParameter(deleteCommand, "dept_id_1", DbType.String, dept_id);

            int rowsAffected = db.ExecuteNonQuery(deleteCommand);

            return rowsAffected;

        }
        public int InsertDept(string dept_id, string sname, string sman, string tel, string remark, bool can_sell, string statu)
        {
            SqlDatabase db = common.db;

            DbCommand insertCommand = db.GetStoredProcCommand("insert_dept_list");
            db.AddInParameter(insertCommand, "dept_id_1", DbType.String, dept_id);
            db.AddInParameter(insertCommand, "sname_2", DbType.String, sname);
            db.AddInParameter(insertCommand, "sman_3", DbType.String, sman);
            db.AddInParameter(insertCommand, "tel_4", DbType.String, tel);
            db.AddInParameter(insertCommand, "remark_5", DbType.String, remark);
            db.AddInParameter(insertCommand, "can_sell", DbType.String, can_sell);
            db.AddInParameter(insertCommand, "_statu", DbType.String, statu);

            int rowsAffected = db.ExecuteNonQuery(insertCommand);

            return rowsAffected;

        }


        public DataSet GetDuty()
        {

            SqlDatabase db = common.db;

            string sqlCommand = "SELECT [duty_id], [sname],  [remark] FROM [duty_list] ORDER BY [duty_id]";
            DbCommand dbCommand = db.GetSqlStringCommand(sqlCommand);

            DataSet _DataSet = null;

            _DataSet = db.ExecuteDataSet(dbCommand);


            return _DataSet;
        }

        public int DeleteDuty(string duty_id)
        {
            SqlDatabase db = common.db;

            DbCommand deleteCommand = db.GetStoredProcCommand("delete_duty_list");
            db.AddInParameter(deleteCommand, "duty_id", DbType.String, duty_id);

            int rowsAffected = db.ExecuteNonQuery(deleteCommand);

            return rowsAffected;

        }
        public int InsertDuty(string duty_id, string sname, string remark, string statu)
        {
            SqlDatabase db = common.db;

            DbCommand insertCommand = db.GetStoredProcCommand("insert_duty_list");
            db.AddInParameter(insertCommand, "duty_id", DbType.String, duty_id);
            db.AddInParameter(insertCommand, "sname", DbType.String, sname);
            db.AddInParameter(insertCommand, "remark", DbType.String, remark);
            db.AddInParameter(insertCommand, "_statu", DbType.String, statu);

            int rowsAffected = db.ExecuteNonQuery(insertCommand);

            return rowsAffected;

        }




        public DataSet Getmomey_unit_list()
        {

            SqlDatabase db = common.db;

            string sqlCommand = "SELECT money_id, [momey_unit_id], [momey_unit_name],  [momey_unit_name_en],[base_usa],convert(varchar(10),sdate,120) as sdate  FROM [momey_unit_list] ORDER BY money_id";
            DbCommand dbCommand = db.GetSqlStringCommand(sqlCommand);

            DataSet _DataSet = null;

            _DataSet = db.ExecuteDataSet(dbCommand);


            return _DataSet;
        }

        public int Deletemomey_unit(string momey_unit_id)
        {
            SqlDatabase db = common.db;

            DbCommand deleteCommand = db.GetStoredProcCommand("delete_momey_unit_list");
            db.AddInParameter(deleteCommand, "momey_unit_id", DbType.String, momey_unit_id);

            int rowsAffected = db.ExecuteNonQuery(deleteCommand);

            return rowsAffected;

        }
        public int Insertmomey_unit(string momey_unit_id, string momey_unit_name, string momey_unit_name_en, Double base_usa, string statu)
        {
            SqlDatabase db = common.db;

            DbCommand insertCommand = db.GetStoredProcCommand("insert_momey_unit_list");
            db.AddInParameter(insertCommand, "momey_unit_id", DbType.String, momey_unit_id);
            db.AddInParameter(insertCommand, "momey_unit_name", DbType.String, momey_unit_name);
            db.AddInParameter(insertCommand, "momey_unit_name_en", DbType.String, momey_unit_name_en);
            db.AddInParameter(insertCommand, "base_usa", DbType.Double, base_usa);
            db.AddInParameter(insertCommand, "_statu", DbType.String, statu);

            int rowsAffected = db.ExecuteNonQuery(insertCommand);

            return rowsAffected;

        }

        public DataSet GetDepot()
        {

            SqlDatabase db = common.db;

            string sqlCommand = "SELECT  [depot_id], [sname], [sman], [tel], [remark] ,case stype when 'R' then '原料' when 'H' then '零部件' else '成品' end as stype FROM [depot_list] ORDER BY [depot_id]";
            DbCommand dbCommand = db.GetSqlStringCommand(sqlCommand);

            DataSet _DataSet = null;

            _DataSet = db.ExecuteDataSet(dbCommand);


            return _DataSet;
        }

        public int DeleteDepot(string depot_id)
        {
            SqlDatabase db = common.db;

            DbCommand deleteCommand = db.GetStoredProcCommand("delete_depot_list");
            db.AddInParameter(deleteCommand, "depot_id_1", DbType.String, depot_id);

            int rowsAffected = db.ExecuteNonQuery(deleteCommand);

            return rowsAffected;

        }
        public int InsertDepot(string depot_id, string sname, string sman, string tel, string remark, string stype, string statu)
        {
            SqlDatabase db = common.db;

            DbCommand insertCommand = db.GetStoredProcCommand("insert_depot_list");
            db.AddInParameter(insertCommand, "depot_id_1", DbType.String, depot_id);
            db.AddInParameter(insertCommand, "sname_2", DbType.String, sname);
            db.AddInParameter(insertCommand, "sman_3", DbType.String, sman);
            db.AddInParameter(insertCommand, "tel_4", DbType.String, tel);
            db.AddInParameter(insertCommand, "stype", DbType.String, stype);
            db.AddInParameter(insertCommand, "remark_5", DbType.String, remark);
            db.AddInParameter(insertCommand, "_statu", DbType.String, statu);

            int rowsAffected = db.ExecuteNonQuery(insertCommand);

            return rowsAffected;

        }

        private int   set_allid()
        {
            SqlDatabase db = common.db;

            DbCommand insertCommand = db.GetStoredProcCommand("set_allid");

          return   db.ExecuteNonQuery(insertCommand);
        }


        public DataSet Getmaterial_type_by_fatherid(string  fatherid)
        {

            SqlDatabase db = common.db;

            string sqlCommand = "Select  id,context,fatherid From  tbtree  where fatherid=" + fatherid;
            DbCommand dbCommand = db.GetSqlStringCommand(sqlCommand);

            return db.ExecuteDataSet(dbCommand);

        }

        public DataSet Getmaterial_type()
        {

            SqlDatabase db = common.db;

            string sqlCommand = @"Select  id,context,  fatherid     From  tbtree ";
            DbCommand dbCommand = db.GetSqlStringCommand(sqlCommand);

            return db.ExecuteDataSet(dbCommand);

        }
        public int Insert_material_type(int fatherid, string context)
        {
            SqlDatabase db = common.db;

            string sqlCommand = "insert into tbtree (context,fatherid ) values('"+context+"',"+fatherid.ToString()+")   ";
            DbCommand dbCommand = db.GetSqlStringCommand(sqlCommand);

            
db.ExecuteNonQuery(CommandType.Text,sqlCommand);
            return set_allid();
        }


        private void delete_material_by_type(int stype)
        {
            SqlDatabase db = common.db;

            string sqlCommand = "delete from material_list where stype=" + stype.ToString();
            DbCommand dbCommand = db.GetSqlStringCommand(sqlCommand);
            db.ExecuteNonQuery(CommandType.Text, sqlCommand);
        }

        public int Modify_material_type(int id, string context)
        {
            SqlDatabase db = common.db;

            string sqlCommand = "update tbtree set  context='"+context+"' where id="+id.ToString();
            DbCommand dbCommand = db.GetSqlStringCommand(sqlCommand);
db.ExecuteNonQuery(CommandType.Text, sqlCommand);
          
            return   set_allid();
        }

        public int Delete_material_type(int id)
        {
            SqlDatabase db = common.db;

            string sqlCommand = "delete from tbtree where id=" + id.ToString();
            DbCommand dbCommand = db.GetSqlStringCommand(sqlCommand);

            delete_material_by_type(id);db.ExecuteNonQuery(CommandType.Text, sqlCommand);
           
            return  set_allid();
        }
        public DataSet GetPayment()
        {

            SqlDatabase db = common.db;

            string sqlCommand = "SELECT [payment_id], [sname],[days],  [remark] FROM [payment_list] ORDER BY [payment_id]";
            DbCommand dbCommand = db.GetSqlStringCommand(sqlCommand);

            DataSet _DataSet = null;

            _DataSet = db.ExecuteDataSet(dbCommand);


            return _DataSet;
        }

        public int DeletePayment(int payment_id)
        {
            SqlDatabase db = common.db;

            DbCommand deleteCommand = db.GetStoredProcCommand("delete_payment_list");
            db.AddInParameter(deleteCommand, "payment_id", DbType.Int16, payment_id);

            int rowsAffected = db.ExecuteNonQuery(deleteCommand);

            return rowsAffected;

        }
        public int InsertPayment(int payment_id, string sname,Int16 days, string remark, string statu)
        {
            SqlDatabase db = common.db;

            DbCommand insertCommand = db.GetStoredProcCommand("insert_payment_list");
            db.AddInParameter(insertCommand, "payment_id", DbType.Int16, payment_id);
            db.AddInParameter(insertCommand, "sname", DbType.String, sname);
            db.AddInParameter(insertCommand, "days", DbType.Int16, days);
            db.AddInParameter(insertCommand, "remark", DbType.String, remark);
            db.AddInParameter(insertCommand, "_statu", DbType.String, statu);

            int rowsAffected = db.ExecuteNonQuery(insertCommand);

            return rowsAffected;

        }

        public DataSet Getunit_list()
        {

            SqlDatabase db = common.db;

            string sqlCommand = "SELECT [unit_id], [sname],  case when [is_Base_Unit]=1 then '基本单位' else '' end as is_Base_Unit,[rate_to_base]  FROM [unit_list] ORDER BY unit_id";
            DbCommand dbCommand = db.GetSqlStringCommand(sqlCommand);

            DataSet _DataSet = null;

            _DataSet = db.ExecuteDataSet(dbCommand);


            return _DataSet;
        }

        public int Deleteunit(string unit_id)
        {
            SqlDatabase db = common.db;

            DbCommand deleteCommand = db.GetStoredProcCommand("delete_unit_list");
            db.AddInParameter(deleteCommand, "unit_id", DbType.String, unit_id);

            int rowsAffected = db.ExecuteNonQuery(deleteCommand);

            return rowsAffected;

        }
        public int Insertunit(string unit_id, string sname, int is_Base_Unit, Double rate_to_base, string statu)
        {
            SqlDatabase db = common.db;

            DbCommand insertCommand = db.GetStoredProcCommand("insert_unit_list");
            db.AddInParameter(insertCommand, "unit_id", DbType.String, unit_id);
            db.AddInParameter(insertCommand, "sname", DbType.String, sname);
            db.AddInParameter(insertCommand, "is_Base_Unit", DbType.Int16, is_Base_Unit);
            db.AddInParameter(insertCommand, "rate_to_base", DbType.Double, rate_to_base);
            db.AddInParameter(insertCommand, "_statu", DbType.String, statu);

            int rowsAffected = db.ExecuteNonQuery(insertCommand);

            return rowsAffected;

        }


        /// <summary>
        ///  更新一条数据
        /// </summary>
        public int Update_Company_data(Model.BaseData.Company_data model)
        {
            SqlDatabase db = common.db;
            DbCommand _Command = db.GetStoredProcCommand("UP_Company_data_Update");

            db.AddInParameter(_Command, "id", DbType.Int32, model.id);
            db.AddInParameter(_Command, "sname", DbType.String, model.sname);
            db.AddInParameter(_Command, "sname_en", DbType.String, model.sname_en);
            db.AddInParameter(_Command, "address", DbType.String, model.address);
            db.AddInParameter(_Command, "sman", DbType.String, model.sman);
            db.AddInParameter(_Command, "tel", DbType.String, model.tel);
            db.AddInParameter(_Command, "fax", DbType.String, model.fax);
            db.AddInParameter(_Command, "mobil", DbType.String, model.mobil);
            db.AddInParameter(_Command, "email", DbType.String, model.email);
            db.AddInParameter(_Command, "remark", DbType.String, model.remark);

            return db.ExecuteNonQuery(_Command);
        }

        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        public Model.BaseData.Company_data GetCompany_dataModel()
        {
            SqlDatabase db = common.db;

            DbCommand SelectCommand = db.GetSqlStringCommand("SELECT * FROM Company_data");

            Model.BaseData.Company_data model = new Model.BaseData.Company_data();

            DataSet ds = db.ExecuteDataSet(SelectCommand);
            if (ds.Tables[0].Rows.Count > 0)
            {
                model.id = Int32.Parse(ds.Tables[0].Rows[0]["id"].ToString());
                model.sname = ds.Tables[0].Rows[0]["sname"].ToString();
                model.sname_en = ds.Tables[0].Rows[0]["sname_en"].ToString();
                model.address = ds.Tables[0].Rows[0]["address"].ToString();
                model.sman = ds.Tables[0].Rows[0]["sman"].ToString();
                model.tel = ds.Tables[0].Rows[0]["tel"].ToString();
                model.fax = ds.Tables[0].Rows[0]["fax"].ToString();
                model.mobil = ds.Tables[0].Rows[0]["mobil"].ToString();
                model.email = ds.Tables[0].Rows[0]["email"].ToString();
                model.remark = ds.Tables[0].Rows[0]["remark"].ToString();
                return model;
            }
            else
            {
                return null;
            }
        }

        public int Getretail_MaterialList_Count()
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetSqlStringCommand("select count(1) from material_list");

            int _count = 0;
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            try
            {
                MyReader.Read();
                _count = Int32.Parse(MyReader[0].ToString());//页面尺寸

            }
            finally
            {
                MyReader.Close();
            }

            return _count;
        }
        public DataSet Get_retail_MaterialList(int CurrentPage, int PageSize)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_material_list_Query");
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);
            db.AddInParameter(selectCommand, "PageSize", DbType.Int32, PageSize);

            return db.ExecuteDataSet(selectCommand);
        }
        public DataSet GetMaterialList(int material_id, int stype, string sname, string model,string  codeID, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_material_list_Query");
            db.AddInParameter(selectCommand, "material_id", DbType.Int32, material_id);
            db.AddInParameter(selectCommand, "stype", DbType.Int32, stype);
            db.AddInParameter(selectCommand, "sname", DbType.String, sname);
            db.AddInParameter(selectCommand, "codeID", DbType.String, codeID);
            db.AddInParameter(selectCommand, "model", DbType.String, model);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }

        public DataSet GetMaterialListEXCEL(int material_id, int stype, string sname, string model, string codeID)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_material_list_Query");
            db.AddInParameter(selectCommand, "material_id", DbType.Int32, material_id);
            db.AddInParameter(selectCommand, "stype", DbType.Int32, stype);
            db.AddInParameter(selectCommand, "sname", DbType.String, sname);
            db.AddInParameter(selectCommand, "codeID", DbType.String, codeID);
            db.AddInParameter(selectCommand, "model", DbType.String, model);
            db.AddInParameter(selectCommand, "@PageSize", DbType.Int32,999999);

            return db.ExecuteDataSet(selectCommand);
        }


        public Array GetMaterialList_Count(int material_id, int stype, string sname, string model, string codeID)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_material_list_Query");
            db.AddInParameter(selectCommand, "material_id", DbType.Int32, material_id);
            db.AddInParameter(selectCommand, "stype", DbType.Int32, stype);
            db.AddInParameter(selectCommand, "sname", DbType.String, sname);
            db.AddInParameter(selectCommand, "codeID", DbType.String, codeID);
            db.AddInParameter(selectCommand, "model", DbType.String, model);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }
        public DataSet GetMaterialList(int material_id, int stype, string sname, string abrv, string model, string codeID, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_material_list_Query");
            db.AddInParameter(selectCommand, "material_id", DbType.Int32, material_id);
            db.AddInParameter(selectCommand, "stype", DbType.Int32, stype);
            db.AddInParameter(selectCommand, "sname", DbType.String, sname);
            db.AddInParameter(selectCommand, "abrv", DbType.String, abrv);
            db.AddInParameter(selectCommand, "codeID", DbType.String, codeID);
            db.AddInParameter(selectCommand, "model", DbType.String, model);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array GetMaterialList_Count(int material_id, int stype, string sname, string abrv, string model, string codeID)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_material_list_Query");
            db.AddInParameter(selectCommand, "material_id", DbType.Int32, material_id);
            db.AddInParameter(selectCommand, "stype", DbType.Int32, stype);
            db.AddInParameter(selectCommand, "sname", DbType.String, sname);
            db.AddInParameter(selectCommand, "abrv", DbType.String, abrv);
            db.AddInParameter(selectCommand, "codeID", DbType.String, codeID);
            db.AddInParameter(selectCommand, "model", DbType.String, model);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }

        public string Get_material_type_class(int material_type_id)
        {
            SqlDatabase db = common.db;
            DbCommand _Command = db.GetStoredProcCommand("Get_material_type_class");

            db.AddInParameter(_Command, "material_type_id", DbType.Int32, material_type_id);
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(_Command);
            MyReader.Read();
            return MyReader[0].ToString();
        }
        public int AddMaterialList(Model.BaseData.material_list model)
        {
            SqlDatabase db = common.db;
            DbCommand _Command = db.GetStoredProcCommand("UP_material_list_ADD");

            db.AddInParameter(_Command, "material_id", DbType.Int32, model.material_id);
            db.AddInParameter(_Command, "safe_store_up", DbType.Int32, model.safe_store_up);
            db.AddInParameter(_Command, "safe_store_down", DbType.Int32, model.safe_store_down);
            db.AddInParameter(_Command, "stype", DbType.Int32, model.stype);
            db.AddInParameter(_Command, "sname", DbType.String, model.sname);
            db.AddInParameter(_Command, "abrv", DbType.String, model.abrv);
            db.AddInParameter(_Command, "model", DbType.String, model.model);
            db.AddInParameter(_Command, "unit_id", DbType.String, model.Unit_id);
            db.AddInParameter(_Command, "is_qc", DbType.Boolean, model.is_qc);
            db.AddInParameter(_Command, "remark", DbType.String, model.remark);
            db.AddInParameter(_Command, "expire_date", DbType.String, model.expire_date);
            db.AddInParameter(_Command, "codeID", DbType.String, model.CodeId);

            return db.ExecuteNonQuery(_Command);
        }

        /// <summary>
        ///  更新一条数据
        /// </summary>
        public int UpdateMaterialList(Model.BaseData.material_list model)
        {
            SqlDatabase db = common.db;
            DbCommand _Command = db.GetStoredProcCommand("UP_material_list_Update");

            db.AddInParameter(_Command, "material_id", DbType.Int32, model.material_id);
            db.AddInParameter(_Command, "safe_store_up", DbType.Int32, model.safe_store_up);
            db.AddInParameter(_Command, "safe_store_down", DbType.Int32, model.safe_store_down);
            db.AddInParameter(_Command, "stype", DbType.Int32, model.stype);
            db.AddInParameter(_Command, "sname", DbType.String, model.sname);
            db.AddInParameter(_Command, "model", DbType.String, model.model);
            db.AddInParameter(_Command, "unit_id", DbType.String, model.Unit_id);
            db.AddInParameter(_Command, "abrv", DbType.String, model.abrv);
            db.AddInParameter(_Command, "is_qc", DbType.Boolean, model.is_qc);
            db.AddInParameter(_Command, "remark", DbType.String, model.remark);
            db.AddInParameter(_Command, "expire_date", DbType.String, model.expire_date);
            db.AddInParameter(_Command, "codeID", DbType.String, model.CodeId);

            return db.ExecuteNonQuery(_Command);
        }

        /// <summary>
        /// 删除一条数据
        /// </summary>
        public int DeleteMaterialList(int material_id)
        {

            SqlDatabase db = common.db;
            DbCommand deleteCommand = db.GetStoredProcCommand("UP_material_list_Delete");
            db.AddInParameter(deleteCommand, "material_id", DbType.Int32, material_id);
            int rowsAffected = db.ExecuteNonQuery(deleteCommand);

            return rowsAffected;
        }

        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        public Model.BaseData.material_list GetMaterialListModel(int material_id)
        {
            SqlDatabase db = common.db;

            DbCommand SelectCommand = db.GetSqlStringCommand("SELECT * FROM material_list WHERE [material_id] =" + material_id.ToString());

            Model.BaseData.material_list model = new Model.BaseData.material_list();

            DataSet ds = db.ExecuteDataSet(SelectCommand);
            model.material_id = material_id;
            if (ds.Tables[0].Rows.Count > 0)
            {
                model.stype = Int32.Parse(ds.Tables[0].Rows[0]["stype"].ToString());
                model.sname = ds.Tables[0].Rows[0]["sname"].ToString();
                model.abrv = ds.Tables[0].Rows[0]["abrv"].ToString();
                model.model = ds.Tables[0].Rows[0]["model"].ToString();
                model.Unit_id = ds.Tables[0].Rows[0]["unit_id"].ToString();
                model.remark = ds.Tables[0].Rows[0]["remark"].ToString();
                model.expire_date = ds.Tables[0].Rows[0]["expire_date"].ToString();
                model.safe_store_up = Int32.Parse(ds.Tables[0].Rows[0]["safe_store_up"].ToString());
                model.safe_store_down = Int32.Parse(ds.Tables[0].Rows[0]["safe_store_down"].ToString());
                model.CodeId = ds.Tables[0].Rows[0]["codeId"].ToString();
                if (ds.Tables[0].Rows[0]["is_qc"].ToString() != "")
                {
                    if ((ds.Tables[0].Rows[0]["is_qc"].ToString() == "1") || (ds.Tables[0].Rows[0]["is_qc"].ToString().ToLower() == "true"))
                    {
                        model.is_qc = true;
                    }
                    else
                    {
                        model.is_qc = false;
                    }
                }

                return model;
            }
            else
            {
                return null;
            }
        }



        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        public Model.BaseData.material_list GetMaterialListModel(string codeid)
        {
            SqlDatabase db = common.db;

            DbCommand SelectCommand = db.GetSqlStringCommand("SELECT * FROM material_list WHERE [codeid] ='" + codeid+"'");

            Model.BaseData.material_list model = new Model.BaseData.material_list();

            DataSet ds = db.ExecuteDataSet(SelectCommand);
            model.CodeId = codeid;
            if (ds.Tables[0].Rows.Count > 0)
            {
                model.stype = Int32.Parse(ds.Tables[0].Rows[0]["stype"].ToString());
                model.sname = ds.Tables[0].Rows[0]["sname"].ToString();
                model.model = ds.Tables[0].Rows[0]["model"].ToString();
                model.Unit_id = ds.Tables[0].Rows[0]["unit_id"].ToString();
                model.remark = ds.Tables[0].Rows[0]["remark"].ToString();
                model.expire_date = ds.Tables[0].Rows[0]["expire_date"].ToString();
                model.material_id = Int32.Parse(ds.Tables[0].Rows[0]["material_id"].ToString());
                model.safe_store_up = Int32.Parse(ds.Tables[0].Rows[0]["safe_store_up"].ToString());
                model.safe_store_down = Int32.Parse(ds.Tables[0].Rows[0]["safe_store_down"].ToString());
                if (ds.Tables[0].Rows[0]["is_qc"].ToString() != "")
                {
                    if ((ds.Tables[0].Rows[0]["is_qc"].ToString() == "1") || (ds.Tables[0].Rows[0]["is_qc"].ToString().ToLower() == "true"))
                    {
                        model.is_qc = true;
                    }
                    else
                    {
                        model.is_qc = false;
                    }
                }

                return model;
            }
            else
            {
                return null;
            }
        }








        public DataSet Getother_type()
        {

            SqlDatabase db = common.db;

            string sqlCommand = "SELECT [typeID], [type_name],  case when [inORout]=1 then '收入' else '開支' end as inORout  FROM [other_type] ORDER BY typeID";
            DbCommand dbCommand = db.GetSqlStringCommand(sqlCommand);

            DataSet _DataSet = null;

            _DataSet = db.ExecuteDataSet(dbCommand);


            return _DataSet;
        }

        public int Deleteother_type(string typeID)
        {
            SqlDatabase db = common.db;

            DbCommand deleteCommand = db.GetSqlStringCommand("delete from other_type where typeID=@typeID");
            db.AddInParameter(deleteCommand, "typeID", DbType.String, typeID);

            int rowsAffected = db.ExecuteNonQuery(deleteCommand);

            return rowsAffected;

        }
        public int Insertother_type(string typeID, string type_name, bool inORout, string statu)
        {
            SqlDatabase db = common.db;

            DbCommand insertCommand = db.GetStoredProcCommand("insert_other_type");
            db.AddInParameter(insertCommand, "typeID", DbType.Int16, typeID);
            db.AddInParameter(insertCommand, "type_name", DbType.String, type_name);
            db.AddInParameter(insertCommand, "inORout", DbType.Boolean, inORout);
            db.AddInParameter(insertCommand, "_statu", DbType.String, statu);

            int rowsAffected = db.ExecuteNonQuery(insertCommand);

            return rowsAffected;

        }

    }
}
