﻿using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using Maticsoft.DBUtility;//请先添加引用
using Microsoft.Practices.EnterpriseLibrary.Data;
using Microsoft.Practices.EnterpriseLibrary.Data.Sql;
using System.Web.UI.WebControls;
using System.Data.Common;
namespace DataClass
{
	/// <summary>
	/// 数据访问类Client_Pay 。
	/// </summary>
    public class Client_Pay 
	{
		public Client_Pay()
		{}

        public int insert_into_Client_Pay(string op_id, string client_id, string dd_id, string dept_id, decimal amount)
        {
            SqlDatabase db = common.db;


            using (DbCommand dbcomm = db.GetSqlStringCommand("INSERT INTO  Client_Pay  (op_id  ,dd_id ,amount,dept_id,client_id) VALUES(@op_id  ,@dd_id ,@amount,@dept_id,@client_id)"))
            {

                db.AddInParameter(dbcomm, "op_id", DbType.String, op_id);
                db.AddInParameter(dbcomm, "dd_id", DbType.String, dd_id);
                db.AddInParameter(dbcomm, "dept_id", DbType.String, dept_id);
                db.AddInParameter(dbcomm, "client_id", DbType.String, client_id);
                db.AddInParameter(dbcomm, "amount", DbType.Decimal, amount);
                return db.ExecuteNonQuery(dbcomm);
            }

        }
        public DataSet Get_Client_Pay_record_List(string client_id, string from_date, string to_date, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_Client_Pay_record_Query");
            db.AddInParameter(selectCommand, "client_id", DbType.String, client_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array Get_Client_Pay_record_List_Count(string client_id, string from_date, string to_date)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_Client_Pay_record_Query");
            db.AddInParameter(selectCommand, "client_id", DbType.String, client_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }



        public DataSet Get_client_payable_List(string client_id,  int is_query_all)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_client_payable");
            db.AddInParameter(selectCommand, "client_id", DbType.String, client_id);
            db.AddInParameter(selectCommand, "is_query_all", DbType.Int16, is_query_all);

            return db.ExecuteDataSet(selectCommand);
        }


        public static DataSet Get_client_not_payable_remark(string client_id, string dd_id, string dept_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetSqlStringCommand(@"SELECT   *  from sell_and_modify_remark_View WHERE     (client_id =@client_id) AND (dept_id =@dept_id) AND (dd_id =@dd_id)");
            db.AddInParameter(selectCommand, "client_id", DbType.String, client_id);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "dd_id", DbType.String, dd_id);

            return db.ExecuteDataSet(selectCommand);
        }

        /*SELECT     client_id, dept_id, dd_id, sdate, amount, had_pay_amount, payable, dd_type, client_name, dept_name, sman, address, tel, abrv, client_type_name, 
                      client_type_id, pay_state
FROM         client_payable_view
WHERE     (client_id = 'aagda') AND (dept_id = '0') AND (dd_id = '010803150001')*/

        public DataSet Get_client_payable_remark(string op_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetSqlStringCommand(@"SELECT     dbo.Client_Pay.op_id, dbo.Client_Pay.dd_id, dbo.Client_Pay.amount AS payable, ISNULL(dbo.dept_list.sname, '总店') AS dept_name
FROM         dbo.Client_Pay LEFT OUTER JOIN
                      dbo.dept_list ON dbo.Client_Pay.dept_id = dbo.dept_list.dept_id where dbo.Client_Pay.op_id=@op_id");
            db.AddInParameter(selectCommand, "op_id", DbType.String, op_id);

            return db.ExecuteDataSet(selectCommand);
        }




        public DataSet Get_client_sell_pay_print_data(string client_id, string from_date, string to_date)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("client_sell_pay_print_data");
            db.AddInParameter(selectCommand, "client_id", DbType.String, client_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);

            return db.ExecuteDataSet(selectCommand);
        }


        public DataSet Get_client_sum_payable_List(string client, int pay_state,  int client_type_id, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_client_sum_payable");
            db.AddInParameter(selectCommand, "client", DbType.String, client);
            db.AddInParameter(selectCommand, "pay_state", DbType.Int16, pay_state);
            db.AddInParameter(selectCommand, "client_type_id", DbType.Int16, client_type_id);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }

        public Array Get_client_sum_payable_Count(string client, int pay_state,  int client_type_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_client_sum_payable");
            db.AddInParameter(selectCommand, "client", DbType.String, client);
            db.AddInParameter(selectCommand, "pay_state", DbType.Int16, pay_state);
            db.AddInParameter(selectCommand, "client_type_id", DbType.Int16, client_type_id);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }

        public Array Get_client_sum_amount(string client, int pay_state, int client_type_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_client_sum_amount");
            db.AddInParameter(selectCommand, "client", DbType.String, client);
            db.AddInParameter(selectCommand, "pay_state", DbType.Int16, pay_state);
            db.AddInParameter(selectCommand, "client_type_id", DbType.Int16, client_type_id);

            decimal[] Array = new decimal[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = decimal.Parse(MyReader[0].ToString());//页面尺寸

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }



		#region  成员方法
		/// <summary>
		///  增加一条数据
		/// </summary>
		public string  Add(Model.Client_Pay model)
		{
            SqlDatabase db = common.db;

            DbCommand dbcomm = db.GetStoredProcCommand("UP_Client_Pay_record_ADD");

            db.AddInParameter(dbcomm, "amount", DbType.Decimal, model.amount);
            db.AddInParameter(dbcomm, "sman", DbType.String, model.sman);
            db.AddInParameter(dbcomm, "sdate", DbType.String, model.sdate);

            db.AddInParameter(dbcomm, "dept_id", DbType.String, model.dept_id);
            db.AddInParameter(dbcomm, "pay_Way", DbType.Int16, model.pay_Way);
            db.AddInParameter(dbcomm, "remark", DbType.String, model.remark);
            db.AddInParameter(dbcomm, "client_id", DbType.String, model.client_id);
            db.AddOutParameter(dbcomm, "op_id", DbType.String, 20); 

         //   db.AddParameter(dbcomm, "op_id", DbType.String, ParameterDirection.ReturnValue, "", DataRowVersion.Current, null);
            db.ExecuteNonQuery(dbcomm);

            return dbcomm.Parameters["@op_id"].Value.ToString();
		}


		/// <summary>
		/// 删除一条数据
		/// </summary>
		public void Delete(string op_id)
		{

			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@op_id", SqlDbType.VarChar)
				};
			parameters[0].Value = op_id;
            DbHelperSQL.RunProcedure("UP_Client_Pay_record_Delete", parameters, out rowsAffected);
		}

		/// <summary>
		/// 得到一个对象实体
		/// </summary>
		public Model.Client_Pay GetModel(string op_id)
		{
            SqlDatabase db = common.db;

            DbCommand SelectCommand = db.GetSqlStringCommand("select * from  Client_Pay_view where op_id='" + op_id + "'");
            Model.Client_Pay model = new Model.Client_Pay();

            DataSet ds = db.ExecuteDataSet(SelectCommand);
            model.op_id = op_id;
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["amount"].ToString()!="")
				{
                    model.amount = Decimal.Parse(ds.Tables[0].Rows[0]["amount"].ToString());
				}
				model.sman=ds.Tables[0].Rows[0]["sman"].ToString();
				model.sdate=ds.Tables[0].Rows[0]["sdate"].ToString();
				model.pay_Way=Int16.Parse(ds.Tables[0].Rows[0]["pay_Way"].ToString());
				model.remark=ds.Tables[0].Rows[0]["remark"].ToString();
				model.sk_man=ds.Tables[0].Rows[0]["sk_man"].ToString();
                model.sk_date = ds.Tables[0].Rows[0]["sk_date"].ToString();
                model.client_id = ds.Tables[0].Rows[0]["client_id"].ToString();
				return model;
			}
			else
			{
				return null;
			}
		}



        public DataSet Get_client_pay_bill(string client_id, string from_date, string to_date, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_client_pay_bill_Query");
            db.AddInParameter(selectCommand, "client_id", DbType.String, client_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array Get_client_pay_sum(string client_id, string from_date, string to_date)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_client_pay_bill_sum");
            db.AddInParameter(selectCommand, "client_id", DbType.String, client_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);

            decimal[] Array = new decimal[1];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = decimal.Parse(MyReader[0].ToString());//页面尺寸

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }


        public DataSet Get_client_pay_bill_excel(string client_id, string from_date, string to_date)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_client_pay_bill_Query");
            db.AddInParameter(selectCommand, "client_id", DbType.String, client_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "PageSize", DbType.Int32, 99999);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array Get_client_pay_bill_Count(string client_id, string from_date, string to_date)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_client_pay_bill_Query");
            db.AddInParameter(selectCommand, "client_id", DbType.String, client_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }



        public DataSet Get_client_sum_payable_Excel(string client, int pay_state, int client_type_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_client_sum_payable");
            db.AddInParameter(selectCommand, "client", DbType.String, client);
            db.AddInParameter(selectCommand, "pay_state", DbType.Int16, pay_state);
            db.AddInParameter(selectCommand, "client_type_id", DbType.Int16, client_type_id);
            db.AddInParameter(selectCommand, "@PageSize", DbType.Int32, 99999);

            return db.ExecuteDataSet(selectCommand);
        }









		#endregion  成员方法
	}
}

