﻿using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using Maticsoft.DBUtility;//请先添加引用
using Microsoft.Practices.EnterpriseLibrary.Data;
using Microsoft.Practices.EnterpriseLibrary.Data.Sql;
using System.Web.UI.WebControls;
using System.Data.Common;
namespace DataClass
{
    /// <summary>
    /// 数据访问类Provide_Pay 。
    /// </summary>
    public class Provide_Pay
    {
        public Provide_Pay()
        { }

        public int insert_into_Provide_Pay(string op_id, string Provide_id, string stock_id, string dept_id, Decimal amount)
        {
            SqlDatabase db = common.db;

            DbCommand dbcomm = db.GetSqlStringCommand("INSERT INTO  Provide_Pay  (op_id  ,stock_id ,amount,dept_id,Provide_id) VALUES(@op_id  ,@stock_id ,@amount,@dept_id,@Provide_id)");

            db.AddInParameter(dbcomm, "op_id", DbType.String, op_id);
            db.AddInParameter(dbcomm, "stock_id", DbType.String, stock_id);
            db.AddInParameter(dbcomm, "dept_id", DbType.String, dept_id);
            db.AddInParameter(dbcomm, "Provide_id", DbType.String, Provide_id);
            db.AddInParameter(dbcomm, "amount", DbType.Decimal, amount);
            return db.ExecuteNonQuery(dbcomm);

        }
        public DataSet Get_Provide_Pay_record_List(string Provide_id, string from_date, string to_date, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_Provide_Pay_record_Query");
            db.AddInParameter(selectCommand, "Provide_id", DbType.String, Provide_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array Get_Provide_Pay_record_List_Count(string Provide_id, string from_date, string to_date)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_Provide_Pay_record_Query");
            db.AddInParameter(selectCommand, "Provide_id", DbType.String, Provide_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }



        public DataSet Get_Provide_payable_List(string Provide_id, int is_query_all)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_Provide_payable");
            db.AddInParameter(selectCommand, "Provide_id", DbType.String, Provide_id);
            db.AddInParameter(selectCommand, "is_query_all", DbType.Int16, is_query_all);

            return db.ExecuteDataSet(selectCommand);
        }



        public static DataSet Get_provide_not_payable_remark(string provide_id, string stock_id, string dept_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetSqlStringCommand(@"SELECT   *  from stock_and_little_View WHERE     (provide_id =@provide_id) AND (dept_id =@dept_id) AND (stock_id =@stock_id)");
            db.AddInParameter(selectCommand, "provide_id", DbType.String, provide_id);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "stock_id", DbType.String, stock_id);

            return db.ExecuteDataSet(selectCommand);
        }

        /*SELECT     client_id, dept_id, dd_id, sdate, amount, had_pay_amount, payable, dd_type, client_name, dept_name, sman, address, tel, abrv, client_type_name, 
                      client_type_id, pay_state
FROM         client_payable_view
WHERE     (client_id = 'aagda') AND (dept_id = '0') AND (dd_id = '010803150001')*/
        public DataSet Get_Provide_sum_payable_List(string Provide, int pay_state,  int Provide_type_id, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_Provide_sum_payable");
            db.AddInParameter(selectCommand, "Provide", DbType.String, Provide);
            db.AddInParameter(selectCommand, "pay_state", DbType.Int16, pay_state);
            db.AddInParameter(selectCommand, "Provide_type_id", DbType.Int16, Provide_type_id);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }


        public DataSet Get_provide_sum_payable_Excel(string Provide, int pay_state, int Provide_type_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_Provide_sum_payable");
            db.AddInParameter(selectCommand, "Provide", DbType.String, Provide);
            db.AddInParameter(selectCommand, "pay_state", DbType.Int16, pay_state);
            db.AddInParameter(selectCommand, "Provide_type_id", DbType.Int16, Provide_type_id);
            db.AddInParameter(selectCommand, "@PageSize", DbType.Int32, 99999);

            return db.ExecuteDataSet(selectCommand);
        }
        public DataSet Get_Provide_payable_remark(string op_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetSqlStringCommand(@"SELECT     dbo.Provide_Pay.op_id, dbo.Provide_Pay.stock_id, isnull(dbo.provide_stock_View.amount,0) as amount,
isnull(dbo.provide_stock_View.dd_type,'') as dd_type, dbo.Provide_Pay.amount AS payable, 
                      ISNULL(dbo.dept_list.sname, '总店') AS dept_name
FROM         dbo.dept_list RIGHT OUTER JOIN
                      dbo.Provide_Pay ON dbo.dept_list.dept_id = dbo.Provide_Pay.dept_id LEFT OUTER JOIN
                      dbo.provide_stock_View ON dbo.Provide_Pay.stock_id = dbo.provide_stock_View.stock_id AND dbo.Provide_Pay.dept_id = dbo.provide_stock_View.dept_id AND 
                      dbo.Provide_Pay.Provide_id = dbo.provide_stock_View.Provide_id where dbo.Provide_Pay.op_id=@op_id");
            db.AddInParameter(selectCommand, "op_id", DbType.String, op_id);

            return db.ExecuteDataSet(selectCommand);
        }



        public Array Get_Provide_sum_payable_Count(string Provide_id, int pay_state, int Provide_type_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_Provide_sum_payable");
            db.AddInParameter(selectCommand, "Provide", DbType.String, Provide_id);
            db.AddInParameter(selectCommand, "pay_state", DbType.Int16, pay_state);
            db.AddInParameter(selectCommand, "Provide_type_id", DbType.Int16, Provide_type_id);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }


        public Array Get_Provide_sum_amount(string Provide, int pay_state,  int Provide_type_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_Provide_sum_amount");
            db.AddInParameter(selectCommand, "Provide", DbType.String, Provide);
            db.AddInParameter(selectCommand, "pay_state", DbType.Int16, pay_state);
            db.AddInParameter(selectCommand, "Provide_type_id", DbType.Int16, Provide_type_id);

            decimal[] Array = new decimal[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = decimal.Parse(MyReader[0].ToString());//页面尺寸

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }




        #region  成员方法
        /// <summary>
        ///  增加一条数据
        /// </summary>
        public string Add(Model.Provide_Pay model)
        {
            SqlDatabase db = common.db;

            DbCommand dbcomm = db.GetStoredProcCommand("UP_Provide_Pay_record_ADD");

            db.AddInParameter(dbcomm, "amount", DbType.Decimal, model.amount);
            db.AddInParameter(dbcomm, "sman", DbType.String, model.sman);
            db.AddInParameter(dbcomm, "sdate", DbType.String, model.sdate);
            db.AddInParameter(dbcomm, "dept_id", DbType.String, model.dept_id);
            db.AddInParameter(dbcomm, "pay_Way", DbType.Int16, model.pay_Way);
            db.AddInParameter(dbcomm, "remark", DbType.String, model.remark);
            db.AddInParameter(dbcomm, "Provide_id", DbType.String, model.Provide_id);
            db.AddOutParameter(dbcomm, "op_id", DbType.String, 20);

            //   db.AddParameter(dbcomm, "op_id", DbType.String, ParameterDirection.ReturnValue, "", DataRowVersion.Current, null);
            db.ExecuteNonQuery(dbcomm);

            return dbcomm.Parameters["@op_id"].Value.ToString();
        }


        /// <summary>
        /// 删除一条数据
        /// </summary>
        public void Delete(string op_id)
        {

            int rowsAffected;
            SqlParameter[] parameters = {
					new SqlParameter("@op_id", SqlDbType.VarChar)
				};
            parameters[0].Value = op_id;
            DbHelperSQL.RunProcedure("UP_Provide_Pay_record_Delete", parameters, out rowsAffected);
        }

        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        public Model.Provide_Pay GetModel(string op_id)
        {
            SqlDatabase db = common.db;

            DbCommand SelectCommand = db.GetSqlStringCommand("select * from  Provide_Pay_view where op_id='" + op_id + "'");
            Model.Provide_Pay model = new Model.Provide_Pay();

            DataSet ds = db.ExecuteDataSet(SelectCommand);
            model.op_id = op_id;
            if (ds.Tables[0].Rows.Count > 0)
            {
                if (ds.Tables[0].Rows[0]["amount"].ToString() != "")
                {
                    model.amount =Decimal.Parse(ds.Tables[0].Rows[0]["amount"].ToString());
                }
                model.sman = ds.Tables[0].Rows[0]["sman"].ToString();
                model.sdate = ds.Tables[0].Rows[0]["sdate"].ToString();
                model.pay_Way = Int16.Parse(ds.Tables[0].Rows[0]["pay_Way"].ToString());
                model.remark = ds.Tables[0].Rows[0]["remark"].ToString();
                model.sk_man = ds.Tables[0].Rows[0]["sk_man"].ToString();
                model.sk_date = ds.Tables[0].Rows[0]["sk_date"].ToString();
                model.Provide_id = ds.Tables[0].Rows[0]["Provide_id"].ToString();
                return model;
            }
            else
            {
                return null;
            }
        }




        public DataSet Get_provide_pay_bill(string provide_id, string from_date, string to_date, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_provide_pay_bill_Query");
            db.AddInParameter(selectCommand, "provide_id", DbType.String, provide_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }

        public Array Get_provide_pay_sum(string provide_id, string from_date, string to_date)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_provide_pay_bill_sum");
            db.AddInParameter(selectCommand, "provide_id", DbType.String, provide_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);

            decimal[] Array = new decimal[1];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = decimal.Parse(MyReader[0].ToString());//页面尺寸

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }


        public DataSet Get_provide_pay_bill_excel(string provide_id, string from_date, string to_date)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_provide_pay_bill_Query");
            db.AddInParameter(selectCommand, "provide_id", DbType.String, provide_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "PageSize", DbType.Int32, 99999);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array Get_provide_pay_bill_Count(string provide_id, string from_date, string to_date)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_provide_pay_bill_Query");
            db.AddInParameter(selectCommand, "provide_id", DbType.String, provide_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }




        #endregion  成员方法
    }
}

