﻿using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using Maticsoft.DBUtility;//请先添加引用
using Microsoft.Practices.EnterpriseLibrary.Data;
using Microsoft.Practices.EnterpriseLibrary.Data.Sql;
using System.Data.Common;
using System.Web.UI.WebControls;
namespace DataClass
{
	/// <summary>
	/// 数据访问类back_for_modify 。
	/// </summary>
	public class back_for_modify
	{
        public back_for_modify()
		{}
		#region  成员方法
		
		
        public DataSet GetddList(string product_name, string client_name, string dept_id, string from_date, string to_date, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_back_for_modify_Query");
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "client_name", DbType.String, client_name);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array GetddList_Count(string product_name, string client_name, string dept_id, string from_date, string to_date)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_back_for_modify_Query");
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "client_name", DbType.String, client_name);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }
	

		/// <summary>
		///  增加一条数据
		/// </summary>
        public string Add(Model.back_for_modify model)
		{
			//model.input_id=GetMaxId();
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@product_id", SqlDbType.VarChar,20),
					new SqlParameter("@product_sn", SqlDbType.VarChar,50),
					new SqlParameter("@scount", SqlDbType.Int,4),
					new SqlParameter("@client", SqlDbType.VarChar,10),
					new SqlParameter("@sman", SqlDbType.VarChar,20),
					new SqlParameter("@sdate", SqlDbType.VarChar,20),
					new SqlParameter("@remark", SqlDbType.VarChar,50),
					new SqlParameter("@bill_id", SqlDbType.VarChar,20),
					new SqlParameter("@dept_id", SqlDbType.VarChar,5),
					new SqlParameter("@good_or_bad", SqlDbType.Bit,1)};
            parameters[0].Value = model.product_id;
			parameters[1].Value = model.product_sn;
			parameters[2].Value = model.scount;
			parameters[3].Value = model.client;
			parameters[4].Value = model.sman;
			parameters[5].Value = model.sdate;
			parameters[6].Value = model.remark;
			parameters[7].Value = model.bill_id;
			parameters[8].Value = model.dept_id;
			parameters[9].Value = model.good_or_bad;

			DbHelperSQL.RunProcedure("UP_back_for_modify_ADD",parameters,out rowsAffected);
			return model.input_id;
		}

		/// <summary>
		///  更新一条数据
		/// </summary>
		public void Update(Model.back_for_modify model)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@input_id", SqlDbType.VarChar,20),
					new SqlParameter("@product_id", SqlDbType.Int,4),
					new SqlParameter("@product_sn", SqlDbType.VarChar,50),
					new SqlParameter("@scount", SqlDbType.Int,4),
					new SqlParameter("@client", SqlDbType.VarChar,10),
					new SqlParameter("@sman", SqlDbType.VarChar,20),
					new SqlParameter("@sdate", SqlDbType.VarChar,20),
					new SqlParameter("@remark", SqlDbType.VarChar,50),
					new SqlParameter("@bill_id", SqlDbType.VarChar,20),
					new SqlParameter("@dept_id", SqlDbType.VarChar,5),
					new SqlParameter("@good_or_bad", SqlDbType.Bit,1)};
			parameters[0].Value = model.input_id;
			parameters[1].Value = model.product_id;
			parameters[2].Value = model.product_sn;
			parameters[3].Value = model.scount;
			parameters[4].Value = model.client;
			parameters[5].Value = model.sman;
			parameters[6].Value = model.sdate;
			parameters[7].Value = model.remark;
			parameters[8].Value = model.bill_id;
			parameters[9].Value = model.dept_id;
			parameters[10].Value = model.good_or_bad;

			DbHelperSQL.RunProcedure("UP_back_for_modify_Update",parameters,out rowsAffected);
		}

		/// <summary>
		/// 删除一条数据
		/// </summary>
        public void Delete(string input_id, string dept_id)
		{

			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@input_id", SqlDbType.VarChar,20),
					new SqlParameter("@dept_id", SqlDbType.VarChar,5)
				};
            parameters[0].Value = input_id;
            parameters[1].Value = dept_id;
			DbHelperSQL.RunProcedure("UP_back_for_modify_Delete",parameters,out rowsAffected);
		}

		/// <summary>
		/// 得到一个对象实体
		/// </summary>
        public Model.back_for_modify GetModel(string input_id, string dept_id)
		{
            SqlDatabase db = common.db;

            DbCommand SelectCommand = db.GetSqlStringCommand("SELECT * FROM back_for_modify_view WHERE [input_id] ='" + input_id + "' and dept_id='" + dept_id + "'");

            Model.back_for_modify model = new Model.back_for_modify();

            DataSet ds = db.ExecuteDataSet(SelectCommand);
            model.input_id = input_id;
            model.dept_id = dept_id;
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["product_id"].ToString()!="")
				{
					model.product_id=int.Parse(ds.Tables[0].Rows[0]["product_id"].ToString());
				}
				model.product_sn=ds.Tables[0].Rows[0]["product_sn"].ToString();
				if(ds.Tables[0].Rows[0]["scount"].ToString()!="")
				{
					model.scount=int.Parse(ds.Tables[0].Rows[0]["scount"].ToString());
				}
				model.client=ds.Tables[0].Rows[0]["client"].ToString();
				model.sman=ds.Tables[0].Rows[0]["sman"].ToString();
				model.sdate=ds.Tables[0].Rows[0]["sdate"].ToString();
				model.remark=ds.Tables[0].Rows[0]["remark"].ToString();
				model.bill_id=ds.Tables[0].Rows[0]["bill_id"].ToString();
				if(ds.Tables[0].Rows[0]["good_or_bad"].ToString()!="")
				{
					if((ds.Tables[0].Rows[0]["good_or_bad"].ToString()=="1")||(ds.Tables[0].Rows[0]["good_or_bad"].ToString().ToLower()=="true"))
					{
						model.good_or_bad=true;
					}
					else
					{
						model.good_or_bad=false;
					}
				}

				return model;
			}
			else
			{
				return null;
			}
		}
        public static void back_for_modify_Op(string input_id, string dept_id,int scount, string sman)
        {
            SqlDatabase db = common.db;

            DbCommand opCommand = db.GetSqlStringCommand("update  back_for_modify set op_scount=" + scount .ToString()+ ",op_man='" + sman + "',op_date=convert(varchar(19),getdate(),120) WHERE [input_id] ='" + input_id + "' and dept_id='" + dept_id + "'");

            db.ExecuteNonQuery(opCommand);
        }
        public static void back_for_modify_Op_un(string input_id, string dept_id, string sman)
        {
            SqlDatabase db = common.db;

            DbCommand opCommand = db.GetSqlStringCommand("update  back_for_modify set op_scount=0,op_man='',op_date='' WHERE [input_id] ='" + input_id + "' and dept_id='" + dept_id + "'");

            db.ExecuteNonQuery(opCommand);
        }

		#endregion  成员方法
	}
}

