﻿using System;
using System.Data;
using System.Globalization;
using System.Text;
using System.Text.RegularExpressions;
using Microsoft.Practices.EnterpriseLibrary.Data;
using Microsoft.Practices.EnterpriseLibrary.Data.Sql;
using System.Data.Common;
using System.Data.SqlClient;
using System.Web.UI.WebControls;
using System.Configuration;

namespace DataClass
{
   public class back_restore_database
   {
       /**//// <summary>
        /// 服务器
        /// </summary>
        private string server;
        
        /**//// <summary>
        /// 登录名
        /// </summary>
        private string uid;
        
        /**//// <summary>
        /// 登录密码
        /// </summary>
        private string pwd;
        
        /**//// <summary>
        /// 要操作的数据库
        /// </summary>
        private string database;
        
        /**//// <summary>
        /// 数据库连接字符串
        /// </summary>
        private string conn;
 
        /**//// <summary>
        /// DbOperate类的构造函数
        /// 在这里进行字符串的切割，获取服务器，登录名，密码，数据库
        /// </summary>
       
        
        /**//// <summary>
        /// 切割字符串
        /// </summary>
        /// <param name="str"></param>
        /// <param name="bg"></param>
        /// <param name="ed"></param>
        /// <returns></returns>
        

       public back_restore_database()
        {
            RegexOptions options = (RegexOptions.Multiline | RegexOptions.IgnoreCase);
            Regex reg = new Regex("Data Source=(?<1>[^;]*);Initial Catalog=(?<2>[^;]*);User ID=(?<3>[^;]*);password=(?<4>[^;]*)", options);

            MatchCollection mc = reg.Matches(common.connectionString);
            foreach (Match ma in mc)
            {
                server = ma.Groups["1"].Value.Trim();
                database = ma.Groups["2"].Value.Trim();
                uid = ma.Groups["3"].Value.Trim();
                pwd = ma.Groups["4"].Value.Trim();
            }
        }
       public void backup_data(string op_sman, string Save_File_Path)
       {
           try
           {
               SQLDMO.Backup backup = new SQLDMO.BackupClass();
               SQLDMO.SQLServer sqlserver = new SQLDMO.SQLServerClass();
               sqlserver.LoginSecure = false;
               sqlserver.Connect(server, uid, pwd);
               backup.Action = SQLDMO.SQLDMO_BACKUP_TYPE.SQLDMOBackup_Database;
               backup.Database = database;

               string filename = DateTime.Now.ToString("yyyyMMddHHmmss") + ".bak";


               backup.Files = Save_File_Path + filename;
               //backup.Files=@"f:\www\"+DateTime.Now.ToString("yyyyMMddhhss")+".bak";
               backup.BackupSetName = database;
               backup.BackupSetDescription = "data_backup";
               backup.Initialize = true;
               backup.SQLBackup(sqlserver);


               insert_backup_record(filename, op_sman);
           }
           catch
           {
           }
       }
       private int insert_backup_record(string filename, string sman)
       {
           SqlDatabase db = common.db;

           DbCommand insertCommand = db.GetSqlStringCommand("INSERT INTO [data_backup]( [filename],[sman]) VALUES ( '" + filename + "','" + sman + "')");

           int rowsAffected = db.ExecuteNonQuery(insertCommand);

           return rowsAffected;
       }

   
       public DataSet Get_Back_List(int CurrentPage)
       {
           SqlDatabase db = common.db;

           DbCommand selectCommand = db.GetStoredProcCommand("UP_backup_Query");
           db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

           return db.ExecuteDataSet(selectCommand);
       }
       public Array Get_Back_List_Count()
       {
           SqlDatabase db = common.db;

           DbCommand selectCommand = db.GetStoredProcCommand("UP_backup_Query");
           db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

           int[] Array = new int[3];
           SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
           ListItem _List = new ListItem();
           try
           {
               MyReader.Read();
               Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
               Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
               Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

           }
           finally
           {
               MyReader.Close();
           }

           return Array;
       }
       private void create_cutid()
       {
           SqlConnection conn = new SqlConnection("server=" + server + ";uid=" + uid + ";pwd=" + pwd + ";database=master");

           SqlCommand cmd = new SqlCommand(@"CREATE PROCEDURE [cutid]
                        (
                         @dbname varchar(20) --数据库的名称
                        )
                         WITH  ENCRYPTION  AS 
                        BEGIN
                         DECLARE @sql nvarchar(500)
                         DECLARE @spid int
                         SET @sql='declare getspid cursor for select spid from sysprocesses where dbid=db_id('''+@dbname+''')'
                         EXECUTE (@sql)
                         OPEN getspid
                         FETCH NEXT FROM getspid INTO @spid
                         WHILE @@fetch_status<>-1
                          BEGIN
                           EXECUTE('kill '+@spid)
                           FETCH NEXT FROM getspid INTO @spid
                          END
                         CLOSE getspid
                         DEALLOCATE getspid
                        END  ", conn);
           cmd.CommandType = CommandType.Text;
           conn.Open();
           try
           {
               cmd.ExecuteNonQuery();
           }
           catch
           {
           }
       }
       private bool exepro()
       {
           SqlConnection conn = new SqlConnection("server=" + server + ";uid=" + uid + ";pwd=" + pwd + ";database=master");


           SqlCommand cmd = new SqlCommand("cutid", conn);
           cmd.CommandType = CommandType.StoredProcedure;
           cmd.Parameters.AddWithValue("dbname", database);
           try
           {
               conn.Open();
               cmd.ExecuteNonQuery();
               return true;
           }
           catch
           {
               return false;
           }
           finally
           {
               conn.Close();
           }
       }

       public string DbRestore(string Save_File_Path)
       {
           create_cutid();
           if (exepro())
           {
               SQLDMO.Restore oRecomputer = new SQLDMO.Restore();
               SQLDMO.SQLServer oSQLServer = new SQLDMO.SQLServerClass();
               try
               {
                   oSQLServer.LoginSecure = false;
                   oSQLServer.Connect(server, uid, pwd);
                   oRecomputer.Action = SQLDMO.SQLDMO_RESTORE_TYPE.SQLDMORestore_Database;
                   oRecomputer.Database = database;


                   oRecomputer.Files = Save_File_Path;
                   oRecomputer.FileNumber = 1;
                   oRecomputer.ReplaceDatabase = true;
                   oRecomputer.SQLRestore(oSQLServer);

                   return "数据恢复成功!!";
               }
               catch  
               {
                   return "恢复数据出现错误,请稍后再试!!";
               }
               finally
               {
                   oSQLServer.DisConnect();
               }
           }
           else
           {
               return "仍有用户在使用本系统，恢复数据出现错误,请稍后再试!!";
           }
       }
    }
}
