﻿using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using Maticsoft.DBUtility;//请先添加引用
using Microsoft.Practices.EnterpriseLibrary.Data;
using Microsoft.Practices.EnterpriseLibrary.Data.Sql;
using System.Web.UI.WebControls;
using System.Data.Common;
namespace DataClass
{
    /// <summary>
    /// 数据访问类bank_list。
    /// </summary>
    public class bank_list
    {
        public bank_list()
        { }
        #region  成员方法
        /// <summary>
        ///  增加一条数据
        /// </summary>
        public int Add(Model.bank_list model,string _state)
        {
            SqlDatabase db = common.db;

            string _sql = "";
            if (_state == "I")
                _sql = "UP_bank_list_ADD";
            else
                _sql = "UP_bank_list_Update";


            DbCommand dbCommand = db.GetStoredProcCommand(_sql);
            db.AddInParameter(dbCommand, "bank_id", DbType.Int32, model.bank_id);
            db.AddInParameter(dbCommand, "bank_name", DbType.String, model.bank_name);
            db.AddInParameter(dbCommand, "first_amount", DbType.Decimal, model.first_amount);
            db.AddInParameter(dbCommand, "this_amount", DbType.Decimal, model.this_amount);

            db.AddInParameter(dbCommand, "remark", DbType.String, model.remark);
            db.AddInParameter(dbCommand, "bank_code", DbType.String, model.bank_code);
            db.ExecuteNonQuery(dbCommand);
            return (int)db.GetParameterValue(dbCommand, "bank_id");
        }

       

        /// <summary>
        /// 删除一条数据
        /// </summary>
        public void Delete(int bank_id)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetStoredProcCommand("UP_bank_list_Delete");
            db.AddInParameter(dbCommand, "bank_id", DbType.Int32, bank_id);

            db.ExecuteNonQuery(dbCommand);
        }

        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        public Model.bank_list GetModel(int bank_id)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetSqlStringCommand("select bank_id,bank_name,first_amount,this_amount,remark,bank_code where bank_id=@bank_id ");
            db.AddInParameter(dbCommand, "bank_id", DbType.Int32, bank_id);

            Model.bank_list model = null;
            using (IDataReader dataReader = db.ExecuteReader(dbCommand))
            {
                if (dataReader.Read())
                {
                    model = ReaderBind(dataReader);
                }
            }
            return model;
        }

        /// <summary>
        /// 获得数据列表
        /// </summary>
        public DataSet GetList()
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("bank_list_query");

            return db.ExecuteDataSet(selectCommand);
        }


        /// <summary>
        /// 对象实体绑定数据
        /// </summary>
        public Model.bank_list ReaderBind(IDataReader dataReader)
        {
            Model.bank_list model = new Model.bank_list();
            object ojb;
            ojb = dataReader["bank_id"];
            if (ojb != null && ojb != DBNull.Value)
            {
                model.bank_id = (int)ojb;
            }
            model.bank_name = dataReader["bank_name"].ToString();
            ojb = dataReader["first_amount"];
            if (ojb != null && ojb != DBNull.Value)
            {
                model.first_amount = (decimal)ojb;
            }
            ojb = dataReader["this_amount"];
            if (ojb != null && ojb != DBNull.Value)
            {
                model.this_amount = (decimal)ojb;
            }
            model.remark = dataReader["remark"].ToString();
            model.bank_code = dataReader["bank_code"].ToString();
            return model;
        }

        #endregion  成员方法
    }
}

