﻿using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using Maticsoft.DBUtility;//请先添加引用
using Microsoft.Practices.EnterpriseLibrary.Data;
using Microsoft.Practices.EnterpriseLibrary.Data.Sql;
using System.Web.UI.WebControls;
using System.Data.Common;
namespace DataClass
{
    /// <summary>
    /// 数据访问类cash_list。
    /// </summary>
    public class cash_list
    {
        public cash_list()
        { }
        #region  成员方法

        public Array Getdept_dayList_sum(string dept_id, string from_date, string to_date)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_dept_day_sum");
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);

            decimal[] Array = new decimal[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = decimal.Parse(MyReader[0].ToString());//页面尺寸

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }

        public DataSet Getdept_day(  string dept_id,   string from_date, string to_date, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_dept_day_Query");
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array Getdept_day_Count(  string dept_id,   string from_date, string to_date)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_dept_day_Query");
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }



        public DataSet GetcashList(string bank_id, string dept_id, string stype,string inout, string from_date, string to_date,int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_cash_list_Query");
            db.AddInParameter(selectCommand, "bank_id", DbType.String, bank_id);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "stype", DbType.String, stype);
            db.AddInParameter(selectCommand, "inout", DbType.String, inout);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array GetcashList_Count(string bank_id, string dept_id, string stype, string inout, string from_date, string to_date)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_cash_list_Query");
            db.AddInParameter(selectCommand, "bank_id", DbType.String, bank_id);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "stype", DbType.String, stype);
            db.AddInParameter(selectCommand, "inout", DbType.String, inout);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }


        public Array GetcashList_sum(string bank_id, string dept_id, string stype, string from_date, string to_date)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_cash_list_sum");
            db.AddInParameter(selectCommand, "bank_id", DbType.String, bank_id);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "stype", DbType.String, stype);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);

            decimal[] Array = new decimal[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = decimal.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = decimal.Parse(MyReader[1].ToString());//总记录数
                Array[2] = decimal.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }




        /// <summary>
        ///  增加一条数据
        /// </summary>
        public void Add(Model.cash_list model)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetStoredProcCommand("UP_cash_list_ADD");
            db.AddInParameter(dbCommand, "sdate", DbType.String, model.sdate);
            db.AddInParameter(dbCommand, "remark", DbType.String, model.remark);
            db.AddInParameter(dbCommand, "stype", DbType.String, model.stype);
            db.AddInParameter(dbCommand, "bank_id", DbType.Int32, model.bank_id);
            db.AddInParameter(dbCommand, "amount", DbType.Decimal, model.amount);
            db.AddInParameter(dbCommand, "system_input", DbType.Int32, model.system_input);//system_input_id
            db.AddInParameter(dbCommand, "system_input_id", DbType.String, model.system_input_id);//system_input_id
            db.AddInParameter(dbCommand, "dept_id", DbType.String, model.dept_id);
           // db.AddInParameter(dbCommand, "money_id", DbType.Int16, model.money_id);
            db.AddInParameter(dbCommand, "op_man", DbType.String, model.op_man);
            db.ExecuteNonQuery(dbCommand);
        }

        /// <summary>
        ///  更新一条数据
        /// </summary>
        public void Update(Model.cash_list model)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetStoredProcCommand("UP_cash_list_Update");
            db.AddInParameter(dbCommand, "op_id", DbType.String, model.op_id);
            db.AddInParameter(dbCommand, "sdate", DbType.String, model.sdate);
            db.AddInParameter(dbCommand, "remark", DbType.String, model.remark);
            db.AddInParameter(dbCommand, "stype", DbType.String, model.stype);
            db.AddInParameter(dbCommand, "bank_id", DbType.Int32, model.bank_id);//_system_input
            db.AddInParameter(dbCommand, "amount", DbType.Decimal, model.amount);
            db.AddInParameter(dbCommand, "dept_id", DbType.String, model.dept_id);
          //  db.AddInParameter(dbCommand, "money_id", DbType.Int16, model.money_id);
            db.AddInParameter(dbCommand, "op_man", DbType.String, model.op_man);
            db.ExecuteNonQuery(dbCommand);
        }
        public static int Add_Client_Pay(string sdate, string bank_id, decimal amount, string op_id, string op_man,string client_name,string dept_id)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetStoredProcCommand("UP_cash_list_ADD");
            db.AddInParameter(dbCommand, "sdate", DbType.String, sdate);
            db.AddInParameter(dbCommand, "remark", DbType.String,"收客户: "+client_name+" 款");
            db.AddInParameter(dbCommand, "stype", DbType.String, "1");
            db.AddInParameter(dbCommand, "bank_id", DbType.Int32, Int16.Parse(bank_id));
            db.AddInParameter(dbCommand, "amount", DbType.Decimal, amount);
            db.AddInParameter(dbCommand, "system_input", DbType.Int32, 1);//system_input_id
            db.AddInParameter(dbCommand, "system_input_id", DbType.String, op_id);//system_input_id
            db.AddInParameter(dbCommand, "dept_id", DbType.String, dept_id);
          //  db.AddInParameter(dbCommand, "money_id", DbType.Int16, 0);
            db.AddInParameter(dbCommand, "op_man", DbType.String, op_man);
           return  db.ExecuteNonQuery(dbCommand);
        }

        public static int Delete_Client_Pay(string op_id)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetSqlStringCommand("delete from cash_list where system_input_id=@system_input_id");
            db.AddInParameter(dbCommand, "system_input_id", DbType.String, op_id);
            return db.ExecuteNonQuery(dbCommand);
        }
        /*UPDATE    Provide_Pay_record
SET              pay_Way = CASE WHEN pay_way = '中国农业银行对公帐号' THEN 2 ELSE 1 END
UPDATE    client_Pay_record
SET              pay_Way = CASE WHEN pay_way = '中国农业银行对公帐号' THEN 2 ELSE 1 END*/

        public static int Add_dept_pay(string sdate, string dept_id, string sk_man)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetStoredProcCommand("UP_Add_dept_pay");
            db.AddInParameter(dbCommand, "sdate", DbType.String, sdate);
            db.AddInParameter(dbCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(dbCommand, "sk_man", DbType.String, sk_man);
            return db.ExecuteNonQuery(dbCommand);
        }

        public static int delete_dept_pay(string sdate, string dept_id)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetStoredProcCommand("UP_Delete_dept_pay");
            db.AddInParameter(dbCommand, "sdate", DbType.String, sdate);
            db.AddInParameter(dbCommand, "dept_id", DbType.String, dept_id);
            return db.ExecuteNonQuery(dbCommand);
        }



        public static int Add_Day_Pay(string sdate, decimal amount, string op_man, string bank_id, string dept_id, string dept_name)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetStoredProcCommand("UP_cash_list_ADD");
            db.AddInParameter(dbCommand, "sdate", DbType.String, sdate);
            db.AddInParameter(dbCommand, "remark", DbType.String, dept_name+":日结算现金");
            db.AddInParameter(dbCommand, "stype", DbType.String, "1");
            db.AddInParameter(dbCommand, "bank_id", DbType.Int32, Int16.Parse(bank_id));
            db.AddInParameter(dbCommand, "amount", DbType.Decimal, amount);
            db.AddInParameter(dbCommand, "system_input", DbType.Int32, 1);//system_input_id
            db.AddInParameter(dbCommand, "system_input_id", DbType.String, "日结算现金");//system_input_id
            db.AddInParameter(dbCommand, "dept_id", DbType.String, dept_id);
          //  db.AddInParameter(dbCommand, "money_id", DbType.Int16, 0);
            db.AddInParameter(dbCommand, "op_man", DbType.String, op_man);
            return db.ExecuteNonQuery(dbCommand);
        }

        public static int Delete_Day_Pay(string sdate, string dept_id)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetSqlStringCommand("delete from cash_list where system_input_id='日结算现金' and sdate=@sdate and dept_id=@dept_id");
            db.AddInParameter(dbCommand, "sdate", DbType.String, sdate);
            db.AddInParameter(dbCommand, "dept_id", DbType.String, dept_id);

            return db.ExecuteNonQuery(dbCommand);
        }

        public static int Add_Provide_Pay(string sdate, string bank_id, decimal amount, string op_id, string op_man, string provide_name,string dept_id)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetStoredProcCommand("UP_cash_list_ADD");
            db.AddInParameter(dbCommand, "sdate", DbType.String, sdate);
            db.AddInParameter(dbCommand, "remark", DbType.String, "付供应商: " + provide_name + " 款");
            db.AddInParameter(dbCommand, "stype", DbType.String, "0");
            db.AddInParameter(dbCommand, "bank_id", DbType.Int32, Int16.Parse(bank_id));
            db.AddInParameter(dbCommand, "amount", DbType.Decimal, amount);
            db.AddInParameter(dbCommand, "system_input", DbType.Int32, 1);//system_input_id
            db.AddInParameter(dbCommand, "system_input_id", DbType.String, op_id);//system_input_id
            db.AddInParameter(dbCommand, "dept_id", DbType.String, dept_id);
          //  db.AddInParameter(dbCommand, "money_id", DbType.Int16, 0);
            db.AddInParameter(dbCommand, "op_man", DbType.String, op_man);
            return db.ExecuteNonQuery(dbCommand);
        }

        public static int Delete_Provide_Pay(string op_id)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetSqlStringCommand("delete from cash_list where system_input_id=@system_input_id");
            db.AddInParameter(dbCommand, "system_input_id", DbType.String, op_id);
            return db.ExecuteNonQuery(dbCommand);
        }

        /// <summary>
        /// 删除一条数据
        /// </summary>
        public void Delete(string op_id)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetStoredProcCommand("UP_cash_list_Delete");
            db.AddInParameter(dbCommand, "op_id", DbType.String, op_id);

            db.ExecuteNonQuery(dbCommand);
        }

        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        public Model.cash_list GetModel(string op_id)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetSqlStringCommand("SELECT     op_id, sdate, remark, stype, bank_id, in_amount, out_amount,case when in_amount>0 then in_amount else out_amount end as amount, op_man, op_date, dept_id, sk_man, sk_date, money_id, system_input FROM         cash_list where op_id=@op_id");
            db.AddInParameter(dbCommand, "op_id", DbType.String, op_id);

            Model.cash_list model = null;
            using (IDataReader dataReader = db.ExecuteReader(dbCommand))
            {
                if (dataReader.Read())
                {
                    model = ReaderBind(dataReader);
                }
            }
            return model;
        }

        

        /// <summary>
        /// 对象实体绑定数据
        /// </summary>
        public  Model.cash_list ReaderBind(IDataReader dataReader)
        {
           Model.cash_list model = new Model.cash_list();
            object ojb;
            model.op_id = dataReader["op_id"].ToString();
            model.sdate = dataReader["sdate"].ToString();
            model.remark = dataReader["remark"].ToString();
            model.stype = dataReader["stype"].ToString();

            model.dept_id = dataReader["dept_id"].ToString();

            ojb = dataReader["money_id"];
            if (ojb != null && ojb != DBNull.Value)
            {
                model.money_id = (int)ojb;
            }

            ojb = dataReader["system_input"];
            if (ojb != null && ojb != DBNull.Value)
            {
                model.system_input = (int)ojb;
            }

            ojb = dataReader["bank_id"];
            if (ojb != null && ojb != DBNull.Value)
            {
                model.bank_id = (int)ojb;
            }
            ojb = dataReader["amount"];
            if (ojb != null && ojb != DBNull.Value)
            {
                model.amount = (decimal)ojb;
            }
            return model;
        }



        public DataSet Get_remark(string op_state, string dept_id, string dd_id, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_dept_day_remark_Query");
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "op_state", DbType.String, op_state);
            db.AddInParameter(selectCommand, "dd_id", DbType.String, dd_id);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array Get_remark_Count(string op_state, string dept_id, string dd_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_dept_day_remark_Query");
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "op_state", DbType.String, op_state);
            db.AddInParameter(selectCommand, "dd_id", DbType.String, dd_id);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }





        #endregion  成员方法
    }
}

