﻿using System;
using System.Data;
using System.Globalization;
using System.Text;
using Microsoft.Practices.EnterpriseLibrary.Data;
using Microsoft.Practices.EnterpriseLibrary.Data.Sql;
using System.Data.Common;
using System.Data.SqlClient;
using System.Web.UI.WebControls;

namespace DataClass
{
    public class client_list
    {
        public client_list()
        {
        }

        public int Getretail_clientList_Count()
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetSqlStringCommand("select count(1) from client_list");

            int _count = 0;
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            try
            {
                MyReader.Read();
                _count = Int32.Parse(MyReader[0].ToString());//页面尺寸

            }
            finally
            {
                MyReader.Close();
            }

            return _count;
        }
        public DataSet Getretail_clientList(int CurrentPage, int PageSize)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_client_list_Query");
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);
            db.AddInParameter(selectCommand, "PageSize", DbType.Int32, PageSize);

            return db.ExecuteDataSet(selectCommand);
        }
        public DataSet GetclientList(string client_id, string sname, string abrv,int client_type_id, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_client_list_Query");
            db.AddInParameter(selectCommand, "client_id", DbType.String, client_id);
            db.AddInParameter(selectCommand, "client_type_id", DbType.Int16, client_type_id);
            db.AddInParameter(selectCommand, "sname", DbType.String, sname);
            db.AddInParameter(selectCommand, "abrv", DbType.String, abrv);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array Getclientlist_Count(string client_id, string sname, string abrv, int client_type_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_client_list_Query");
            db.AddInParameter(selectCommand, "client_id", DbType.String, client_id);
            db.AddInParameter(selectCommand, "client_type_id", DbType.Int16, client_type_id);
            db.AddInParameter(selectCommand, "sname", DbType.String, sname);
            db.AddInParameter(selectCommand, "abrv", DbType.String, abrv);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }

        public int Add(Model.BaseData.client_list model)
        {
            SqlDatabase db = common.db;
            DbCommand _Command = db.GetStoredProcCommand("UP_client_list_ADD");

            db.AddInParameter(_Command, "client_id", DbType.String, model.client_id);

            db.AddInParameter(_Command, "client_type_id", DbType.String, model.client_type_id);
            db.AddInParameter(_Command, "sname", DbType.String, model.sname);
            db.AddInParameter(_Command, "sman", DbType.String, model.sman);
            db.AddInParameter(_Command, "address", DbType.String, model.address);
            db.AddInParameter(_Command, "abrv", DbType.String, model.abrv);
            db.AddInParameter(_Command, "tel", DbType.String, model.tel);
            db.AddInParameter(_Command, "fax", DbType.String, model.fax);
            db.AddInParameter(_Command, "email", DbType.String, model.email);
            db.AddInParameter(_Command, "first_amount", DbType.Decimal, model.First_amount);
            db.AddInParameter(_Command, "Max_amount", DbType.Decimal, model.Max_amount);
            db.AddInParameter(_Command, "mobil", DbType.String, model.mobil);
            db.AddInParameter(_Command, "remark", DbType.String, model.remark);

            return db.ExecuteNonQuery(_Command);
        }

        /// <summary>
        ///  更新一条数据
        /// </summary>
        public int Update(Model.BaseData.client_list model)
        {
            SqlDatabase db = common.db;
            DbCommand _Command = db.GetStoredProcCommand("UP_client_list_Update");

            db.AddInParameter(_Command, "client_id", DbType.String, model.client_id);
            db.AddInParameter(_Command, "client_type_id", DbType.String, model.client_type_id);
            db.AddInParameter(_Command, "sname", DbType.String, model.sname);
            db.AddInParameter(_Command, "sman", DbType.String, model.sman);
            db.AddInParameter(_Command, "address", DbType.String, model.address);
            db.AddInParameter(_Command, "abrv", DbType.String, model.abrv);
            db.AddInParameter(_Command, "tel", DbType.String, model.tel);
            db.AddInParameter(_Command, "fax", DbType.String, model.fax);
            db.AddInParameter(_Command, "email", DbType.String, model.email);
            db.AddInParameter(_Command, "first_amount", DbType.Decimal, model.First_amount);
            db.AddInParameter(_Command, "Max_amount", DbType.Decimal, model.Max_amount);
            db.AddInParameter(_Command, "mobil", DbType.String, model.mobil);
            db.AddInParameter(_Command, "remark", DbType.String, model.remark);

            return db.ExecuteNonQuery(_Command);
        }

        /// <summary>
        /// 删除一条数据
        /// </summary>
        public int Delete(string client_id)
        {

            SqlDatabase db = common.db;
            DbCommand deleteCommand = db.GetStoredProcCommand("UP_client_list_Delete");
            db.AddInParameter(deleteCommand, "client_id", DbType.String, client_id);
            int rowsAffected = db.ExecuteNonQuery(deleteCommand);

            return rowsAffected;
        }

        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        public Model.BaseData.client_list GetModel(string client_id)
        {
            SqlDatabase db = common.db;

            DbCommand SelectCommand = db.GetSqlStringCommand("SELECT * FROM client_list WHERE [client_id] ='" + client_id + "'");

            Model.BaseData.client_list model = new Model.BaseData.client_list();

            DataSet ds = db.ExecuteDataSet(SelectCommand);
            model.client_id = client_id;
            if (ds.Tables[0].Rows.Count > 0)
            {
                model.sname = ds.Tables[0].Rows[0]["sname"].ToString();
                model.sman = ds.Tables[0].Rows[0]["sman"].ToString();
                model.address = ds.Tables[0].Rows[0]["address"].ToString();
                model.abrv = ds.Tables[0].Rows[0]["abrv"].ToString();
                model.tel = ds.Tables[0].Rows[0]["tel"].ToString();
                model.fax = ds.Tables[0].Rows[0]["fax"].ToString();
                model.email = ds.Tables[0].Rows[0]["email"].ToString();
                model.mobil = ds.Tables[0].Rows[0]["mobil"].ToString();
                model.remark = ds.Tables[0].Rows[0]["remark"].ToString();
                model.First_amount =Decimal.Parse(ds.Tables[0].Rows[0]["first_amount"].ToString());
                model.Max_amount = Decimal.Parse(ds.Tables[0].Rows[0]["Max_amount"].ToString());
                model.client_type_id = Int16.Parse(ds.Tables[0].Rows[0]["client_type_id"].ToString());


                return model;
            }
            else
            {
                return null;
            }
        }
    }
}
