﻿using System;
using System.Data;
using System.Globalization;
using System.Text;
using Microsoft.Practices.EnterpriseLibrary.Data;
using Microsoft.Practices.EnterpriseLibrary.Data.Sql;
using System.Data.Common;
using System.Data.SqlClient;
using System.Web.UI.WebControls;

namespace DataClass
{
    public class dd_remark
    {
        public dd_remark()
        {
        }

        public DataSet GetDdProductList(string client_name, string client_abrv, string product_name, string product_abrv, string from_date, string to_date, string dept_id, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_dd_product_Query");
            db.AddInParameter(selectCommand, "client_name", DbType.String, client_name);
            db.AddInParameter(selectCommand, "client_abrv", DbType.String, client_abrv);
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "product_abrv", DbType.String, product_abrv);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array GetDdProductkList_Count(string client_name, string client_abrv, string product_name, string product_abrv, string from_date, string to_date, string dept_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_dd_product_Query");
            db.AddInParameter(selectCommand, "client_name", DbType.String, client_name);
            db.AddInParameter(selectCommand, "client_abrv", DbType.String, client_abrv);
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "product_abrv", DbType.String, product_abrv);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }



        public DataSet GetDdRemarkList(string dd_id,string dept_id, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_dd_remark_Query");
            db.AddInParameter(selectCommand, "dd_id", DbType.String, dd_id);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array GetDdRemarkList_Count(string dd_id,string dept_id )
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_dd_remark_Query");
            db.AddInParameter(selectCommand, "dd_id", DbType.String, dd_id);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }

        public int Add(Model.BaseData.dd_remark model)
        {
            SqlDatabase db = common.db;
            DbCommand _Command = db.GetStoredProcCommand("dd_remark_ADD");

            db.AddInParameter(_Command, "dd_id", DbType.String, model.dd_id);
            db.AddInParameter(_Command, "dept_id", DbType.String, model.dept_id);
            db.AddInParameter(_Command, "yj_date", DbType.String, model.yj_date);
            db.AddInParameter(_Command, "product_id", DbType.Int32, model.product_id);
            db.AddInParameter(_Command, "scount", DbType.Int32, model.scount);
            db.AddInParameter(_Command, "price", DbType.Decimal, model.price);

            db.AddInParameter(_Command, "money_id", DbType.Int16, model.Money_ID);


            db.AddInParameter(_Command, "remark", DbType.String, model.remark);

            return db.ExecuteNonQuery(_Command);
        }

        /// <summary>
        ///  更新一条数据
        /// </summary>
        public int Update(Model.BaseData.dd_remark model)
        {
            SqlDatabase db = common.db;
            DbCommand _Command = db.GetStoredProcCommand("dd_remark_Update");

            db.AddInParameter(_Command, "dd_id", DbType.String, model.dd_id);
            db.AddInParameter(_Command, "dept_id", DbType.String, model.dept_id);
            db.AddInParameter(_Command, "yj_date", DbType.String, model.yj_date);
            db.AddInParameter(_Command, "product_id", DbType.Int32, model.product_id);
            db.AddInParameter(_Command, "scount", DbType.Int32, model.scount);
            db.AddInParameter(_Command, "price", DbType.Decimal, model.price);
            db.AddInParameter(_Command, "money_id", DbType.Int16, model.Money_ID);

            db.AddInParameter(_Command, "remark", DbType.String, model.remark);

            return db.ExecuteNonQuery(_Command);
        }

        /// <summary>
        /// 删除一条数据
        /// </summary>
        public int Delete(string dd_id, string dept_id, Int32 product_id)
        {

            SqlDatabase db = common.db;
            DbCommand deleteCommand = db.GetStoredProcCommand("dd_remark_Delete");
            db.AddInParameter(deleteCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(deleteCommand, "dd_id", DbType.String, dd_id);
            db.AddInParameter(deleteCommand, "product_id", DbType.Int32, product_id);
            int rowsAffected = db.ExecuteNonQuery(deleteCommand);

            return rowsAffected;
        }
        /// <summary>
        /// 总金额
        /// </summary>
        public int dd_amount(string dd_id, string dept_id, Int32 amount)
        {

            SqlDatabase db = common.db;
            DbCommand deleteCommand = db.GetSqlStringCommand("update dd_list set amount=@amount where dd_id=@dd_id and dept_id=@dept_id");
            db.AddInParameter(deleteCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(deleteCommand, "dd_id", DbType.String, dd_id);
            db.AddInParameter(deleteCommand, "amount", DbType.Int32, amount);
            int rowsAffected = db.ExecuteNonQuery(deleteCommand);

            return rowsAffected;
        }

        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        public Model.BaseData.dd_remark GetModel(string dd_id, string dept_id, Int32 product_id)
        {
            SqlDatabase db = common.db;

            DbCommand SelectCommand = db.GetSqlStringCommand("SELECT * FROM dd_remark WHERE [dept_id] ='" + dept_id + "' and  [dd_id] ='" + dd_id + "' and product_id=" + product_id.ToString());

            Model.BaseData.dd_remark model = new Model.BaseData.dd_remark();

            DataSet ds = db.ExecuteDataSet(SelectCommand);
            if (ds.Tables[0].Rows.Count > 0)
            {
                model.price = Decimal.Parse(ds.Tables[0].Rows[0]["price"].ToString());
                model.remark = ds.Tables[0].Rows[0]["remark"].ToString();
                model.scount = Int32.Parse(ds.Tables[0].Rows[0]["scount"].ToString());
                model.Money_ID = Int16.Parse(ds.Tables[0].Rows[0]["Money_ID"].ToString());
                model.dd_id = ds.Tables[0].Rows[0]["dd_id"].ToString();
                model.dept_id = ds.Tables[0].Rows[0]["dept_id"].ToString();
                model.yj_date = ds.Tables[0].Rows[0]["yj_date"].ToString();
                model.product_id = Int32.Parse(ds.Tables[0].Rows[0]["product_id"].ToString());

                return model;
            }
            else
            {
                return null;
            }
        }
    }
}
