﻿using System;
using System.Data;
using System.Globalization;
using System.Text;
using Microsoft.Practices.EnterpriseLibrary.Data;
using Microsoft.Practices.EnterpriseLibrary.Data.Sql;
using System.Data.Common;
using System.Data.SqlClient;
using System.Web.UI.WebControls;
using Maticsoft.DBUtility;//请先添加引用
namespace DataClass
{
	/// <summary>
	/// 数据访问类first_input 。
	/// </summary>
	public class first_input
	{
		public first_input()
		{}
		#region  成员方法



        public DataSet GetddList(int product_id, string product_name, string from_date, string to_date, string dept_id, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_first_input_Query");
            db.AddInParameter(selectCommand, "product_id", DbType.Int32, product_id);
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array GetddList_Count(int  product_id, string product_name, string from_date, string to_date, string dept_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_first_input_Query");
            db.AddInParameter(selectCommand, "product_id", DbType.Int32, product_id);
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }

		/// <summary>
		///  增加一条数据
		/// </summary>
        public string Add(Model.first_input model)
		{
			//model.input_id=GetMaxId();
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@input_id", SqlDbType.VarChar,20),
					new SqlParameter("@product_id", SqlDbType.Int,4),
					new SqlParameter("@product_sn", SqlDbType.VarChar,50),
					new SqlParameter("@scount", SqlDbType.Int,4),
					new SqlParameter("@price", SqlDbType.Float,8),
					new SqlParameter("@money_id", SqlDbType.Int,4),
					new SqlParameter("@sman", SqlDbType.VarChar,20),
					new SqlParameter("@sdate", SqlDbType.VarChar,10),
					new SqlParameter("@remark", SqlDbType.VarChar,50),
					new SqlParameter("@dept_id", SqlDbType.VarChar,5)};
			parameters[0].Value = model.input_id;
			parameters[1].Value = model.product_id;
			parameters[2].Value = model.product_sn;
			parameters[3].Value = model.scount;
			parameters[4].Value = model.price;
			parameters[5].Value = model.money_id;
			parameters[6].Value = model.sman;
			parameters[7].Value = model.sdate;
			parameters[8].Value = model.remark;
			parameters[9].Value = model.dept_id;

			DbHelperSQL.RunProcedure("UP_first_input_ADD",parameters,out rowsAffected);
			return model.input_id;
		}

		/// <summary>
		///  更新一条数据
		/// </summary>
		public void Update(Model.first_input model)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@input_id", SqlDbType.VarChar,20),
					new SqlParameter("@product_id", SqlDbType.Int,4),
					new SqlParameter("@product_sn", SqlDbType.VarChar,50),
					new SqlParameter("@scount", SqlDbType.Int,4),
					new SqlParameter("@price", SqlDbType.Float,8),
					new SqlParameter("@money_id", SqlDbType.Int,4),
					new SqlParameter("@sman", SqlDbType.VarChar,20),
					new SqlParameter("@sdate", SqlDbType.VarChar,10),
					new SqlParameter("@remark", SqlDbType.VarChar,50),
					new SqlParameter("@dept_id", SqlDbType.VarChar,5)};
			parameters[0].Value = model.input_id;
			parameters[1].Value = model.product_id;
			parameters[2].Value = model.product_sn;
			parameters[3].Value = model.scount;
			parameters[4].Value = model.price;
			parameters[5].Value = model.money_id;
			parameters[6].Value = model.sman;
			parameters[7].Value = model.sdate;
			parameters[8].Value = model.remark;
			parameters[9].Value = model.dept_id;

			DbHelperSQL.RunProcedure("UP_first_input_Update",parameters,out rowsAffected);
		}

		/// <summary>
		/// 删除一条数据
		/// </summary>
        public void Delete(string input_id,string dept_id)
		{

			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@input_id", SqlDbType.VarChar,20),
					new SqlParameter("@dept_id", SqlDbType.VarChar,5)
				};
            parameters[0].Value = input_id;
            parameters[1].Value = dept_id;
			DbHelperSQL.RunProcedure("UP_first_input_Delete",parameters,out rowsAffected);
		}

		/// <summary>
		/// 得到一个对象实体
		/// </summary>
        public Model.first_input GetModel(string input_id, string dept_id)
		{
            SqlDatabase db = common.db;

            DbCommand SelectCommand = db.GetSqlStringCommand("SELECT * FROM first_input_view WHERE [input_id] ='" + input_id + "' and dept_id='" + dept_id + "'");

            Model.first_input model = new Model.first_input();

            DataSet ds = db.ExecuteDataSet(SelectCommand);
            model.input_id = input_id;
            model.dept_id = dept_id;
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["product_id"].ToString()!="")
				{
					model.product_id=int.Parse(ds.Tables[0].Rows[0]["product_id"].ToString());
				}
				model.product_sn=ds.Tables[0].Rows[0]["product_sn"].ToString();
				if(ds.Tables[0].Rows[0]["scount"].ToString()!="")
				{
					model.scount=int.Parse(ds.Tables[0].Rows[0]["scount"].ToString());
				}
				if(ds.Tables[0].Rows[0]["price"].ToString()!="")
				{
                    model.price = Decimal.Parse(ds.Tables[0].Rows[0]["price"].ToString());
				}
				if(ds.Tables[0].Rows[0]["money_id"].ToString()!="")
				{
					model.money_id=int.Parse(ds.Tables[0].Rows[0]["money_id"].ToString());
				}
				model.sman=ds.Tables[0].Rows[0]["sman"].ToString();
				model.sdate=ds.Tables[0].Rows[0]["sdate"].ToString();
				model.remark=ds.Tables[0].Rows[0]["remark"].ToString();
				return model;
			}
			else
			{
				return null;
			}
		}

		

		/*
		/// <summary>
		/// 分页获取数据列表
		/// </summary>
		public DataSet GetList(int PageSize,int PageIndex,string strWhere)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@tblName", SqlDbType.VarChar, 255),
					new SqlParameter("@fldName", SqlDbType.VarChar, 255),
					new SqlParameter("@PageSize", SqlDbType.Int),
					new SqlParameter("@PageIndex", SqlDbType.Int),
					new SqlParameter("@IsReCount", SqlDbType.Bit),
					new SqlParameter("@OrderType", SqlDbType.Bit),
					new SqlParameter("@strWhere", SqlDbType.VarChar,1000),
					};
			parameters[0].Value = "first_input";
			parameters[1].Value = "input_id";
			parameters[2].Value = PageSize;
			parameters[3].Value = PageIndex;
			parameters[4].Value = 0;
			parameters[5].Value = 0;
			parameters[6].Value = strWhere;	
			return DbHelperSQL.RunProcedure("UP_GetRecordByPage",parameters,"ds");
		}*/

		#endregion  成员方法
	}
}

