﻿using System;
using System.Data;
using System.Globalization;
using System.Text;
using Microsoft.Practices.EnterpriseLibrary.Data;
using Microsoft.Practices.EnterpriseLibrary.Data.Sql;
using System.Data.Common;
using System.Data.SqlClient;
using System.Web.UI.WebControls;

namespace DataClass
{
    public class product_input
    {
        public product_input()
        {
        }

        public DataSet Getproduct_input_queryList(string provide_name, string provide_abrv, string product_name, string product_abrv, string from_date, string to_date, string dept_id, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_all_product_input_Query");
            db.AddInParameter(selectCommand, "provide_name", DbType.String, provide_name);
            db.AddInParameter(selectCommand, "provide_abrv", DbType.String, provide_abrv);
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "product_abrv", DbType.String, product_abrv);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array Getproduct_input_queryList_Count(string provide_name, string provide_abrv, string product_name, string product_abrv, string from_date, string to_date, string dept_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_all_product_input_Query");
            db.AddInParameter(selectCommand, "provide_name", DbType.String, provide_name);
            db.AddInParameter(selectCommand, "provide_abrv", DbType.String, provide_abrv);
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "product_abrv", DbType.String, product_abrv);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }



        public DataSet GetddList(string product_name, string provide_name, string from_date, string to_date, string dept_id, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_product_input_Query");
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "provide_name", DbType.String, provide_name);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array GetddList_Count(string product_name, string provide_name, string from_date, string to_date, string dept_id)
        {
            SqlDatabase db = common.db;
          //  Database db = DatabaseFactory.CreateDatabase();

            DbCommand selectCommand = db.GetStoredProcCommand("UP_product_input_Query");
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "provide_name", DbType.String, provide_name);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }

        public int Add(Model.product_input model)
        {
            SqlDatabase db = common.db;
            DbCommand _Command = db.GetStoredProcCommand("product_input_ADD");

            db.AddInParameter(_Command, "product_id", DbType.Int32, model.product_id);
            db.AddInParameter(_Command, "product_sn", DbType.String, model.product_sn);
            db.AddInParameter(_Command, "scount", DbType.Int32, model.scount);
            db.AddInParameter(_Command, "price", DbType.Decimal, model.price);

            db.AddInParameter(_Command, "provide", DbType.String, model.provide_id);
            db.AddInParameter(_Command, "money_id", DbType.Int16, model.money_id);
            db.AddInParameter(_Command, "dept_id", DbType.String, model.dept_id);
            db.AddInParameter(_Command, "sman", DbType.String, model.sman);
            db.AddInParameter(_Command, "bill_id", DbType.String, model.bill_id);
            db.AddInParameter(_Command, "remark", DbType.String, model.remark);

            return db.ExecuteNonQuery(_Command);
        }

        /// <summary>
        ///  更新一条数据
        /// </summary>
        public int Update(Model.product_input model)
        {
            SqlDatabase db = common.db;
            DbCommand _Command = db.GetStoredProcCommand("product_input_Update");

            db.AddInParameter(_Command, "input_id", DbType.String, model.input_id);
            db.AddInParameter(_Command, "product_id", DbType.Int32, model.product_id);
            db.AddInParameter(_Command, "dept_id", DbType.String, model.dept_id);
            db.AddInParameter(_Command, "product_sn", DbType.String, model.product_sn);
            db.AddInParameter(_Command, "scount", DbType.Int32, model.scount);
            db.AddInParameter(_Command, "price", DbType.Decimal, model.price);
            db.AddInParameter(_Command, "provide", DbType.String, model.provide_id);
            db.AddInParameter(_Command, "money_id", DbType.Int16, model.money_id);
            db.AddInParameter(_Command, "sman", DbType.String, model.sman);
            db.AddInParameter(_Command, "bill_id", DbType.String, model.bill_id);
            db.AddInParameter(_Command, "remark", DbType.String, model.remark);

            return db.ExecuteNonQuery(_Command);
        }

        /// <summary>
        /// 删除一条数据
        /// </summary>
        public int Delete(string input_id,string dept_id)
        {

            SqlDatabase db = common.db;
            DbCommand deleteCommand = db.GetStoredProcCommand("product_input_Delete");
            db.AddInParameter(deleteCommand, "input_id", DbType.String, input_id);
            db.AddInParameter(deleteCommand, "dept_id", DbType.String, dept_id);
            int rowsAffected = db.ExecuteNonQuery(deleteCommand);

            return rowsAffected;
        }

        public static int get_store_scount(Int32 product_id,Int32 modify_scount,string dept_id,bool good_or_bad)
        {
            if (good_or_bad)
            {
                SqlDatabase db = common.db;
                DbCommand _Command = db.GetStoredProcCommand("get_store_scount");
                db.AddInParameter(_Command, "product_id", DbType.Int32, product_id);
                db.AddInParameter(_Command, "modify_scount", DbType.Int32, modify_scount);
                db.AddInParameter(_Command, "dept_id", DbType.String, dept_id);
                db.AddOutParameter(_Command, "store_scount", DbType.Int32, 0);
                db.ExecuteNonQuery(_Command);
                return int.Parse(db.GetParameterValue(_Command, "store_scount").ToString());
            }
            else
                return 9000000;
        }

        public static int get_store_scount(Int32 product_id, Int32 modify_scount, string dept_id)
        {
                SqlDatabase db = common.db;
                DbCommand _Command = db.GetStoredProcCommand("get_store_scount");
                db.AddInParameter(_Command, "product_id", DbType.Int32, product_id);
                db.AddInParameter(_Command, "modify_scount", DbType.Int32, modify_scount);
                db.AddInParameter(_Command, "dept_id", DbType.String, dept_id);
                db.AddOutParameter(_Command, "store_scount", DbType.Int32, 0);
                db.ExecuteNonQuery(_Command);
                return int.Parse(db.GetParameterValue(_Command, "store_scount").ToString());
        }


        public static int get_retail_store_scount(Int32 product_id, Int32 modify_scount, string dept_id)
        {
            SqlDatabase db = common.db;
            DbCommand _Command = db.GetStoredProcCommand("get_store_scount");
            db.AddInParameter(_Command, "product_id", DbType.Int32, product_id);
            db.AddInParameter(_Command, "modify_scount", DbType.Int32, modify_scount);
            db.AddInParameter(_Command, "dept_id", DbType.String, dept_id);
            db.AddOutParameter(_Command, "store_scount", DbType.Int32, 0);
            db.ExecuteNonQuery(_Command);
            return int.Parse(db.GetParameterValue(_Command, "store_scount").ToString());
        }

        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        public Model.product_input GetModel(string input_id,string dept_id)
        {
            SqlDatabase db = common.db;

            DbCommand SelectCommand = db.GetSqlStringCommand("SELECT * FROM product_input_view WHERE [input_id] ='" + input_id + "' and dept_id='" + dept_id + "'");

            Model.product_input model = new Model.product_input();

            DataSet ds = db.ExecuteDataSet(SelectCommand);
            model.input_id = input_id;
            if (ds.Tables[0].Rows.Count > 0)
            {
                model.product_id = Int32.Parse(ds.Tables[0].Rows[0]["product_id"].ToString());
                model.scount = Int32.Parse(ds.Tables[0].Rows[0]["scount"].ToString());
                model.provide_id = ds.Tables[0].Rows[0]["provide_id"].ToString();
                model.provide_name = ds.Tables[0].Rows[0]["provide_name"].ToString();
                model.product_name = ds.Tables[0].Rows[0]["product_name"].ToString();

                model.product_sn = ds.Tables[0].Rows[0]["product_sn"].ToString();
                model.price = Decimal.Parse(ds.Tables[0].Rows[0]["price"].ToString());


                model.sman = ds.Tables[0].Rows[0]["sman"].ToString();
                model.money_id = Int16.Parse(ds.Tables[0].Rows[0]["money_id"].ToString());
                model.remark = ds.Tables[0].Rows[0]["remark"].ToString();
                model.bill_id = ds.Tables[0].Rows[0]["bill_id"].ToString();
                model.dept_id = ds.Tables[0].Rows[0]["dept_id"].ToString();

                return model;
            }
            else
            {
                return null;
            }
        }
    }
}
