﻿
using System.Collections.Generic;

using System;
using System.Data;
using System.Globalization;
using System.Text;
using Microsoft.Practices.EnterpriseLibrary.Data;
using Microsoft.Practices.EnterpriseLibrary.Data.Sql;
using System.Data.Common;
using System.Data.SqlClient;
using System.Web.UI.WebControls;


namespace DataClass
{
    /// <summary>
    /// 数据访问类product_lend。
    /// </summary>
    public class product_lend
    {
        public product_lend()
        { }
        #region  成员方法
        /// <summary>
        /// 是否存在该记录
        /// </summary>
        public bool Exists(string output_id)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetStoredProcCommand("UP_product_lend_Exists");
            db.AddInParameter(dbCommand, "output_id", DbType.String, output_id);
            int result;
            object obj = db.ExecuteScalar(dbCommand);
            int.TryParse(obj.ToString(), out result);
            if (result == 1)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        public Array Get_product_lend_sum(string product_name, string client_id, string dept_id, string from_date, string to_date, Int16 revert_state)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_product_lend_sum");
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "client_id", DbType.String, client_id);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "revert_state", DbType.Int16, revert_state);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);

            decimal[] Array = new decimal[1];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = decimal.Parse(MyReader[0].ToString());//页面尺寸

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }


        public DataSet Getproduct_lendList_Excel(string product_name, string client_id, string dept_id, string from_date, string to_date, Int16 revert_state)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_product_lend_Query");
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "client_id", DbType.String, client_id);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "revert_state", DbType.Int16, revert_state);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "PageSize", DbType.Int32, 99999);

            return db.ExecuteDataSet(selectCommand);
        }


        public DataSet Getproduct_lendList(string product_name, string client_id, string dept_id, string from_date, string to_date, Int16 revert_state, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_product_lend_Query");
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "client_id", DbType.String, client_id);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "revert_state", DbType.Int16, revert_state);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        /*
         @product_name varchar(50) ='',
@client_id varchar(12) ='',

@from_date varchar(10)='' ,
@to_date varchar(10)='' ,
@revert_state int=-1,
@PageSize int =20,
@IsCount int=0,@CurrentPage int =1
         */
        public Array Getproduct_lendList_Count(string product_name, string client_id, string dept_id, string from_date, string to_date, Int16 revert_state)
        {
            SqlDatabase db = common.db;
            //  SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_product_lend_Query");
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "client_id", DbType.String, client_id);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "revert_state", DbType.Int16, revert_state);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }


        /// <summary>
        ///  增加一条数据
        /// </summary>
        public void Add(Model.product_lend model)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetStoredProcCommand("UP_product_lend_ADD");
            db.AddInParameter(dbCommand, "output_id", DbType.String, model.output_id);
            db.AddInParameter(dbCommand, "product_id", DbType.Int32, model.product_id);
            db.AddInParameter(dbCommand, "product_sn", DbType.String, model.product_sn);
            db.AddInParameter(dbCommand, "scount", DbType.Int32, model.scount);
          //  db.AddInParameter(dbCommand, "price", DbType.Decimal, model.price);
          //  db.AddInParameter(dbCommand, "money_id", DbType.Int32, model.money_id);
            db.AddInParameter(dbCommand, "sman", DbType.String, model.sman);
            db.AddInParameter(dbCommand, "sdate", DbType.String, model.sdate);
            db.AddInParameter(dbCommand, "edate", DbType.String, model.edate);
            db.AddInParameter(dbCommand, "remark", DbType.String, model.remark);
            db.AddInParameter(dbCommand, "bill_id", DbType.String, model.bill_id);
            db.AddInParameter(dbCommand, "dept_id", DbType.String, model.dept_id);
            db.AddInParameter(dbCommand, "client", DbType.String, model.client);
            db.ExecuteNonQuery(dbCommand);
        }

        /// <summary>
        ///  更新一条数据
        /// </summary>
        public void Update(Model.product_lend model)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetStoredProcCommand("UP_product_lend_Update");
            db.AddInParameter(dbCommand, "output_id", DbType.String, model.output_id);
            db.AddInParameter(dbCommand, "product_id", DbType.Int32, model.product_id);
            db.AddInParameter(dbCommand, "product_sn", DbType.String, model.product_sn);
            db.AddInParameter(dbCommand, "scount", DbType.Int32, model.scount);
          //  db.AddInParameter(dbCommand, "price", DbType.Decimal, model.price);
          //  db.AddInParameter(dbCommand, "money_id", DbType.Int32, model.money_id);
            db.AddInParameter(dbCommand, "sman", DbType.String, model.sman);
            db.AddInParameter(dbCommand, "sdate", DbType.String, model.sdate);
            db.AddInParameter(dbCommand, "edate", DbType.String, model.edate);
            db.AddInParameter(dbCommand, "remark", DbType.String, model.remark);
            db.AddInParameter(dbCommand, "bill_id", DbType.String, model.bill_id);
            db.AddInParameter(dbCommand, "dept_id", DbType.String, model.dept_id);
            db.AddInParameter(dbCommand, "client", DbType.String, model.client);
            db.ExecuteNonQuery(dbCommand);
        }


        public int sk(string output_id, string dept_id, string sk_man)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetSqlStringCommand("update product_lend set sk_man='" + sk_man + "',sk_date=convert(varchar(19),getdate(),120) where output_id='" + output_id + "' and  dept_id='" + dept_id + "'");
            return db.ExecuteNonQuery(dbCommand);
        }  /// <summary>
        /// 删除一条数据
        /// </summary>
        public int cancel_sk(string output_id, string dept_id)
        {
            SqlDatabase db = common.db;

            DbCommand dbCommand = db.GetSqlStringCommand("update product_lend set sk_man='',sk_date='' where output_id='" + output_id + "' and  dept_id='" + dept_id + "'");
            return db.ExecuteNonQuery(dbCommand);
        }


        /// <summary>
        /// 删除一条数据
        /// </summary>
        public int revert(string output_id,string dept_id,string revert_man)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetSqlStringCommand("update product_lend set revert_man='" + revert_man + "',revert_date=convert(varchar(19),getdate(),120) where output_id='" + output_id + "' and  dept_id='" + dept_id + "'");
            return db.ExecuteNonQuery(dbCommand);
        }  /// <summary>
        /// 删除一条数据
        /// </summary>
        public int cancel_revert(string output_id,string dept_id)
        {
            SqlDatabase db = common.db;

            DbCommand dbCommand = db.GetSqlStringCommand("update product_lend set revert_man='',revert_date='' where output_id='" + output_id + "' and  dept_id='" + dept_id + "'");
            return db.ExecuteNonQuery(dbCommand);
        }
        /// <summary>
        /// 删除一条数据
        /// </summary>
        public int Delete(string output_id, string dept_id)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetStoredProcCommand("UP_product_lend_Delete");
            db.AddInParameter(dbCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(dbCommand, "output_id", DbType.String, output_id);

            return db.ExecuteNonQuery(dbCommand);
        }

        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        public Model.product_lend GetModel(string output_id, string dept_id)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetStoredProcCommand("UP_product_lend_GetModel");
            db.AddInParameter(dbCommand, "output_id", DbType.String, output_id);
            db.AddInParameter(dbCommand, "dept_id", DbType.String, dept_id);

            Model.product_lend model = null;
            using (IDataReader dataReader = db.ExecuteReader(dbCommand))
            {
                if (dataReader.Read())
                {
                    model = ReaderBind(dataReader);
                }
            }
            return model;
        }

        /// <summary>
        /// 获得数据列表
        /// </summary>
        public DataSet GetList(string strWhere)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select output_id,product_id,product_sn,scount,price,money_id,sman,sdate,edate,remark,bill_id,client,dept_id,sk_man,sk_date ");
            strSql.Append(" FROM product_lend ");
            if (strWhere.Trim() != "")
            {
                strSql.Append(" where " + strWhere);
            }
            SqlDatabase db = common.db;
            return db.ExecuteDataSet(CommandType.Text, strSql.ToString());
        }

        /*
        /// <summary>
        /// 分页获取数据列表
        /// </summary>
        public DataSet GetList(int PageSize,int PageIndex,string strWhere)
        {
            SqlDatabase db = common.db;
            DbCommand dbCommand = db.GetStoredProcCommand("UP_GetRecordByPage");
            db.AddInParameter(dbCommand, "tblName", DbType.String, "product_lend");
            db.AddInParameter(dbCommand, "fldName", DbType.String, "ID");
            db.AddInParameter(dbCommand, "PageSize", DbType.Int32, PageSize);
            db.AddInParameter(dbCommand, "PageIndex", DbType.Int32, PageIndex);
            db.AddInParameter(dbCommand, "IsReCount", DbType.Boolean, 0);
            db.AddInParameter(dbCommand, "OrderType", DbType.Boolean, 0);
            db.AddInParameter(dbCommand, "strWhere", DbType.String, strWhere);
            return db.ExecuteDataSet(dbCommand);
        }*/

        /// <summary>
        /// 获得数据列表（比DataSet效率高，推荐使用）
        /// </summary>
        public List<Model.product_lend> GetListArray(string strWhere)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select output_id,product_id,product_sn,scount,price,money_id,sman,sdate,edate,remark,bill_id,client,dept_id,sk_man,sk_date ");
            strSql.Append(" FROM product_lend ");
            if (strWhere.Trim() != "")
            {
                strSql.Append(" where " + strWhere);
            }
            List<Model.product_lend> list = new List<Model.product_lend>();
            SqlDatabase db = common.db;
            using (IDataReader dataReader = db.ExecuteReader(CommandType.Text, strSql.ToString()))
            {
                while (dataReader.Read())
                {
                    list.Add(ReaderBind(dataReader));
                }
            }
            return list;
        }


        /// <summary>
        /// 对象实体绑定数据
        /// </summary>
        public Model.product_lend ReaderBind(IDataReader dataReader)
        {
            Model.product_lend model = new Model.product_lend();
            object ojb;
            model.output_id = dataReader["output_id"].ToString();
            ojb = dataReader["product_id"];
            if (ojb != null && ojb != DBNull.Value)
            {
                model.product_id = (int)ojb;
            }
            model.product_sn = dataReader["product_sn"].ToString();
            ojb = dataReader["scount"];
            if (ojb != null && ojb != DBNull.Value)
            {
                model.scount = (int)ojb;
            }
            ojb = dataReader["price"];
            if (ojb != null && ojb != DBNull.Value)
            {
                model.price = (decimal)ojb;
            }
            ojb = dataReader["money_id"];
            if (ojb != null && ojb != DBNull.Value)
            {
                model.money_id = (int)ojb;
            }
            model.sman = dataReader["sman"].ToString();
            model.sdate = dataReader["sdate"].ToString();
            model.edate = dataReader["edate"].ToString();
            model.remark = dataReader["remark"].ToString();
            model.bill_id = dataReader["bill_id"].ToString();
            model.client = dataReader["client"].ToString();
            model.dept_id = dataReader["dept_id"].ToString();
            model.sk_man = dataReader["sk_man"].ToString();
            model.sk_date = dataReader["sk_date"].ToString();
            return model;
        }

        #endregion  成员方法
    }
}

