﻿using System;
using System.Data;
using System.Globalization;
using System.Text;
using Microsoft.Practices.EnterpriseLibrary.Data;
using Microsoft.Practices.EnterpriseLibrary.Data.Sql;
using System.Data.Common;
using System.Data.SqlClient;
using System.Web.UI.WebControls;
using Maticsoft.DBUtility;//请先添加引用

namespace DataClass
{
    public class product_output
    {
        public product_output()
        {
        }

        public DataSet Get_output_sk_Query_List(string dept_id, string from_date, string to_date, string sk_state, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_output_sk_Query");
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "sk_state", DbType.String, sk_state);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public DataSet Get_output_sk_sum(string dept_id, string from_date, string to_date, string sk_state)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_output_sk_sum");
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "sk_state", DbType.String, sk_state);

            return db.ExecuteDataSet(selectCommand);
        }

        public Array Get_output_sk_Query_List_Count(string dept_id, string from_date, string to_date, string sk_state)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_output_sk_Query");
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "sk_state", DbType.String, sk_state);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }

        public DataSet GetddList(string product_name, string dept_id, string from_date, string to_date, string bill_id, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_product_output_Query");
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "bill_id", DbType.String, bill_id);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array GetddList_Count(string product_name, string dept_id, string from_date, string to_date,string bill_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_product_output_Query");
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "from_date", DbType.String, from_date);
            db.AddInParameter(selectCommand, "to_date", DbType.String, to_date);
            db.AddInParameter(selectCommand, "bill_id", DbType.String, bill_id);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }

        public int Add(Model.product_output model)
        {
            SqlDatabase db = common.db;
            DbCommand _Command = db.GetStoredProcCommand("product_output_ADD");

            db.AddInParameter(_Command, "product_id", DbType.Int32, model.product_id);
            db.AddInParameter(_Command, "product_sn", DbType.String, model.product_sn);
            db.AddInParameter(_Command, "scount", DbType.Int32, model.scount);
            db.AddInParameter(_Command, "price", DbType.Decimal, model.price);

            db.AddInParameter(_Command, "dept_id", DbType.String, model.dept_id);
            db.AddInParameter(_Command, "money_id", DbType.Int16, model.money_id);
            db.AddInParameter(_Command, "sman", DbType.String, model.sman);
            db.AddInParameter(_Command, "bill_id", DbType.String, model.bill_id);
            db.AddInParameter(_Command, "sdate", DbType.String, model.sdate);
            db.AddInParameter(_Command, "remark", DbType.String, model.remark);
            db.AddInParameter(_Command, "seller_id", DbType.Int16, model.seller_id);
            db.AddInParameter(_Command, "client_id", DbType.String, model.client);

            return db.ExecuteNonQuery(_Command);
        }

        /// <summary>
        ///  更新一条数据
        /// </summary>
        public int Update(Model.product_output model)
        {
            SqlDatabase db = common.db;
            DbCommand _Command = db.GetStoredProcCommand("product_output_Update");

            db.AddInParameter(_Command, "output_id", DbType.String, model.output_id);
            db.AddInParameter(_Command, "product_id", DbType.Int32, model.product_id);
            db.AddInParameter(_Command, "product_sn", DbType.String, model.product_sn);
            db.AddInParameter(_Command, "scount", DbType.Int32, model.scount);
            db.AddInParameter(_Command, "price", DbType.Decimal, model.price);
            db.AddInParameter(_Command, "dept_id", DbType.String, model.dept_id);
            db.AddInParameter(_Command, "money_id", DbType.Int16, model.money_id);
            db.AddInParameter(_Command, "sman", DbType.String, model.sman);
            db.AddInParameter(_Command, "bill_id", DbType.String, model.bill_id);
            db.AddInParameter(_Command, "seller_id", DbType.Int16, model.seller_id);
            db.AddInParameter(_Command, "remark", DbType.String, model.remark);
            db.AddInParameter(_Command, "client_id", DbType.String, model.client);

            return db.ExecuteNonQuery(_Command);
        }

        /// <summary>
        /// 删除一条数据
        /// </summary>
        public int Delete(string output_id,string dept_id)
        {

            SqlDatabase db = common.db;
            DbCommand deleteCommand = db.GetStoredProcCommand("product_output_Delete");
            db.AddInParameter(deleteCommand, "output_id", DbType.String, output_id);
            db.AddInParameter(deleteCommand, "dept_id", DbType.String, dept_id);
            int rowsAffected = db.ExecuteNonQuery(deleteCommand);

            return rowsAffected;
        }

        public static string get_output_bill(string dept_id)
        {

            SqlDatabase db = common.db;
            DbCommand selectCommand = db.GetStoredProcCommand("get_output_bill");
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);

            MyReader.Read();
            return MyReader[0].ToString();
        }


        public static string get_retail_output_bill(string dept_id)
        {

            SqlDatabase db = common.db;
            DbCommand selectCommand = db.GetStoredProcCommand("get_output_bill");
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);

            MyReader.Read();
            return MyReader[0].ToString();
        }

        public DataSet Getprint_data(string output_id,string dept_id)
        {
            SqlDatabase db = common.db;

            DbCommand SelectCommand = db.GetSqlStringCommand(@"SELECT * FROM product_output_view WHERE [output_id]  = @output_id AND dept_id =@dept_id;
SELECT    dbo.GetChineseNum(sum(amount))
FROM         product_output_view
WHERE     [output_id] = @output_id AND dept_id = @dept_id;
");
            db.AddInParameter(SelectCommand, "output_id", DbType.String, output_id);
            db.AddInParameter(SelectCommand, "dept_id", DbType.String, dept_id);
            return db.ExecuteDataSet(SelectCommand);
        }
        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        public Model.product_output GetModel(string output_id, string dept_id)
        {
            SqlDatabase db = common.db;

            DbCommand SelectCommand = db.GetSqlStringCommand("SELECT * FROM product_output_view WHERE [output_id] ='" + output_id + "' and dept_id='" + dept_id + "'");

            Model.product_output model = new Model.product_output();

            DataSet ds = db.ExecuteDataSet(SelectCommand);
            model.output_id = output_id;
            model.dept_id = dept_id;
            if (ds.Tables[0].Rows.Count > 0)
            {
                model.product_id = Int32.Parse(ds.Tables[0].Rows[0]["product_id"].ToString());
                model.scount = Int32.Parse(ds.Tables[0].Rows[0]["scount"].ToString());

                model.product_sn = ds.Tables[0].Rows[0]["product_sn"].ToString();
                model.price = Decimal.Parse(ds.Tables[0].Rows[0]["price"].ToString());
                model.product_name = ds.Tables[0].Rows[0]["product_name"].ToString();


                model.sman = ds.Tables[0].Rows[0]["sman"].ToString();
                model.money_id = Int16.Parse(ds.Tables[0].Rows[0]["money_id"].ToString());
                model.remark = ds.Tables[0].Rows[0]["remark"].ToString();
                model.bill_id = ds.Tables[0].Rows[0]["bill_id"].ToString();

                return model;
            }
            else
            {
                return null;
            }
        }


        protected static int strTOint(string str)
        {
            int _return = 0;
            str = str.Trim();
            if (str.Length == 0) 
                _return = 0;
            else
                _return = Int32.Parse(str);
            return _return;
        }

        public DataSet Product_main_store_EXCEL(string stype,string product_id, string product_name)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_product_store_Query");
            db.AddInParameter(selectCommand, "product_id", DbType.Int32, strTOint(product_id));
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, "0");
            db.AddInParameter(selectCommand, "stype", DbType.String, Int32.Parse(stype));
            db.AddInParameter(selectCommand, "PageSize", DbType.Int32, 99999);

            return db.ExecuteDataSet(selectCommand);
        }
        public DataSet Product_dept_store_EXCEL(string stype, string product_id, string product_name, string dept_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_product_store_Query");
            db.AddInParameter(selectCommand, "product_id", DbType.Int32, strTOint(product_id));
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "stype", DbType.Int32, Int32.Parse(stype));
            db.AddInParameter(selectCommand, "PageSize", DbType.Int32, 99999);

            return db.ExecuteDataSet(selectCommand);
        }

        public DataSet GetstoreList(string stype, string product_id, string product_name, string dept_id, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_product_store_Query");
            db.AddInParameter(selectCommand, "product_id", DbType.Int32, strTOint(product_id));
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "stype", DbType.String, Int32.Parse(stype));
       ///     db.AddInParameter(selectCommand, "all_store", DbType.Int16, 1);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }


        public Array GetstroeList_Count(string stype, string product_id, string product_name, string dept_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_product_store_Query");
            db.AddInParameter(selectCommand, "product_id", DbType.Int32, strTOint(product_id));
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "stype", DbType.String, Int32.Parse(stype));
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }

        public void set_all_store()
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("set_all_store");

            db.ExecuteNonQuery(selectCommand);
        }


        public DataSet Get_allstoreList(string stype, string product_id, string product_name, int user_price)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_product_all_store_Query");
            db.AddInParameter(selectCommand, "product_id", DbType.Int32, strTOint(product_id));
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "stype", DbType.String, Int32.Parse(stype));
            db.AddInParameter(selectCommand, "user_price", DbType.Int16, user_price);

            return db.ExecuteDataSet(selectCommand);
        }


        public DataSet Product_store_EXCEL(string stype, string product_id, string product_name,  int user_price)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_product_all_store_Query");
            db.AddInParameter(selectCommand, "product_id", DbType.Int32, strTOint(product_id));
            db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
            db.AddInParameter(selectCommand, "stype", DbType.String, Int32.Parse(stype));
            db.AddInParameter(selectCommand, "user_price", DbType.Int16, user_price);

            return db.ExecuteDataSet(selectCommand);
        }

        public static int get_main_store(string product_id)
        {
            return (int)DbHelperSQL.GetSingle("select isnull(store_scount,0) from main_store_view where product_id=" + product_id);
        }

        public static int get_dept_store(string product_id,string dept_id)
        {
            return (int)DbHelperSQL.GetSingle("select isnull(store_scount,0) from dept_store_view where product_id=" + product_id + " and dept_id='" + dept_id + "'");
        }

        public static bool is_not_optput_sk(string dept_id,string sdate)
        {
            return !DbHelperSQL.Exists("select 1 from dept_day where  len(rtrim(sk_man))>0 and  dept_id='" + dept_id + "' and sdate ='" + sdate + "'");
        }
        /*
        public static void optput_sk(string dept_id, string sdate, string sk_man)
        {
             DbHelperSQL.ExecuteSql("update  product_output set  sk_date=convert(varchar(19),getdate(),120),  sk_man='" + sk_man + "' where   dept_id='" + dept_id + "' and SUBSTRING(sdate, 1, 10) ='" + sdate + "'");

        }
        public static void optput_un_sk(string dept_id, string sdate)
        {
             DbHelperSQL.ExecuteSql("update  product_output set  sk_date='',  sk_man='' where   dept_id='" + dept_id + "' and SUBSTRING(sdate, 1, 10) ='" + sdate + "'");
        }
         */
    }
}
