﻿using System;
using System.Data;
using System.Globalization;
using System.Text;
using Microsoft.Practices.EnterpriseLibrary.Data;
using Microsoft.Practices.EnterpriseLibrary.Data.Sql;
using System.Data.Common;
using System.Data.SqlClient;
using System.Web.UI.WebControls;

namespace DataClass
{
    public class provide_list
    {
        public provide_list()
        {
        }

        public DataSet GetprovideList(string provide_id, string sname, string abrv, int provide_type_id, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_provide_list_Query");
            db.AddInParameter(selectCommand, "provide_id", DbType.String, provide_id);
            db.AddInParameter(selectCommand, "provide_type_id", DbType.Int16, provide_type_id);
            db.AddInParameter(selectCommand, "sname", DbType.String, sname);
            db.AddInParameter(selectCommand, "abrv", DbType.String, abrv);
            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array GetprovideList_Count(string provide_id, string sname, string abrv, int provide_type_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_provide_list_Query");
            db.AddInParameter(selectCommand, "provide_id", DbType.String, provide_id);
            db.AddInParameter(selectCommand, "provide_type_id", DbType.Int16, provide_type_id);
            db.AddInParameter(selectCommand, "sname", DbType.String, sname);
            db.AddInParameter(selectCommand, "abrv", DbType.String, abrv);
            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }

        public int Add(Model.BaseData.provide_list model)
        {
            SqlDatabase db = common.db;
            DbCommand _Command = db.GetStoredProcCommand("UP_provide_list_Add");

            db.AddInParameter(_Command, "provide_id", DbType.String, model.provide_id);
            db.AddInParameter(_Command, "provide_type_id", DbType.String, model.provide_type_id);
            db.AddInParameter(_Command, "sname", DbType.String, model.sname);
            db.AddInParameter(_Command, "sman", DbType.String, model.sman);
            db.AddInParameter(_Command, "address", DbType.String, model.address);

            db.AddInParameter(_Command, "money_unit_id", DbType.String, model.money_unit_id);
            db.AddInParameter(_Command, "abrv", DbType.String, model.abrv);
            db.AddInParameter(_Command, "tel", DbType.String, model.tel);
            db.AddInParameter(_Command, "fax", DbType.String, model.fax);
            db.AddInParameter(_Command, "email", DbType.String, model.email);
            db.AddInParameter(_Command, "first_amount", DbType.Decimal, model.First_amount);
            db.AddInParameter(_Command, "mobil", DbType.String, model.mobil);
            db.AddInParameter(_Command, "remark", DbType.String, model.remark);

            return db.ExecuteNonQuery(_Command);
        }

        /// <summary>
        ///  更新一条数据
        /// </summary>
        public int Update(Model.BaseData.provide_list model)
        {
            SqlDatabase db = common.db;
            DbCommand _Command = db.GetStoredProcCommand("UP_provide_list_Update");

            db.AddInParameter(_Command, "provide_id", DbType.String, model.provide_id);
            db.AddInParameter(_Command, "provide_type_id", DbType.String, model.provide_type_id);
            db.AddInParameter(_Command, "sname", DbType.String, model.sname);
            db.AddInParameter(_Command, "sman", DbType.String, model.sman);
            db.AddInParameter(_Command, "address", DbType.String, model.address);
            db.AddInParameter(_Command, "money_unit_id", DbType.String, model.money_unit_id);
            db.AddInParameter(_Command, "abrv", DbType.String, model.abrv);
            db.AddInParameter(_Command, "tel", DbType.String, model.tel);
            db.AddInParameter(_Command, "fax", DbType.String, model.fax);
            db.AddInParameter(_Command, "first_amount", DbType.Decimal, model.First_amount);
            db.AddInParameter(_Command, "email", DbType.String, model.email);
            db.AddInParameter(_Command, "mobil", DbType.String, model.mobil);
            db.AddInParameter(_Command, "remark", DbType.String, model.remark);

            return db.ExecuteNonQuery(_Command);
        }

        /// <summary>
        /// 删除一条数据
        /// </summary>
        public int Delete(string provide_id)
        {

            SqlDatabase db = common.db;
            DbCommand deleteCommand = db.GetStoredProcCommand("UP_provide_list_Delete");
            db.AddInParameter(deleteCommand, "provide_id", DbType.String, provide_id);
            int rowsAffected = db.ExecuteNonQuery(deleteCommand);

            return rowsAffected;
        }

        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        public Model.BaseData.provide_list GetModel(string provide_id)
        {
            SqlDatabase db = common.db;

            DbCommand SelectCommand = db.GetSqlStringCommand("SELECT * FROM provide_list WHERE [provide_id] ='" + provide_id + "'");

            Model.BaseData.provide_list model = new Model.BaseData.provide_list();

            DataSet ds = db.ExecuteDataSet(SelectCommand);
            model.provide_id = provide_id;
            if (ds.Tables[0].Rows.Count > 0)
            {
                model.sname = ds.Tables[0].Rows[0]["sname"].ToString();
                model.sman = ds.Tables[0].Rows[0]["sman"].ToString();
                model.address = ds.Tables[0].Rows[0]["address"].ToString();
                model.abrv = ds.Tables[0].Rows[0]["abrv"].ToString();
                model.tel = ds.Tables[0].Rows[0]["tel"].ToString();
                model.fax = ds.Tables[0].Rows[0]["fax"].ToString();
                model.email = ds.Tables[0].Rows[0]["email"].ToString();
                model.mobil = ds.Tables[0].Rows[0]["mobil"].ToString();
                model.remark = ds.Tables[0].Rows[0]["remark"].ToString();
                model.money_unit_id = ds.Tables[0].Rows[0]["money_unit_id"].ToString();
                model.First_amount = Decimal.Parse(ds.Tables[0].Rows[0]["first_amount"].ToString());
                model.provide_type_id = Int16.Parse(ds.Tables[0].Rows[0]["provide_type_id"].ToString());


                return model;
            }
            else
            {
                return null;
            }
        }
    }
}
