﻿using System;
using System.Data;
using System.Globalization;
using System.Text;
using Microsoft.Practices.EnterpriseLibrary.Data;
using Microsoft.Practices.EnterpriseLibrary.Data.Sql;
using System.Data.Common;
using System.Data.SqlClient;
using System.Web.UI.WebControls;

namespace DataClass
{
    public class stock_list
    {
        public stock_list()
        {
        }



        public static bool exists_input(string stock_id)
        {
            string strSQL;
            strSQL = "select 1  from [stock_input_remark]  where rtrim(stock_id)='" + stock_id + "' ";

            SqlDatabase db = common.db;

            DbCommand SelectCommand = db.GetSqlStringCommand(strSQL);

            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(SelectCommand);
            MyReader.Read();

            return MyReader.HasRows;
        }


        public void _print_stock_data(string dept_id, string provide_name, string xd_date_from, string xd_date_to, string jh_date_from, string jh_date_to, int stock_statu)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_stock_list_print");
            db.AddInParameter(selectCommand, "provide_name", DbType.String, provide_name);


            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);

            db.AddInParameter(selectCommand, "xd_date_from", DbType.String, xd_date_from);
            db.AddInParameter(selectCommand, "xd_date_to", DbType.String, xd_date_to);
            db.AddInParameter(selectCommand, "jh_date_from", DbType.String, jh_date_from);
            db.AddInParameter(selectCommand, "jh_date_to", DbType.String, jh_date_to);



            db.AddInParameter(selectCommand, "stock_statu", DbType.Int16, stock_statu);


            db.ExecuteDataSet(selectCommand);
        }
        public DataSet GetStockList(int PageSize, string dept_id, string provide_name, string xd_date_from, string xd_date_to, string jh_date_from, string jh_date_to, int stock_statu, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_stock_list_Query");
            db.AddInParameter(selectCommand, "provide_name", DbType.String, provide_name);

            db.AddInParameter(selectCommand, "PageSize", DbType.Int16, PageSize);

            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);

            db.AddInParameter(selectCommand, "xd_date_from", DbType.String, xd_date_from);
            db.AddInParameter(selectCommand, "xd_date_to", DbType.String, xd_date_to);
            db.AddInParameter(selectCommand, "jh_date_from", DbType.String, jh_date_from);
            db.AddInParameter(selectCommand, "jh_date_to", DbType.String, jh_date_to);



            db.AddInParameter(selectCommand, "stock_statu", DbType.Int16, stock_statu);

            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array GetStocklist_Count(int PageSize, string dept_id, string provide_name, string xd_date_from, string xd_date_to, string jh_date_from, string jh_date_to, int stock_statu)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_stock_list_Query");
            db.AddInParameter(selectCommand, "provide_name", DbType.String, provide_name);
            db.AddInParameter(selectCommand, "PageSize", DbType.Int16, PageSize);

            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);

            db.AddInParameter(selectCommand, "xd_date_from", DbType.String, xd_date_from);
            db.AddInParameter(selectCommand, "xd_date_to", DbType.String, xd_date_to);
            db.AddInParameter(selectCommand, "jh_date_from", DbType.String, jh_date_from);
            db.AddInParameter(selectCommand, "jh_date_to", DbType.String, jh_date_to);



            db.AddInParameter(selectCommand, "stock_statu", DbType.Int16, stock_statu);

            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }

            return Array;
        }

        public int Add(Model.BaseData.stock_list model)
        {
            SqlDatabase db = common.db;
            DbCommand _Command = db.GetStoredProcCommand("stock_list_ADD");

            db.AddInParameter(_Command, "xd_man", DbType.String, model.xd_man);
            db.AddInParameter(_Command, "xd_date", DbType.String, model.xd_date);
            db.AddInParameter(_Command, "jh_address", DbType.String, model.jh_address);
            db.AddInParameter(_Command, "remark", DbType.String, model.remark);
            db.AddInParameter(_Command, "provide_id", DbType.String, model.provide_id);
            db.AddInParameter(_Command, "dept_id", DbType.String, model.dept_id);
            db.AddInParameter(_Command, "payment_id", DbType.Int16, model.payment_id);

            db.AddInParameter(_Command, "money_id", DbType.Int16, model.money_id);

            return db.ExecuteNonQuery(_Command);
        }

        /// <summary>
        ///  更新一条数据
        /// </summary>
        public int Update(Model.BaseData.stock_list model)
        {
            SqlDatabase db = common.db;
            DbCommand _Command = db.GetStoredProcCommand("stock_list_Update");

            db.AddInParameter(_Command, "stock_id", DbType.String, model.stock_id);
            db.AddInParameter(_Command, "dept_id", DbType.String, model.dept_id);

            db.AddInParameter(_Command, "xd_man", DbType.String, model.xd_man);
            db.AddInParameter(_Command, "xd_date", DbType.String, model.xd_date);
            db.AddInParameter(_Command, "jh_address", DbType.String, model.jh_address);
            db.AddInParameter(_Command, "remark", DbType.String, model.remark);
            db.AddInParameter(_Command, "provide_id", DbType.String, model.provide_id);
            db.AddInParameter(_Command, "payment_id", DbType.Int16, model.payment_id);

            db.AddInParameter(_Command, "money_id", DbType.Int16, model.money_id);

            return db.ExecuteNonQuery(_Command);
        }

        /// <summary>
        /// 删除一条数据
        /// </summary>
        public int Delete(string stock_id,string dept_id)
        {

            SqlDatabase db = common.db;
            DbCommand deleteCommand = db.GetStoredProcCommand("stock_list_Delete");
            db.AddInParameter(deleteCommand, "stock_id", DbType.String, stock_id);
            db.AddInParameter(deleteCommand, "dept_id", DbType.String, dept_id);
            int rowsAffected = db.ExecuteNonQuery(deleteCommand);

            return rowsAffected;
        }
        public int stock_sk(string stock_id, string dept_id, string sk_man)
        {

            SqlDatabase db = common.db;
            DbCommand _Command = db.GetSqlStringCommand("update stock_list set sk_date=convert(varchar(10),getdate(),120),sk_man=@sk_man where stock_id=@stock_id and dept_id=@dept_id  ");
            db.AddInParameter(_Command, "stock_id", DbType.String, stock_id);
            db.AddInParameter(_Command, "sk_man", DbType.String, sk_man);
            db.AddInParameter(_Command, "dept_id", DbType.String, dept_id);
            int rowsAffected = db.ExecuteNonQuery(_Command);

            return rowsAffected;
        }


        public int stock_jh(string stock_id, string dept_id)
        {

            SqlDatabase db = common.db;
            DbCommand _Command = db.GetSqlStringCommand("update stock_list set jh_date=convert(varchar(10),getdate(),120)  where stock_id=@stock_id  and dept_id=@dept_id ");
            db.AddInParameter(_Command, "stock_id", DbType.String, stock_id);
            db.AddInParameter(_Command, "dept_id", DbType.String, dept_id);
            int rowsAffected = db.ExecuteNonQuery(_Command);

            return rowsAffected;
        }

        public int stock_jd(string stock_id, string dept_id)
        {

            SqlDatabase db = common.db;
            DbCommand _Command = db.GetSqlStringCommand("update stock_list set jd_date=convert(varchar(10),getdate(),120)  where stock_id=@stock_id and dept_id=@dept_id  ");
            db.AddInParameter(_Command, "stock_id", DbType.String, stock_id);
            db.AddInParameter(_Command, "dept_id", DbType.String, dept_id);
            int rowsAffected = db.ExecuteNonQuery(_Command);

            return rowsAffected;
        }

        public int stock_cancel_sk(string stock_id, string dept_id)
        {

            SqlDatabase db = common.db;
            DbCommand _Command = db.GetSqlStringCommand("update stock_list set sk_date='',sk_man='' where stock_id=@stock_id and dept_id=@dept_id  ");
            db.AddInParameter(_Command, "stock_id", DbType.String, stock_id);
            db.AddInParameter(_Command, "dept_id", DbType.String, dept_id);
            int rowsAffected = db.ExecuteNonQuery(_Command);

            return rowsAffected;
        }


        public int stock_cancel_jh(string stock_id, string dept_id)
        {

            SqlDatabase db = common.db;
            DbCommand _Command = db.GetSqlStringCommand("update stock_list set jh_date=''  where stock_id=@stock_id  and dept_id=@dept_id ");
            db.AddInParameter(_Command, "stock_id", DbType.String, stock_id);
            db.AddInParameter(_Command, "dept_id", DbType.String, dept_id);
            int rowsAffected = db.ExecuteNonQuery(_Command);

            return rowsAffected;
        }

        public int stock_cancel_jd(string stock_id, string dept_id)
        {

            SqlDatabase db = common.db;
            DbCommand _Command = db.GetSqlStringCommand("update stock_list set jd_date=''  where stock_id=@stock_id and dept_id=@dept_id  ");
            db.AddInParameter(_Command, "stock_id", DbType.String, stock_id);
            db.AddInParameter(_Command, "dept_id", DbType.String, dept_id);
            int rowsAffected = db.ExecuteNonQuery(_Command);

            return rowsAffected;
        }

        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        public Model.BaseData.stock_list GetModel(string stock_id, string dept_id)
        {
            SqlDatabase db = common.db;

            DbCommand SelectCommand = db.GetSqlStringCommand("SELECT * FROM stock_list_view WHERE [stock_id] ='" + stock_id + "' and dept_id='" + dept_id + "'");

            Model.BaseData.stock_list model = new Model.BaseData.stock_list();

            DataSet ds = db.ExecuteDataSet(SelectCommand);
            model.stock_id = stock_id;
            model.dept_id = dept_id;
            if (ds.Tables[0].Rows.Count > 0)
            {
                model.xd_man = ds.Tables[0].Rows[0]["xd_man"].ToString();
                model.xd_date = ds.Tables[0].Rows[0]["xd_date"].ToString();
                model.jh_address = ds.Tables[0].Rows[0]["jh_address"].ToString();
                model.remark = ds.Tables[0].Rows[0]["remark"].ToString();
                model.sk_man = ds.Tables[0].Rows[0]["sk_man"].ToString();
                model.sk_date = ds.Tables[0].Rows[0]["sk_date"].ToString();
                model.payment_id = Int16.Parse(ds.Tables[0].Rows[0]["payment_id"].ToString());
                model.money_id = Int16.Parse(ds.Tables[0].Rows[0]["money_id"].ToString());
                model.jh_date = ds.Tables[0].Rows[0]["jh_date"].ToString();
                model.jd_date = ds.Tables[0].Rows[0]["jd_date"].ToString();
                model.stock_statu = Int16.Parse(ds.Tables[0].Rows[0]["stock_statu"].ToString());
                model.provide_id = ds.Tables[0].Rows[0]["provide_id"].ToString();
                model.stock_amount = Int32.Parse(ds.Tables[0].Rows[0]["amount1"].ToString());

                return model;
            }
            else
            {
                return null;
            }
        }



        public DataSet Getstock_output_remark(string stock_id, string dept_id, Int32 product_id)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("select_stock_input_remark");
            db.AddInParameter(selectCommand, "stock_id", DbType.String, stock_id);
          db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "product_id", DbType.Int32, product_id);

            return db.ExecuteDataSet(selectCommand);
        }



        public int insert_stock_output_remark(string stock_id, string dept_id, string stock_dept_id, Int32 product_id, Int32 scount, string sman)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("Add_stock_input_remark");
            db.AddInParameter(selectCommand, "stock_id", DbType.String, stock_id);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "stock_dept_id", DbType.String, stock_dept_id);
            db.AddInParameter(selectCommand, "product_id", DbType.Int32, product_id);
            db.AddInParameter(selectCommand, "scount", DbType.Int32, scount);
            db.AddInParameter(selectCommand, "sman", DbType.String, sman);

            return db.ExecuteNonQuery(selectCommand);
        }

        public int delete_stock_output_remark(string stock_id,  Int32 product_id, string dept_id,string sdate)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("Delete_stock_input_remark");
            db.AddInParameter(selectCommand, "stock_id", DbType.String, stock_id);
           db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "product_id", DbType.Int32, product_id);
            db.AddInParameter(selectCommand, "sdate", DbType.String, sdate);

            return db.ExecuteNonQuery(selectCommand);
        }


        public DataSet Getstock_outdate_Excel(string dept_id, string provide)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_stock_outdate_Query");
            db.AddInParameter(selectCommand, "provide", DbType.String, provide);

            db.AddInParameter(selectCommand, "PageSize", DbType.Int32, 99999);

            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);


            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, 1);

            return db.ExecuteDataSet(selectCommand);
        }

        public DataSet Getstock_outdateList(int PageSize, string dept_id, string provide, int CurrentPage)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_stock_outdate_Query");
            db.AddInParameter(selectCommand, "provide", DbType.String, provide);

            db.AddInParameter(selectCommand, "PageSize", DbType.Int16, PageSize);

            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);


            db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

            return db.ExecuteDataSet(selectCommand);
        }
        public Array Getstock_outdate_list_Count(int PageSize, string dept_id, string provide)
        {
            SqlDatabase db = common.db;

            DbCommand selectCommand = db.GetStoredProcCommand("UP_stock_outdate_Query");
            db.AddInParameter(selectCommand, "provide", DbType.String, provide);
            db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
            db.AddInParameter(selectCommand, "PageSize", DbType.Int16, PageSize);

            db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

            int[] Array = new int[3];
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
            ListItem _List = new ListItem();
            try
            {
                MyReader.Read();
                Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
                Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
                Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

            }
            finally
            {
                MyReader.Close();
            }
            //
            return Array;
        }
    }

}
