﻿using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using Maticsoft.DBUtility;//请先添加引用
using Microsoft.Practices.EnterpriseLibrary.Data;
using Microsoft.Practices.EnterpriseLibrary.Data.Sql;
using System.Web.UI.WebControls;
using System.Data.Common;

namespace DataClass
{
   public class store_month
    {
       public store_month()
        { }

       public DataSet get_month_date()
       {
           SqlDatabase db = common.db;

           DbCommand selectCommand = db.GetSqlStringCommand("select sdate,sman from  month_date order by sdate desc");
           return db.ExecuteDataSet(selectCommand);
       }
       public static string  get_month_last_date()
       {
            SqlDatabase db = common.db;
           DbCommand selectCommand = db.GetSqlStringCommand("select isnull( max(sdate),'1900-01-01') as sdate from  month_date"); 
            SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);

            MyReader.Read();
            return MyReader[0].ToString();
       }

       public int exec_month(string sman)
       {
           SqlDatabase db = common.db;

           DbCommand selectCommand = db.GetStoredProcCommand("month");
           db.AddInParameter(selectCommand, "sman", DbType.String, sman);
          return  db.ExecuteNonQuery(selectCommand);
       }
       public int adjust_month_store(string month_date, string dept_id, int product_id, int adjust_scount, string adjust_man)
       {
           SqlDatabase db = common.db;

           DbCommand selectCommand = db.GetStoredProcCommand("UP_adjust_month_store");
           db.AddInParameter(selectCommand, "month_date", DbType.String, month_date);
           db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
           db.AddInParameter(selectCommand, "adjust_man", DbType.String, adjust_man);
           db.AddInParameter(selectCommand, "product_id", DbType.Int32, product_id);
           db.AddInParameter(selectCommand, "adjust_scount", DbType.Int32, adjust_scount);
           return db.ExecuteNonQuery(selectCommand);
       }

       protected static int strTOint(string str)
       {
           int _return = 0;
           str = str.Trim();
           if (str.Length == 0)
               _return = 0;
           else
               _return = Int32.Parse(str);
           return _return;
       }

       public DataSet Get_month_storeList(string dept_id, string month_date, string stype, string product_id, string product_name, string  is_adjust, int  CurrentPage)
       {
           SqlDatabase db = common.db;

           DbCommand selectCommand = db.GetStoredProcCommand("UP_month_store_Query");
           db.AddInParameter(selectCommand, "product_id", DbType.Int32, strTOint(product_id));
           db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
           db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
           db.AddInParameter(selectCommand, "month_date", DbType.String, month_date);
           db.AddInParameter(selectCommand, "stype", DbType.String, Int32.Parse(stype));
           db.AddInParameter(selectCommand, "is_adjust", DbType.Int16, Int16.Parse(is_adjust));
           db.AddInParameter(selectCommand, "CurrentPage", DbType.Int32, CurrentPage);

           DataSet ds= db.ExecuteDataSet(selectCommand);
           DataTable dt = ds.Tables[0];


           dt.Columns["dept_id"].ColumnName = "门市号";
           dt.Columns["dept_name"].ColumnName = "门市";
           dt.Columns["product_id"].ColumnName = "产品号";
           dt.Columns["product_name"].ColumnName = "品名";
           dt.Columns["first_input"].ColumnName = "上期库存数";
           dt.Columns["product_input"].ColumnName = "产品入库";
           dt.Columns["stock_input"].ColumnName = "采购单入库";
           dt.Columns["client_back_in_scount"].ColumnName = "客户退货";
           dt.Columns["back_provide_in_scount"].ColumnName = "返修入库";
           dt.Columns["revert_scount"].ColumnName = "外借归还";
           dt.Columns["lend_scount"].ColumnName = "外借";
           dt.Columns["adjust_out_scount"].ColumnName = "调出数";
           dt.Columns["adjust_in_scount"].ColumnName = "调入数";
           dt.Columns["dd_output_scount"].ColumnName = "订单出货";
           dt.Columns["output_scount"].ColumnName = "前台销售";
           dt.Columns["back_provide_out_scount"].ColumnName = "退供应商";
           dt.Columns["client_back_out_scount"].ColumnName = "还客户";
           dt.Columns["useless_scount"].ColumnName = "报废";
           dt.Columns["store_scount"].ColumnName = "当前库存数";
           dt.Columns["price"].ColumnName = "单价";
           dt.Columns["amount"].ColumnName = "当前金额";
           dt.Columns["adjust_amount"].ColumnName = "修正金额";
          // dt.Columns.Remove("price");
         //  dt.Columns.Remove("amount");

           return ds;
           
       }


       public Array Get_month_storeList_sum(string dept_id, string month_date, string stype, string product_id, string product_name,string  is_adjust)
       {
           SqlDatabase db = common.db;


           DbCommand selectCommand = db.GetStoredProcCommand("UP_month_store_sum");
           db.AddInParameter(selectCommand, "product_id", DbType.Int32, strTOint(product_id));
           db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
           db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
           db.AddInParameter(selectCommand, "month_date", DbType.String, month_date);
           db.AddInParameter(selectCommand, "is_adjust", DbType.Int16, Int16.Parse(is_adjust));
           db.AddInParameter(selectCommand, "stype", DbType.String, Int32.Parse(stype));

           decimal[] Array = new decimal[18];
           SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
           ListItem _List = new ListItem();
           try
           {
               MyReader.Read();
               Array[0] = decimal.Parse(MyReader["first_input"].ToString());
               Array[1] = decimal.Parse(MyReader["product_input"].ToString());
               Array[2] = decimal.Parse(MyReader["stock_input"].ToString());
               Array[3] = decimal.Parse(MyReader["lend_scount"].ToString());
               Array[4] = decimal.Parse(MyReader["revert_scount"].ToString());
               Array[5] = decimal.Parse(MyReader["dd_output_scount"].ToString());
               Array[6] = decimal.Parse(MyReader["output_scount"].ToString());
               Array[7] = decimal.Parse(MyReader["adjust_in_scount"].ToString());
               Array[8] = decimal.Parse(MyReader["adjust_out_scount"].ToString());


               Array[9] = decimal.Parse(MyReader["client_back_in_scount"].ToString());
               Array[10] = decimal.Parse(MyReader["back_provide_in_scount"].ToString());


               Array[11] = decimal.Parse(MyReader["back_provide_out_scount"].ToString());
               Array[12] = decimal.Parse(MyReader["client_back_out_scount"].ToString());


               Array[13] = decimal.Parse(MyReader["useless_scount"].ToString());
               Array[14] = decimal.Parse(MyReader["store_scount"].ToString());
               Array[15] = decimal.Parse(MyReader["adjust_scount"].ToString());


               Array[16] = decimal.Parse(MyReader["adjust_amount"].ToString());
               Array[17] = decimal.Parse(MyReader["amount"].ToString());


           }
           finally
           {
               MyReader.Close();
           }

           return Array;
       }


       public DataSet Get_month_storeList_excel(string dept_id, string month_date, string stype, string product_id, string product_name, string is_adjust)
       {
           SqlDatabase db = common.db;

           DbCommand selectCommand = db.GetStoredProcCommand("UP_month_store_Query");
           db.AddInParameter(selectCommand, "product_id", DbType.Int32, strTOint(product_id));
           db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
           db.AddInParameter(selectCommand, "month_date", DbType.String, month_date);
           db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
           db.AddInParameter(selectCommand, "stype", DbType.String, Int32.Parse(stype));
           db.AddInParameter(selectCommand, "is_adjust", DbType.Int16, Int16.Parse(is_adjust));
           db.AddInParameter(selectCommand, "PageSize", DbType.Int32, 99999);

           DataSet ds = db.ExecuteDataSet(selectCommand);
           DataTable dt = ds.Tables[0];


           dt.Columns["dept_id"].ColumnName = "门市号";
           dt.Columns["dept_name"].ColumnName = "门市";
           dt.Columns["product_id"].ColumnName = "产品号";
           dt.Columns["product_name"].ColumnName = "品名";
        //   dt.Columns["last_month_date"].ColumnName = "上期日期";
           dt.Columns["first_input"].ColumnName = "上期库存数";
           dt.Columns["revert_scount"].ColumnName = "外借归还";
           dt.Columns["lend_scount"].ColumnName = "外借";
           dt.Columns["product_input"].ColumnName = "产品入库";
           dt.Columns["stock_input"].ColumnName = "采购单入库";
           dt.Columns["client_back_in_scount"].ColumnName = "客户退货";
           dt.Columns["back_provide_in_scount"].ColumnName = "返修入库";
           dt.Columns["adjust_out_scount"].ColumnName = "调出数";
           dt.Columns["adjust_in_scount"].ColumnName = "调入数";
           dt.Columns["dd_output_scount"].ColumnName = "订单出货";
           dt.Columns["output_scount"].ColumnName = "前台销售";
           dt.Columns["back_provide_out_scount"].ColumnName = "退供应商";
           dt.Columns["client_back_out_scount"].ColumnName = "还客户";
           dt.Columns["useless_scount"].ColumnName = "报废";
           dt.Columns["store_scount"].ColumnName = "当前库存数";
        //   dt.Columns["month_date"].ColumnName = "本期日期";
       //    dt.Columns["price"].ColumnName = "单价";
       //    dt.Columns["amount"].ColumnName = "金额";

           dt.Columns.Remove("last_month_date");
           dt.Columns.Remove("month_date");
           dt.Columns.Remove("price");
           dt.Columns.Remove("amount");
           return ds;

       }

       public Array Get_month_storeList_Count(string dept_id, string month_date, string stype, string product_id, string product_name, string  is_adjust)
       {
           SqlDatabase db = common.db;

           DbCommand selectCommand = db.GetStoredProcCommand("UP_month_store_Query");
           db.AddInParameter(selectCommand, "product_id", DbType.Int32, strTOint(product_id));
           db.AddInParameter(selectCommand, "product_name", DbType.String, product_name);
           db.AddInParameter(selectCommand, "month_date", DbType.String, month_date);
           db.AddInParameter(selectCommand, "dept_id", DbType.String, dept_id);
           db.AddInParameter(selectCommand, "stype", DbType.String, Int32.Parse(stype));
           db.AddInParameter(selectCommand, "is_adjust", DbType.Int16, Int16.Parse(is_adjust));
           db.AddInParameter(selectCommand, "IsCount", DbType.Int32, 1);

           int[] Array = new int[3];
           SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);
           ListItem _List = new ListItem();
           try
           {
               MyReader.Read();
               Array[0] = Int32.Parse(MyReader[0].ToString());//页面尺寸
               Array[1] = Int32.Parse(MyReader[1].ToString());//总记录数
               Array[2] = Int32.Parse(MyReader[2].ToString());//总页数

           }
           finally
           {
               MyReader.Close();
           }

           return Array;
       }

       public  static  string get_last_date(string sdate)
       {
           SqlDatabase db = common.db;

           DbCommand selectCommand = db.GetSqlStringCommand("select isnull(max(sdate),'') as sdate  from  month_date where sdate<@sdate");
           db.AddInParameter(selectCommand, "sdate", DbType.String, sdate);

           SqlDataReader MyReader = (SqlDataReader)db.ExecuteReader(selectCommand);

           MyReader.Read();
           return MyReader[0].ToString();
       }
    }
}
