#region ռ
using System;
using System.Text;
using System.Text.RegularExpressions;
#endregion

/*
 *   ĿƣPathik.DataValidator
 *	 Copyright (c) 2004-2005,  
 *	 All rights reserved.
 *	 
 *	 ļƣDataValidator.cs
 *	 ļʶ֤
 *	 ժ    Ҫ֤ĶԶַ֤ຯдΪ̬
 *			   ֱʹã贴ʵ
 *	 
 *	 ǰ汾0.5
 *	     ߣPathik
 *	 ڣ2004-12-09

 *	 ȡ汾1.0 
 *	 ԭ  Pathik
 *	 ȡ  Pathik
 *	 ޸ݣЧ
 *	 ޸  ˵
 *	 Ԥգ2005101
 *	 ʱ䣺
 */

namespace Market
{
	/// <summary>
	/// ValidHelper ֤ࡣ
	/// </summary>
	public class DataValidator
	{
		#region DataValidator
		/// <summary>
		/// չ캯
		/// </summary>
		public DataValidator()
		{
			//
			// TODO: ڴ˴ӹ캯߼
			//
		}
		#endregion

		#region IsInt32
		/// <summary>
		/// ַ֤Ƿ
		/// </summary>
		/// <param name="input">Ҫַ֤</param>
		/// <returns></returns>
		public static bool IsInt32(string input)
		{
            //string regexString = @"^-?\\d+$";

            //return Regex.IsMatch(input, regexString);

            try
            {
                Convert.ToInt32(input);
                return true;
            }
            catch
            {
                return false;
            }
		}
		#endregion

		#region IsDouble
		/// <summary>
		/// ַ֤Ƿ񸡵
		/// </summary>
		/// <param name="v">Ҫַ֤</param>
		/// <returns></returns>
        public static bool IsDecimal(string input)
		{
            //string regexString = @"^(-?\\d+)(\\.\\d+)?$";

         
            //return Regex.IsMatch(input, regexString);

            try
            {
                Convert.ToDecimal(input);
                return true;
            }
            catch
            {
                return false;
            }
		}
		#endregion

		#region IsEmail
		/// <summary>
		/// ַ֤Emailַ
		/// </summary>
		/// <param name="input">Ҫַ֤</param>
		/// <returns></returns>
		public static bool IsEmail(string input)
		{
			// Return true if strIn is in valid e-mail format.
			string regexString = @"^([\w-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([\w-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$";
			
			return Regex.IsMatch(input, regexString); 
		}
		#endregion

		#region IsDate
		/// <summary>
		/// ַ֤Ƿ[2004-2-29|||2004-02-29 10:29:39 pm|||2004/12/31]
		/// </summary>
		/// <param name="v">Ҫַ֤</param>
		/// <returns></returns>
		public static bool IsDate(string input)
		{
			string regexString = @"^((\d{2}(([02468][048])|([13579][26]))[\-\/\s]?((((0?[13578])|(1[02]))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\-\/\s]?((0?[1-9])|([1-2][0-9])))))|(\d{2}(([02468][1235679])|([13579][01345789]))[\-\/\s]?((((0?[13578])|(1[02]))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\-\/\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\s(((0?[1-9])|(1[0-2]))\:([0-5][0-9])((\s)|(\:([0-5][0-9])\s))([AM|PM|am|pm]{2,2})))?$";

			return Regex.IsMatch(input, regexString);
			#region Description
			/*
			Expression:  ^((\d{2}(([02468][048])|([13579][26]))[\-\/\s]?((((0?[13578]
							)|(1[02]))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[4
							69])|(11))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\-\/\
							s]?((0?[1-9])|([1-2][0-9])))))|(\d{2}(([02468][1235679])|([1
							3579][01345789]))[\-\/\s]?((((0?[13578])|(1[02]))[\-\/\s]?((
							0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\-\/\s]?((
							0?[1-9])|([1-2][0-9])|(30)))|(0?2[\-\/\s]?((0?[1-9])|(1[0-9]
							)|(2[0-8]))))))(\s(((0?[1-9])|(1[0-2]))\:([0-5][0-9])((\s)|(
							\:([0-5][0-9])\s))([AM|PM|am|pm]{2,2})))?$
 
			Author:  Sung Lee 
			Sample Matches:  
			2004-2-29|||2004-02-29 10:29:39 pm|||2004/12/31 
			Sample Non-Matches:  
			2003-2-29|||2003-13-02|||2003-2-2 10:72:30 am 
			Description:  Matches ANSI SQL date format YYYY-mm-dd hh:mi:ss am/pm. You can use / - or space for date delimiters, so 2004-12-31 works just as well as 2004/12/31. Checks leap year from 1901 to 2099. 
			 */
			#endregion
		}
		#endregion

		#region IsAnsiSqlDate
		/// <summary>
		/// ַ֤Ƿ ANSI SQL date format
		/// </summary>
		/// <param name="v">Ҫַ֤</param>
		/// <returns></returns>
		public static bool IsAnsiSqlDate(string input)
		{
			string regexString = @"^((\d{2}(([02468][048])|([13579][26]))[\-\/\s]?((((0?[13578]
									)|(1[02]))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[4
									69])|(11))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\-\/\
									s]?((0?[1-9])|([1-2][0-9])))))|(\d{2}(([02468][1235679])|([1
									3579][01345789]))[\-\/\s]?((((0?[13578])|(1[02]))[\-\/\s]?((
									0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\-\/\s]?((
									0?[1-9])|([1-2][0-9])|(30)))|(0?2[\-\/\s]?((0?[1-9])|(1[0-9]
									)|(2[0-8]))))))(\s(((0?[1-9])|(1[0-2]))\:([0-5][0-9])((\s)|(
									\:([0-5][0-9])\s))([AM|PM|am|pm]{2,2})))?$";

			return Regex.IsMatch(input, regexString);
			#region Description
			/*
			Expression:  ^((\d{2}(([02468][048])|([13579][26]))[\-\/\s]?((((0?[13578]
							)|(1[02]))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[4
							69])|(11))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\-\/\
							s]?((0?[1-9])|([1-2][0-9])))))|(\d{2}(([02468][1235679])|([1
							3579][01345789]))[\-\/\s]?((((0?[13578])|(1[02]))[\-\/\s]?((
							0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\-\/\s]?((
							0?[1-9])|([1-2][0-9])|(30)))|(0?2[\-\/\s]?((0?[1-9])|(1[0-9]
							)|(2[0-8]))))))(\s(((0?[1-9])|(1[0-2]))\:([0-5][0-9])((\s)|(
							\:([0-5][0-9])\s))([AM|PM|am|pm]{2,2})))?$
							 
							Author:  Sung Lee 
							Sample Matches:  
							2004-2-29|||2004-02-29 10:29:39 pm|||2004/12/31 
							Sample Non-Matches:  
							2003-2-29|||2003-13-02|||2003-2-2 10:72:30 am 
							Description:  Matches ANSI SQL date format YYYY-mm-dd hh:mi:ss am/pm. You can use / - or space for date delimiters, so 2004-12-31 works just as well as 2004/12/31. Checks leap year from 1901 to 2099. 

			 */
			#endregion
		}
		#endregion

		#region IsTxtFileName
		/// <summary>
		/// ַ֤ǷTXTļ(ȫ)
		/// </summary>
		/// <param name="input">Ҫַ֤</param>
		/// <returns></returns>
		public static bool IsTxtFileName(string input)
		{
			string regexString = @"^(([a-zA-Z]:)|(\\{2}\w+)\$?)(\\(\w[\w ]*))+\.(txt|TXT)$";

			return Regex.IsMatch(input, regexString);
			#region Description
			/*
			
			Expression:  ^(([a-zA-Z]:)|(\\{2}\w+)\$?)(\\(\w[\w ]*))+\.(txt|TXT)$
 
			Author:  Michael Ash 
			Sample Matches:  
			c:\file.txt|||c:\folder\sub folder\file.txt|||\\network\folder\file.txt 
			Sample Non-Matches:  
			C:|||C:\file.xls|||folder.txt 
			Description:  This RE validates a path/file of type txt (text file) This RE can be used as a filter on certain file types, while insuring the entire string is a fully qualified path and file. The filter value can be changed or added to as you need 

			 */
			#endregion
		}
		#endregion
	}
}
