﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
namespace Market
{
    public partial class Form1 : Form
    {
        private DataTable _client_list;
        private DataTable _material_list;
        private DataTable _unit_list;
        private DataTable _seller_list;
        private DataTable _money_list;
    //    private DataGridViewPrinter MyDataGridViewPrinter;

        private int all_count =0; //总行数
        private int linesPerPage = 5; //每页行数
        private int had_print_count = 0; //行计数器
        private int count = 0; //行计数器

        private int all_page_count = 0;

        private Market.retail.retailSoapClient ws = new Market.retail.retailSoapClient();

        private DataTable table;

        private DataTable DT
        {
            get
            {
                if (table == null)
                {
                    table = new DataTable();
                    temp_table(table);
                }
                return table;
            }
            set
            {
                table = value;
            }
        }
        public Form1()
        {
            InitializeComponent();
            get_data_table();
            get_user_info();
            d_date.Value = DateTime.Now;

            login_info model = new login_info();
            this.Text = model.sname;


            backgroundWorker1.RunWorkerAsync();
            backgroundWorker2.RunWorkerAsync(); 
        }
        private void get_user_info()
        {
            login_info model = new login_info();
            userid.Text = model.User_ID;
            username.Text = model.User_Name;
            dept.Text = model.Dept;
            duty.Text = model.Duty;

            h_dept_id.Text = model.Dept_ID;
            h_user_price.Text = model.User_price;
            h_user_type.Text = model.User_type;
        }
        private void get_data_table()
        {
            get_unit_list();
            get_seller_list();
            get_money_list();         
        }
        private void get_unit_list()
        {
            _unit_list = ws.get_retail_unit_list();
            c_unit_id.DataSource = _unit_list;
            c_unit_id.DisplayMember = "sname";
            c_unit_id.ValueMember = "unit_id";

        }

        private void get_money_list()
        {
            _money_list = ws.get_retail_money_list();
            c_money_id.DataSource = _money_list;
            c_money_id.DisplayMember = "momey_unit_name";
            c_money_id.ValueMember = "money_id";

        }

        private void get_seller_list()
        {
            _seller_list = ws.get_retail_seller_list();
            c_seller_id.DataSource = _seller_list;
            c_seller_id.DisplayMember = "seller_name";
            c_seller_id.ValueMember = "seller_id";

        }
        private void get_client_list(BackgroundWorker worker, DoWorkEventArgs e)
        {
            progressBar1.Visible = true;
            int _count = ws.get_retail_client_count();
            _client_list = ws.get_retail_client_list(1, 10);
            progressBar1.Maximum = _count;
            int i = 0;
            if (_count % 10 != 0)
            {
                if (_count > 10)
                {
                    for (i = 2; i <= (_count / 10) + 1; i++)
                    {
                        foreach (DataRow dw in ws.get_retail_client_list(i, 10).Rows)
                        {
                            _client_list.Rows.Add(dw.ItemArray);
                        }
                        worker.ReportProgress((i - 1) * 10);

                    }
                }
            }
            if (_count % 10 == 0)
            {
                if (_count > 10)
                {
                    for (i = 2; i <= (_count / 10); i++)
                    {
                        foreach (DataRow dw in ws.get_retail_client_list(i, 10).Rows)
                        {
                            _client_list.Rows.Add(dw.ItemArray);
                        }
                        worker.ReportProgress((i - 1) * 10);
                    }
                }
            }

            c_client_id.DataSource = _client_list;
            c_client_id.DisplayMember = "sname";
            c_client_id.ValueMember = "client_id";
            c_client_id.SelectedIndex = -1;
            c_client_id.Text = "";

            progressBar1.Visible = false;
        }
        private void get_material_list(BackgroundWorker worker, DoWorkEventArgs e)
        {
            progressBar2.Visible = true;
            int _count = ws.get_retail_material_list_count();
            _material_list = ws.get_retail_material_list(1, 10);
            progressBar2.Maximum = _count;
            int i = 0;
            if (_count % 10 != 0)
            {
                if (_count > 10)
                {
                    for (i = 2; i <= (_count / 10) + 1; i++)
                    {
                        foreach (DataRow dw in ws.get_retail_material_list(i, 10).Rows)
                        {
                            _material_list.Rows.Add(dw.ItemArray);
                        }
                        worker.ReportProgress((i-1) * 10);
                    }
                }
            }
            if (_count % 10 == 0)
            {
                if (_count > 10)
                {
                    for (i = 2; i <= (_count / 10); i++)
                    {
                        foreach (DataRow dw in ws.get_retail_material_list(i, 10).Rows)
                        {
                            _material_list.Rows.Add(dw.ItemArray);
                        }
                        worker.ReportProgress((i - 1) * 10);
                    }
                }
            }

            c_product_id.DataSource = _material_list;
            c_product_id.DisplayMember = "sname";
            c_product_id.ValueMember = "material_id";
            c_product_id.SelectedIndex = -1;
            c_product_id.Text = "";
            progressBar2.Visible = false;
        }


        private void dataGridView1_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            using (SolidBrush b = new SolidBrush(dataGridView1.RowHeadersDefaultCellStyle.ForeColor))
            {
                e.Graphics.DrawString(Convert.ToString(e.RowIndex + 1, System.Globalization.CultureInfo.CurrentUICulture),
                e.InheritedRowStyle.Font, b, e.RowBounds.Location.X + 20, e.RowBounds.Location.Y + 4);
            } 

        }

        private void multiColumnComboBox2_OpenSearchForm(object sender, EventArgs e)
        {

            FormSearch newForm = new FormSearch((MultiColumnComboBox)sender);
            newForm.ShowDialog();
        }

        protected override bool ProcessDialogKey(Keys keyData)
        {
            if (keyData == Keys.Return)
            {
                this.SelectNextControl(this.ActiveControl, true, true, true, true);
            }
            return base.ProcessDialogKey(keyData);
        }

        private void c_cliebt_id_Enter(object sender, EventArgs e)
        {
            c_client_id.DroppedDown = true;
        }

        private void c_product_id_Enter(object sender, EventArgs e)
        {
            c_product_id.DroppedDown = true;
        }

        private void c_seller_Enter(object sender, EventArgs e)
        {
            c_seller_id.DroppedDown = true;
        }

        private void c_unit_id_Enter(object sender, EventArgs e)
        {
            c_unit_id.DroppedDown = true;
        }

        private void c_money_id_Enter(object sender, EventArgs e)
        {
            c_money_id.DroppedDown = true;
        }

        private void temp_table(DataTable _table)
        {

            DataColumn columnoutput_id;
            DataColumn columnproduct_id;
            DataColumn columnproduct_sn;
            DataColumn columnproduct_name;
            DataColumn columnscount;
            DataColumn columnprice;
            DataColumn columnmoney_id;
            DataColumn columnsman;
            DataColumn columnsdate;
            DataColumn columnremark;
            DataColumn columndept_id;
            DataColumn columnmoney_name;
            DataColumn columnamount;
            DataColumn columnbill_id;
            DataColumn columnclient;
            DataColumn columnclient_name;
            DataColumn columnunit_name;

            columnoutput_id = new System.Data.DataColumn("output_id", typeof(int), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnoutput_id);
            columnproduct_id = new System.Data.DataColumn("product_id", typeof(int), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnproduct_id);
            columnproduct_name = new System.Data.DataColumn("product_name", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnproduct_name);
            columnproduct_sn = new System.Data.DataColumn("product_sn", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnproduct_sn);
            columnscount = new System.Data.DataColumn("scount", typeof(int), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnscount);
            columnunit_name = new System.Data.DataColumn("unit_name", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnunit_name);
            columnprice = new System.Data.DataColumn("price", typeof(double), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnprice);
            columnmoney_id = new System.Data.DataColumn("money_id", typeof(int), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnmoney_id);
            columnsman = new System.Data.DataColumn("sman", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnsman);
            columnsdate = new System.Data.DataColumn("sdate", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnsdate);
            columndept_id = new System.Data.DataColumn("dept_id", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columndept_id);
            columnmoney_name = new System.Data.DataColumn("money_name", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnmoney_name);
            columnamount = new System.Data.DataColumn("amount", typeof(double), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnamount);
            columnbill_id = new System.Data.DataColumn("bill_id", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnbill_id);
            columnclient = new System.Data.DataColumn("client", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnclient);
            columnclient_name = new System.Data.DataColumn("client_name", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnclient_name);
            columnremark = new System.Data.DataColumn("remark", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnremark);

            columnoutput_id.AutoIncrement = true;
            columnoutput_id.AutoIncrementSeed = 1;
            columnoutput_id.AutoIncrementStep = 1;
            columnoutput_id.AllowDBNull = false;
            columnoutput_id.ReadOnly = true;
            columnoutput_id.Unique = true;
            columnproduct_id.AllowDBNull = false;
            columnproduct_sn.AllowDBNull = false;
            columnproduct_sn.MaxLength = 50;
            columnscount.AllowDBNull = false;
            columnprice.AllowDBNull = false;
            columnmoney_id.AllowDBNull = false;
            columnsman.AllowDBNull = false;
            columnsman.MaxLength = 20;
            columnsdate.AllowDBNull = false;
            columnsdate.MaxLength = 20;
            columnremark.AllowDBNull = false;
            columnremark.MaxLength = 50;
            columndept_id.AllowDBNull = false;
            columndept_id.MaxLength = 5;
            columnproduct_name.AllowDBNull = false;
            columnproduct_name.MaxLength = 50;
            columnmoney_name.AllowDBNull = false;
            columnmoney_name.MaxLength = 10;
            columnbill_id.AllowDBNull = false;
            columnbill_id.MaxLength = 10;
            columnclient.AllowDBNull = false;
            columnclient.MaxLength = 10;
            columnclient_name.AllowDBNull = false;
            columnclient_name.MaxLength = 50;
            columnunit_name.AllowDBNull = false;
            columnunit_name.MaxLength = 50;

        }
        private void _Save()
        { 
        try
            {
                if (c_product_id.Text.Trim().Length > 0)
                {
                    int stroe_scount = 0;
                    if (DT.Rows.Count == 0)
                        l_output_id.Text = ws.get_retail_output_bill(h_dept_id.Text);

                    DataRow row;
                    DataView view;
                    stroe_scount = ws.get_retail_store_scount(Int32.Parse(c_product_id.SelectedValue.ToString()), 0, h_dept_id.Text);
                    if (stroe_scount >= Convert.ToInt32(text_scount.Text))
                    {
                        row = DT.NewRow();

                        row["product_id"] = Int32.Parse(c_product_id.SelectedValue.ToString());
                        row["product_name"] = c_product_id.Text;
                        row["product_sn"] = text_produce_sn.Text.Trim();
                        row["money_id"] = Int16.Parse(c_money_id.SelectedValue.ToString());
                        row["money_name"] = c_money_id.Text;
                        row["price"] = Convert.ToDecimal(text_price.Text);
                        row["amount"] = Convert.ToDecimal(text_price.Text) * Convert.ToInt32(text_scount.Text);
                        row["remark"] = text_remark.Text.Trim();
                        row["sman"] = username.Text;
                        row["dept_id"] = h_dept_id.Text;
                        row["scount"] = Convert.ToInt32(text_scount.Text);
                        row["sdate"] = d_date.Text + " " + DateTime.Now.ToString("HH:mm:ss");
                        row["bill_id"] = l_output_id.Text;
                        row["client"] = c_client_id.Text.Length > 0 ? c_client_id.SelectedValue.ToString() : "";

                        row["client_name"] = c_client_id.Text.Length > 0 ? c_client_id.Text : "";

                        row["unit_name"] = c_unit_id.Text;
                        DT.Rows.Add(row);

                        view = new DataView(DT);

                        dataGridView1.DataSource = view;
                        //    dataGridView1.DataBind();
                        dataGridView1.Columns["product_id"].HeaderText = "编号";
                        dataGridView1.Columns["product_name"].HeaderText = "品名";
                        dataGridView1.Columns["product_sn"].HeaderText = "序列号";
                        dataGridView1.Columns["money_id"].HeaderText = "货币号";
                        dataGridView1.Columns["money_name"].HeaderText = "货币";
                        dataGridView1.Columns["price"].HeaderText = "单价";
                        dataGridView1.Columns["amount"].HeaderText = "金额";
                        dataGridView1.Columns["remark"].HeaderText = "备注";
                        dataGridView1.Columns["sman"].HeaderText = "销售人";
                        dataGridView1.Columns["dept_id"].HeaderText = "部门号";
                        dataGridView1.Columns["scount"].HeaderText = "数量";
                        dataGridView1.Columns["sdate"].HeaderText = "日期";
                        dataGridView1.Columns["bill_id"].HeaderText = "单号";
                        dataGridView1.Columns["client"].HeaderText = "客户号";
                        dataGridView1.Columns["client_name"].HeaderText = "客户";
                        dataGridView1.Columns["unit_name"].HeaderText = "单位";


                        dataGridView1.Columns["output_id"].Visible = false;
                        dataGridView1.Columns["product_id"].Visible = false;
                        dataGridView1.Columns["product_name"].Visible = true;
                        dataGridView1.Columns["product_sn"].Visible = true;
                        dataGridView1.Columns["money_id"].Visible = false;
                        dataGridView1.Columns["money_name"].Visible = true;
                        dataGridView1.Columns["price"].Visible = true;
                        dataGridView1.Columns["amount"].Visible = true;
                        dataGridView1.Columns["remark"].Visible = true;
                        dataGridView1.Columns["sman"].Visible = false;
                        dataGridView1.Columns["dept_id"].Visible = false;
                        dataGridView1.Columns["scount"].Visible = true;
                        dataGridView1.Columns["unit_name"].Visible = true;
                        dataGridView1.Columns["sdate"].Visible = false;
                        dataGridView1.Columns["bill_id"].Visible = false;
                        dataGridView1.Columns["client"].Visible = false;
                        dataGridView1.Columns["client_name"].Visible = false;

                        object obj = DT.Compute("sum(amount)", "1=1");


                        l_sum_amount.Text = obj.ToString();

                        c_product_id.Text = "";
                        text_codeID.Text = "";
                        c_product_id.Text = "";
                        text_produce_sn.Text = "";
                        text_scount.Text = "1";
                        text_price.Text = "0";
                        text_remark.Text = "";
                        //  text_codeID.Text = "";


                    }
                    else
                        MessageBox.Show(c_product_id.SelectedText + "的库存数不够,最多能销售" + stroe_scount.ToString(), "系统提示", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
                else
                    MessageBox.Show("请先选择货物！！", "系统提示", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
            catch
            {
                MessageBox.Show("对不起，数据输入错误，请检查！！", "系统提示", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }


        private void button3_Click(object sender, EventArgs e)
        {
            _Save();
        }


        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            get_client_list(backgroundWorker1, e);
        }

        private void backgroundWorker1_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
        }

        private void backgroundWorker1_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            this.progressBar1.Value = e.ProgressPercentage;
        }

        private void backgroundWorker2_DoWork(object sender, DoWorkEventArgs e)
        {
            get_material_list(backgroundWorker2, e);
        }

        private void backgroundWorker2_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            this.progressBar2.Value = e.ProgressPercentage;
        }

        private void backgroundWorker2_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            //
        }

        private void c_product_id_Leave(object sender, EventArgs e)
        {
            if (c_product_id.Text.Length > 0)
            {
                text_price.Text = ws.get_product_price(c_product_id.SelectedValue.ToString(), Int16.Parse(h_user_price.Text)).ToString();
            }
            else
            {
                c_product_id.Focus();
                MessageBox.Show("对不起，请选择货物！！", "系统提示", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
        }

        private void _Amount()
        {
            try
            {
                if (l_output_id.Text.Length > 0)
                {
                    Decimal pay_amount = 0;
                    if (c_client_id.Text.Trim().Length == 0 && Decimal.Parse(l_sum_amount.Text) > Decimal.Parse(text_amount.Text))
                    {
                        MessageBox.Show("对不起,本次销售为[零售],不能欠款!!", "系统提示", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                        return;
                    }
                    else
                    {

                        if (c_client_id.Text.Trim().Length != 0)
                        {
                            if (Decimal.Parse(l_sum_amount.Text) <= Decimal.Parse(text_amount.Text))
                            {
                                pay_amount = Decimal.Parse(l_sum_amount.Text);
                                MessageBox.Show("本次销售应付:" + l_sum_amount.Text + "实付:" + text_amount.Text + ",应找零:" + Convert.ToString(Decimal.Parse(text_amount.Text) - Decimal.Parse(l_sum_amount.Text)), "系统提示", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                            }
                            else
                            {
                                pay_amount = Decimal.Parse(text_amount.Text);
                                MessageBox.Show("本次销售应付:" + l_sum_amount.Text + "实付:" + text_amount.Text + ",欠款为:" + Convert.ToString(Decimal.Parse(l_sum_amount.Text) - Decimal.Parse(text_amount.Text)) + ",到时结清余款!!", "系统提示", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                            }
                        }
                        else
                        {
                            pay_amount = Decimal.Parse(l_sum_amount.Text);
                            MessageBox.Show("本次销售应付:" + l_sum_amount.Text + "实付:" + text_amount.Text + ",应找零:" + Convert.ToString(Decimal.Parse(text_amount.Text) - Decimal.Parse(l_sum_amount.Text)), "系统提示", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                        }

                        foreach (DataRow dr in DT.Rows)
                            ws.insert_product_output(dr["client"].ToString(), dr["bill_id"].ToString(),
                               dr["dept_id"].ToString(), dr["sdate"].ToString(),
                                Int16.Parse(c_seller_id.SelectedValue.ToString()),
                                Int32.Parse(dr["product_id"].ToString()),
                                dr["product_sn"].ToString().Trim(), Convert.ToInt32(dr["scount"].ToString()),
                                Decimal.Parse(dr["price"].ToString()), Int16.Parse(dr["money_id"].ToString()),
                                username.Text, dr["remark"].ToString());

                        if (pay_amount > 0)
                            ws.insert_client_pay_record(ws.insert_client_pay(pay_amount,
                                username.Text, d_date.Text + " " + DateTime.Now.ToString("HH:mm:ss"),
                                h_dept_id.Text, c_client_id.Text.Length > 0 ? c_client_id.SelectedValue.ToString().Trim() : ""),
                                c_client_id.Text.Length > 0 ? c_client_id.SelectedValue.ToString().Trim() : "", "01" + l_output_id.Text.Trim(),
                                h_dept_id.Text, pay_amount);


                        if (SetupThePrinting())
                        {
                            all_count = DT.Rows.Count; //总行数
                            linesPerPage = 5; //每页行数

                            count = 0; //行计数器
                            had_print_count = 0; //已经打印数

                            all_page_count = int.Parse(Math.Ceiling((double)all_count / (double)linesPerPage).ToString()); //总页数

                            try
                            {
                                MyPrintDocument.Print();
                            }
                            catch (Exception ex)
                            {

                                MessageBox.Show(ex.ToString(), "警告", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                            }
                            finally
                            {
                                l_sum_amount.Text = "0";

                                c_product_id.Text = "";
                                text_codeID.Text = "";
                                c_product_id.Text = "";
                                text_produce_sn.Text = "";
                                text_scount.Text = "1";
                                text_price.Text = "0";
                                text_remark.Text = "";


                                DataView view;
                                DT.Rows.Clear();
                                view = new DataView(DT);

                                dataGridView1.DataSource = view;
                            }
                        }
                    }
                }
            }
            catch
            {//SysAdmin   SysAdmin84603955
                MessageBox.Show("对不起，数据输入错误，请检查！！", "系统提示", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }

        }
        private void button1_Click(object sender, EventArgs e)
        {
            _Amount();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if ((DT.Rows.Count > 0) && (MessageBox.Show("确定要取消本次销售吗??", "系统提示", MessageBoxButtons.YesNo, MessageBoxIcon.Warning) == DialogResult.Yes))
                _Cancel();
        }
        private void _Cancel()
        {
            l_sum_amount.Text = "0";

            c_product_id.Text = "";
            text_codeID.Text = "";
            c_product_id.Text = "";
            text_produce_sn.Text = "";
            text_scount.Text = "1";
            text_price.Text = "0";
            text_remark.Text = "";


            DataView view;
            DT.Rows.Clear();
            view = new DataView(DT);

            dataGridView1.DataSource = view;
        }
        private void MyPrintDocument_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            Graphics g = e.Graphics; //获得绘图对象


            float yPosition = 0;   //绘制字符串的纵向位置
            float leftMargin = e.MarginBounds.Left; //左边距
            float topMargin = e.MarginBounds.Top; //上边距


            Font printFont;
             printFont = new Font("宋体", 12, FontStyle.Regular, GraphicsUnit.Point); //当前的打印字体
            SolidBrush myBrush = new SolidBrush(Color.Black);//刷子
           
            g.DrawString(  c_client_id.Text.Length > 0 ? c_client_id.Text : "零售", printFont, myBrush, leftMargin, yPosition, new StringFormat());
            g.DrawString("NO:" + l_output_id.Text, printFont, myBrush, leftMargin + 400, yPosition, new StringFormat());

            yPosition += 24;
            g.DrawString("日期:" + d_date.Text, printFont, myBrush, leftMargin, yPosition, new StringFormat());

            yPosition += 36;

            while ((count < linesPerPage) && (had_print_count<all_count))
            {
                yPosition = topMargin + (count * printFont.GetHeight(g));
                g.DrawString(DT.Rows[had_print_count]["product_name"].ToString(), printFont, myBrush, leftMargin, yPosition, new StringFormat());

                g.DrawString(DT.Rows[had_print_count]["scount"].ToString(), printFont, myBrush, leftMargin + 300, yPosition, new StringFormat());
                g.DrawString(DT.Rows[had_print_count]["unit_name"].ToString(), printFont, myBrush, leftMargin + 350, yPosition, new StringFormat());
                g.DrawString(DT.Rows[had_print_count]["price"].ToString(), printFont, myBrush, leftMargin + 450, yPosition, new StringFormat());
                g.DrawString(DT.Rows[had_print_count]["amount"].ToString(), printFont, myBrush, leftMargin + 550, yPosition, new StringFormat());
                g.DrawString(DT.Rows[had_print_count]["money_name"].ToString(), printFont, myBrush, leftMargin + 650, yPosition, new StringFormat());
                
                count++;
                had_print_count++;
            }
            /* dataGridView1.Columns["product_id"].HeaderText = "编号";
                        dataGridView1.Columns["product_name"].HeaderText = "品名";
                        dataGridView1.Columns["product_sn"].HeaderText = "序列号";
                        dataGridView1.Columns["money_id"].HeaderText = "货币号";
                        dataGridView1.Columns["money_name"].HeaderText = "货币";
                        dataGridView1.Columns["price"].HeaderText = "单价";
                        dataGridView1.Columns["amount"].HeaderText = "金额";
                        dataGridView1.Columns["remark"].HeaderText = "备注";
                        dataGridView1.Columns["sman"].HeaderText = "销售人";
                        dataGridView1.Columns["dept_id"].HeaderText = "部门号";
                        dataGridView1.Columns["scount"].HeaderText = "数量";
                        dataGridView1.Columns["sdate"].HeaderText = "日期";
                        dataGridView1.Columns["bill_id"].HeaderText = "单号";
                        dataGridView1.Columns["client"].HeaderText = "客户号";
                        dataGridView1.Columns["client_name"].HeaderText = "客户";*/

            //如果本页打印完成而line不为空说明还有没完成的页面这将触发下一次的打印事件在下一次的打印中lineReader会
            //自动读取上次没有打印完的内容因为lineReader是这个打印方法外的类的成员它可以记录当前读取的位置
            if (all_page_count > 1)
            {
                all_page_count--;
                count = 0;
                e.HasMorePages = true;
            }
            else
            {
                object obj = DT.Compute("sum(amount)", "1=1");

                g.DrawString(obj.ToString().ToString(), printFont, myBrush, leftMargin + 550, yPosition + 50, new StringFormat());
                g.DrawString("总金额:" + FengFan.money.MoneyLowerToUpper(Decimal.Parse(obj.ToString())) + "(" + obj.ToString() + ")", printFont, myBrush, leftMargin, yPosition + 100, new StringFormat());
                g.DrawString("经手人:" + username.Text, printFont, myBrush, leftMargin, yPosition + 1250, new StringFormat());

                e.HasMorePages = false;
            }

        }


        private bool SetupThePrinting()
        {
            PrintDialog MyPrintDialog = new PrintDialog();
            MyPrintDialog.AllowCurrentPage = false;
            MyPrintDialog.AllowPrintToFile = false;
            MyPrintDialog.AllowSelection = false;
            MyPrintDialog.AllowSomePages = false;
            MyPrintDialog.PrintToFile = false;
            MyPrintDialog.ShowHelp = false;
            MyPrintDialog.ShowNetwork = false;

          //  if (MyPrintDialog.ShowDialog() != DialogResult.OK)
            //    return false;

            MyPrintDocument.DocumentName = "Output_Print";
            MyPrintDocument.PrinterSettings =MyPrintDialog.PrinterSettings;
            MyPrintDocument.DefaultPageSettings = MyPrintDialog.PrinterSettings.DefaultPageSettings;
            MyPrintDocument.DefaultPageSettings.Margins = new System.Drawing.Printing.Margins(40, 40, 40, 40);
           // MyPrintDocument.DefaultPageSettings.PaperSize.Kind  = true;
          //  MyPrintDocument.DefaultPageSettings.PaperSize.Height = 40;
          //  MyPrintDocument.DefaultPageSettings.PaperSize.Width = 40; 
            
            //if (MessageBox.Show("Do you want the report to be centered on the page",
            //"InvoiceManager - Center on Page", MessageBoxButtons.YesNo,
            //MessageBoxIcon.Question) == DialogResult.Yes)
            //    MyDataGridViewPrinter = new DataGridViewPrinter(dataGridView1,
            //    MyPrintDocument, true, true, "Customers", new Font("Tahoma", 18,
            //    FontStyle.Bold, GraphicsUnit.Point), Color.Black, true);
            //else
             //   MyDataGridViewPrinter = new DataGridViewPrinter(dataGridView1,
            //    MyPrintDocument, false, true, "出货单", new Font("宋体", 24,
            //    FontStyle.Bold, GraphicsUnit.Point), Color.Black, true);

            return true;
        }

        private void Form1_Activated(object sender, EventArgs e)
        {
            HotKey.RegisterHotKey(Handle, 1000, HotKey.KeyModifiers.None, Keys.F1);
            HotKey.RegisterHotKey(Handle, 1001, HotKey.KeyModifiers.None, Keys.F2);
            HotKey.RegisterHotKey(Handle, 1002, HotKey.KeyModifiers.None, Keys.F3);
            HotKey.RegisterHotKey(Handle, 1003, HotKey.KeyModifiers.None, Keys.F4);
        }

        private void Form1_Leave(object sender, EventArgs e)
        {
            HotKey.UnregisterHotKey(Handle, 1000);
            HotKey.UnregisterHotKey(Handle, 1001);
            HotKey.UnregisterHotKey(Handle, 1002);
            HotKey.UnregisterHotKey(Handle, 1003);

        }


        protected override void WndProc(ref Message m)
        {
            const int WM_HOTKEY = 0x0312;
            //按快捷键

            switch (m.Msg)
            {
                case WM_HOTKEY:
                    switch (m.WParam.ToInt32())
                    {
                        case 1000:    //按下的是F1
                            _Amount();
                            break;
                        case 1001:    //按下的是F2
                            _Save();
                            break;
                        case 1002:    //按下的是F3   启用条形码与否
                            set_codeID();
                            break;
                        case 1003:    //按下的是F4
                            if (( DT.Rows.Count>0) && (MessageBox.Show("确定要取消本次销售吗??", "系统提示", MessageBoxButtons.YesNo, MessageBoxIcon.Warning) == DialogResult.Yes))
                            _Cancel();
                            break;
                    }
                    break;
            }
            base.WndProc(ref m);
        }

        private void set_codeID()
        {
            if (!text_codeID.Enabled)
            {
                text_codeID.Enabled = true;
                text_codeID.Focus();
            }
            else
            {
                text_codeID.Enabled = false;
            }
        }



    }
}
