﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using System.ComponentModel;

namespace Market
{
    public enum HLineType
    {
        Etched,
        Single
    }

    public class HorizontalLine : Control
    {
        public HorizontalLine()
        {
            SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.FixedHeight |
              ControlStyles.OptimizedDoubleBuffer | ControlStyles.ResizeRedraw |
                ControlStyles.SupportsTransparentBackColor | ControlStyles.UserPaint, true);
            lineType = HLineType.Etched;
        }

        public override System.Drawing.Size GetPreferredSize(Size proposedSize)
        {
            if (proposedSize == Size.Empty)
                return new Size(150, 1);
            return proposedSize;
        }

        private HLineType lineType;
        [DefaultValue(HLineType.Etched)]
        public HLineType LineType
        {
            get
            {
                return lineType;
            }
            set
            {
                if (lineType != value)
                {
                    lineType = value;
                    CreatePen();
                    Invalidate();
                }
            }
        }

        public override Color ForeColor
        {
            get
            {
                return base.ForeColor;
            }
            set
            {
                base.ForeColor = value;
                CreatePen();
            }
        }

        Pen pen;
        void CreatePen()
        {
            if (pen != null)
            {
                pen.Dispose();
                pen = null;
            }

            if (lineType == HLineType.Single)
                pen = new Pen(ForeColor);
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            base.OnPaint(e);
            switch (lineType)
            {
                case HLineType.Etched:
                    ControlPaint.DrawBorder3D(e.Graphics, ClientRectangle,
                      Border3DStyle.Etched, Border3DSide.Top);
                    break;
                case HLineType.Single:
                    if (Width > Height)
                        e.Graphics.DrawLine(pen, 0, 0, Width - 1, 0);
                    else
                        e.Graphics.DrawLine(pen, 0, 0, 0, Height - 1);
                    break;
            }
        }
    }

}


