﻿
using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Globalization;
using System.Windows.Forms;
//using BrawDraw.Com.PhotoFrame.Net.PublicFunctions;
using System.ComponentModel;

namespace Market
{
//这是控件的关键代码
 public class SevenSegmentClock : UserControl
 { 

  DateTime _dateTime;
//默认使用同时绘制日期和时间
  SevenSegmentClockStyle _clockStyle = SevenSegmentClockStyle.DateAndTime;
  Color _clockColor = Color.Black;
//是否绘制阴影（即残影），以摸拟真似的LED时钟
  bool _isDrawShadow = true;

  Timer _timer    = null;
//是否自动更新时间
  bool _isTimerEnable = false;
  Graphics g = null;
  Bitmap m_Bitmap = null;

  public bool IsDrawShadow
  {
   get { return this._isDrawShadow; }
   set 
   {
    this._isDrawShadow = value;
    this.Invalidate(); 
   }
  }

  [Browsable(false)]
  public System.Windows.Forms.Timer Timer
  {
   get { return this._timer; }
   set 
   {
    this._timer = value;
    if(_timer != null)
    {
     _timer.Tick    += new EventHandler(TimerOnTick);
    }
   }
  }

  public bool IsTimerEnable
  {
   get { return this._isTimerEnable; }
   set 
   { 
    if(value == true)
    {
     if(this._timer == null)
     {
      _timer = new Timer();
      _timer.Tick    += new EventHandler(TimerOnTick);
      _timer.Interval = 1000;
      _timer.Enabled  = true;
     }
    }
    else
    {
     if(this._timer != null)
     {
      _timer.Enabled  = false;
     }
    }
    this._isTimerEnable = value;
   }
  }

  public void Start()
  {
   this.IsTimerEnable = true;
   this.Refresh();
  }

  public void Stop()
  {
   this.IsTimerEnable = false;
  }

  public System.DateTime DateTime
  {
   get { return this._dateTime; }
   set { this._dateTime = value; }
  }

//LED文字的颜色
  public System.Drawing.Color ClockColor
  {
   get { return this._clockColor; }
   set 
   { 
    this._clockColor = value;
    this.Invalidate(); 
   }
  }

  public SevenSegmentClockStyle SevenSegmentClockStyle
  {
   get { return this._clockStyle; }
   set 
   {
    this._clockStyle = value; 
    this.Invalidate(); 
   }
  }

  public SevenSegmentClock()
  {
   Text = "Seven-Segment Clock";
//使用双缓冲，支持透明绘制
   SetStyle(ControlStyles.UserPaint | ControlStyles.DoubleBuffer | ControlStyles.AllPaintingInWmPaint
    | ControlStyles.ResizeRedraw | ControlStyles.SupportsTransparentBackColor, true);
   this.UpdateStyles();
   Init();
   _dateTime = DateTime.Now;
  }

//初始化
  private void Init()
  {
   m_Bitmap = new Bitmap(this.Width, this.Height);

   g = Graphics.FromImage(m_Bitmap);
   g.CompositingQuality = CompositingQuality.HighQuality;
   g.TextRenderingHint = System.Drawing.Text.TextRenderingHint.AntiAliasGridFit;
   
   //g.InterpolationMode = InterpolationMode.HighQualityBicubic;
   g.SmoothingMode = SmoothingMode.HighQuality;
   //g.TextRenderingHint = System.Drawing.Text.TextRenderingHint.AntiAliasGridFit;
  }

  void TimerOnTick(object obj, EventArgs ea)
  {
   DateTime dtNow = DateTime.Now;
   dtNow = new DateTime(dtNow.Year, dtNow.Month, dtNow.Day, dtNow.Hour, dtNow.Minute, dtNow.Second);
   if (dtNow != _dateTime)
   {
    _dateTime = dtNow;
    Invalidate();
   }
  }

  protected override void OnPaint(PaintEventArgs e)
  {
   m_Bitmap = DrawClock();
   Graphics gg = e.Graphics;
   gg.CompositingQuality = CompositingQuality.HighQuality;
   gg.DrawImageUnscaled(m_Bitmap, 0, 0);
   //g.Dispose();
  }

  public Bitmap DrawClock()
  {
   return this.DrawClock(this.ClientRectangle);
  }

  private void SevenSegmentClock_Resize(object sender, System.EventArgs e)
  {
   Init();
   this.Refresh();
  }

  private void InitializeComponent()
  {
   // 
   // SevenSegmentClock
   // 
   this.Name = "SevenSegmentClock";
   this.Size = new System.Drawing.Size(448, 64);
   this.Resize += new System.EventHandler(this.SevenSegmentClock_Resize);
  }

  int _clockStringWidth;
  int _clockStringHeight;
  public int ClockStringWidth
  {
   get
   {
    return _clockStringWidth;
   }
  }
  
  public int ClockStringHeight
  {
   get
   {
    return _clockStringHeight;
   }
  }

//绘制时钟
  public Bitmap DrawClock(Rectangle destRect)
  {
   m_Bitmap = new Bitmap(destRect.Width, destRect.Height);
   //m_Bitmap = new Bitmap(destRect.X + this.Width, destRect.Y + this.Height);
   Graphics grfx = Graphics.FromImage(m_Bitmap);
//设置绘图面板的绘制质量等
   grfx.CompositingQuality = CompositingQuality.HighQuality;
   grfx.TextRenderingHint = System.Drawing.Text.TextRenderingHint.AntiAliasGridFit;
   grfx.SmoothingMode = SmoothingMode.HighQuality;

   SevenSegmentDisplay ssd = new SevenSegmentDisplay(grfx);
   ssd.IsDrawShadow = this._isDrawShadow;
   GraphicsState gs = grfx.Save();
   grfx.TranslateTransform(destRect.X, destRect.Y);
   string strTime = string.Empty;
   if(this._clockStyle == SevenSegmentClockStyle.TimeOnly)
   {
    strTime = _dateTime.ToString("T", DateTimeFormatInfo.InvariantInfo);
   }
   else if(this._clockStyle == SevenSegmentClockStyle.DateOnly)
   {
//设置日期格式
    strTime = _dateTime.ToString("yyyy-MM-dd", DateTimeFormatInfo.InvariantInfo);
   }
   else
   {
    strTime = _dateTime.ToString("yyyy-MM-dd", DateTimeFormatInfo.InvariantInfo) + " " + _dateTime.ToString("T", DateTimeFormatInfo.InvariantInfo);
   }

   SizeF  sizef   = ssd.MeasureString(strTime, Font);
   float  fScale  = Math.Min(destRect.Width  / sizef.Width, destRect.Height / sizef.Height);
   Font   font    = new Font(Font.FontFamily, fScale * Font.SizeInPoints);

   sizef = ssd.MeasureString(strTime, font);
   _clockStringWidth = (int)sizef.Width;
   _clockStringHeight = (int)sizef.Height;

   ssd.DrawString(strTime, font, new SolidBrush(this._clockColor), 
    (destRect.Width  - sizef.Width) / 2, 
    (destRect.Height - sizef.Height) / 2);
   grfx.Restore(gs);
   return m_Bitmap;
  }
 }
}

