﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace computer.BaseData
{
    public partial class material_type : System.Web.UI.Page
    {
       // protected Boolean no_child = false;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
               // Page.Title = common.CompanyName() + Page.Title;
                intiTree();

               // material_stype.Value = "-9";

                common.Init_DropDown_Item(D_unit, "select unit_id,sname from unit_list order by  unit_id");
            }
        }
        protected void intiTree()
        {

            mytreeview ws = new mytreeview();
            ws.ShowTv(TreeView1);
            tree_ID.Value = "0";
        }


        protected void TreeView1_SelectedNodeChanged(object sender, EventArgs e)
        {
            TreeNode Selected = this.TreeView1.SelectedNode;

            tree_ID.Value= Selected.Value.ToString();
            if (Selected.Parent != null)
                tree_father_ID.Value = Selected.Parent.Value.ToString();
            else
                tree_father_ID.Value = "0";

            TextBox3.Text = Selected.Text.ToString();

            if (Selected.ChildNodes.Count > 0)
            {
                is_last_dot.Value = "0";
            }
            else
            {
                is_last_dot.Value = "1";
            }
          //  _err_str(Selected.Value.ToString() + Selected.Text.ToString());
            DataClass.BaseData ws = new DataClass.BaseData();
            Label1.Text = ws.Get_material_type_class(Int16.Parse(Selected.Value.ToString())) ;
            GridView1.Caption = ws.Get_material_type_class(Int16.Parse(Selected.Value.ToString())) + "的所有产品：";

            material_stype.Value = tree_ID.Value;
            get_material();
            material_ID.Value = "0";
            txtname.Text = "";
            txtabrv.Text = "";
            txtmodel.Text = "";
            txtremark.Text = "";
            txtexpire_date.Text = "";
            txtcodeid.Text = "";
            IU_Statu.Value = "N";
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            if (Int16.Parse(tree_ID.Value) > 1)
            {
                DataClass.BaseData ws = new DataClass.BaseData();
                ws.Insert_material_type(Int16.Parse(tree_father_ID.Value), txt_context.Text);

                _reset_tree();
                this.FondNode(TreeView1.Nodes, Int16.Parse(tree_father_ID.Value));
            }
            else
                _err_str("请先選擇类别!!!");

        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            if (Int16.Parse(tree_ID.Value) >0)
            {
                DataClass.BaseData ws = new DataClass.BaseData();
                ws.Insert_material_type(Int16.Parse(tree_ID.Value), txt_context.Text);
                _reset_tree();
                this.FondNode(TreeView1.Nodes, Int16.Parse(tree_ID.Value));
            }
            else
                _err_str("请先選擇类别!!!");
        }

        protected void _reset_tree()
        {
            txt_context.Text = "";
            TreeView1.Nodes.Clear();
            intiTree();
        }
        protected void Button3_Click(object sender, EventArgs e)
        {
            if (Int16.Parse(tree_ID.Value) > 1)
            {
                if (is_last_dot.Value == "1")
                {
                    DataClass.BaseData ws = new DataClass.BaseData();
                    ws.Delete_material_type(Int16.Parse(tree_ID.Value));
                    _reset_tree();
                    this.FondNode(TreeView1.Nodes, Int16.Parse(tree_father_ID.Value));
                }
                else
                    _err_str("请先删除子类别!!!");
            }
            else
                _err_str("根不能删除!!!");

        }
        private void FondNode(TreeNodeCollection tnc, int MyCount)
        {
            foreach (TreeNode tn in tnc)
            {
                if (tn.Value == MyCount.ToString())
                {
                    tn.Select();
                    this.ExpandNode(tn);
                    break;
                }
                else
                    this.FondNode(tn.ChildNodes, MyCount);
            }
        }

        //打开节点
        private void ExpandNode(TreeNode tn)
        {
            if (tn.Depth != 0)
            {
                this.ExpandNode(tn.Parent);
                tn.Expand();
            }
            else
                tn.Expand();
        }

        protected void Button6_Click(object sender, EventArgs e)
        {
            DataClass.BaseData ws = new DataClass.BaseData();
            ws.Modify_material_type(Int16.Parse(tree_ID.Value), txt_context.Text);
            _reset_tree();
            this.FondNode(TreeView1.Nodes, Int16.Parse(tree_ID.Value));
        }

        protected void get_material()
        {
            get_material_list(1);
            get_material_Count();
        }

        protected void get_material_list(int CurrentPage)
        {
            try
            {
                DataClass.BaseData ws = new DataClass.BaseData();
                GridView1.DataSource = ws.GetMaterialList(0, Int16.Parse(tree_ID.Value), "", "", "", CurrentPage);
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//８４２８８８０８
        }
        protected void get_material_Count()
        {
            try
            {
                DataClass.BaseData ws = new DataClass.BaseData();
                int[] _ws = (int[])ws.GetMaterialList_Count(0, Int16.Parse(tree_ID.Value), "", "", "");
                AspNetPager1.CurrentPageIndex = 1;
                AspNetPager1.PageSize = _ws[0];//页面尺寸
                AspNetPager1.RecordCount = _ws[1];
                TotalCount.Text = _ws[1].ToString();//总记录数
                PageCount.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
                //get_material();
            }
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                LinkButton addButton1 = (LinkButton)e.Row.FindControl("LinkButton1");
                addButton1.CommandArgument = e.Row.RowIndex.ToString();
                LinkButton addButton4 = (LinkButton)e.Row.FindControl("LinkButton4");
                addButton4.CommandArgument = e.Row.RowIndex.ToString();

                addButton4.Attributes.Add("onclick", "return confirm('确定要删除：" + FengFan.Functions.clear_null(e.Row.Cells[1].Text.Trim()) + " 吗?！');");

            }
        }

        protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Select")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewRow row = GridView1.Rows[index];


                DataClass.BaseData ws = new DataClass.BaseData();
                Model.BaseData.material_list model = new Model.BaseData.material_list();
                model = ws.GetMaterialListModel(Int32.Parse(FengFan.Functions.clear_null( row.Cells[0].Text)));

                material_ID.Value =FengFan.Functions.clear_null(model.material_id.ToString());
                txtcodeid.Text =FengFan.Functions.clear_null(model.CodeId);
                txtname.Text = FengFan.Functions.clear_null(model.sname);
                txtabrv.Text = FengFan.Functions.clear_null(model.abrv);//&nbsp;
                txtmodel.Text = FengFan.Functions.clear_null(model.model);
                D_unit.SelectedIndex = D_unit.Items.IndexOf(D_unit.Items.FindByValue(FengFan.Functions.clear_null(model.Unit_id)));

             txtexpire_date.Text = FengFan.Functions.clear_null(model.expire_date);
             txtsafe_store_down.Text = FengFan.Functions.clear_null(model.safe_store_down.ToString());
                txtremark.Text = FengFan.Functions.clear_null(model.remark);
                material_stype.Value= FengFan.Functions.clear_null(model.stype.ToString());
                IU_Statu.Value = "M";
            }
        }

        protected void Button5_Click(object sender, EventArgs e)
        {
            if (tree_ID.Value != "-9")
            {
                DataClass.BaseData ws = new DataClass.BaseData();
                Model.BaseData.material_list model = new Model.BaseData.material_list();
                model.material_id = Int32.Parse(material_ID.Value);
                model.sname = txtname.Text.Trim();
                if (txtabrv.Text.Trim().Length > 0)
                    model.abrv = txtabrv.Text.Trim();
                else
                    model.abrv = FengFan.PY.getSpells(txtname.Text);
                model.model = txtmodel.Text.Trim();
                model.remark = txtremark.Text.Trim();
                model.expire_date = txtexpire_date.Text;

                model.Unit_id = D_unit.SelectedItem.Value;


                model.safe_store_down = Int32.Parse(txtsafe_store_down.Text);
                model.CodeId = txtcodeid.Text.Trim();
                model.stype = Int32.Parse(material_stype.Value); //Int16.Parse(tree_ID.Value);


                if (!DataClass.BaseData.repeat_codeID(txtcodeid.Text.Trim(), IU_Statu.Value, material_ID.Value))
                {
                    if (IU_Statu.Value == "N")
                    {
                        try
                        {
                            ws.AddMaterialList(model);
                        }
                        catch (Exception ex)
                        {
                            common.Uerr_str(UpdatePanel1, "对不起，货物品名不能重复！！");
                        }
                        finally
                        {
                            get_material();
                            material_ID.Value = "0";
                            txtsafe_store_down.Text = "0";
                            txtname.Text = "";
                            txtabrv.Text = "";
                            txtmodel.Text = "";
                            txtremark.Text = "";
                            txtexpire_date.Text = "";
                            txtcodeid.Text = "";
                            IU_Statu.Value = "N";
                        }
                    }
                    if (IU_Statu.Value == "M")
                    {
                        try
                        {
                            ws.UpdateMaterialList(model);
                        }
                        catch (Exception ex)
                        {
                            common.Uerr_str(UpdatePanel1, "对不起，货物品名不能重复！！");
                        }
                        finally
                        {
                            get_material();
                            material_ID.Value = "0";
                            txtsafe_store_down.Text = "0";
                            txtname.Text = "";
                            txtabrv.Text = "";
                            txtmodel.Text = "";
                            txtremark.Text = "";
                            txtexpire_date.Text = "";
                            txtcodeid.Text = "";
                            IU_Statu.Value = "N";
                        }
                    }


                }
                else
                    _err_str("对不起，货物条码可以为空，但不能重复！！");
            }
            else
                _err_str("对不起，请先选择类别！！");
        }

        protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {

            GridViewRow row = GridView1.Rows[e.RowIndex];
            try
            {
                DataClass.BaseData ws = new DataClass.BaseData();
                if(ws.DeleteMaterialList(Int32.Parse((FengFan.Functions.clear_null(row.Cells[0].Text.Trim()))))==1)
                    common.Uerr_str(UpdatePanel1, row.Cells[2].Text.Trim()+"删除成功!!!");
                else

                   _err_str("不能删除"+row.Cells[2].Text.Trim() + ",系统存在它的进出数据!!!");
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.Message.Replace("\r\n", "").Replace("'", "\""));
            }
            finally
            {
                get_material();
            }
        }

        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            get_material_list(AspNetPager1.CurrentPageIndex);
        }

        protected void Button4_Click(object sender, EventArgs e)
        {
            material_ID.Value = "0";
            txtsafe_store_down.Text = "0";
            txtname.Text = "";
            txtabrv.Text = "";
            txtmodel.Text = "";
            txtremark.Text = "";
            txtexpire_date.Text = "";
            txtcodeid.Text = "";
            IU_Statu.Value = "N";
        }

        protected void Button7_Click(object sender, EventArgs e)
        {

            DataTable dt = get_print_data().Tables[0];

          dt.Columns.Remove("insert_datetime");
            dt.Columns.Remove("remark");
            dt.Columns.Remove("is_qc");
            dt.Columns.Remove("stype");
            dt.Columns.Remove("safe_store_up");
           dt.Columns.Remove("unit_id");


            dt.Columns["material_id"].ColumnName = "编号";
            dt.Columns["sname"].ColumnName = "名称";
            dt.Columns["safe_store_down"].ColumnName = "安全库存";
            dt.Columns["abrv"].ColumnName = "简称";
            dt.Columns["model"].ColumnName = "规格";
            dt.Columns["codeID"].ColumnName = "条形码";
            dt.Columns["expire_date"].ColumnName = "保修期";
            dt.Columns["unit_name"].ColumnName = "单位";

            GridView2.Visible = true;
            GridView2.DataSource = dt;
            GridView2.DataBind();
            GridView2.Caption = DateTime.Now.ToString("yyyy-MM-dd") + "：全部库存数";


      common ws = new common();
             
         ws.ConvertGridViewToExcel(GridView2);

            //  Response.End();
       //   GridView2.Visible = false;
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            // Confirms that an HtmlForm control is rendered for
        }
        protected DataSet get_print_data()
        {
            DataClass.BaseData ws = new DataClass.BaseData();
            return ws.GetMaterialListEXCEL(0, Int16.Parse(tree_ID.Value), "", "", "");
        }


        protected void _err_str(string mess_str)
        {
            common.Uerr_str(UpdatePanel1,  mess_str );
        }
    }
}