﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

namespace computer.controls
{
    public partial class month_store : System.Web.UI.UserControl
    {
        private string _sdate = "";
        public string Sdate
        {
            set
            {
                _sdate = value;
            }
            get
            {
                return _sdate;
            }
        }
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                common.Init_DropDown_for_Dept(DropDownList_dept_id);
            }
        }


        public void get_data()
        {
            H_date.Value = _sdate;
            get_month_store_list(1);
            get_Count();
        }
        protected void get_month_store_list(int CurrentPage)
        {
            try
            {
                DataClass.store_month ws = new DataClass.store_month();
                GridView2.DataSource = ws.Get_month_storeList(DropDownList_dept_id.SelectedItem.Value, H_date.Value, "0", txt_product_id.Text.Trim(), TextBox_product_name.Text.Trim(),CheckBox1.Checked?"1":"0", CurrentPage);
                GridView2.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//
        }
        protected void get_Count()
        {
            try
            {
                DataClass.store_month ws = new DataClass.store_month();
                int[] _ws = (int[])ws.Get_month_storeList_Count(DropDownList_dept_id.SelectedItem.Value, H_date.Value, "0", txt_product_id.Text.Trim(), TextBox_product_name.Text.Trim(), CheckBox1.Checked ? "1" : "0");
                AspNetPager1.CurrentPageIndex = 1;
                AspNetPager1.PageSize = _ws[0];//页面尺寸
                AspNetPager1.RecordCount = _ws[1];
                TotalCount.Text = _ws[1].ToString();//总记录数
                PageCount.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//
        }
        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            get_month_store_list(AspNetPager1.CurrentPageIndex);

        }

        protected void Button4_Click(object sender, EventArgs e)
        {
            DataTable dt = get_print_data().Tables[0];
            dt.Columns.Remove("门市号");
            GridView3.Visible = true;
            GridView3.DataSource = dt;
            GridView3.DataBind();
            GridView3.Caption = H_date.Value + "盘点库存数";

            common.ToExcel(GridView3, "month");

            Response.End();
            GridView3.Visible = false;
        }
        protected DataSet get_print_data()
        {
            DataClass.store_month ws = new DataClass.store_month();
            return ws.Get_month_storeList_excel(DropDownList_dept_id.SelectedItem.Value, H_date.Value, "0", txt_product_id.Text.Trim(), TextBox_product_name.Text.Trim(), CheckBox1.Checked ? "1" : "0");
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            get_month_store_list(1);
            get_Count();
        }

        protected void Button1_Click(object sender, EventArgs e)
        {

        }

        protected void Button3_Click(object sender, EventArgs e)
        {

        }

        protected void GridView2_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                LinkButton addButton1 = (LinkButton)e.Row.FindControl("LinkButton1");
                addButton1.CommandArgument = e.Row.RowIndex.ToString();
            }
            if (e.Row.RowType == DataControlRowType.Footer)
            {
                DataClass.store_month ws = new DataClass.store_month();
                decimal[] _ws = (decimal[])ws.Get_month_storeList_sum(DropDownList_dept_id.SelectedItem.Value, H_date.Value, "0", txt_product_id.Text.Trim(), TextBox_product_name.Text.Trim(), CheckBox1.Checked ? "1" : "0");

                e.Row.Cells[3].Text = _ws[0].ToString();
                e.Row.Cells[4].Text = _ws[1].ToString();
                e.Row.Cells[5].Text = _ws[2].ToString();
                e.Row.Cells[6].Text = _ws[3].ToString();
                e.Row.Cells[7].Text = _ws[4].ToString();
                e.Row.Cells[8].Text = _ws[5].ToString();
                e.Row.Cells[9].Text = _ws[6].ToString();
                e.Row.Cells[10].Text = _ws[7].ToString();
                e.Row.Cells[11].Text = _ws[8].ToString();
                e.Row.Cells[12].Text = _ws[9].ToString();
                e.Row.Cells[13].Text = _ws[10].ToString();
                e.Row.Cells[14].Text = _ws[11].ToString();
                e.Row.Cells[15].Text = _ws[12].ToString();
                e.Row.Cells[16].Text = _ws[13].ToString();


                e.Row.Cells[17].Text = _ws[14].ToString();
                e.Row.Cells[18].Text = _ws[15].ToString();

                e.Row.Cells[22].Text = _ws[16].ToString();
                e.Row.Cells[23].Text = _ws[17].ToString();
            }
        }

        protected void GridView2_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Adjust")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewRow row = GridView2.Rows[index];
                
                TextBox tx1=(TextBox)row.FindControl("TextBox1");


            int i = row.Cells.Count - 1;
                DataClass.store_month ws = new DataClass.store_month();
                ws.adjust_month_store(H_date.Value,row.Cells[i].Text,Int32.Parse(row.Cells[1].Text),Int32.Parse(tx1.Text),Session["User_Name"].ToString());
                get_month_store_list(AspNetPager1.CurrentPageIndex);
            }
        }

        protected void GridView2_RowCreated(object sender, GridViewRowEventArgs e)
        {
            int i = e.Row.Cells.Count - 1;
            e.Row.Cells[i].Visible = false;
        }
    }
}