﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace computer.controls
{
    public partial class product_query : System.Web.UI.UserControl
    {
        public event EventHandler SelectEvent;
        public event EventHandler CancelEvent;

        protected string product_id = "";
        protected string product_name = "";

        public String get_product_name
        {
            get
            {
                return product_name;//
            }
        }

        protected string product_codeid = "";

        public String get_product_codeid
        {
            get
            {
                return product_codeid;//
            }
        }


        public String get_product_id
        {
            get
            {
                return product_id;
            }
        }
        protected void Page_Load(object sender, EventArgs e)
        {

            if (!Page.IsPostBack)
            {
                tree_ID.Value = "0";
                mytreeview ws=new mytreeview();
                ws.ShowTv(TreeView1);
            }
        }
        

        protected void TreeView1_SelectedNodeChanged(object sender, EventArgs e)
        {
            TreeNode Selected = this.TreeView1.SelectedNode;
            tree_ID.Value = Selected.Value.ToString();

            get_material();
        }

        public void get_material()
        {
            get_product_list(1);
            get_product_Count();
        }

        protected void get_product_list(int CurrentPage)
        {
            try
            {
                DataClass.BaseData ws = new DataClass.BaseData();
                GridView1.DataSource = ws.GetMaterialList(0, Int32.Parse(tree_ID.Value), TextBox1.Text, TextBox4.Text, TextBox2.Text, TextBox3.Text, CurrentPage);
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
                //common.Uerr_str((UpdatePanel)Page.FindControl("UpdatePanel1"), ex.ToString());
            }
            finally
            {
            }//８４２８８８０８
        }
        protected void get_product_Count()
        {
            try
            {
                DataClass.BaseData ws = new DataClass.BaseData();
                int[] _ws = (int[])ws.GetMaterialList_Count(0, Int32.Parse(tree_ID.Value), TextBox1.Text, TextBox4.Text, TextBox2.Text, TextBox3.Text);
                AspNetPager1.CurrentPageIndex = 1;
                AspNetPager1.PageSize = _ws[0];//页面尺寸
                AspNetPager1.RecordCount = _ws[1];
                TotalCount.Text = _ws[1].ToString();//总记录数
                PageCount.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
                //common.Uerr_str((UpdatePanel)Page.FindControl("UpdatePanel1"), ex.ToString());
            }
            finally
            {
                //get_material();
            }
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                LinkButton addButton1 = (LinkButton)e.Row.FindControl("LinkButton1");
                addButton1.CommandArgument = e.Row.RowIndex.ToString();

            }
        }

        protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Select")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewRow row = GridView1.Rows[index];
                product_id = FengFan.Functions.clear_null(row.Cells[0].Text.Trim());
                product_name= FengFan.Functions.clear_null(row.Cells[2].Text.Trim());
                product_codeid = FengFan.Functions.clear_null(row.Cells[1].Text.Trim());
                if (SelectEvent != null)
                {
                    SelectEvent(sender, new EventArgs());

                }
            }
        }
        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            get_product_list(AspNetPager1.CurrentPageIndex);
        }

        protected void Button2_Click(object sender, EventArgs e)
        {

            if (CancelEvent != null)
            {
                CancelEvent(sender, new EventArgs());
            }
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            get_product_list(1);
        }
    }
}