﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace computer.controls
{
    public partial class stock_remark : System.Web.UI.UserControl
    {
       protected Double _amount = 0;
        public event EventHandler CloseEvent;

        private string _stock_id = "";

        private string _client_name = "";
        private string _stock_amount = "";
        private int _money_id =0;


        private string _dept_id = "";
        public string Dept_Id
        {
            set
            {
                _dept_id = value;
            }
            get
            {
                return _dept_id;
            }
        }



        public string Stock_Id
          {
            set
            {
                _stock_id = value;
            }
            get
            {
                return _stock_id;
            }
        }
        public String Stock_amount
        {
            set
            {
                _stock_amount = value;
            }
            get
            {
                return _stock_amount;
            }
        } 
        public String Client_Name
        {
            set
            {
                _client_name = value;
            }
            get
            {
                return _client_name;
            }
        }

        public int Money_ID
        {
            set
            {
                _money_id = value;
            }
            get
            {
                return _money_id;
            }
        }

        protected void Page_Load(object sender, EventArgs e)
        {
           
        }
        public void get_data()
        {
            _amount = 0;
            common.Init_DropDown_Item(Drop_money_id, "SELECT     money_id, momey_unit_name FROM         momey_unit_list order by money_id");
            Drop_money_id.SelectedIndex = _money_id;
            txt_sum_scount.Text = _stock_amount;

            Label_stock_id.Text = _stock_id;
            Label_client_name.Text = _client_name;
            HiddenField_dept_id.Value = _dept_id;
            get_stock_remark();
            Button2.Enabled = true;
            HiddenField_state.Value = "New";
            Product_query1.Visible = false;
        }
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            Product_query1.SelectEvent += new EventHandler(get_product_id);
            Product_query1.CancelEvent += new EventHandler(cancel_product_select);
        }
        private void cancel_product_select(object sender, EventArgs e)
        {
            Product_query1.Visible = false;
        }
        private void get_product_id(object sender, EventArgs e)
        {
            txt_product_id.Text = Product_query1.get_product_id;


          //  DataClass.product_price ws = new DataClass.product_price();
          //  Model.BaseData.product_price model = new Model.BaseData.product_price();

          //  model = ws.GetModel(Int32.Parse(txt_product_id.Text));


          //  txt_price.Text = model.price3.ToString();

            product_name.Text = Product_query1.get_product_name;
            Product_query1.Visible = false;
        }
        private void _null()
        {
            txt_product_id.Text = "";
            product_name.Text = "";
            txt_scount.Text = "1";
            txt_price.Text = "0";
            HiddenField_state.Value = "New";
            yj_date.Text = DateTime.Now.ToString("yyyy-MM-dd");
            Button2.Enabled = true;
        }
        protected void Button1_Click(object sender, EventArgs e)
        {
            if (!DataClass.stock_list.exists_input(Stock_Id))
            {
            if (txt_product_id.Text.Trim().Length > 0)
            {
                DataClass.stock_remark ws = new DataClass.stock_remark();
                Model.BaseData.stock_remark model = new Model.BaseData.stock_remark();

                model.dept_id = HiddenField_dept_id.Value;
                model.stock_id = Label_stock_id.Text;
                model.product_id = Int32.Parse(txt_product_id.Text);
                model.scount = Int32.Parse(txt_scount.Text.Trim());
                model.price = Decimal.Parse(txt_price.Text.Trim());
                model.Money_ID = Int16.Parse(Drop_money_id.SelectedItem.Value);
                model.remark = txt_remark.Text.Trim();
                model.yj_date = yj_date.Text;
                if (HiddenField_state.Value == "New")
                    try
                    {
                        ws.Add(model);
                        get_stock_remark_list(AspNetPager1.CurrentPageIndex);
                    }
                    catch
                    {
                        common.Uerr_str(UpdatePanel1, "该订单存在这个产品,不能增加,请修改数量！！");
                    }
                else
                    try
                    {
                        ws.Update(model);
                        get_stock_remark_list(AspNetPager1.CurrentPageIndex);

                    }
                    catch
                    {
                        common.Uerr_str(UpdatePanel1, "该订单存在这个产品,不能增加,请修改数量！！");
                    }
                _null();
            }
            else
            common.Uerr_str(UpdatePanel1, "请先选择产品！！");
            }

            else
                common.Uerr_str(UpdatePanel1, "该采购单已经入库或已经部分入库，如确需修改，请先删除此采购单对应的入库！！");

        }
        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            get_stock_remark_list(AspNetPager1.CurrentPageIndex);
        }

        protected void get_stock_remark()
        {
            get_stock_remark_list(1);
            get_stock_remark_Count();
        }

        protected void get_stock_remark_list(int CurrentPage)
        {
            try
            {
                DataClass.stock_remark ws = new DataClass.stock_remark();
                GridView1.DataSource = ws.GetStockRemarkList(Label_stock_id.Text, HiddenField_dept_id.Value, CurrentPage);
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
               // common.Uerr_str((UpdatePanel)Page.FindControl("UpdatePanel1"), ex.ToString());
            }
            finally
            {
            }//８４２８８８０８
        }
        protected void get_stock_remark_Count()
        {
            try
            {
                DataClass.stock_remark ws = new DataClass.stock_remark();
                int[] _ws = (int[])ws.GetStockRemarkList_Count(Label_stock_id.Text, HiddenField_dept_id.Value);
                AspNetPager1.CurrentPageIndex = 1;
                AspNetPager1.PageSize = _ws[0];//页面尺寸
                AspNetPager1.RecordCount = _ws[1];
                TotalCount.Text = _ws[1].ToString();//总记录数
                PageCount.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
               // common.Uerr_str((UpdatePanel)Page.FindControl("UpdatePanel1"), ex.ToString());
            }
            finally
            {
                //get_material();
            }
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
          //  
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                _amount += Double.Parse(e.Row.Cells[6].Text);
                LinkButton addButton1 = (LinkButton)e.Row.FindControl("LinkButton1");
                addButton1.CommandArgument = e.Row.RowIndex.ToString();

                LinkButton addButton2 = (LinkButton)e.Row.FindControl("LinkButton2");
                addButton2.CommandArgument = e.Row.RowIndex.ToString();
                addButton2.Attributes.Add("onclick", "return confirm('确定要删除配件:" + e.Row.Cells[2].Text + "吗??');");

            }
            if (e.Row.RowType == DataControlRowType.Footer)
            {
                e.Row.Cells[6].Text = Convert.ToString(_amount * Int32.Parse(txt_sum_scount.Text));
            }
        }

        protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            Int16 index = Convert.ToInt16(e.CommandArgument);
            GridViewRow row = GridView1.Rows[index];
            Int32 product_id = Int32.Parse(FengFan.Functions.clear_null(row.Cells[1].Text.Trim()));
            string dd_id = FengFan.Functions.clear_null(Label_stock_id.Text);
            DataClass.stock_remark ws = new DataClass.stock_remark();
            if (e.CommandName == "_Select")
            {
                if (!DataClass.stock_list.exists_input(dd_id))
                {
                    Model.BaseData.stock_remark model = new Model.BaseData.stock_remark();
                    model = ws.GetModel(dd_id, HiddenField_dept_id.Value, product_id);
                    product_name.Text = FengFan.Functions.clear_null(row.Cells[2].Text.Trim());
                    txt_product_id.Text = model.product_id.ToString();
                    txt_scount.Text = model.scount.ToString();
                    txt_price.Text = model.price.ToString();
                    txt_remark.Text = model.remark.ToString();
                    yj_date.Text = model.yj_date;
                    Drop_money_id.SelectedIndex = Drop_money_id.Items.IndexOf(Drop_money_id.Items.FindByValue(FengFan.Functions.clear_null(model.Money_ID.ToString())));
                    HiddenField_state.Value = "Modify";
                    Button2.Enabled = false;
                }

                else
                    common.Uerr_str(UpdatePanel1, "该采购单已经入库或已经部分入库，如确需修改，请先删除此采购单对应的入库！！");
                  //  common._err_str("该采购单已经入库或已经部分入库，如确需修改，请先删除此采购单对应的入库！！",this.Page);
            }

            if (e.CommandName == "_Delete")
            {
                if (!DataClass.stock_list.exists_input(dd_id))
                {
                    ws.Delete(dd_id, HiddenField_dept_id.Value, product_id);
                    get_stock_remark_list(AspNetPager1.CurrentPageIndex);
                }

                else
                    common.Uerr_str(UpdatePanel1, "该采购单已经入库或已经部分入库，如确需修改，请先删除此采购单对应的入库！！");
                 //   common._err_str("该采购单已经入库或已经部分入库，如确需修改，请先删除此采购单对应的入库！！",this.Page);
            }
        }
        protected void Button3_Click(object sender, EventArgs e)
        {
            DataClass.stock_remark ws=new DataClass.stock_remark();
            ws.stock_amount(Label_stock_id.Text, HiddenField_dept_id.Value, Int32.Parse(txt_sum_scount.Text.Trim()));
            if (CloseEvent != null)
            {
                CloseEvent(sender, new EventArgs());
            }
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            Product_query1.get_material();
            Product_query1.Visible = true;
        }

        protected void GridView1_RowCommand1(object sender, GridViewCommandEventArgs e)
        {

        }

    }
}