﻿using System;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace computer.financial
{
    public partial class bank_list : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
               // Page.Title = common.CompanyName() + Page.Title;
                get_bank_list();
            }
        }
        protected void get_bank_list()
        {
            try
            {
                DataClass.bank_list ws = new DataClass.bank_list();
                this.GridView1.DataSource = ws.GetList();
                this.GridView1.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }
        }
        protected void Button1_Click(object sender, EventArgs e)
        {
            _null();
        }
        protected void _null()
        {
            Hbankid.Value = "0";
            Txt_bank_name.Text = "";
            Txt_bank_code.Text = "";
            Txt_first_amount.Text = "0";

            TextBox_Remark.Text = "";

            Button1.Text = "新增";
            HiddenField1.Value = "I";
        }
        protected void Button2_Click(object sender, EventArgs e)
        {
            if (Txt_bank_name.Text.Trim() != string.Empty)
                try
                {
                    DataClass.bank_list ws = new DataClass.bank_list();
                    Model.bank_list model = new Model.bank_list();
                    model.bank_code = Txt_bank_code.Text;
                    model.bank_name = Txt_bank_name.Text;
                    model.first_amount =Decimal.Parse(Txt_first_amount.Text);
                    model.remark = TextBox_Remark.Text;
                    model.bank_id = Int16.Parse(Hbankid.Value);
                    model.this_amount = 0;
                    ws.Add(model,HiddenField1.Value);
                }
                catch (Exception ex)
                {
                    common.Uerr_str(UpdatePanel1, ex.Message.Replace("\r\n", "").Replace("'", "\""));
                }
                finally
                {
                    get_bank_list();
                    _null();
                }

        }
        protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Select")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewRow row = GridView1.Rows[index];
                Hbankid.Value = FengFan.Functions.clear_null(row.Cells[0].Text.Trim());
                Txt_bank_name.Text = FengFan.Functions.clear_null(row.Cells[1].Text.Trim());
                Txt_bank_code.Text = FengFan.Functions.clear_null(row.Cells[2].Text.Trim());
                Txt_first_amount.Text = FengFan.Functions.clear_null(row.Cells[3].Text.Trim());
                TextBox_Remark.Text = FengFan.Functions.clear_null(row.Cells[5].Text.Trim());

                Button1.Text = "取消";
                HiddenField1.Value = "U";
            }

        }
        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                LinkButton addButton3 = (LinkButton)e.Row.FindControl("LinkButton3");
                LinkButton addButton4 = (LinkButton)e.Row.FindControl("LinkButton4");
                addButton3.CommandArgument = e.Row.RowIndex.ToString();
                addButton4.CommandArgument = e.Row.RowIndex.ToString();

                addButton4.Attributes.Add("onclick", "return confirm('确定要删除银行：" + FengFan.Functions.clear_null(e.Row.Cells[1].Text.Trim()) + " 吗?');");

            }

        }
        protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            GridViewRow row = GridView1.Rows[e.RowIndex];
            try
            {
                DataClass.bank_list ws = new DataClass.bank_list();
                ws.Delete(Int16.Parse(FengFan.Functions.clear_null(row.Cells[0].Text.Trim())));
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.Message.Replace("\r\n", "").Replace("'", "\""));
            }
            finally
            {
                get_bank_list();
            }
        }

    }

}