﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace computer.financial
{
    public partial class provide_bill : System.Web.UI.Page
    {
       // protected contorls.half_product_query Half_product_query2;

        protected double a1 = 0;
        protected double a2 = 0;
        protected double a3= 0;

        protected double b1 = 0;
        protected double b2 = 0;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
               // Page.Title = common.CompanyName() + Page.Title;
                common.Init_DropDown_Item(Q_provide_type_id, "SELECT     provide_type_id, provide_type_name FROM         provide_type ORDER BY provide_type_id ");
                get_data();
            }

        }

        public void get_data()
        {
            get_provide_sum_payable(1);
            get_provide_sum_payable_Count();
        }
        protected void get_provide_sum_payable(int CurrentPage)
        {
            try
            {
                DataClass.Provide_Pay ws = new DataClass.Provide_Pay();
                GridView1.DataSource = ws.Get_Provide_sum_payable_List(TextBox1.Text.Trim(), Int16.Parse(Q_pay_state.SelectedItem.Value), Int16.Parse(Q_provide_type_id.SelectedItem.Value), CurrentPage);
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//８４２８８８０８
        }
        protected void get_provide_sum_payable_Count()
        {
            try
            {
                DataClass.Provide_Pay ws = new DataClass.Provide_Pay();
                int[] _ws = (int[])ws.Get_Provide_sum_payable_Count(TextBox1.Text.Trim(), Int16.Parse(Q_pay_state.SelectedItem.Value), Int16.Parse(Q_provide_type_id.SelectedItem.Value));
                AspNetPager1.CurrentPageIndex = 1;
                AspNetPager1.PageSize = _ws[0];//页面尺寸
                AspNetPager1.RecordCount = _ws[1];
                TotalCount.Text = _ws[1].ToString();//总记录数
                PageCount.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }
        }
        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            get_provide_sum_payable(AspNetPager1.CurrentPageIndex);
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            get_data();
        }

        protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewRow row = GridView1.Rows[index];
            if (e.CommandName == "_Remark")
            {
                Label1.Text = row.Cells[0].Text;
                Label2.Text = row.Cells[2].Text;

                get_bill_data(Label1.Text);

            }
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                LinkButton addButton1 = (LinkButton)e.Row.FindControl("LinkButton1");
                addButton1.CommandArgument = e.Row.RowIndex.ToString();
                LinkButton addButton2 = (LinkButton)e.Row.FindControl("LinkButton2");
                addButton2.CommandArgument = e.Row.RowIndex.ToString();
            }
            if (e.Row.RowType == DataControlRowType.Footer)
            {
                DataClass.Provide_Pay ws = new DataClass.Provide_Pay();
                decimal[] _ws = (decimal[])ws.Get_Provide_sum_amount(TextBox1.Text.Trim(), Int16.Parse(Q_pay_state.SelectedItem.Value), Int16.Parse(Q_provide_type_id.SelectedItem.Value));

                e.Row.Cells[5].Text = "总计：";

                e.Row.Cells[6].Text = _ws[0].ToString();
            }
        }


        public void get_bill_data(string provide_id)
        {

            get_provide_pay_bill(provide_id, 1);
            get_provide_pay_bill_Count(provide_id);

            get_sum_amount(provide_id);
        }
        protected void get_sum_amount(string provide_id)
        {
            try
            {
                DataClass.Provide_Pay ws = new DataClass.Provide_Pay();
                decimal[] _ws = (decimal[])ws.Get_provide_pay_sum(provide_id, date_from.Text, date_to.Text);
                L_sum.Text = _ws[0].ToString();//总页数
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//
        }
        protected void get_provide_pay_bill(string provide_id, int CurrentPage)
        {
            try
            {
                DataClass.Provide_Pay ws = new DataClass.Provide_Pay();
                GridView2.DataSource = ws.Get_provide_pay_bill(provide_id,date_from.Text,date_to.Text, CurrentPage);
                GridView2.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//８４２８８８０８
        }
        protected void get_provide_pay_bill_Count(string provide_id)
        {
            try
            {
                DataClass.Provide_Pay ws = new DataClass.Provide_Pay();
                int[] _ws = (int[])ws.Get_provide_pay_bill_Count(provide_id, date_from.Text, date_to.Text);
                AspNetPager2.CurrentPageIndex = 1;
                AspNetPager2.PageSize = _ws[0];//页面尺寸
                AspNetPager2.RecordCount = _ws[1];
                TotalCount2.Text = _ws[1].ToString();//总记录数
                PageCount2.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }
        }
        protected void AspNetPager2_PageChanged(object sender, EventArgs e)
        {
            get_provide_pay_bill(Label1.Text, AspNetPager2.CurrentPageIndex);
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            // Confirms that an HtmlForm control is rendered for
        }
        protected void Button2_Click(object sender, EventArgs e)
        {
            DataClass.Provide_Pay ws = new DataClass.Provide_Pay();

          //  FengFan.ExcelEdit ExcelEdit1 = new FengFan.ExcelEdit();

            DataTable dt = ws.Get_provide_pay_bill_excel(Label1.Text, date_from.Text, date_to.Text).Tables[0];


            dt.Columns.Remove("provide_id");
            dt.Columns.Remove("product_id");
            dt.Columns.Remove("dd_type_id");
            dt.Columns.Remove("orderid");

            dt.Columns["dd_type"].ColumnName = "类型";
            dt.Columns["sdate"].ColumnName = "日期";
            dt.Columns["product_name"].ColumnName = "品名";
            dt.Columns["scount"].ColumnName = "数量";
            dt.Columns["price"].ColumnName = "价格";
            dt.Columns["amount"].ColumnName = "金额";


            GridView3.Visible = true;
            GridView3.DataSource = dt;
            GridView3.DataBind();
            GridView3.Caption = "截止至 "+ DateTime.Now.ToString("yyyy-MM-dd") + "：供应商对账单";


            common wss = new common();

            wss.ConvertGridViewToExcel(GridView3);

          //  ExcelEdit1.ExportToExcel(dt, Server.MapPath("provide_pay.xls"), Label2.Text + "当月对账单，截止日期：" + DateTime.Now.ToString("yyyy-MM-dd"), this.Page);
        }

        protected void Button9_Click(object sender, EventArgs e)
        {
            DataClass.Provide_Pay ws = new DataClass.Provide_Pay();

            //  FengFan.ExcelEdit ExcelEdit1 = new FengFan.ExcelEdit();

            DataTable dt = ws.Get_provide_sum_payable_Excel(TextBox1.Text.Trim(), Int16.Parse(Q_pay_state.SelectedItem.Value), Int16.Parse(Q_provide_type_id.SelectedItem.Value)).Tables[0];


            //dt.Columns.Remove("provide_id");
            //dt.Columns.Remove("product_id");
            //dt.Columns.Remove("dd_type_id");
            //dt.Columns.Remove("orderid");

            //dt.Columns["dd_type"].ColumnName = "类型";
            //dt.Columns["sdate"].ColumnName = "日期";
            //dt.Columns["product_name"].ColumnName = "品名";
            //dt.Columns["scount"].ColumnName = "数量";
            //dt.Columns["price"].ColumnName = "价格";
            //dt.Columns["amount"].ColumnName = "金额";


            GridView3.Visible = true;
            GridView3.DataSource = dt;
            GridView3.DataBind();
            GridView3.Caption = "截止至 " + DateTime.Now.ToString("yyyy-MM-dd") + "：供应商对账单";


            common wss = new common();

            wss.ConvertGridViewToExcel(GridView3);

        }

    }
}
