﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

namespace computer.financial
{
    public partial class sell_analyse : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
               // Page.Title = common.CompanyName() + Page.Title;
                int year = DateTime.Now.AddMonths(-1).Year;
                int month = DateTime.Now.AddMonths(-1).Month;

                DateTime firstDayOfThisMonth = new DateTime(year, month, 1);
                DateTime lastDayOfThisMonth = new DateTime(year, month, DateTime.DaysInMonth(year, month));

                Q_xd_date_from.Text = firstDayOfThisMonth.ToString("yyyy-MM-dd");
                Q_xd_date_to.Text = lastDayOfThisMonth.ToString("yyyy-MM-dd");
                get_data(DropDownList1.SelectedItem.Value, Q_xd_date_from.Text, Q_xd_date_to.Text);
            }
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            get_data(DropDownList1.SelectedItem.Value, Q_xd_date_from.Text, Q_xd_date_to.Text);
        }

        protected void get_data(string stype, string from_date, string to_date)
        {
            DataClass.sell_profit ws = new DataClass.sell_profit();
            GridView1.DataSource=ws.Get_analyse_data( stype, from_date, to_date);            
            GridView1.Caption = "从日期：" + Q_xd_date_from.Text + "  到日期：" + Q_xd_date_to.Text + "   按" + DropDownList1.SelectedItem.Text + "统计数据";

            GridView1.DataBind();
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            // Confirms that an HtmlForm control is rendered for
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            common.ToExcel(GridView1, "profit");

            Response.End();
        }

        protected void GridView1_Sorting(object sender, GridViewSortEventArgs e)
        {
            string sortExpression = e.SortExpression;

            if (GridViewSortDirection == SortDirection.Ascending)
            {

                GridViewSortDirection = SortDirection.Descending;

                SortGridView(sortExpression, "DESC");

            }

            else
            {

                GridViewSortDirection = SortDirection.Ascending;

                SortGridView(sortExpression, "ASC");

            }


        }
        public SortDirection GridViewSortDirection
        {

            get
            {

                if (ViewState["sortDirection"] == null)

                    ViewState["sortDirection"] = SortDirection.Ascending;

                return (SortDirection)ViewState["sortDirection"];

            }

            set { ViewState["sortDirection"] = value; }

        }
        private void SortGridView(string sortExpression, string direction)
        {
            DataClass.sell_profit ws = new DataClass.sell_profit();
            DataTable dt = ws.Get_analyse_data(DropDownList1.SelectedItem.Value, Q_xd_date_from.Text, Q_xd_date_to.Text).Tables[0];            


            DataView dv = new DataView(dt);

            dv.Sort = sortExpression + " " + direction;

            GridView1.DataSource = dv;

            GridView1.DataBind();

        }
    }
}
