﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace computer.financial
{
    public partial class sell_query : System.Web.UI.Page
    {
        protected decimal _amount = 0;
        protected decimal _amount1 = 0;

        protected void Page_Load(object sender, EventArgs e)
        {

            if (!Page.IsPostBack)
            {
               // Page.Title = common.CompanyName() + Page.Title;
                common.Init_DropDown_for_Dept(DropDownList_dept_id);//DropDownList1
                TextBox3.Text = DateTime.Now.ToString("yyyy-MM-dd");
                TextBox4.Text = DateTime.Now.ToString("yyyy-MM-dd");

                get_output_sk_data();

            }
        }
        protected void get_output_sk_data()
        {
            get_output_sk_list(1);
            get_output_sk_sum();
            get_Count();
        }

        protected void get_output_sk_sum()
        {
            try
            {
                DataClass.product_output ws = new DataClass.product_output();
                GridView3.DataSource = ws.Get_output_sk_sum(DropDownList_dept_id.SelectedItem.Value, TextBox3.Text.Trim(), TextBox4.Text.Trim(), RadioButtonList1.SelectedItem.Value);
                GridView3.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//
        }
        protected void get_output_sk_list(int CurrentPage)
        {
            try
            {
                DataClass.product_output ws = new DataClass.product_output();
                GridView1.DataSource = ws.Get_output_sk_Query_List(DropDownList_dept_id.SelectedItem.Value, TextBox3.Text.Trim(), TextBox4.Text.Trim(), RadioButtonList1.SelectedItem.Value, CurrentPage);
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//
        }
        protected void get_Count()
        {
            try
            {
                DataClass.product_output ws = new DataClass.product_output();
                int[] _ws = (int[])ws.Get_output_sk_Query_List_Count(DropDownList_dept_id.SelectedItem.Value, TextBox3.Text.Trim(), TextBox4.Text.Trim(), RadioButtonList1.SelectedItem.Value);
                AspNetPager1.CurrentPageIndex = 1;
                AspNetPager1.PageSize = _ws[0];//页面尺寸
                AspNetPager1.RecordCount = _ws[1];
                TotalCount.Text = _ws[1].ToString();//总记录数
                PageCount.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            HiddenField_dd_id.Value = "0";
            get_output_sk_data();
            if (TextBox3.Text.Trim() == TextBox4.Text.Trim())
            {
                if (DataClass.product_output.is_not_optput_sk(DropDownList_dept_id.SelectedItem.Value, TextBox3.Text.Trim()))
                {
                    Button2.Visible = true;
                    Button3.Visible = false;
                }
                else
                {
                    Button2.Visible = false;
                    Button3.Visible = true;
                }
            }
            else
            {
                Button2.Visible = false;
                Button3.Visible = false;

            }
        }

        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            get_output_sk_list(AspNetPager1.CurrentPageIndex);
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                LinkButton LinkButton66 = (LinkButton)e.Row.FindControl("LinkButton6");
                LinkButton66.CommandArgument = e.Row.RowIndex.ToString();

                if (e.Row.Cells[10].Text == "1")
                    LinkButton66.Visible = true;
                else
                    LinkButton66.Visible = false;
                _amount +=Decimal.Parse(e.Row.Cells[4].Text);

            }

            if (e.Row.RowType == DataControlRowType.Footer)
            {
                e.Row.Cells[3].Text = "总计：";
                e.Row.Cells[4].Text = _amount.ToString();
                Hday_amount.Value = _amount.ToString();
            }
        }

        protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "remark")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewRow row = GridView1.Rows[index];
                HiddenField_dd_id.Value = row.Cells[1].Text.Trim();
                HiddenField_dept_id.Value = row.Cells[9].Text.Trim();
                HiddenField_op_state.Value = row.Cells[10].Text.Trim();
                get_product_output_data(row.Cells[10].Text, row.Cells[9].Text, HiddenField_dd_id.Value);
            }
        }

        protected void AspNetPager2_PageChanged(object sender, EventArgs e)
        {
            get_product_output_list(HiddenField_op_state.Value, HiddenField_dept_id.Value, HiddenField_dd_id.Value, AspNetPager2.CurrentPageIndex);
        }

        protected void GridView2_RowDataBound(object sender, GridViewRowEventArgs e)
        {
                int i = e.Row.Cells.Count - 1;
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                _amount1 +=Decimal.Parse(e.Row.Cells[i].Text);
            }
            if (e.Row.RowType == DataControlRowType.Footer)
            {
                e.Row.Cells[i].Text = _amount1.ToString();
            }
        }

        protected void get_product_output_data(string op_state, string dept_id, string dd_id)
        {
            get_product_output_list(op_state, dept_id, dd_id, 1);
          //  get_product_output_Count(op_state, dept_id, dd_id);
        }
        protected void get_product_output_list(string op_state, string dept_id, string dd_id, int CurrentPage)
        {
            try
            {
                DataClass.cash_list ws = new DataClass.cash_list();
                GridView2.DataSource = ws.Get_remark(op_state, dept_id, dd_id, CurrentPage);
                GridView2.DataBind();
            }
            catch (Exception ex)
            {
                FengFan.MessageBox.Show(Page, ex.ToString());
            }
            finally
            {
            }//
        }
        protected void get_product_output_Count(string op_state, string dept_id, string dd_id)
        {
            try
            {
                DataClass.cash_list ws = new DataClass.cash_list();
                int[] _ws = (int[])ws.Get_remark_Count(op_state, dept_id, dd_id);
                AspNetPager2.CurrentPageIndex = 1;
                AspNetPager2.PageSize = _ws[0];//页面尺寸
                AspNetPager2.RecordCount = _ws[1];
                TotalCount1.Text = _ws[1].ToString();//总记录数
                PageCount1.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
                FengFan.MessageBox.Show(Page, ex.ToString());
            }
            finally
            {
            }//
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            DataClass.cash_list.Add_dept_pay(TextBox3.Text.Trim(), DropDownList_dept_id.SelectedItem.Value, Session["User_Name"].ToString()); 
            get_output_sk_data();
        }

        protected void Button3_Click(object sender, EventArgs e)
        {
            DataClass.cash_list.delete_dept_pay(TextBox3.Text.Trim(),  DropDownList_dept_id.SelectedItem.Value);
            get_output_sk_data();
        }

        protected void GridView1_RowCreated(object sender, GridViewRowEventArgs e)
        {

            e.Row.Cells[9].Visible = false;//dept_id
            e.Row.Cells[10].Visible = false;//op_state
        }

    }
}
