﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

namespace computer.query
{
    public partial class input_query : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
               // Page.Title = common.CompanyName() + Page.Title;
                common.Init_DropDown_for_Dept(DropDownList_dept_id);//DropDownList1
                DropDownList_dept_id.SelectedIndex = DropDownList_dept_id.Items.IndexOf(DropDownList_dept_id.Items.FindByValue(Session["Dept_ID"].ToString()));

                mytreeview ws = new mytreeview();
                ws.ShowTv(TreeView1);
                get_stock_list(1);
                get_Count();
            }
        }
        protected void get_stock_list(int CurrentPage)
        {
            try
            {
                DataClass.stock_query ws = new DataClass.stock_query();
                GridView1.DataSource = ws.GetcstockList(H_stype.Value, Txt_provide.Text.Trim(), Txt_product.Text.Trim(), DropDownList_dept_id.SelectedItem.Value, date_from.Text, date_to.Text, CurrentPage);
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//
        }
        protected void get_Count()
        {
            try
            {
                DataClass.stock_query ws = new DataClass.stock_query();
                int[] _ws = (int[])ws.GetstockList_Count(H_stype.Value, Txt_provide.Text.Trim(), Txt_product.Text.Trim(), DropDownList_dept_id.SelectedItem.Value, date_from.Text, date_to.Text);
                AspNetPager1.CurrentPageIndex = 1;
                AspNetPager1.PageSize = _ws[0];//页面尺寸
                AspNetPager1.RecordCount = _ws[1];
                TotalCount.Text = _ws[1].ToString();//总记录数
                PageCount.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//
        }

        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            get_stock_list(AspNetPager1.CurrentPageIndex);
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            get_stock_list(1);
            get_Count();
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.Footer)
            {
                DataClass.stock_query ws = new DataClass.stock_query();
                decimal[] _ws = (decimal[])ws.GetstockList_sum(H_stype.Value, Txt_provide.Text.Trim(), Txt_product.Text.Trim(), DropDownList_dept_id.SelectedItem.Value, date_from.Text, date_to.Text);

                e.Row.Cells[8].Text = "总计：";
                e.Row.Cells[9].Text = _ws[0].ToString();
              //  e.Row.Cells[11].Text = _ws[1].ToString();
            }
        }

        protected void Button2_Click(object sender, EventArgs e)
        {

            DataTable dt = get_print_data().Tables[0];
            dt.Columns.Remove("stype");


            dt.Columns.Remove("dd_type_id");
            dt.Columns.Remove("dept_id");
            dt.Columns.Remove("input_dept_id");
            dt.Columns.Remove("product_id");
            dt.Columns.Remove("provide_id");
            dt.Columns.Remove("orderid");
            dt.Columns.Remove("stock_id");

            dt.Columns["dd_type"].ColumnName = "类型";
            dt.Columns["sdate"].ColumnName = "日期";
            dt.Columns["dept_name"].ColumnName = "采购门市";
            dt.Columns["product_name"].ColumnName = "品名";
            dt.Columns["xd_scount"].ColumnName = "实收数量";
            dt.Columns["scount"].ColumnName = "采购数量";
            dt.Columns["price"].ColumnName = "价格";
            dt.Columns["amount"].ColumnName = "金额";
            dt.Columns["xd_date"].ColumnName = "下单日期";
            dt.Columns["provide_name"].ColumnName = "供应商";
            dt.Columns["input_dept_name"].ColumnName = "收货门市";


            GridView2.Visible = true;
            GridView2.DataSource =dt;
            GridView2.DataBind();
            GridView2.Caption = "门市：" + DropDownList_dept_id.SelectedItem.Text +"  类别："+ H_stype_name.Value +  "  从日期：" + date_from.Text + "  到日期：" + date_to.Text + "的采购数";

            common.ToExcel(GridView2, "store");

            Response.End();
            GridView2.Visible = false;
        }

        public override void VerifyRenderingInServerForm(Control control)
        {
           
        }

        protected DataSet get_print_data()
        {
            DataClass.stock_query ws = new DataClass.stock_query();
            return ws.GetcstockList_EXCEL(H_stype.Value, Txt_provide.Text.Trim(), Txt_product.Text.Trim(), DropDownList_dept_id.SelectedItem.Value, date_from.Text, date_to.Text);
        }

        public SortDirection GridViewSortDirection
        {

            get
            {

                if (ViewState["sortDirection"] == null)

                    ViewState["sortDirection"] = SortDirection.Ascending;

                return (SortDirection)ViewState["sortDirection"];

            }

            set { ViewState["sortDirection"] = value; }

        }
        private void SortGridView(string sortExpression, string direction)
        {
            DataClass.stock_query ws = new DataClass.stock_query();
            DataTable dt = ws.GetcstockList(H_stype.Value, Txt_provide.Text.Trim(), Txt_product.Text.Trim(), DropDownList_dept_id.SelectedItem.Value, date_from.Text, date_to.Text, AspNetPager1.CurrentPageIndex).Tables[0];


            DataView dv = new DataView(dt);

            dv.Sort = sortExpression + " "+direction;

            GridView1.DataSource = dv;

            GridView1.DataBind();

        }


        protected void GridView1_Sorting(object sender, GridViewSortEventArgs e)
        {
            string sortExpression = e.SortExpression;

            if (GridViewSortDirection == SortDirection.Ascending)
            {

                GridViewSortDirection = SortDirection.Descending;

                SortGridView(sortExpression, "DESC");

            }

            else
            {

                GridViewSortDirection = SortDirection.Ascending;

                SortGridView(sortExpression, "ASC");

            } 


        }

        protected void TreeView1_SelectedNodeChanged(object sender, EventArgs e)
        {
            H_stype.Value = TreeView1.SelectedNode.Value;
            DataClass.BaseData ws = new DataClass.BaseData();
            H_stype_name.Value = ws.Get_material_type_class(Int16.Parse(H_stype.Value));
            GridView1.Caption = H_stype_name.Value;
            get_stock_list(1);
            get_Count();
       
        }



    }
}
