﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Xml.Linq;

namespace computer
{
    /// <summary>
    /// Summary description for retail
    /// </summary>
    [WebService(Namespace = "http://tempuri.org/")]
    [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
    [ToolboxItem(false)]
    // To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
    // [System.Web.Script.Services.ScriptService]
    public class retail : System.Web.Services.WebService
    {
        [WebMethod]
        public int insert_product_output(string client, string bill_id, string dept_id, string sdate, int seller_id, int product_id, string product_sn, int scount, decimal price, int money_id, string sman, string remark)
        {
            Model.product_output model = new Model.product_output();
            DataClass.product_output ws = new DataClass.product_output();

            model.client = client;
            model.bill_id = bill_id;
            model.dept_id = dept_id; 
            model.sdate = sdate;
            model.seller_id = seller_id;
            model.product_id = Int32.Parse(product_id.ToString());

            model.product_sn = product_sn;

            model.scount = Convert.ToInt32(scount);

            model.price = Convert.ToDecimal(price);
            model.money_id = money_id;

            model.sman = sman;

            model.remark = remark;

         return    ws.Add(model);
        }
        [WebMethod]
        public string insert_client_pay(decimal amount, string sman, string sdate, string dept_id, string client_id)
        {
            Model.Client_Pay model_Pay = new Model.Client_Pay();
            DataClass.Client_Pay ws_Pay = new DataClass.Client_Pay();

            model_Pay.amount = amount;
            model_Pay.sman = sman;
            model_Pay.sdate = sdate;
            model_Pay.pay_Way = 0;  //零售现付     1,2,3.....付款方式   现金   银行等
            if (client_id.Trim().Length != 0)

                model_Pay.remark = "注册客户前台销售";
            else
                model_Pay.remark = "前台销售";

            model_Pay.dept_id = dept_id;
            model_Pay.client_id = client_id;

            string op_id = "";
            if (model_Pay.amount > 0)
                op_id = ws_Pay.Add(model_Pay);

            return op_id;

        }
        [WebMethod]
        public int insert_client_pay_record(string op_id, string client_id, string dd_id, string dept_id, decimal amount)
        {
            DataClass.Client_Pay ws_Pay = new DataClass.Client_Pay();
           return  ws_Pay.insert_into_Client_Pay( op_id,  client_id,  dd_id,  dept_id,  amount);
        }


        [WebMethod]
        public  int get_retail_store_scount(Int32 product_id, Int32 modify_scount, string dept_id)
        {
            return DataClass.product_input.get_retail_store_scount( product_id,  modify_scount,  dept_id);
        }
        [WebMethod]
        public  string get_retail_output_bill(string dept_id)
        {
            return DataClass.product_output.get_retail_output_bill(dept_id);
        }

        [WebMethod]
        public decimal get_product_price(string product_id, Int16 user_price)
        {
            DataClass.product_price ws = new DataClass.product_price();
            Model.BaseData.product_price model = new Model.BaseData.product_price();

            model = ws.GetModel(Int32.Parse(product_id));

            decimal _price = 0;
            if (user_price == 1) _price = model.price1;
            if (user_price == 2) _price = model.price2;
            if (user_price == 3) _price = model.price3;
            if (user_price == 4) _price = model.price4;
            if (user_price == 5) _price = model.price5;

            return _price;
        }


        [WebMethod]
        public Boolean get_company_info(out string company_name, out string company_address, out string company_tel, out string company_fax, out string company_sman)
        {
            company_name = "";
            company_address = "";
            company_tel = "";
            company_fax = "";
            company_sman = "";
            try
            {
                DataClass.BaseData Company_ws = new DataClass.BaseData();
                Model.BaseData.Company_data model = new Model.BaseData.Company_data();
                model = Company_ws.GetCompany_dataModel();
                company_name = model.sname;
                company_address = model.address;
                company_tel = model.tel;
                company_fax = model.fax;
                company_sman = model.sman;

                return true;
            }
            catch
            {
                return false;
            }

        }

        [WebMethod]
        public Boolean retail_UserLogin(string user_id, string _pass, out string User_Name, out string Dept, out string Dept_ID, out string Duty, out string User_type, out string User_price)
        {
            DataClass._system ws = new DataClass._system();

            return ws.retail_UserLogin(user_id, _pass, out User_Name, out Dept, out Dept_ID, out Duty, out User_type, out User_price);
        }

        [WebMethod]
        public int get_retail_client_count()
        {
            DataClass.client_list ws = new DataClass.client_list();
            return ws.Getretail_clientList_Count();
        }

        [WebMethod]
        public DataTable get_retail_client_list(int CurrentPage, int PageSize)
        {
            DataClass.client_list ws = new DataClass.client_list();
            DataTable dt= ws.Getretail_clientList( CurrentPage,  PageSize).Tables[0];

            dt.Columns.Remove("sman");
            dt.Columns.Remove("address");
            dt.Columns.Remove("tel");
            dt.Columns.Remove("fax");
            dt.Columns.Remove("mobil");
            dt.Columns.Remove("email");
            dt.Columns.Remove("abrv");
            dt.Columns.Remove("remark");
            dt.Columns.Remove("first_amount");
            dt.Columns.Remove("client_type_id");
            dt.Columns.Remove("client_type_name");
            dt.Columns.Remove("payable");
            dt.Columns.Remove("max_amount");

            return dt;

        }

        [WebMethod]
        public int get_retail_material_list_count()
        {
            DataClass.BaseData ws = new DataClass.BaseData();
            return ws.Getretail_MaterialList_Count();
        }


        [WebMethod]
        public DataTable get_retail_material_list(int CurrentPage, int PageSize)
        {
            DataClass.BaseData ws = new DataClass.BaseData();
            DataTable dt = ws.Get_retail_MaterialList(CurrentPage, PageSize).Tables[0];
            dt.Columns.Remove("abrv");
            dt.Columns.Remove("insert_datetime");
            dt.Columns.Remove("remark");
            dt.Columns.Remove("is_qc");
            dt.Columns.Remove("stype");
            dt.Columns.Remove("expire_date");
            dt.Columns.Remove("safe_store_up");
            dt.Columns.Remove("safe_store_down");

            return dt;
        }
        [WebMethod]
        public DataTable get_retail_unit_list()
        {
            DataClass.BaseData ws = new DataClass.BaseData();
            DataTable dt = ws.Getunit_list().Tables[0];
            //dt.Columns.Remove("is_Base_Unit");
            //dt.Columns.Remove("rate_to_base");

            return dt;
        }
        [WebMethod]
        public DataTable get_retail_seller_list()
        {
            DataClass._system ws = new DataClass._system();
            DataTable dt = ws.GetSellerList().Tables[0];
            //dt.Columns.Remove("dept_name");
            //dt.Columns.Remove("tel");
            //dt.Columns.Remove("is_out");

            return dt;
        }

        [WebMethod]
        public DataTable get_retail_money_list()
        {
            DataClass.BaseData ws = new DataClass.BaseData();
            DataTable dt = ws.Getmomey_unit_list().Tables[0];
            //dt.Columns.Remove("dept_name");
            //dt.Columns.Remove("tel");
            //dt.Columns.Remove("is_out");

            return dt;
        }
    }
}
