﻿using System;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace computer.sell
{
    public partial class Seller : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
               // Page.Title = common.CompanyName() + Page.Title;
                common.Init_DropDown_Item(Dept, "select dept_id,sname from dept_list order by dept_id");


                get_Seller();
            }
        }


        protected void get_Seller()
        {
            try
            {
                DataClass._system ws = new DataClass._system();
                GridView1.DataSource = ws.GetSellerList();
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            _null();
        }
        protected void _null()
        {
            TextBox_Name.Text = "";
            Dept.SelectedIndex = 0;
            Txt_tel.Text = "";
            Button1.Text = "新增";
            HiddenField1.Value = "I";
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            if (TextBox_Name.Text.Trim() != string.Empty)
                try
                {
                    DataClass._system ws = new DataClass._system();
                    ws.InsertSeller(Hsellerid.Value, TextBox_Name.Text, Dept.SelectedItem.Value, Txt_tel.Text, HiddenField1.Value);
                    _null();
                }
                catch (Exception ex)
                {
                    common.Uerr_str(UpdatePanel1, ex.Message.Replace("\r\n", "").Replace("'", "\""));
                }
                finally
                {
                    get_Seller();
                }
        }

        protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Select")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewRow row = GridView1.Rows[index];
                Hsellerid.Value = FengFan.Functions.clear_null(row.Cells[0].Text.Trim());
                TextBox_Name.Text = FengFan.Functions.clear_null(row.Cells[1].Text.Trim());
                Dept.SelectedIndex = Dept.Items.IndexOf(Dept.Items.FindByText(FengFan.Functions.clear_null(row.Cells[2].Text.Trim())));
                Txt_tel.Text = FengFan.Functions.clear_null(row.Cells[3].Text.Trim());

                Button1.Text = "取消";
                HiddenField1.Value = "U";
            }

        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                LinkButton addButton3 = (LinkButton)e.Row.FindControl("LinkButton3");
                addButton3.CommandArgument = e.Row.RowIndex.ToString();
                LinkButton addButton4 = (LinkButton)e.Row.FindControl("LinkButton4");

                addButton4.Attributes.Add("onclick", "return confirm('确定要删除用户：" + FengFan.Functions.clear_null(e.Row.Cells[1].Text.Trim()) + " 吗?');");

            }
        }

        protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            GridViewRow row = GridView1.Rows[e.RowIndex];
            try
            {
                DataClass._system ws = new DataClass._system();
                ws.DeleteSeller(FengFan.Functions.clear_null(row.Cells[0].Text.Trim()));
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.Message.Replace("\r\n", "").Replace("'", "\""));
            }
            finally
            {
                get_Seller();
            }
        }

  /**/
    }
}
