﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace computer.sell
{
    public partial class dd_outdate : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
               // Page.Title = common.CompanyName() + Page.Title;
                common.Init_DropDown_Item(Dept, "select dept_id,sname from dept_list order by dept_id");

                get_dd_data(1);
                get_Count();
            }
        }
        protected void get_dd_data(int CurrentPage)
        {
            try
            {
                DataClass.dd_list ws = new DataClass.dd_list();
                GridView1.DataSource = ws.Getdd_outdateList(20, Dept.SelectedItem.Value, txt_client.Text.Trim(), CurrentPage);
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//８４２８８８０８
        }
        protected void get_Count()
        {
            try
            {
                DataClass.dd_list ws = new DataClass.dd_list();
                int[] _ws = (int[])ws.Getdd_outdate_list_Count(20, Dept.SelectedItem.Value, txt_client.Text.Trim());
                AspNetPager1.CurrentPageIndex = 1;
                AspNetPager1.PageSize = _ws[0];//页面尺寸
                AspNetPager1.RecordCount = _ws[1];
                TotalCount.Text = _ws[1].ToString();//总记录数
                PageCount.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }
        }

        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            get_dd_data(AspNetPager1.CurrentPageIndex);
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            get_dd_data(1);
            get_Count();
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            // Confirms that an HtmlForm control is rendered for
        }
        protected void Button2_Click(object sender, EventArgs e)
        {
            DataClass.dd_list ws = new DataClass.dd_list();

            DataTable dt = ws.Getdd_outdate_Excel(Dept.SelectedItem.Value, txt_client.Text.Trim()).Tables[0];

            dt.Columns.Remove("id");
            dt.Columns.Remove("dept_id");
            dt.Columns.Remove("amount");
            dt.Columns.Remove("orderid");
            dt.Columns.Remove("client_id");
            dt.Columns.Remove("product_id");
            dt.Columns.Remove("stype");
            dt.Columns.Remove("momey_unit_name");
            dt.Columns.Remove("remark");
            dt.Columns.Remove("price");
            dt.Columns.Remove("scount");

            dt.Columns["dd_id"].ColumnName = "订单";
            dt.Columns["sname"].ColumnName = "品名";
            dt.Columns["model"].ColumnName = "规格";
            dt.Columns["dd_sum_scount"].ColumnName = "订单数量";
            dt.Columns["out_scount"].ColumnName = "已出货数量";
            dt.Columns["not_out_scount"].ColumnName = "未出数量";
            dt.Columns["yj_date"].ColumnName = "计划货期";
            dt.Columns["client_name"].ColumnName = "客户";
            dt.Columns["dept_name"].ColumnName = "门市";
            dt.Columns["xd_date"].ColumnName = "下单日期";
            dt.Columns["unit_name"].ColumnName = "单位";


            GridView3.Visible = true;
            GridView3.DataSource = dt;
            GridView3.DataBind();
            GridView3.Caption = "截止至 " + DateTime.Now.ToString("yyyy-MM-dd") + "：逾期未出货数量";


            common wss = new common();

            wss.ConvertGridViewToExcel(GridView3);
        }


    }
}
