﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Microsoft.Reporting.WebForms;

namespace computer.sell
{
    public partial class product_output : System.Web.UI.Page
    {
        protected double _amount=0;
     //   protected DataTable table;
        protected DataTable DT
        {
            get
            {
                DataTable table = ViewState["DataTable"] as DataTable;
                if (table == null)
                {
                    table = new DataTable();
                    temp_table(table);
                    ViewState["DataTable"] = table;
                }
                return table;
            }
            set
            {
                ViewState["DataTable"] = value;
            }

        }

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
               // Page.Title = common.CompanyName() + Page.Title;
                common.Init_DropDown_Item(DropDownList_money_id, "SELECT     money_id, momey_unit_name FROM         momey_unit_list order by money_id");//DropDownList1
                common.Init_DropDown_for_Dept(DropDownList_dept_id);//DropDownList1
                //  Form.DefaultButton = "ctl00$ContentPlaceHolder1$Product_id1$Button1";
                DropDownList_dept_id.SelectedIndex = DropDownList_dept_id.Items.IndexOf(DropDownList_dept_id.Items.FindByValue(Session["Dept_ID"].ToString()));
                DropDownList_money_id.SelectedIndex = 1;
                product_output_id.Value = "0";
                txt_output_date.Text = DateTime.Now.ToString("yyyy-MM-dd");

                if (DataClass.BaseData.is_MeiShi(Session["Dept_ID"].ToString()))
                {
                    common.Init_DropDown_Item(D_seller, "SELECT     seller_id, seller_name FROM         seller where seller_name in (SELECT     user_name FROM         user_list WHERE     (user_price = 1)) or  dept_id='" + Session["Dept_ID"].ToString() + "' ORDER BY seller_id");

                }
                else
                {
                    common.Init_DropDown_Item(D_seller, "SELECT     seller_id, seller_name FROM         seller   ORDER BY seller_id");
                }

                tr2.Visible = false;
                Button2.Attributes.Add("onclick", "return confirm('本次销售确定结账吗?');");
            }
        }
        private void temp_table(DataTable _table)
        {

            DataColumn columnoutput_id;
            DataColumn columnproduct_id;
            DataColumn columnproduct_sn;
            DataColumn columnproduct_name;
            DataColumn columnscount;
            DataColumn columnprice;
            DataColumn columnmoney_id;
            DataColumn columnsman;
            DataColumn columnsdate;
            DataColumn columnremark;
            DataColumn columndept_id;
            DataColumn columnmoney_name;
            DataColumn columnamount;
            DataColumn columnbill_id;
            DataColumn columnclient;
            DataColumn columnclient_name;

            columnoutput_id = new System.Data.DataColumn("output_id", typeof(int), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnoutput_id);
            columnproduct_id = new System.Data.DataColumn("product_id", typeof(int), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnproduct_id);
            columnproduct_sn = new System.Data.DataColumn("product_sn", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnproduct_sn);
            columnscount = new System.Data.DataColumn("scount", typeof(int), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnscount);
            columnprice = new System.Data.DataColumn("price", typeof(double), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnprice);
            columnmoney_id = new System.Data.DataColumn("money_id", typeof(int), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnmoney_id);
            columnsman = new System.Data.DataColumn("sman", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnsman);
            columnsdate = new System.Data.DataColumn("sdate", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnsdate);
            columnremark = new System.Data.DataColumn("remark", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnremark);
            columndept_id = new System.Data.DataColumn("dept_id", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columndept_id);
            columnproduct_name = new System.Data.DataColumn("product_name", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnproduct_name);
            columnmoney_name = new System.Data.DataColumn("money_name", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnmoney_name);
            columnamount = new System.Data.DataColumn("amount", typeof(double), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnamount);
            columnbill_id = new System.Data.DataColumn("bill_id", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnbill_id);
            columnclient = new System.Data.DataColumn("client", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnclient);
            columnclient_name = new System.Data.DataColumn("client_name", typeof(string), null, System.Data.MappingType.Element);
            _table.Columns.Add(columnclient_name);

            columnoutput_id.AutoIncrement = true;
            columnoutput_id.AutoIncrementSeed = 1;
            columnoutput_id.AutoIncrementStep = 1;
            columnoutput_id.AllowDBNull = false;
            columnoutput_id.ReadOnly = true;
            columnoutput_id.Unique = true;
            columnproduct_id.AllowDBNull = false;
            columnproduct_sn.AllowDBNull = false;
            columnproduct_sn.MaxLength = 50;
            columnscount.AllowDBNull = false;
            columnprice.AllowDBNull = false;
            columnmoney_id.AllowDBNull = false;
            columnsman.AllowDBNull = false;
            columnsman.MaxLength = 20;
            columnsdate.AllowDBNull = false;
            columnsdate.MaxLength = 20;
            columnremark.AllowDBNull = false;
            columnremark.MaxLength = 50;
            columndept_id.AllowDBNull = false;
            columndept_id.MaxLength = 5;
            columnproduct_name.AllowDBNull = false;
            columnproduct_name.MaxLength = 50;
            columnmoney_name.AllowDBNull = false;
            columnmoney_name.MaxLength = 10;
            columnbill_id.AllowDBNull = false;
            columnbill_id.MaxLength = 10;
            columnclient.AllowDBNull = false;
            columnclient.MaxLength = 10;
            columnclient_name.AllowDBNull = false;
            columnclient_name.MaxLength = 50;

        }
        protected void get_product_output_list(int CurrentPage)
        {
            try
            {
                DataClass.product_output ws = new DataClass.product_output();
                GridView1.DataSource = ws.GetddList(TextBox1.Text.Trim(), DropDownList_dept_id.SelectedItem.Value, TextBox3.Text.Trim(), TextBox4.Text.Trim(),TextBox_bill_id.Text, CurrentPage);
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
                FengFan.MessageBox.Show(Page, ex.ToString());
            }
            finally
            {
            }//
        }
        protected void get_Count()
        {
            try
            {
                DataClass.product_output ws = new DataClass.product_output();
                int[] _ws = (int[])ws.GetddList_Count(TextBox1.Text.Trim(), DropDownList_dept_id.SelectedItem.Value, TextBox3.Text.Trim(), TextBox4.Text.Trim(), TextBox_bill_id.Text);
                AspNetPager1.CurrentPageIndex = 1;
                AspNetPager1.PageSize = _ws[0];//页面尺寸
                AspNetPager1.RecordCount = _ws[1];
                TotalCount.Text = _ws[1].ToString();//总记录数
                PageCount.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
                FengFan.MessageBox.Show(Page, ex.ToString());
            }
            finally
            {
            }//
        }

        protected void get_sell_Count()
        {
            int _record_count = DT.Rows.Count;
            int page_count = DT.Rows.Count / 20 + 1;

            AspNetPager1.CurrentPageIndex = 1;
            AspNetPager1.PageSize = page_count;//页面尺寸
            AspNetPager1.RecordCount = _record_count;
            TotalCount.Text = _record_count.ToString();//总记录数
            PageCount.Text = page_count.ToString();//总页数

        }

        protected void _Null()
        {
            txt_product_id.Text = "";
            Label_product_name.Text = "";

           // txtclient_id.Text = "";
          //  Label_client_name.Text = "";

            txt_scount.Text = "1";
            txt_price.Text = "0";
            txt_product_sn.Text = "";
            txtremark.Text = "";

            DropDownList_money_id.SelectedIndex =1;
            product_output_id.Value = "0";
            HiddenField_store_scount.Value = "0";

            IU_Statu.Value = "I";

            get_sell_Count();

        }
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            Product_id1.CancelEvent += new EventHandler(cancel_dd_select);

            Product_id1.SelectEvent += new EventHandler(get_dd_id);


            Client_query1.SelectEvent += new EventHandler(get_Client_id);
            Client_query1.CancelEvent += new EventHandler(cancel_client_select);
        }

        private void get_Client_id(object sender, EventArgs e)
        {
            // FengFan.MessageBox.Show(this.Page,"ccccccccccccc");

            txtclient_id.Text = Client_query1.select_client_id;
            Label_client_name.Text = Client_query1.select_client_name;
            Client_query1.Visible = false;
        }
        private void cancel_client_select(object sender, EventArgs e)
        {
            txtclient_id.Text = "";
             Label_client_name.Text = "";
            Client_query1.Visible = false;
        }



        private void cancel_dd_select(object sender, EventArgs e)
        {
            Product_id1.Visible = false;
        }

        private void get_dd_id(object sender, EventArgs e)
        {
            string expression;
            expression = "product_id=" + Product_id1.get_product_id.Trim();
            if (DT.Select(expression).Length == 0)
            {

                txt_product_id.Text = Product_id1.get_product_id;
                Label_product_name.Text = Product_id1.get_product_name;


                DataClass.product_price ws = new DataClass.product_price();
                Model.BaseData.product_price model = new Model.BaseData.product_price();

                model = ws.GetModel(Int32.Parse(txt_product_id.Text));

                txt_price.Text = get_product_price(txt_product_id.Text).ToString();


                Product_id1.Visible = false;
            }
            else
                common.Uerr_str(UpdatePanel1, "本次销售存在[" + Product_id1.get_product_name + "]这个产品,不能增加,请修改数量!!");
        } 

        protected void Button1_Click(object sender, EventArgs e)
        {
            get_product_output_list(1);
            get_Count();

            TR1.Visible = true;
            GridView1.Columns[0].Visible = false;
            GridView1.Columns[13].Visible = false;
            GridView1.Columns[9].Visible = true;
            GridView1.Columns[10].Visible = true;
            GridView1.Columns[11].Visible = true;
        }

        protected void Button5_Click(object sender, EventArgs e)
        {
           Product_id1.get_material();
            Product_id1.Visible = true;
        }

      

        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            get_product_output_list(AspNetPager1.CurrentPageIndex);
        }

        protected void Button3_Click(object sender, EventArgs e)
        {
            string last_month_date = DataClass.store_month.get_month_last_date();
            if (DateTime.Parse(txt_output_date.Text) > DateTime.Parse(last_month_date))
            {
                int stroe_scount = 0;
                if (DT.Rows.Count == 0)
                    Label_bill_id.Text = DataClass.product_output.get_output_bill(DropDownList_dept_id.SelectedItem.Value);
                DataRow row;
                DataView view;
                if (IU_Statu.Value == "I")
                {
                    stroe_scount = DataClass.product_input.get_store_scount(Int32.Parse(txt_product_id.Text), 0, DropDownList_dept_id.SelectedItem.Value);
                    if (stroe_scount >= Convert.ToInt32(txt_scount.Text))
                    {
                        row = DT.NewRow();

                        row["product_id"] = Int32.Parse(txt_product_id.Text);
                        row["product_name"] = Label_product_name.Text;
                        row["product_sn"] = txt_product_sn.Text.Trim();
                        row["money_id"] = Int16.Parse(DropDownList_money_id.SelectedItem.Value);
                        row["money_name"] = DropDownList_money_id.SelectedItem.Text;
                        row["price"] = Convert.ToDecimal(txt_price.Text);
                        row["amount"] = Convert.ToDecimal(txt_price.Text) * Convert.ToInt32(txt_scount.Text);
                        row["remark"] = txtremark.Text.Trim();
                        row["sman"] = Session["User_Name"].ToString();
                        row["dept_id"] = DropDownList_dept_id.SelectedItem.Value;
                        row["scount"] = Convert.ToInt32(txt_scount.Text);
                        row["sdate"] = txt_output_date.Text + " " + DateTime.Now.ToString("HH:mm:ss");
                        row["bill_id"] = Label_bill_id.Text;
                        row["client"] = FengFan.Functions.clear_null(txtclient_id.Text).Length > 0 ? txtclient_id.Text : "零售";
                        row["client_name"] = FengFan.Functions.clear_null(txtclient_id.Text).Length > 0 ? Label_client_name.Text : "零售";


                        DT.Rows.Add(row);
                    }
                    else
                        common.Uerr_str(UpdatePanel1, Label_product_name.Text + "的库存数不够,最多能销售" + stroe_scount.ToString());
                }
                if (IU_Statu.Value == "U")
                {
                    stroe_scount = DataClass.product_input.get_store_scount(Int32.Parse(txt_product_id.Text), Int32.Parse(HiddenField_store_scount.Value), DropDownList_dept_id.SelectedItem.Value);
                    if (stroe_scount >= Convert.ToInt32(txt_scount.Text))
                    {
                        string expression;
                        expression = "output_id=" + product_output_id.Value;
                        DataRow[] foundRows;
                        foundRows = DT.Select(expression);
                        row = foundRows[0];
                        row.BeginEdit();
                        row["product_id"] = Int32.Parse(txt_product_id.Text);
                        row["product_name"] = Label_product_name.Text;
                        row["product_sn"] = txt_product_sn.Text.Trim();
                        row["money_id"] = Int16.Parse(DropDownList_money_id.SelectedItem.Value);
                        row["money_name"] = DropDownList_money_id.SelectedItem.Text;
                        row["price"] = Convert.ToDecimal(txt_price.Text);
                        row["amount"] = Convert.ToDecimal(txt_price.Text) * Convert.ToInt32(txt_scount.Text);
                        row["remark"] = txtremark.Text.Trim();
                        row["sman"] = Session["User_Name"].ToString();
                        row["dept_id"] = DropDownList_dept_id.SelectedItem.Value;
                        row["scount"] = Convert.ToInt32(txt_scount.Text);
                        row["sdate"] = txt_output_date.Text + " " + DateTime.Now.ToString("HH:mm:ss");
                        row["bill_id"] = Label_bill_id.Text;
                        row["client"] = FengFan.Functions.clear_null(txtclient_id.Text).Length > 0 ? txtclient_id.Text : "零售";
                        row["client_name"] = FengFan.Functions.clear_null(txtclient_id.Text).Length > 0 ? Label_client_name.Text : "零售";
                        row.EndEdit();
                    }
                    else
                        common.Uerr_str(UpdatePanel1, Label_product_name.Text + "的库存数不够,最多能销售" + stroe_scount.ToString());
                }
                IU_Statu.Value = "I";
                view = new DataView(DT);
                GridView1.DataSource = view;
                GridView1.DataBind();
                GridView1.Columns[0].Visible = true;
                GridView1.Columns[9].Visible = false;
                GridView1.Columns[10].Visible = false;
                GridView1.Columns[11].Visible = false;
                GridView1.Columns[13].Visible = true;

                TR1.Visible = false;


                tr2.Visible = true;
                _Null();
            }
            else

                common.Uerr_str(UpdatePanel1, "对不起，最后一次结算日期是："+last_month_date+",销售日期不得小于该日期!!");
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                LinkButton addButton3 = (LinkButton)e.Row.FindControl("LinkButton3");
                addButton3.CommandArgument = e.Row.RowIndex.ToString();
                LinkButton addButton4 = (LinkButton)e.Row.FindControl("LinkButton4");
                addButton4.CommandArgument = e.Row.RowIndex.ToString();

                addButton4.Attributes.Add("onclick", "return confirm('确定要删除成品输入单：" + FengFan.Functions.clear_null(e.Row.Cells[0].Text.Trim()) + " 吗?');");
                _amount += Double.Parse(e.Row.Cells[6].Text);

                Lsum_amount.Text = _amount.ToString();
            }
            
            if (e.Row.RowType == DataControlRowType.Header)
            {
                Button Button66 = (Button)e.Row.FindControl("Button6");

                Button66.Attributes.Add("onclick", "return confirm('确定要取消" + Label_bill_id.Text + "吗?');");
            }
            if (e.Row.RowType == DataControlRowType.Footer)
            {
                Button Button22 = (Button)e.Row.FindControl("Button2");
            }
        }

        protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            try
            {
                DT.Rows[e.RowIndex].Delete();
                DataView view;
                DT.Rows.Clear();
                view = new DataView(DT);
                GridView1.DataSource = view;
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
                FengFan.MessageBox.Show(Page, ex.Message.Replace("\r\n", "").Replace("'", "\""));
            }
            finally
            {
                _Null();
            }
        }

        protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Select")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewRow row = GridView1.Rows[index];

                string expression;
                expression = "output_id="+FengFan.Functions.clear_null(row.Cells[0].Text.Trim());
                DataRow[] foundRows;

                foundRows = DT.Select(expression);


                product_output_id.Value = FengFan.Functions.clear_null(foundRows[0]["output_id"].ToString());
                txt_product_id.Text = FengFan.Functions.clear_null(foundRows[0]["product_id"].ToString());
                Label_product_name.Text = FengFan.Functions.clear_null(foundRows[0]["product_name"].ToString());
                txt_product_sn.Text = FengFan.Functions.clear_null(foundRows[0]["product_sn"].ToString());

                txtclient_id.Text = FengFan.Functions.clear_null(foundRows[0]["client"].ToString());
                Label_client_name.Text = FengFan.Functions.clear_null(foundRows[0]["client_name"].ToString());

                txt_scount.Text = FengFan.Functions.clear_null(foundRows[0]["scount"].ToString());
                txt_price.Text = FengFan.Functions.clear_null(foundRows[0]["price"].ToString());
                HiddenField_store_scount.Value = txt_scount.Text;


                DropDownList_money_id.SelectedIndex = DropDownList_money_id.Items.IndexOf(DropDownList_money_id.Items.FindByText(FengFan.Functions.clear_null(foundRows[0]["money_name"].ToString())));
                txtremark.Text = FengFan.Functions.clear_null(foundRows[0]["remark"].ToString());

                IU_Statu.Value = "U";

            }
        }
        private decimal get_product_price(string product_id)
        {
                DataClass.product_price ws1 = new DataClass.product_price();
                Model.BaseData.product_price model1 = new Model.BaseData.product_price();

                model1 = ws1.GetModel(Int32.Parse(txt_product_id.Text));


                int user_price = Int16.Parse(System.Web.HttpContext.Current.Session["User_price"].ToString());
                decimal _price = 0;
                if (user_price == 1) _price = model1.price1;
                if (user_price == 2) _price = model1.price2;
                if (user_price == 3) _price = model1.price3;
                if (user_price == 4) _price = model1.price4;
                if (user_price == 5) _price = model1.price5;

                return _price;
        }
        protected void Button4_Click(object sender, EventArgs e)
        {
            DataClass.BaseData ws = new DataClass.BaseData();
            Model.BaseData.material_list model = new Model.BaseData.material_list();
            model = ws.GetMaterialListModel(txt_product_id.Text.Trim());

            if (model!=null)
            {
                txt_product_id.Text = model.material_id.ToString();
                Label_product_codeid.Text = model.CodeId;
                Label_product_name.Text = model.sname;
                txt_price.Text = get_product_price(txt_product_id.Text).ToString();
            }
            else
                common.Uerr_str(UpdatePanel1, "该条形码没有注册,请通过查询方式找该产品!!");
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            if (Label_bill_id.Text.Length > 0)
            {

                if (txtclient_id.Text.Trim().Length == 0 && Double.Parse(Lsum_amount.Text) > Double.Parse(TextBox2.Text))
                {
                    common.Uerr_str(UpdatePanel1, "对不起,本次销售为[零售],不能欠款!!");
                    return;
                }
                else
                {
                    Model.Client_Pay model_Pay = new Model.Client_Pay();
                    DataClass.Client_Pay ws_Pay = new DataClass.Client_Pay();

                    if (txtclient_id.Text.Trim().Length != 0)
                    {
                        if (Double.Parse(Lsum_amount.Text) <= Double.Parse(TextBox2.Text))
                        {
                            model_Pay.amount = Decimal.Parse(Lsum_amount.Text);
                            common.Uerr_str(UpdatePanel1, "本次销售应付:" + Lsum_amount.Text + "实付:" + TextBox2.Text + ",应找零:" + Convert.ToString(Double.Parse(TextBox2.Text) - Double.Parse(Lsum_amount.Text)));
                        }
                        else
                        {
                            model_Pay.amount = Decimal.Parse(TextBox2.Text);
                            common.Uerr_str(UpdatePanel1, "本次销售应付:" + Lsum_amount.Text + "实付:" + TextBox2.Text + ",欠款为:" + Convert.ToString(Double.Parse(Lsum_amount.Text) - Double.Parse(TextBox2.Text)) + ",到时结清余款!!");
                        }
                    }
                    else
                    {
                        model_Pay.amount = Decimal.Parse(Lsum_amount.Text);
                        common.Uerr_str(UpdatePanel1, "本次销售应付:" + Lsum_amount.Text + "实付:" + TextBox2.Text + ",应找零:" + Convert.ToString(Double.Parse(TextBox2.Text) - Double.Parse(Lsum_amount.Text)));
                    }

                    Model.product_output model = new Model.product_output();
                    DataClass.product_output ws = new DataClass.product_output();
                    foreach (DataRow dr in DT.Rows)
                    {

                        model.product_id = Int32.Parse(dr["product_id"].ToString());

                        model.remark = dr["remark"].ToString();
                        model.product_sn = dr["product_sn"].ToString().Trim();
                        model.money_id = Int16.Parse(dr["money_id"].ToString());

                        model.scount = Convert.ToInt32(dr["scount"].ToString());

                        model.price = Convert.ToDecimal(dr["price"].ToString());

                        model.seller_id = Int16.Parse(D_seller.SelectedItem.Value);

                        model.sdate = dr["sdate"].ToString();
                        model.bill_id = Label_bill_id.Text;
                        model.client = txtclient_id.Text;

                        model.sman = Session["User_Name"].ToString();
                        model.dept_id = dr["dept_id"].ToString();


                        ws.Add(model);

                    }
                    if(CheckBox1.Checked)
                 //    _print("01" + Label_bill_id.Text.Trim(), Session["Dept_ID"].ToString());

                  //  model_Pay.dd_id="01"+Label_bill_id.Text.Trim();

                    model_Pay.sman=Session["User_Name"].ToString();
                    model_Pay.sdate = DateTime.Now.ToString("yyyy-MM-dd"); 
                    model_Pay.pay_Way=0;  //零售现付     1,2,3.....付款方式   现金   银行等
                    if (txtclient_id.Text.Trim().Length != 0)
                  
                    model_Pay.remark="注册客户前台销售";
                    else

                        model_Pay.remark = "前台销售";
                    model_Pay.dept_id = Session["Dept_ID"].ToString();
                    model_Pay.client_id = txtclient_id.Text;

                    string op_id = "";
                    if (model_Pay.amount > 0)
                    {
                        op_id = ws_Pay.Add(model_Pay);
                        ws_Pay.insert_into_Client_Pay(op_id, txtclient_id.Text, "01" + Label_bill_id.Text.Trim(), Session["Dept_ID"].ToString(), model_Pay.amount);

                    }

                    Label_bill_id.Text = "";
                    Lsum_amount.Text = "0";
                    D_seller.SelectedIndex = 0;

                    txtclient_id.Text ="";
                    Label_client_name.Text = "";
                    _Null();

                    _amount = 0;

                    TextBox2.Text = "0";

                     tr2.Visible = false;
                    DataView view;
                    DT.Rows.Clear();
                    view = new DataView(DT);
                    GridView1.DataSource = view;
                    GridView1.DataBind();
                }
            }
        }

        protected void Button6_Click(object sender, EventArgs e)
        {
            if (Label_bill_id.Text.Length > 0)
            {
                Label_bill_id.Text = "";
                DataView view;
                DT.Rows.Clear();
                view = new DataView(DT);
                GridView1.DataSource = view;
                GridView1.DataBind();
            }
        }

        protected void Button7_Click(object sender, EventArgs e)
        {
            if (DT.Rows.Count == 0)
                Client_query1.Visible = true;
            else
                common.Uerr_str(UpdatePanel1, "对不起,单次销售不能选择不同的客户!!");
        }


        protected void _print(string output_id, string dept_id)
        {
            DataClass.product_output ws = new DataClass.product_output();

            DataSet ds = ws.Getprint_data(output_id, dept_id);
            DataTable mydt = ds.Tables[0];
            Microsoft.Reporting.WebForms.LocalReport rpt = new Microsoft.Reporting.WebForms.LocalReport();
            rpt.ReportPath = Server.MapPath("product_output.rdlc");

            DataClass.BaseData Company_ws = new DataClass.BaseData();
            Model.BaseData.Company_data model = new Model.BaseData.Company_data();
            model = Company_ws.GetCompany_dataModel();
            ReportParameter rptParacompany_name = new ReportParameter("company_name", model.sname);
            rpt.SetParameters(new ReportParameter[] { rptParacompany_name });
            ReportParameter rptParacompany_address = new ReportParameter("company_address", model.address);
            rpt.SetParameters(new ReportParameter[] { rptParacompany_address });
            ReportParameter rptParacompany_tel = new ReportParameter("company_tel", model.tel);
            rpt.SetParameters(new ReportParameter[] { rptParacompany_tel });
            ReportParameter rptParacompany_fax = new ReportParameter("company_fax", model.fax);
            rpt.SetParameters(new ReportParameter[] { rptParacompany_fax });
            ReportParameter rptParacompany_sman = new ReportParameter("company_sman", model.sman);
            rpt.SetParameters(new ReportParameter[] { rptParacompany_sman });

            ReportParameter rptParaC_Amount = new ReportParameter("C_Amount", ds.Tables[1].Rows[0][0].ToString());
            rpt.SetParameters(new ReportParameter[] { rptParaC_Amount });


            ReportDataSource rds = new ReportDataSource("product_output", mydt);
            rpt.DataSources.Clear();
            rpt.DataSources.Add(rds);

            // 由报表生成 PDF 文件，并保存在内存中
            Microsoft.Reporting.WebForms.Warning[] Warnings;
            string[] strStreamIds;
            string strMimeType;
            string strEncoding;
            string strFileNameExtension;

            byte[] bytes = rpt.Render("PDF", null, out strMimeType, out strEncoding, out strFileNameExtension,
                out strStreamIds, out Warnings);

            // 通过 Session 将动态生成的PDF文件的内容与 MyHandler 共享
            FengFan.MyHandler.content_type = "application/pdf";
            FengFan.MyHandler.content = bytes;

            // 打开一个新的窗体，向 MyHandler.jxd 发出访问请求
            if (!Page.ClientScript.IsStartupScriptRegistered(Page.GetType(), "OpenFile"))
            {
                Page.ClientScript.RegisterStartupScript(Page.GetType(), "OpenFile",
                    "window.open('MyHandler.dxd');", true);
            }

        }


    }
}