﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace computer.stock
{
    public partial class provide_list : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
               // Page.Title = common.CompanyName() + Page.Title;
                common.Init_DropDown_Item(DropDownList_money_unit, "SELECT momey_unit_id, momey_unit_name FROM momey_unit_list ORDER BY money_id ");
                common.Init_DropDown_Item(provide_type_id, "SELECT     provide_type_id, provide_type_name FROM         provide_type ORDER BY provide_type_id ");
                common.Init_DropDown_Item(Q_provide_type_id, "SELECT     provide_type_id, provide_type_name FROM         provide_type ORDER BY provide_type_id ");


                if (common.get_right(Session["User_ID"].ToString(), "stock@provide_list", "_insert")) Button3.Visible = true; else Button3.Visible = false;
                if (common.get_right(Session["User_ID"].ToString(), "stock@provide_list", "_insert")) Button2.Visible = true; else Button2.Visible = false;

                get_provide_list(1);
                get_Count();
                TD1.Visible = false;
            }

        }
        protected void get_provide_list(int CurrentPage)
        {
            try
            {
                DataClass.provide_list ws = new DataClass.provide_list();
                GridView1.DataSource = ws.GetprovideList(TextBox1.Text.Trim(), TextBox2.Text.Trim(),TextBox3.Text.Trim(),Int16.Parse(Q_provide_type_id.SelectedItem.Value), CurrentPage);
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//８４２８８８０８
        }
        protected void get_Count()
        {
            try
            {
                DataClass.provide_list ws = new DataClass.provide_list();
                int[] _ws = (int[])ws.GetprovideList_Count(TextBox1.Text.Trim(), TextBox3.Text.Trim(), TextBox2.Text.Trim(), Int16.Parse(Q_provide_type_id.SelectedItem.Value));
               AspNetPager1.CurrentPageIndex = 1;
               AspNetPager1.PageSize = _ws[0];//页面尺寸
                AspNetPager1.RecordCount = _ws[1];
                TotalCount.Text = _ws[1].ToString();//总记录数
               PageCount.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }
        }
        protected void _Null()
        {
            txtprovide_id.Text = "";
            txtsname.Text = "";
            txtsman.Text = "";
            txtabrv.Text = "";
            txtaddress.Text = "";
            txttel.Text = "";
            txtfax.Text = "";
            txtmobil.Text = "";
            txtemail.Text = "";
            txtremark.Text = "";
            txtfirst_amount.Text = "0";
            
            IU_Statu.Value = "I";
            txtprovide_id.Enabled = true;
            Button2.Text = "新增";
            TD1.Visible = false;
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            if (Button2.Text == "取消")
            {
                _Null();
                TD1.Visible = false;
            }
            else
            {
                _Null();
                TD1.Visible = true;
                Button2.Text = "取消";
            }
        }

        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            get_provide_list(AspNetPager1.CurrentPageIndex);
        }

        protected void Button1_Click(object sender, EventArgs e)
        {

            get_provide_list(1);
            get_Count();
        }

        protected void Button3_Click(object sender, EventArgs e)
        {
            try
            {
                DataClass.provide_list ws = new DataClass.provide_list();
                Model.BaseData.provide_list model = new Model.BaseData.provide_list();
                model.provide_id = txtprovide_id.Text;
                model.sname = txtsname.Text;
                model.sman = txtsman.Text;
                model.address = txtaddress.Text;
                model.money_unit_id = DropDownList_money_unit.SelectedItem.Value;
                model.tel = txttel.Text;
                model.fax = txtfax.Text;
                model.mobil = txtmobil.Text;
                model.email = txtemail.Text;
                model.First_amount = Decimal.Parse(txtfirst_amount.Text.Trim());
                model.provide_type_id = Int16.Parse(provide_type_id.SelectedItem.Value);

                if (txtabrv.Text.Trim().Length > 0)
                    model.abrv = txtabrv.Text;
                else
                    model.abrv = FengFan.PY.getSpells(txtsname.Text);


                model.remark = txtremark.Text;
              
                if (IU_Statu.Value == "I")
                {
                    try
                    {
                        ws.Add(model);
                        _Null();
                    }
                    catch (Exception ex)
                    {
                        FengFan.MessageBox.Show(this.Page,ex.ToString());// "供应商编号"+txtprovide_id.Text+"已经存在!!");
                    }
                    finally
                    {
                        get_provide_list(AspNetPager1.CurrentPageIndex);
                    }
                }
                else
                {
                    try
                    {
                        ws.Update(model);
                        _Null();
                    }
                    catch (Exception ex)
                    {
                        common.Uerr_str(UpdatePanel1, ex.ToString());
                    }
                    finally
                    {
                        get_provide_list(AspNetPager1.CurrentPageIndex);
                    }
                }
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }

        }

        protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Select")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewRow row = GridView1.Rows[index];


                DataClass.provide_list ws = new DataClass.provide_list();
                Model.BaseData.provide_list model = new Model.BaseData.provide_list();

                model = ws.GetModel(FengFan.Functions.clear_null(row.Cells[0].Text.Trim()));

                txtprovide_id.Text = model.provide_id;
                txtsname.Text = model.sname;
                txtsman.Text = model.sman;
                txtabrv.Text = FengFan.Functions.clear_null(model.abrv);
                txtaddress.Text = model.address;
                txttel.Text = model.tel;
                txtfax.Text = model.fax;
                txtmobil.Text = model.mobil;

                txtfirst_amount.Text = model.First_amount.ToString();

                txtemail.Text = model.email;
                txtremark.Text = FengFan.Functions.clear_null(model.remark);
                DropDownList_money_unit.SelectedIndex = DropDownList_money_unit.Items.IndexOf(DropDownList_money_unit.Items.FindByValue(FengFan.Functions.clear_null(model.money_unit_id)));
                provide_type_id.SelectedIndex = provide_type_id.Items.IndexOf(provide_type_id.Items.FindByValue(FengFan.Functions.clear_null(model.provide_type_id.ToString())));
                txtprovide_id.Enabled = false;
                TD1.Visible = true;
                Button2.Text = "取消";
                IU_Statu.Value = "U";
            }
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {

            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                LinkButton addButton3 = (LinkButton)e.Row.FindControl("LinkButton3");
                addButton3.CommandArgument = e.Row.RowIndex.ToString();
                LinkButton addButton4 = (LinkButton)e.Row.FindControl("LinkButton4");
                addButton4.CommandArgument = e.Row.RowIndex.ToString();

                addButton4.Attributes.Add("onclick", "return confirm('确定要删除供应商：" + FengFan.Functions.clear_null(e.Row.Cells[1].Text.Trim()) + " 吗?');");

                if (common.get_right(Session["User_ID"].ToString(), "stock@provide_list", "_modify")) addButton3.Visible = true; else addButton3.Visible = false;
                if (common.get_right(Session["User_ID"].ToString(), "stock@provide_list", "_delete")) addButton4.Visible = true; else addButton4.Visible = false;
            }
        }

        protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            GridViewRow row = GridView1.Rows[e.RowIndex];
            try
            {
                DataClass.provide_list ws = new DataClass.provide_list();
                ws.Delete(FengFan.Functions.clear_null(row.Cells[0].Text.Trim()));
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.Message.Replace("\r\n", "").Replace("'", "\""));
            }
            finally
            {
                get_provide_list(AspNetPager1.CurrentPageIndex);
                _Null();
            }
        }
    }
}
