﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace computer.stock
{
    public partial class stock_data : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
               // Page.Title = common.CompanyName() + Page.Title;
                provide_query1.Visible = false;
                stock_remark1.Visible = false;
                TD1.Visible = false;
                common.Init_DropDown_Item(DropDownList_payment, "SELECT payment_id, sname FROM payment_list order by payment_id");
                common.Init_DropDown_Item(DropDownList_money_unit, "SELECT money_id, momey_unit_name FROM momey_unit_list ORDER BY money_id");
                common.Init_DropDown_for_Dept(txtjh_astockress);//DropDownList1

                get_stock_data(1);
                get_Count();
                txt_xd_date.Text = DateTime.Now.ToString("yyyy-MM-dd");
            }

        }

        public override void VerifyRenderingInServerForm(Control control)
        {
            // Confirms that an HtmlForm control is rendered for
        }
        protected void get_stock_data(int CurrentPage)
        {
            try
            {
                DataClass.stock_list ws = new DataClass.stock_list();
                GridView1.DataSource = ws.GetStockList(20, Session["Dept_ID"].ToString(), Q_provide_name.Text.Trim(), Q_xd_date_from.Text.Trim(), Q_xd_date_to.Text.Trim(), Q_jh_date_from.Text.Trim(), Q_jh_date_to.Text.Trim(), Int16.Parse(Q_stock_statu.SelectedItem.Value), CurrentPage);
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//８４２８８８０８
        }
        protected void get_Count()
        {
            try
            {
                DataClass.stock_list ws = new DataClass.stock_list();
                int[] _ws = (int[])ws.GetStocklist_Count(20, Session["Dept_ID"].ToString(), Q_provide_name.Text.Trim(), Q_xd_date_from.Text.Trim(), Q_xd_date_to.Text.Trim(), Q_jh_date_from.Text.Trim(), Q_jh_date_to.Text.Trim(), Int16.Parse(Q_stock_statu.SelectedItem.Value));
               AspNetPager1.CurrentPageIndex = 1;
               AspNetPager1.PageSize = _ws[0];//页面尺寸
                AspNetPager1.RecordCount = _ws[1];
                TotalCount.Text = _ws[1].ToString();//总记录数
               PageCount.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }
        }
        protected void _Null()
        {

            txtstock_id.Value = "0";
            txtprovide_id.Text = "";
            txtremark.Text = "";
            //txtjh_astockress.Text = "";
            Label_provide_name.Text = "";
            HiddenField_dept_id.Value = "";
            IU_Statu.Value = "I";
            txt_xd_date.Text = DateTime.Now.ToString("yyyy-MM-dd");
               /* */
            Button2.Text = "新增";
            TD1.Visible = false;
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            if (Button2.Text == "取消")
            {
                _Null();
                TD1.Visible = false;
            }
            else
            {
                _Null();
                TD1.Visible = true;
                Button2.Text = "取消";
            }
        }

        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            get_stock_data(AspNetPager1.CurrentPageIndex);
        }

        protected void Button1_Click(object sender, EventArgs e)
        {

            get_stock_data(1);
            get_Count();
        }

        protected void Button3_Click(object sender, EventArgs e)
        {

            try
            {
                DataClass.stock_list ws = new DataClass.stock_list();
                Model.BaseData.stock_list model = new Model.BaseData.stock_list();

                model.stock_id = txtstock_id.Value;
                model.provide_id = txtprovide_id.Text;
                model.remark = txtremark.Text;
                model.xd_man = Session["User_Name"].ToString();
                model.dept_id = Session["Dept_ID"].ToString();
                model.xd_date = txt_xd_date.Text;

                model.jh_address = txtjh_astockress.SelectedItem.Value;
                model.payment_id = Int16.Parse(DropDownList_payment.SelectedItem.Value);
                model.money_id = Int16.Parse(DropDownList_money_unit.SelectedItem.Value);
                /**/

                if (IU_Statu.Value == "I")
                {
                    try
                    {
                        ws.Add(model);
                        _Null();
                    }
                    catch
                    {
                        common.Uerr_str(UpdatePanel1, "输入不正确，请检查！！");
                    }
                    finally
                    {
                        get_stock_data(AspNetPager1.CurrentPageIndex);
                    }
                }
                else
                {
                    try
                    {

                        model.dept_id =HiddenField_dept_id.Value;
                        ws.Update(model);
                        _Null();
                    }
                    catch
                    {
                        common.Uerr_str(UpdatePanel1, "输入不正确，请检查！！");
                    }
                    finally
                    {
                        get_stock_data(AspNetPager1.CurrentPageIndex);
                    }
                }
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString().Replace("\r\n", "").Replace("'", "\""));
            }
        }

        protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
        {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewRow row = GridView1.Rows[index];
                DataClass.stock_list ws = new DataClass.stock_list();
                if (e.CommandName == "Select")
                {

                    if (!DataClass.stock_list.exists_input(FengFan.Functions.clear_null(row.Cells[0].Text.Trim())))
                    {
                        Model.BaseData.stock_list model = new Model.BaseData.stock_list();

                        model = ws.GetModel(FengFan.Functions.clear_null(row.Cells[0].Text.Trim()), row.Cells[11].Text.Trim());

                        txtstock_id.Value = model.stock_id.ToString();
                        txtprovide_id.Text = model.provide_id.ToString();

                        txtremark.Text = model.remark;
                       txt_xd_date.Text =  model.xd_date;
                        HiddenField_dept_id.Value = row.Cells[11].Text.Trim();

                        Label_provide_name.Text = model.provide_name;

                        DropDownList_payment.SelectedIndex = DropDownList_payment.Items.IndexOf(DropDownList_payment.Items.FindByValue(FengFan.Functions.clear_null(model.payment_id.ToString())));
                        DropDownList_money_unit.SelectedIndex = DropDownList_money_unit.Items.IndexOf(DropDownList_money_unit.Items.FindByValue(FengFan.Functions.clear_null(model.money_id.ToString())));

                        txtjh_astockress.SelectedIndex = txtjh_astockress.Items.IndexOf(txtjh_astockress.Items.FindByValue(FengFan.Functions.clear_null(model.jh_address)));

                        Button2.Text = "取消";
                        IU_Statu.Value = "U";
                        TD1.Visible = true;
                    }

                    else
                        common.Uerr_str(UpdatePanel1, "该采购单已经入库或已经部分入库，如确需修改，请先删除此采购单对应的入库！！");
                }
            if (e.CommandName == "sk")
            {
                ws.stock_sk(row.Cells[0].Text.Trim(), row.Cells[11].Text.Trim(), Session["User_Name"].ToString());
                get_stock_data(AspNetPager1.CurrentPageIndex);
            }
            if (e.CommandName == "jh")
            {
                ws.stock_jh(row.Cells[0].Text.Trim(), row.Cells[11].Text.Trim());
                get_stock_data(AspNetPager1.CurrentPageIndex);
            }
            if (e.CommandName == "jd")
            {
                ws.stock_jd(row.Cells[0].Text.Trim(), row.Cells[11].Text.Trim());
                get_stock_data(AspNetPager1.CurrentPageIndex);
            }


            if (e.CommandName == "cancel_sk")
            {
                ws.stock_cancel_sk(row.Cells[0].Text.Trim(), row.Cells[11].Text.Trim());
                get_stock_data(AspNetPager1.CurrentPageIndex);
            }
            if (e.CommandName == "cancel_jh")
            {
                ws.stock_cancel_jh(row.Cells[0].Text.Trim(), row.Cells[11].Text.Trim());
                get_stock_data(AspNetPager1.CurrentPageIndex);
            }
            if (e.CommandName == "cancel_jd")
            {
                ws.stock_cancel_jd(row.Cells[0].Text.Trim(), row.Cells[11].Text.Trim());
                get_stock_data(AspNetPager1.CurrentPageIndex);
            }
            if (e.CommandName == "remark")
            {
                stock_remark1.Stock_Id = row.Cells[0].Text.Trim();
                stock_remark1.Client_Name = row.Cells[1].Text.Trim();
                stock_remark1.Stock_amount = ws.GetModel(row.Cells[0].Text.Trim(), row.Cells[11].Text.Trim()).stock_amount.ToString();
                stock_remark1.Money_ID = ws.GetModel(row.Cells[0].Text.Trim(), row.Cells[11].Text.Trim()).money_id;
                stock_remark1.Dept_Id = row.Cells[11].Text.Trim();
                stock_remark1.get_data();
                stock_remark1.Visible = true;
                TABLE1.Visible = false;
            }
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {

            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                LinkButton astockButton3 = (LinkButton)e.Row.FindControl("LinkButton3");
                astockButton3.CommandArgument = e.Row.RowIndex.ToString();
                LinkButton astockButton4 = (LinkButton)e.Row.FindControl("LinkButton4");
                astockButton4.CommandArgument = e.Row.RowIndex.ToString();

                astockButton4.Attributes.Add("onclick", "return confirm('确定要删除订单：" + FengFan.Functions.clear_null(e.Row.Cells[0].Text.Trim()) + " 吗?');");


                LinkButton astockButton1 = (LinkButton)e.Row.FindControl("LinkButton1");
               // LinkButton astockButton2 = (LinkButton)e.Row.FindControl("LinkButton2");
               // LinkButton astockButton5 = (LinkButton)e.Row.FindControl("LinkButton5");
                astockButton1.CommandArgument = e.Row.RowIndex.ToString();

                astockButton1.Visible = true;
              //  astockButton2.Visible = false;
              //  astockButton5.Visible = false;
                if (FengFan.Functions.clear_null(e.Row.Cells[3].Text.Trim()).Length == 0)
                {

                    astockButton3.Visible = true;
                    astockButton4.Visible = true;

                    astockButton1.CommandName = "sk";
                    astockButton1.Text = "审核";
                    astockButton1.Attributes.Add("onclick", "return confirm('订单：" + FengFan.Functions.clear_null(e.Row.Cells[0].Text.Trim()) + "确定确认审核 吗?');");
                }
                else
                {
                    astockButton3.Visible = false;
                    astockButton4.Visible = false;

                    astockButton1.CommandName = "cancel_sk";
                   // astockButton2.Visible = true;
                    astockButton1.Text = "取消审核";
                    astockButton1.Attributes.Add("onclick", "return confirm('订单：" + FengFan.Functions.clear_null(e.Row.Cells[0].Text.Trim()) + "确定取消审核 吗?');");


                    if (FengFan.Functions.clear_null(e.Row.Cells[4].Text.Trim()).Length == 0)

                        astockButton1.Visible = true;
                    else
                        astockButton1.Visible = false;

                    //astockButton2.Visible = true;
                    //astockButton2.CommandArgument = e.Row.RowIndex.ToString();
                    //if (FengFan.Functions.clear_null(e.Row.Cells[4].Text.Trim()).Length == 0)
                    //{
                    //    astockButton1.Visible = true;
                    //    astockButton2.CommandName = "jh";
                    //    astockButton2.Text = "交货";
                    //    astockButton2.Attributes.Add("onclick", "return confirm('订单：" + FengFan.Functions.clear_null(e.Row.Cells[0].Text.Trim()) + "确定确认已经交货了 吗?');");
                    //}
                    //else
                    //{
                    //    astockButton1.Visible = false;
                    //    astockButton5.Visible = true;

                    //    astockButton2.CommandName = "cancel_jh";
                    //    astockButton2.Text = "取消交货";
                    //    astockButton2.Attributes.Add("onclick", "return confirm('订单：" + FengFan.Functions.clear_null(e.Row.Cells[0].Text.Trim()) + "确定取消交货 吗?');");



                        //astockButton5.Visible = true;
                        //astockButton5.CommandArgument = e.Row.RowIndex.ToString();
                        //if (FengFan.Functions.clear_null(e.Row.Cells[5].Text.Trim()).Length == 0)
                        //{
                        //    astockButton5.CommandName = "jd";
                        //    astockButton5.Text = "结单";
                        //    astockButton5.Attributes.Add("onclick", "return confirm('订单：" + FengFan.Functions.clear_null(e.Row.Cells[0].Text.Trim()) + "确定确认已经付款，可以结单了 吗?');");
                        //}
                        //else
                        //{
                        //    astockButton2.Visible = false;
                        //    astockButton5.CommandName = "cancel_jd";
                        //    astockButton5.Text = "取消结单";
                        //    astockButton5.Attributes.Add("onclick", "return confirm('订单：" + FengFan.Functions.clear_null(e.Row.Cells[0].Text.Trim()) + "确定取消结单 吗?');");
                        //}
                    
                }

                LinkButton astockButton6 = (LinkButton)e.Row.FindControl("LinkButton6");
                astockButton6.CommandArgument = e.Row.RowIndex.ToString();

                if (FengFan.Functions.clear_null(e.Row.Cells[3].Text.Trim()).Length == 0)
                    astockButton6.Visible = true;
                else astockButton6.Visible = false;

            }
        }

        protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            GridViewRow row = GridView1.Rows[e.RowIndex];
            try
            {
                if (!DataClass.stock_list.exists_input(FengFan.Functions.clear_null(row.Cells[0].Text.Trim())))
                {
                DataClass.stock_list ws = new DataClass.stock_list();
                ws.Delete(FengFan.Functions.clear_null(row.Cells[0].Text.Trim()), row.Cells[11].Text.Trim());
                }

                else
                    common.Uerr_str(UpdatePanel1, "该采购单已经入库或已经部分入库，如确需修改，请先删除此采购单对应的入库！！");
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.Message.Replace("\r\n", "").Replace("'", "\""));
            }
            finally
            {
                get_stock_data(AspNetPager1.CurrentPageIndex);
                _Null();
            }
        }

        protected void Button4_Click(object sender, EventArgs e)
        {
            provide_query1.Visible = true;
        }
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            provide_query1.SelectEvent += new EventHandler(get_provide_id);


            stock_remark1.CloseEvent += new EventHandler(clost_stock_remark);
            provide_query1.CancelEvent += new EventHandler(cancel_provide_select);
        }
        private void get_provide_id(object sender, EventArgs e)
        {
            // FengFan.MessageBox.Show(this.Page,"ccccccccccccc");

            txtprovide_id.Text = provide_query1.select_provide_id;
            Label_provide_name.Text = provide_query1.select_provide_name;
            provide_query1.Visible = false;
        }
        private void clost_stock_remark(object sender, EventArgs e)
        {
            TABLE1.Visible = true;
            stock_remark1.Visible = false;
            get_stock_data(AspNetPager1.CurrentPageIndex);
        }
        private void cancel_provide_select(object sender, EventArgs e)
        {
            provide_query1.Visible = false;
        }

        protected void Button6_Click(object sender, EventArgs e)
        {
            DataClass.stock_list ws = new DataClass.stock_list();
            ws._print_stock_data(HiddenField_dept_id.Value, Q_provide_name.Text.Trim(), Q_xd_date_from.Text.Trim(), Q_xd_date_to.Text.Trim(), Q_jh_date_from.Text.Trim(), Q_jh_date_to.Text.Trim(), Int16.Parse(Q_stock_statu.SelectedItem.Value));
                string path = Server.MapPath("../report_file/") + "/stock_data_print";
                // common.Uerr_str(UpdatePanel1, path);
                pdf_print(path);           
        }

        private void pdf_print(string path_str)
        {
            Context.Response.ClearContent();
            Context.Response.ClearHeaders();
            Context.Response.ContentType = "application/pdf";

         //   Response.Write(FengFan.Functions.Report2PDF(path_str));
            //Response.Flush();
            //Response.Close();
        }

        protected void Button5_Click(object sender, EventArgs e)
        {
            TABLE1.Visible =true ;
        }

        protected void Button7_Click(object sender, EventArgs e)
        {
            TABLE1.Visible = true;
        }

        protected void GridView1_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[11].Visible = false;  
        }
    }
}
