﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace computer.store
{
    public partial class dept_store_query : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
               // Page.Title = common.CompanyName() + Page.Title;
                common.Init_DropDown_for_Dept(DropDownList_dept_id);//DropDownList1
               DropDownList_dept_id.Items.RemoveAt(0);
               DropDownList_dept_id.SelectedIndex = DropDownList_dept_id.Items.IndexOf(DropDownList_dept_id.Items.FindByValue(Session["Dept_ID"].ToString()));
               mytreeview ws = new mytreeview();
               ws.ShowTv(TreeView1);
                get_data();
            }
        }
        protected void get_data()
        {
            get_product_store_list(1);
            get_Count();
        }
        protected DataSet get_print_data()
        {
            DataClass.product_output ws = new DataClass.product_output();
            return ws.Product_dept_store_EXCEL(H_stype.Value, txt_product_id.Text.Trim(), TextBox_product_name.Text.Trim(), DropDownList_dept_id.SelectedItem.Value);
        }
        protected void get_product_store_list(int CurrentPage)
        {
            try
            {
                DataClass.product_output ws = new DataClass.product_output();
                GridView1.DataSource = ws.GetstoreList(H_stype.Value, txt_product_id.Text.Trim(), TextBox_product_name.Text.Trim(), DropDownList_dept_id.SelectedItem.Value, CurrentPage);
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//
        }
        protected void get_Count()
        {
            try
            {
                DataClass.product_output ws = new DataClass.product_output();
                int[] _ws = (int[])ws.GetstroeList_Count(H_stype.Value, txt_product_id.Text.Trim(), TextBox_product_name.Text.Trim(), DropDownList_dept_id.SelectedItem.Value);
                AspNetPager1.CurrentPageIndex = 1;
                AspNetPager1.PageSize = _ws[0];//页面尺寸
                AspNetPager1.RecordCount = _ws[1];
                TotalCount.Text = _ws[1].ToString();//总记录数
                PageCount.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//
        }
        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            get_product_store_list(AspNetPager1.CurrentPageIndex);

        }
        protected void Button1_Click(object sender, EventArgs e)
        {
            Product_query1.get_material();
            Product_query1.Visible = true;
        }
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            Product_query1.CancelEvent += new EventHandler(Cancel_Product_Cancel_Select);

            Product_query1.SelectEvent += new EventHandler(Get_Product_Select);
        }

        private void Get_Product_Select(object sender, EventArgs e)
        {
            txt_product_id.Text = Product_query1.get_product_id;
            Label_product_name.Text = Product_query1.get_product_name;
            Label_product_codeid.Text = Product_query1.get_product_codeid;
            Product_query1.Visible = false;
        }

        private void Cancel_Product_Cancel_Select(object sender, EventArgs e)
        {
            Product_query1.Visible = false;
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            get_data();
        }

        public override void VerifyRenderingInServerForm(Control control)
        {
            // Confirms that an HtmlForm control is rendered for
        }
        protected void Button4_Click(object sender, EventArgs e)
        {

            DataTable dt = get_print_data().Tables[0];
         //   dt.Columns.Remove("stype");
            GridView2.Visible = true;
            GridView2.DataSource = dt;
            GridView2.DataBind();
            GridView2.Caption = DateTime.Now.ToString("yyyy-MM-dd") + "：" + DropDownList_dept_id.SelectedItem.Text +  H_stype_name.Value + "库存数";

            common.ToExcel(GridView2,"store");

            Response.End();
            GridView2.Visible = false;

       //   FengFan.ExcelEdit ExcelEdit1 = new FengFan.ExcelEdit();

          //  DataTable dt = get_print_data().Tables[0];

          //  ExcelEdit1.ExportToExcel(dt, Server.MapPath("store.xls"), DateTime.Now.ToString("yyyy-MM-dd") + "："+DropDownList_dept_id.SelectedItem.Text+"库存数", this.Page);
        }

        protected void TreeView1_SelectedNodeChanged(object sender, EventArgs e)
        {
            H_stype.Value = TreeView1.SelectedNode.Value;
            DataClass.BaseData ws = new DataClass.BaseData();
            H_stype_name.Value = ws.Get_material_type_class(Int16.Parse(H_stype.Value));
            GridView1.Caption = H_stype_name.Value;
            get_data();
        }
    }
}
