﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace computer.store
{
    public partial class first_input : System.Web.UI.Page
    {
        // protected contorls.half_product_query Half_product_query2;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
               // Page.Title = common.CompanyName() + Page.Title;
                common.Init_DropDown_for_Dept(DropDownList_Qdept_id);//DropDownList1
                DropDownList_Qdept_id.SelectedIndex = DropDownList_Qdept_id.Items.IndexOf(DropDownList_Qdept_id.Items.FindByValue(Session["Dept_ID"].ToString()));

                common.Init_DropDown_for_Dept(DropDownList_dept_id);//DropDownList1
                DropDownList_dept_id.SelectedIndex = DropDownList_dept_id.Items.IndexOf(DropDownList_dept_id.Items.FindByValue(Session["Dept_ID"].ToString()));

                if (DataClass.BaseData.is_MeiShi(Session["Dept_ID"].ToString()))
                {
                    DropDownList_Qdept_id.Enabled = false;
                    DropDownList_dept_id.Enabled = false;
                }
                else
                {
                    DropDownList_Qdept_id.Enabled = true;
                    DropDownList_dept_id.Enabled = true;
                }

                common.Init_DropDown_Item(DropDownList_money_id, "SELECT     money_id, momey_unit_name FROM         momey_unit_list order by money_id");//DropDownList1
                DropDownList_money_id.SelectedIndex = 1;
                TD1.Visible = false;
                first_input_id.Value = "0";
                get_first_input_list(1);
                get_Count();
            }
        }
        protected void get_first_input_list(int CurrentPage)
        {
            try
            {
                DataClass.first_input ws = new DataClass.first_input();
                GridView1.DataSource = ws.GetddList(0,TextBox1.Text.Trim(), TextBox3.Text.Trim(), TextBox4.Text.Trim(), DropDownList_Qdept_id.SelectedItem.Value, CurrentPage);
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//
        }
        protected void get_Count()
        {
            try
            {
                DataClass.first_input ws = new DataClass.first_input();
                int[] _ws = (int[])ws.GetddList_Count(0,TextBox1.Text.Trim(),  TextBox3.Text.Trim(), TextBox4.Text.Trim(), DropDownList_Qdept_id.SelectedItem.Value);
                AspNetPager1.CurrentPageIndex = 1;
                AspNetPager1.PageSize = _ws[0];//页面尺寸
                AspNetPager1.RecordCount = _ws[1];
                TotalCount.Text = _ws[1].ToString();//总记录数
                PageCount.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//
        }
        protected void _Null()
        {
            txt_product_id.Text = "";
            Label_product_name.Text = "";
            txt_scount.Text = "0";
            txt_price.Text = "0";
            txt_product_sn.Text = "";
            txtremark.Text = "";
            DropDownList_dept_id.SelectedIndex = DropDownList_dept_id.Items.IndexOf(DropDownList_dept_id.Items.FindByValue(Session["Dept_ID"].ToString()));

            DropDownList_money_id.SelectedIndex = 1;
            first_input_id.Value = "0";

            IU_Statu.Value = "I";
            Button2.Text = "新增";
            TD1.Visible = false;
        }
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            Dd_remark1.CancelEvent += new EventHandler(cancel_dd_select);

            Dd_remark1.SelectEvent += new EventHandler(get_dd_id);

        }


        private void cancel_dd_select(object sender, EventArgs e)
        {
            Dd_remark1.Visible = false;
        }

        private void get_dd_id(object sender, EventArgs e)
        {
            txt_product_id.Text = Dd_remark1.get_product_id;
            Label_product_name.Text = Dd_remark1.get_product_name;
            Dd_remark1.Visible = false;
        }

        protected void Button1_Click(object sender, EventArgs e)
        {

            get_first_input_list(1);
            get_Count();
        }

        protected void Button5_Click(object sender, EventArgs e)
        {
            Dd_remark1.get_material();
            Dd_remark1.Visible = true;
        }

        protected void Button2_Click(object sender, EventArgs e)
        {

            if (Button2.Text == "取消")
            {
                _Null();
                TD1.Visible = false;
            }
            else
            {
                _Null();
                TD1.Visible = true;
                Button2.Text = "取消";
            }
        }

        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            get_first_input_list(AspNetPager1.CurrentPageIndex);
        }

        protected void Button3_Click(object sender, EventArgs e)
        {
            if (!FengFan.Functions.IsInt(txt_scount.Text))
                common.Uerr_str(UpdatePanel1, "数量输入不正确，请检查！！");
            else
            {
                try
                {
                    DataClass.first_input ws = new DataClass.first_input();
                    Model.first_input model = new Model.first_input();

                    model.product_id = Int32.Parse(txt_product_id.Text);
                    model.remark = txtremark.Text;
                    model.product_sn = txt_product_sn.Text.Trim();
                    model.money_id = Int16.Parse(DropDownList_money_id.SelectedItem.Value);
                    model.dept_id = DropDownList_dept_id.SelectedItem.Value;

                    model.scount = Convert.ToInt32(txt_scount.Text);

                    model.price = Convert.ToDecimal(txt_price.Text);
                    model.input_id = first_input_id.Value;

                    model.sman = Session["User_Name"].ToString();

                    if (IU_Statu.Value == "I")
                    {
                        try
                        {
                            ws.Add(model);
                            _Null();
                        }
                        catch (Exception ex)
                        {
                            common.Uerr_str(UpdatePanel1, ex.ToString());
                        }
                        finally
                        {
                            get_first_input_list(AspNetPager1.CurrentPageIndex);
                        }
                    }
                    if (IU_Statu.Value == "U")
                    {
                        try
                        {
                            ws.Update(model);
                            _Null();
                        }
                        catch (Exception ex)
                        {
                            common.Uerr_str(UpdatePanel1, ex.ToString());
                        }
                        finally
                        {
                            get_first_input_list(AspNetPager1.CurrentPageIndex);
                        }
                    }
                }
                catch (Exception ex)
                {
                    common.Uerr_str(UpdatePanel1, ex.ToString());
                }
            }
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                LinkButton addButton3 = (LinkButton)e.Row.FindControl("LinkButton3");
                addButton3.CommandArgument = e.Row.RowIndex.ToString();
                LinkButton addButton4 = (LinkButton)e.Row.FindControl("LinkButton4");
                addButton4.CommandArgument = e.Row.RowIndex.ToString();

                addButton4.Attributes.Add("onclick", "return confirm('确定要删除成品输入单：" + FengFan.Functions.clear_null(e.Row.Cells[0].Text.Trim()) + " 吗?');");


                int i = e.Row.Cells.Count - 1;

                if (e.Row.Cells[i].Text.Trim().Length > 0)
                {
                  //  Button2.Visible = false;
                  //  Button3.Visible = false;
                    addButton3.Visible = false;

                    addButton4.Visible = false;
                }
                else
                {
                    addButton3.Visible = true;

                    addButton4.Visible = true;
                }

            }

        }

        protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            GridViewRow row = GridView1.Rows[e.RowIndex];
            try
            {
                DataClass.first_input ws = new DataClass.first_input();
                ws.Delete(FengFan.Functions.clear_null(row.Cells[0].Text.Trim()), Session["Dept_ID"].ToString());
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.Message.Replace("\r\n", "").Replace("'", "\""));
            }
            finally
            {
                get_first_input_list(AspNetPager1.CurrentPageIndex);
                _Null();
            }
        }

        protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Select")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewRow row = GridView1.Rows[index];


                DataClass.first_input ws = new DataClass.first_input();
                Model.first_input model = new Model.first_input();

                model = ws.GetModel(FengFan.Functions.clear_null(row.Cells[0].Text.Trim()), Session["Dept_ID"].ToString());

                Label_product_name.Text = FengFan.Functions.clear_null(row.Cells[2].Text.Trim());

                txt_product_id.Text = model.product_id.ToString();

                txt_scount.Text = model.scount.ToString();
                txt_price.Text = model.price.ToString();


                txt_product_sn.Text = model.product_sn.ToString();

                first_input_id.Value = model.input_id.ToString();
                txtremark.Text = model.remark;

                DropDownList_money_id.SelectedIndex = DropDownList_money_id.Items.IndexOf(DropDownList_money_id.Items.FindByValue(FengFan.Functions.clear_null(model.money_id.ToString())));
                DropDownList_dept_id.SelectedIndex = DropDownList_dept_id.Items.IndexOf(DropDownList_dept_id.Items.FindByValue(FengFan.Functions.clear_null(model.dept_id.ToString())));

                Button2.Text = "取消";
                IU_Statu.Value = "U";
                TD1.Visible = true;
            }
        }

        protected void GridView1_RowCreated(object sender, GridViewRowEventArgs e)
        {

            int i = e.Row.Cells.Count - 1;
            e.Row.Cells[i].Visible = false;
        }


    }
}
