﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

namespace computer.store
{
    public partial class product_lend : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                // Page.Title = common.CompanyName() + Page.Title;
                common.Init_DropDown_for_Dept(DropDownList_Qdept_id);//DropDownList1
                DropDownList_Qdept_id.SelectedIndex = DropDownList_Qdept_id.Items.IndexOf(DropDownList_Qdept_id.Items.FindByValue(Session["Dept_ID"].ToString()));

                common.Init_DropDown_for_Dept(DropDownList_dept_id);//DropDownList1
                DropDownList_dept_id.SelectedIndex = DropDownList_dept_id.Items.IndexOf(DropDownList_dept_id.Items.FindByValue(Session["Dept_ID"].ToString()));

                if (DataClass.BaseData.is_MeiShi(Session["Dept_ID"].ToString()))
                {
                    DropDownList_Qdept_id.Enabled = false;
                    DropDownList_dept_id.Enabled = false;
                }
                else
                {
                    DropDownList_Qdept_id.Enabled = true;
                    DropDownList_dept_id.Enabled = true;
                }

                TD1.Visible = false;
                product_lend_id.Value = "0";
                get_product_lend_sum_amount();
                get_product_lend_list(1);
                get_Count();
            }
        }

        protected void get_product_lend_sum_amount()
        {
            try
            {
                DataClass.product_lend ws = new DataClass.product_lend();
                decimal[] _ws = (decimal[])ws.Get_product_lend_sum(TextBox1.Text.Trim(), TextBox2.Text.Trim(), DropDownList_Qdept_id.SelectedItem.Value, TextBox3.Text.Trim(), TextBox4.Text.Trim(), Int16.Parse(DropDownList1.SelectedItem.Value));
                H_amount.Value = _ws[0].ToString();//总页数
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//
        }

        protected void get_product_lend_list(int CurrentPage)
        {
            try
            {
                DataClass.product_lend ws = new DataClass.product_lend();
                GridView1.DataSource = ws.Getproduct_lendList(TextBox1.Text.Trim(), TextBox2.Text.Trim(), DropDownList_Qdept_id.SelectedItem.Value, TextBox3.Text.Trim(), TextBox4.Text.Trim(), Int16.Parse(DropDownList1.SelectedItem.Value), CurrentPage);
                GridView1.DataBind();

               
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//string product_name, string client_id, string dept_id, string from_date, string to_date, string revert_state
        }
        protected void get_Count()
        {
            try
            {
                DataClass.product_lend ws = new DataClass.product_lend();
                int[] _ws = (int[])ws.Getproduct_lendList_Count(TextBox1.Text.Trim(), TextBox2.Text.Trim(), DropDownList_Qdept_id.SelectedItem.Value, TextBox3.Text.Trim(), TextBox4.Text.Trim(), Int16.Parse(DropDownList1.SelectedItem.Value));
                AspNetPager1.CurrentPageIndex = 1;
                AspNetPager1.PageSize = _ws[0];//页面尺寸
                AspNetPager1.RecordCount = _ws[1];
                TotalCount.Text = _ws[1].ToString();//总记录数
                PageCount.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//
        }
        protected void GridView1_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[0].Visible = false;
           
        }
        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            get_product_lend_list(AspNetPager1.CurrentPageIndex);
        }
        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                LinkButton addButton1 = (LinkButton)e.Row.FindControl("LinkButton1");
                addButton1.CommandArgument = e.Row.RowIndex.ToString();
                LinkButton addButton2 = (LinkButton)e.Row.FindControl("LinkButton2");
                addButton2.CommandArgument = e.Row.RowIndex.ToString();

                LinkButton addButton3 = (LinkButton)e.Row.FindControl("LinkButton3");
                addButton3.CommandArgument = e.Row.RowIndex.ToString();
                LinkButton addButton4 = (LinkButton)e.Row.FindControl("LinkButton4");
                addButton4.CommandArgument = e.Row.RowIndex.ToString();

                LinkButton addButton5 = (LinkButton)e.Row.FindControl("LinkButton5");
                addButton5.CommandArgument = e.Row.RowIndex.ToString();
                LinkButton addButton6 = (LinkButton)e.Row.FindControl("LinkButton6");
                addButton6.CommandArgument = e.Row.RowIndex.ToString();

                addButton2.Attributes.Add("onclick", "return confirm('确定要删除外借展览单：" + FengFan.Functions.clear_null(e.Row.Cells[1].Text.Trim()) + " 吗?');");
                //get_right

                if (e.Row.Cells[0].Text == Session["Dept_ID"].ToString())
                {

                    addButton5.Visible = true;
                    addButton6.Visible = true;

                    if (e.Row.Cells[13].Text.Trim().Length > 6)
                    {
                        addButton1.Visible = false;
                        addButton2.Visible = false;
                    }
                    else
                    {
                        addButton1.Visible = true;
                        addButton2.Visible = true;
                    }

                }
                else
                {
                    addButton1.Visible = false;
                    addButton2.Visible = false;
                    addButton5.Visible = false;
                    addButton6.Visible = false;
                }
                if (common.get_right(Session["User_ID"].ToString(), "store@product_lend", "_sk1"))
                {

                    addButton3.Visible = true;
                    addButton4.Visible = true;
                    //if (e.Row.Cells[13].Text.Trim().Length== 0)
                    //{
                    //    addButton3.Visible = false;
                    //    addButton4.Visible =true ;
                    //}
                    //else
                    //{
                    //    addButton3.Visible = true;
                    //    addButton4.Visible =false ;
                    //}
                    //addButton3.Text = e.Row.Cells[13].Text.Trim();//.Length.ToString();
                    //addButton4.Text = e.Row.Cells[13].Text.Trim();//.Length.ToString();
                }
                else
                {
                    addButton3.Visible = false;
                    addButton4.Visible = false;
                }

            }
            if (e.Row.RowType == DataControlRowType.Footer)
            {
                e.Row.Cells[9].Text = H_amount.Value;
            }

        }
    


        protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            int index;
            GridViewRow row;
            DataClass.product_lend ws = new DataClass.product_lend();
            if (e.CommandName == "Select")
            {

                index = Convert.ToInt32(e.CommandArgument);
                row = GridView1.Rows[index];

                Model.product_lend model = new Model.product_lend();

                model = ws.GetModel(FengFan.Functions.clear_null(row.Cells[1].Text.Trim()), FengFan.Functions.clear_null(row.Cells[0].Text.Trim()));

                Label_client_name.Text = FengFan.Functions.clear_null(row.Cells[4].Text.Trim());
                Label_product_name.Text = FengFan.Functions.clear_null(row.Cells[6].Text.Trim());

                txt_client_id.Text = model.client.ToString();
                txt_product_id.Text = model.product_id.ToString();

                txt_scount.Text = model.scount.ToString();

                txt_bill_id.Text = model.bill_id;

                txt_edate.Text = model.edate.Substring(0, 10);
                txt_sdate.Text = model.sdate.Substring(0, 10);

                txt_product_sn.Text = model.product_sn.ToString();

                product_lend_id.Value = model.output_id.ToString();
                txtremark.Text = model.remark;

                DropDownList_dept_id.SelectedIndex = DropDownList_dept_id.Items.IndexOf(DropDownList_dept_id.Items.FindByValue(FengFan.Functions.clear_null(model.dept_id.ToString())));
                HiddenField_store_scount.Value = txt_scount.Text;
                Button2.Text = "取消";
                IU_Statu.Value = "U";
                TD1.Visible = true;
            }
            if (e.CommandName == "Delete")
            {

            }
            if (e.CommandName == "sk")
            {
                index = Convert.ToInt32(e.CommandArgument);
                row = GridView1.Rows[index];

                ws.sk(row.Cells[1].Text, row.Cells[0].Text, Session["User_Name"].ToString()); 
                get_product_lend_list(AspNetPager1.CurrentPageIndex);
            }
            if (e.CommandName == "not_sk")
            {
                index = Convert.ToInt32(e.CommandArgument);
                row = GridView1.Rows[index];
                ws.cancel_sk(row.Cells[1].Text, row.Cells[0].Text); 
                get_product_lend_list(AspNetPager1.CurrentPageIndex);
            }
            if (e.CommandName == "revert")
            {
                index = Convert.ToInt32(e.CommandArgument);
                row = GridView1.Rows[index];
                ws.revert(row.Cells[1].Text, row.Cells[0].Text, Session["User_Name"].ToString()); 
                get_product_lend_list(AspNetPager1.CurrentPageIndex);
            }
            if (e.CommandName == "not_revert")
            {
                index = Convert.ToInt32(e.CommandArgument);
                row = GridView1.Rows[index];
                ws.cancel_revert(row.Cells[1].Text, row.Cells[0].Text); 
                get_product_lend_list(AspNetPager1.CurrentPageIndex);
            }
        }

        protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            GridViewRow row = GridView1.Rows[e.RowIndex];
            try
            {
                DataClass.product_lend ws = new DataClass.product_lend();
                ws.Delete(FengFan.Functions.clear_null(row.Cells[1].Text.Trim()), FengFan.Functions.clear_null(row.Cells[0].Text.Trim()));
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.Message.Replace("\r\n", "").Replace("'", "\""));
            }
            finally
            {
                get_product_lend_list(AspNetPager1.CurrentPageIndex);
                _Null();
            }
        }
        protected void Button4_Click(object sender, EventArgs e)
        {
            Client_query1.get_data();
            Client_query1.Visible = true;
        }
        protected void Button5_Click(object sender, EventArgs e)
        {

            Product_query1.get_material();
            Product_query1.Visible = true;
        }
        protected void _Null()
        {
            txt_product_id.Text = "";
            Label_product_name.Text = "";
            txt_product_sn.Text = "";

            txt_client_id.Text = "";
            Label_client_name.Text = "";

            txt_scount.Text = "1";
            txtremark.Text = "";

            txt_bill_id.Text = "";

            txt_edate.Text = "";
            txt_sdate.Text = "";
            txt_sman.Text = "";

            product_lend_id.Value = "0";
            HiddenField_store_scount.Value = "0";

            IU_Statu.Value = "I";


        }
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            Product_query1.CancelEvent += new EventHandler(cancel_product_select);

            Product_query1.SelectEvent += new EventHandler(get_product_id);


            Client_query1.SelectEvent += new EventHandler(get_Client_id);
            Client_query1.CancelEvent += new EventHandler(cancel_client_select);
        }

        private void get_Client_id(object sender, EventArgs e)
        {
            txt_client_id.Text = Client_query1.select_client_id;
            Label_client_name.Text = Client_query1.select_client_name;
            Client_query1.Visible = false;
        }
        private void cancel_client_select(object sender, EventArgs e)
        {
            txt_client_id.Text = "";
            Label_client_name.Text = "";
            Client_query1.Visible = false;
        }


        private void get_product_id(object sender, EventArgs e)
        {
            txt_product_id.Text = Product_query1.get_product_id;
            Label_product_name.Text = Product_query1.get_product_name;
            Product_query1.Visible = false;
        }
        private void cancel_product_select(object sender, EventArgs e)
        {
            txt_product_id.Text = "";
            Label_product_name.Text = "";
            Product_query1.Visible = false;
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            get_product_lend_sum_amount();
            get_product_lend_list(1);
            get_Count();
            _Null();
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            if (Button2.Text == "取消")
            {
                _Null();
                TD1.Visible = false;
            }
            else
            {
                _Null();
                TD1.Visible = true;
                Button2.Text = "取消";
            }
        }

        protected void Button3_Click(object sender, EventArgs e)
        {
            int stroe_scount = 0;
            if (!FengFan.Functions.IsInt(txt_scount.Text))
                common.Uerr_str(UpdatePanel1, "数量输入不正确，请检查！！");
            else
            {
                try
                {
                    DataClass.product_lend ws = new DataClass.product_lend();
                    Model.product_lend model = new Model.product_lend();

                    model.product_id = Int32.Parse(txt_product_id.Text);
                    model.client = txt_client_id.Text;
                    model.remark = txtremark.Text;
                    model.product_sn = txt_product_sn.Text.Trim();
                    model.dept_id = DropDownList_dept_id.SelectedItem.Value;

                    model.scount = Convert.ToInt32(txt_scount.Text);

                    model.output_id = product_lend_id.Value;

                    model.sdate = txt_sdate.Text;
                    model.edate = txt_edate.Text;

                    model.sman = txt_sman.Text; ;
                    model.bill_id = txt_bill_id.Text.Trim();

                    if (IU_Statu.Value == "I")
                    {
                        stroe_scount = DataClass.product_input.get_store_scount(Int32.Parse(txt_product_id.Text), 0, DropDownList_dept_id.SelectedItem.Value);
                        if (stroe_scount >= Convert.ToInt32(txt_scount.Text))
                        {
                            try
                            {
                                ws.Add(model);
                                _Null();
                            }
                            catch (Exception ex)
                            {
                                common.Uerr_str(UpdatePanel1, ex.ToString().Replace("\n", @"\n").Replace("\r", @"\r").Replace("\"", @"\"""));
                            }
                            finally
                            {
                                TD1.Visible = false;
                                get_product_lend_list(AspNetPager1.CurrentPageIndex);
                            }
                        }
                        else
                            common.Uerr_str(UpdatePanel1, Label_product_name.Text + "的库存数不够,最多能销售" + stroe_scount.ToString());
                    }
                    if (IU_Statu.Value == "U")
                    {
                        stroe_scount = DataClass.product_input.get_store_scount(Int32.Parse(txt_product_id.Text), Int32.Parse(HiddenField_store_scount.Value), DropDownList_dept_id.SelectedItem.Value);
                        if (stroe_scount >= Convert.ToInt32(txt_scount.Text))
                        {
                            try
                            {
                                ws.Update(model);
                                _Null();
                            }
                            catch (Exception ex)
                            {
                                common.Uerr_str(UpdatePanel1,ex.ToString().Replace("\n", @"\n").Replace("\r", @"\r").Replace("\"", @"\"""));
                            }
                            finally
                            {
                                TD1.Visible = false;
                                get_product_lend_list(AspNetPager1.CurrentPageIndex);
                            }
                        }
                    }
                    else
                        common.Uerr_str(UpdatePanel1, Label_product_name.Text + "的库存数不够,最多能销售" + stroe_scount.ToString());
                }
                catch (Exception ex)
                {
                    common.Uerr_str(UpdatePanel1, ex.ToString());
                }
            }
        }

        protected void Button6_Click(object sender, EventArgs e)
        {
            DataTable dt = get_print_data().Tables[0];
            //   dt.Columns.Remove("stype");
            GridView2.Visible = true;
            GridView2.DataSource = dt;
            GridView2.DataBind();
            GridView2.Caption = DateTime.Now.ToString("yyyy-MM-dd") + DropDownList_Qdept_id.SelectedItem.Value + "  外借摆样数";

            common.ToExcel(GridView2, "product_lend");

            Response.End();
            GridView2.Visible = false;

            //    FengFan.ExcelEdit ExcelEdit1 = new FengFan.ExcelEdit();

            //    DataTable dt = get_print_data().Tables[0];


            //    ExcelEdit1.ExportToExcel(dt, Server.MapPath("store.xls"), DateTime.Now.ToString("yyyy-MM-dd")+"：总店库存数", this.Page);
        }
        protected DataSet get_print_data()
        {
            DataClass.product_lend ws = new DataClass.product_lend();
            return ws.Getproduct_lendList_Excel(TextBox1.Text.Trim(), TextBox2.Text.Trim(), DropDownList_Qdept_id.SelectedItem.Value, TextBox3.Text.Trim(), TextBox4.Text.Trim(), Int16.Parse(DropDownList1.SelectedItem.Value));
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            // Confirms that an HtmlForm control is rendered for
        }
    }
}