﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

namespace computer.store
{
    public partial class store_input : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
               // Page.Title = common.CompanyName() + Page.Title;
                common.Init_DropDown_for_Dept(DropDownList_Q_from_dept_id);//DropDownList1
                DropDownList_Q_from_dept_id.SelectedIndex = DropDownList_Q_from_dept_id.Items.IndexOf(DropDownList_Q_from_dept_id.Items.FindByValue(Session["Dept_ID"].ToString()));

                DropDownList_Q_from_dept_id.Enabled = false;
                get_data();
            }
        }

        protected void get_data()
        {
            get_adjust_output_list(1);
            get_Count();
        }

        protected void get_adjust_output_list(int CurrentPage)
        {
            try
            {
                DataClass.store ws = new DataClass.store();
                GridView1.DataSource = ws.Getstore_input(DropDownList_Q_from_dept_id.SelectedItem.Value, 0, 0, txt_product_name.Text.Trim(), DropDownList_Q_state.SelectedItem.Value, CurrentPage);
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//
        }
        protected void get_Count()
        {
            try
            {
                DataClass.store ws = new DataClass.store();
                int[] _ws = (int[])ws.Getstore_input_Count(DropDownList_Q_from_dept_id.SelectedItem.Value, 0, 0, txt_product_name.Text.Trim(), DropDownList_Q_state.SelectedItem.Value);
                AspNetPager1.CurrentPageIndex = 1;
                AspNetPager1.PageSize = _ws[0];//页面尺寸
                AspNetPager1.RecordCount = _ws[1];
                TotalCount.Text = _ws[1].ToString();//总记录数
                PageCount.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            Product_query1.CancelEvent += new EventHandler(Cancel_Product_Cancel_Select);

            Product_query1.SelectEvent += new EventHandler(Get_Product_Select);
        }

        private void Cancel_Product_Cancel_Select(object sender, EventArgs e)
        {
            Product_query1.Visible = false;
        }
        private void Get_Product_Select(object sender, EventArgs e)
        {
            txt_product_id.Text = Product_query1.get_product_id;
            txt_product_name.Text = Product_query1.get_product_name;
            Product_query1.Visible = false;
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            Product_query1.Visible = true;
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {

                LinkButton addButton1 = (LinkButton)e.Row.FindControl("LinkButton1");
                addButton1.CommandArgument = e.Row.RowIndex.ToString();
                addButton1.Attributes.Add("onclick", "return confirm('确定：" + FengFan.Functions.clear_null(e.Row.Cells[0].Text.Trim()) + ",现在收货 吗?');");

                LinkButton addButton2 = (LinkButton)e.Row.FindControl("LinkButton2");
                addButton2.CommandArgument = e.Row.RowIndex.ToString();
                addButton2.Attributes.Add("onclick", "return confirm('确定：" + FengFan.Functions.clear_null(e.Row.Cells[0].Text.Trim()) + ",取消收货 吗?');");


                addButton1.Visible = false;

                addButton2.Visible = false;


                if (Int32.Parse(e.Row.Cells[8].Text.Trim()) > 0)
                    addButton2.Visible =true ;
                else
                    addButton1.Visible =true ;

            }
        }

        protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewRow row = GridView1.Rows[index];
            if (e.CommandName == "_input")
            {
                DataClass.store.Adjust_Output_Op(FengFan.Functions.clear_null(row.Cells[3].Text.Trim()), Session["User_Name"].ToString(),FengFan.Functions.clear_null(row.Cells[2].Text.Trim()), row.Cells[12].Text.Trim());
                get_adjust_output_list(AspNetPager1.CurrentPageIndex);
            }
            if (e.CommandName == "un_input")
            {
                DataClass.store.Adjust_Output_Op_un(FengFan.Functions.clear_null(row.Cells[3].Text.Trim()), FengFan.Functions.clear_null(row.Cells[2].Text.Trim()), row.Cells[12].Text.Trim());
                get_adjust_output_list(AspNetPager1.CurrentPageIndex);
            }
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            get_data();
        }

        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            get_adjust_output_list(AspNetPager1.CurrentPageIndex);
        }

        protected void GridView1_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[11].Visible = false;
            e.Row.Cells[12].Visible = false;
        }

        protected void _err_str(string mess_str)
        {
            common._err_str(mess_str, this.Page);
        }

    }
}
