﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace computer.system
{
    public partial class Data_Backup : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
               // Page.Title = common.CompanyName() + Page.Title;
                get_backup();
            }
        }

        protected void get_backup()
        {
            get_backup_list(1);
            get_Count();
        }

        protected void get_backup_list(int CurrentPage)
        {
            try
            {
                DataClass.back_restore_database ws = new DataClass.back_restore_database();
                GridView1.DataSource = ws.Get_Back_List( CurrentPage);
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }//８４２８８８０８
        }
        protected void get_Count()
        {
            try
            {
                DataClass.back_restore_database ws = new DataClass.back_restore_database();
                int[] _ws = (int[])ws.Get_Back_List_Count();
                AspNetPager1.CurrentPageIndex = 1;
                AspNetPager1.PageSize = _ws[0];//页面尺寸
                AspNetPager1.RecordCount = _ws[1];
                TotalCount.Text = _ws[1].ToString();//总记录数
                PageCount.Text = _ws[2].ToString();//总页数
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            DataClass.back_restore_database ws = new DataClass.back_restore_database();
            ws.backup_data(Session["User_Name"].ToString(),  Server.MapPath("./data_backup/"));

            get_backup();
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                LinkButton addButton4 = (LinkButton)e.Row.FindControl("LinkButton4");
                addButton4.CommandArgument = e.Row.RowIndex.ToString();

                addButton4.Attributes.Add("onclick", "return confirm('确定要恢复到：" + FengFan.Functions.clear_null(e.Row.Cells[0].Text.Trim()) + " 吗？请注意本操作不能再次还原，请通知所有用户暂停使用本系统！！');");

            }
        }

        protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Select")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewRow row = GridView1.Rows[index];
                DataClass.back_restore_database ws = new DataClass.back_restore_database();

                common.Uerr_str(UpdatePanel1, ws.DbRestore(Server.MapPath("./data_backup/") + FengFan.Functions.clear_null(row.Cells[0].Text.Trim())));

            }
        }

        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            get_backup_list(AspNetPager1.CurrentPageIndex);
        }
    }
}
