﻿using System;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace computer.system
{
    public partial class UserList : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
               // Page.Title = common.CompanyName() + Page.Title;
                if (common.get_right(Session["User_ID"].ToString(), "system@UserList", "_insert")) Button1.Visible = true; else Button1.Visible = false;
                if (common.get_right(Session["User_ID"].ToString(), "system@UserList", "_insert")) Button2.Visible = true; else Button2.Visible = false;
                common.Init_DropDown_Item(Dept, "select dept_id,sname from dept_list order by dept_id");
                common.Init_DropDown_Item(Duty, "select duty_id,sname from duty_list order by duty_id");//
                common.Init_DropDown_Item(Dtype_name, "select user_type,type_name from user_type order by user_type");//Dtype_name


                get_User();
            }
        }


        protected void get_User()
        {
            try
            {
                DataClass._system ws = new DataClass._system();
                GridView1.DataSource = ws.GetUserList();
                GridView1.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            _null();
        }
        protected void _null()
        {
            TextBox_ID.Text = "";
            TextBox_Name.Text = "";
            Dept.SelectedIndex = 0;
            Duty.SelectedIndex = 0;//type_name
            Dtype_name.SelectedIndex = 0;
            D_price.SelectedIndex = 0;
            TextBox_ID.Enabled = true;
            Button1.Text = "新增";
            HiddenField1.Value = "I";
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            if (TextBox_ID.Text.Trim() != string.Empty)
                try
                {
                    DataClass._system ws = new DataClass._system();
                    ws.InsertUser(TextBox_ID.Text.Trim(), TextBox_Name.Text, Dept.SelectedItem.Value, Duty.SelectedItem.Value, FengFan.Encrypt.EncodePassword(FengFan.Functions.clear_null(TextBox_ID.Text.Trim()), 0), HiddenField1.Value, Dtype_name.SelectedIndex, D_price.SelectedIndex+1);
                    _null();
                }
                catch (Exception ex)
                {
                    common.Uerr_str(UpdatePanel1, ex.Message.Replace("\r\n", "").Replace("'", "\""));
                }
                finally
                {
                    get_User();
                }
        }

        protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Select")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewRow row = GridView1.Rows[index];
                TextBox_ID.Text = FengFan.Functions.clear_null(row.Cells[0].Text.Trim());
                TextBox_Name.Text = FengFan.Functions.clear_null(row.Cells[1].Text.Trim());
                Dept.SelectedIndex = Dept.Items.IndexOf(Dept.Items.FindByText(FengFan.Functions.clear_null(row.Cells[2].Text.Trim())));
                Duty.SelectedIndex = Duty.Items.IndexOf(Duty.Items.FindByText(FengFan.Functions.clear_null(row.Cells[3].Text.Trim())));
                Dtype_name.SelectedIndex = Dtype_name.Items.IndexOf(Dtype_name.Items.FindByText(FengFan.Functions.clear_null(row.Cells[4].Text.Trim())));
                D_price.SelectedIndex = D_price.Items.IndexOf(D_price.Items.FindByText(FengFan.Functions.clear_null(row.Cells[5].Text.Trim()))); 
              

                TextBox_ID.Enabled = false;
                Button1.Text = "取消";
                HiddenField1.Value = "U";
            }

            if (e.CommandName == "ResetPassword")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewRow row = GridView1.Rows[index];
                DataClass._system ws = new DataClass._system();
                ws.update_user_password(FengFan.Functions.clear_null(row.Cells[0].Text.Trim()), FengFan.Encrypt.EncodePassword(FengFan.Functions.clear_null(row.Cells[0].Text.Trim()),0));
            }
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                LinkButton addButton1 = (LinkButton)e.Row.FindControl("LinkButton1");
                addButton1.CommandArgument = e.Row.RowIndex.ToString();
                addButton1.Attributes.Add("onclick", "return confirm('用户：" + FengFan.Functions.clear_null(e.Row.Cells[1].Text.Trim()) + " 的密码将复位成[ " + FengFan.Functions.clear_null(e.Row.Cells[0].Text.Trim()) + " ],确定吗?')");


                LinkButton addButton3 = (LinkButton)e.Row.FindControl("LinkButton3");
                addButton3.CommandArgument = e.Row.RowIndex.ToString();
                LinkButton addButton4 = (LinkButton)e.Row.FindControl("LinkButton4");

                addButton4.Attributes.Add("onclick", "return confirm('确定要删除用户：" + FengFan.Functions.clear_null(e.Row.Cells[1].Text.Trim()) + " 吗?');");

                if (common.get_right(Session["User_ID"].ToString(), "system@UserList", "_modify")) addButton1.Visible = true; else addButton1.Visible = false;
                if (common.get_right(Session["User_ID"].ToString(), "system@UserList", "_modify")) addButton3.Visible = true; else addButton3.Visible = false;
                if (common.get_right(Session["User_ID"].ToString(), "system@UserList", "_delete")) addButton4.Visible = true; else addButton4.Visible = false;

            }
        }

        protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            GridViewRow row = GridView1.Rows[e.RowIndex];
            if (FengFan.Functions.clear_null(row.Cells[0].Text.Trim()).ToLower() != "user01")
            {
                try
                {
                    DataClass._system ws = new DataClass._system();
                    ws.DeleteUser(FengFan.Functions.clear_null(row.Cells[0].Text.Trim()));
                }
                catch (Exception ex)
                {
                    common.Uerr_str(UpdatePanel1, ex.Message.Replace("\r\n", "").Replace("'", "\""));
                }
                finally
                {
                    get_User();
                }

            }
            else
                common.Uerr_str(UpdatePanel1, "系统管理员不能删除！！");

            /**/
        }
    }
}
