﻿using System;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using System.Xml;

namespace computer.system
{
    public partial class UserRight : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
               // Page.Title = common.CompanyName() + Page.Title;
                get_User();
                common.Init_DropDown_Item(DropDownList_main, "SELECT main_id, main_name FROM menu_table ORDER BY main_id");
            }
        }


        protected void get_User()
        {
            try
            {
                DataClass._system ws = new DataClass._system();
                this.GridView1.DataSource = ws.GetUserList();
                this.GridView1.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }
        }

        protected void get_UserRight(string user_id, string main_id)
        {
            try
            {
                DataClass._system ws = new DataClass._system();
                this.GridView2.DataSource = ws.GetUserRight(user_id, main_id);
                this.GridView2.DataBind();
            }
            catch (Exception ex)
            {
                common.Uerr_str(UpdatePanel1, ex.ToString());
            }
            finally
            {
            }
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            Delete_Save();
            get_xml_data();
            DataClass._system ws = new DataClass._system();
            ws.set_user_right();
        }
        private void meun_Save(string main_id, string meun_id, string meun_name)
        {
            DataClass._system ws = new DataClass._system();
            ws.InsertMeum(main_id, meun_id, meun_name);
        }

        private void Delete_Save()
        {
            DataClass._system ws = new DataClass._system();
            ws.DeleteMeum();
        }

        private void get_xml_data()
        {
            XmlDocument xmldoc = new XmlDocument();
            xmldoc.Load(Server.MapPath("//controls//MenuData.xml"));

            XmlNodeList topM = xmldoc.DocumentElement.ChildNodes;
            foreach (XmlElement element in topM)
            {
                if (element.Name.ToLower() == "menugroup")
                {
                    XmlNodeList nodelist = element.ChildNodes;
                    if (nodelist.Count > 0)
                    {
                        foreach (XmlElement el in nodelist)
                        {
                            if (el.Name.ToLower() == "menuitem")
                            {
                                XmlNodeList nodelist1 = el.ChildNodes;
                                if (nodelist1.Count > 0)
                                {
                                    foreach (XmlElement ell in el)
                                    {
                                        if (ell.Name.ToLower() == "menugroup")
                                        {
                                            XmlNodeList nodelist2 = ell.ChildNodes;

                                            if (nodelist2.Count > 0)
                                            {
                                                foreach (XmlElement elll in ell)
                                                {
                                                    if (elll.GetAttribute("ID").Length > 0)
                                                    {
                                                        meun_Save(el.GetAttribute("ID"), elll.GetAttribute("ID"), elll.GetAttribute("Label"));
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Select")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewRow row = GridView1.Rows[index];
                Label_user_id.Text = FengFan.Functions.clear_null(row.Cells[0].Text.Trim());
                Label_user_name.Text = FengFan.Functions.clear_null(row.Cells[1].Text.Trim());


                get_UserRight(Label_user_id.Text, DropDownList_main.SelectedItem.Value);
            }
        }

        protected void DropDownList_main_SelectedIndexChanged(object sender, EventArgs e)
        {
            get_UserRight(Label_user_id.Text, DropDownList_main.SelectedItem.Value);
        }

        protected void Button3_Click(object sender, EventArgs e)
        {
            DataClass._system ws = new DataClass._system();
            for (int i = 0; i < this.GridView2.Rows.Count; i++)
            {
                GridViewRow row = GridView2.Rows[i];
                CheckBox Chb_has_right1 = this.GridView2.Rows[i].FindControl("Chb_has_right") as CheckBox;
                CheckBox Chb_insert1 = this.GridView2.Rows[i].FindControl("Chb_insert") as CheckBox;
                CheckBox Chb_modify1 = this.GridView2.Rows[i].FindControl("Chb_modify") as CheckBox;
                CheckBox Chb_delete1 = this.GridView2.Rows[i].FindControl("Chb_delete") as CheckBox;
                CheckBox Chb_print1 = this.GridView2.Rows[i].FindControl("Chb_print") as CheckBox;
                CheckBox Chb_sk11 = this.GridView2.Rows[i].FindControl("Chb_sk1") as CheckBox;
                CheckBox Chb_sk21 = this.GridView2.Rows[i].FindControl("Chb_sk2") as CheckBox;
                CheckBox Chb_sk31 = this.GridView2.Rows[i].FindControl("Chb_sk3") as CheckBox;
                HiddenField hd = this.GridView2.Rows[i].FindControl("HiddenField1") as HiddenField;
                ws.Update_Right(Label_user_id.Text, DropDownList_main.SelectedItem.Value, hd.Value, Chb_has_right1.Checked, Chb_insert1.Checked, Chb_modify1.Checked, Chb_delete1.Checked, Chb_print1.Checked, Chb_sk11.Checked, Chb_sk21.Checked, Chb_sk31.Checked);

            }
            common.Uerr_str(UpdatePanel1, "权限已经正确保存！！");
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            DataClass._system ws = new DataClass._system();
           if( ws.CopyRight(Label_user_id.Text, TextBox1.Text)>0)
               common.Uerr_str(UpdatePanel1, "[" + TextBox1.Text + "] 的所有权限已经和 [" + Label_user_id.Text + "] 相同了！！");
           else
               common.Uerr_str(UpdatePanel1, "[" + TextBox1.Text + "] 用户名不存在，请检查！！");

        }
    }
}
